/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.creation.ui.extension;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.consumption.command.common.AddModuleToServerCommand;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateServerCommand;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.ws.internal.wsrt.IContext;
import org.eclipse.wst.ws.internal.wsrt.IWebService;

public class PreServiceInstallCommand
extends AbstractDataModelOperation {
    private IWebService webService_;
    private String project_;
    private String module_;
    private String earProject_;
    private String ear_;
    private IContext context_;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        if (this.context_.getInstall()) {
            IEnvironment environment = this.getEnvironment();
            if (this.webService_.getWebServiceInfo().getServerInstanceId() == null) {
                IServer[] allServers = ServerCore.getServers();
                if (allServers != null && allServers.length > 0) {
                    int i = 0;
                    while (i < allServers.length) {
                        IServer oneServer = allServers[i];
                        if (oneServer.getServerType().getId().equals(this.webService_.getWebServiceInfo().getServerFactoryId())) {
                            this.webService_.getWebServiceInfo().setServerInstanceId(oneServer.getId());
                            this.webService_.getWebServiceInfo().setServerCreated(true);
                        }
                        ++i;
                    }
                }
                if (this.webService_.getWebServiceInfo().getServerInstanceId() == null) {
                    CreateServerCommand createServerCommand = new CreateServerCommand();
                    createServerCommand.setServerFactoryid(this.webService_.getWebServiceInfo().getServerFactoryId());
                    createServerCommand.setServerRuntimeId(this.webService_.getWebServiceInfo().getServerRuntimeId());
                    createServerCommand.setEnvironment(environment);
                    IStatus createServerStatus = createServerCommand.execute(monitor, null);
                    if (createServerStatus.getSeverity() == 0) {
                        this.webService_.getWebServiceInfo().setServerInstanceId(createServerCommand.getServerInstanceId());
                        this.webService_.getWebServiceInfo().setServerCreated(true);
                    } else {
                        if (createServerStatus.getSeverity() == 4) {
                            environment.getStatusHandler().reportError(createServerStatus);
                        }
                        return createServerStatus;
                    }
                }
            }
            AddModuleToServerCommand command = new AddModuleToServerCommand();
            command.setServerInstanceId(this.webService_.getWebServiceInfo().getServerInstanceId());
            if (this.earProject_ != null && this.earProject_.length() > 0 && this.ear_ != null && this.ear_.length() > 0) {
                command.setProject(this.earProject_);
                command.setModule(this.ear_);
            } else {
                command.setProject(this.project_);
                command.setModule(this.module_);
            }
            command.setEnvironment(environment);
            IStatus status = command.execute(monitor, null);
            if (status.getSeverity() == 4) {
                environment.getStatusHandler().reportError(status);
            }
            return status;
        }
        return Status.OK_STATUS;
    }

    public void setProject(String project) {
        this.project_ = project;
    }

    public void setModule(String module) {
        this.module_ = module;
    }

    public void setEarProject(String earProject) {
        this.earProject_ = earProject;
    }

    public void setEar(String ear) {
        this.ear_ = ear;
    }

    public void setWebService(IWebService webService) {
        this.webService_ = webService;
    }

    public void setContext(IContext context) {
        this.context_ = context;
    }
}

