/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.actions;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.PlatformUI;

public abstract class NewJavaEEDropDownAction
extends Action
implements IMenuCreator,
IWorkbenchWindowPulldownDelegate2 {
    protected static final String TAG_WIZARD = "wizard";
    protected static final String TAG_PARAMETER = "parameter";
    protected static final String TAG_NAME = "name";
    protected static final String TAG_VALUE = "value";
    protected static final String TAG_CLASS = "class";
    protected static final String ATT_MENUINDEX = "menuIndex";
    protected static final String PL_NEW = "newWizards";
    protected Menu fMenu = null;
    protected Shell fWizardShell;

    public NewJavaEEDropDownAction() {
        this.setMenuCreator(this);
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu == null) {
            NewJavaEEWizardAction[] actions;
            this.fMenu = new Menu(parent);
            NewJavaEEWizardAction[] newJavaEEWizardActionArray = actions = this.getActionFromDescriptors();
            int n = actions.length;
            int n2 = 0;
            while (n2 < n) {
                NewJavaEEWizardAction action = newJavaEEWizardActionArray[n2];
                action.setShell(this.fWizardShell);
                ActionContributionItem item = new ActionContributionItem((IAction)action);
                item.fill(this.fMenu, -1);
                ++n2;
            }
        }
        return this.fMenu;
    }

    public void run() {
        this.getDefaultAction().run();
    }

    public Action getDefaultAction() {
        NewJavaEEWizardAction[] actions = this.getActionFromDescriptors();
        if (actions.length > 0) {
            return actions[0];
        }
        return null;
    }

    public NewJavaEEWizardAction[] getActionFromDescriptors() {
        ArrayList<NewJavaEEWizardAction> containers = new ArrayList<NewJavaEEWizardAction>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", PL_NEW);
        if (extensionPoint != null) {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = extensionPoint.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getName().equals(TAG_WIZARD) && this.isJavaEEProjectWizard(element)) {
                    containers.add(new NewJavaEEWizardAction(element));
                }
                ++n2;
            }
        }
        Object[] actions = containers.toArray(new NewJavaEEWizardAction[containers.size()]);
        Arrays.sort(actions);
        return actions;
    }

    protected boolean isJavaEEProjectWizard(IConfigurationElement element) {
        IConfigurationElement[] classElements = element.getChildren(TAG_CLASS);
        if (classElements.length > 0) {
            IConfigurationElement[] iConfigurationElementArray = classElements;
            int n = classElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] paramElements;
                IConfigurationElement classElement = iConfigurationElementArray[n2];
                IConfigurationElement[] iConfigurationElementArray2 = paramElements = classElement.getChildren(TAG_PARAMETER);
                int n3 = paramElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement paramElement = iConfigurationElementArray2[n4];
                    if (this.getTypeAttribute().equals(paramElement.getAttribute(TAG_NAME))) {
                        return Boolean.valueOf(paramElement.getAttribute(TAG_VALUE));
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return Boolean.valueOf(element.getAttribute(this.getTypeAttribute())) != false;
    }

    public void init(IWorkbenchWindow window) {
        this.fWizardShell = window.getShell();
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected abstract String getTypeAttribute();

    public static class NewJavaEEWizardAction
    extends Action
    implements Comparable {
        private static final String ATT_NAME = "name";
        private static final String ATT_CLASS = "class";
        private static final String ATT_ICON = "icon";
        private static final String TAG_DESCRIPTION = "description";
        private Shell fShell;
        private IStructuredSelection fSelection;
        private IConfigurationElement fConfigurationElement;
        private int menuIndex;

        public NewJavaEEWizardAction(IConfigurationElement element) {
            this.fConfigurationElement = element;
            this.setText(element.getAttribute("name"));
            String description = this.getDescriptionFromConfig(this.fConfigurationElement);
            this.setDescription(description);
            this.setToolTipText(description);
            this.setImageDescriptor(this.getIconFromConfig(this.fConfigurationElement));
            this.setMenuIndex(this.getMenuIndexFromConfig(this.fConfigurationElement));
        }

        public void run() {
            Shell shell = this.getShell();
            try {
                INewWizard wizard = this.createWizard();
                wizard.init(PlatformUI.getWorkbench(), this.getSelection());
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                PixelConverter converter = new PixelConverter(JFaceResources.getDialogFont());
                dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(70), converter.convertHeightInCharsToPixels(20));
                dialog.create();
                int res = dialog.open();
                this.notifyResult(res == 0);
            }
            catch (CoreException e) {
                Logger.getLogger().log((Throwable)e);
            }
        }

        protected IStructuredSelection getSelection() {
            if (this.fSelection == null) {
                return this.evaluateCurrentSelection();
            }
            return this.fSelection;
        }

        private IStructuredSelection evaluateCurrentSelection() {
            ISelection selection;
            IWorkbenchWindow window = J2EEUIPlugin.getActiveWorkbenchWindow();
            if (window != null && (selection = window.getSelectionService().getSelection()) instanceof IStructuredSelection) {
                return (IStructuredSelection)selection;
            }
            return StructuredSelection.EMPTY;
        }

        public void setSelection(IStructuredSelection selection) {
            this.fSelection = selection;
        }

        protected Shell getShell() {
            if (this.fShell == null) {
                return J2EEUIPlugin.getActiveWorkbenchShell();
            }
            return this.fShell;
        }

        public void setShell(Shell shell) {
            this.fShell = shell;
        }

        private String getDescriptionFromConfig(IConfigurationElement config) {
            IConfigurationElement[] children = config.getChildren(TAG_DESCRIPTION);
            if (children.length >= 1) {
                return children[0].getValue();
            }
            return "";
        }

        private ImageDescriptor getIconFromConfig(IConfigurationElement config) {
            String iconName = config.getAttribute(ATT_ICON);
            if (iconName != null) {
                return J2EEUIPlugin.imageDescriptorFromPlugin((String)config.getContributor().getName(), (String)iconName);
            }
            return null;
        }

        private int getMenuIndexFromConfig(IConfigurationElement config) {
            IConfigurationElement[] classElements = config.getChildren("class");
            if (classElements.length > 0) {
                IConfigurationElement[] iConfigurationElementArray = classElements;
                int n = classElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement[] paramElements;
                    IConfigurationElement classElement = iConfigurationElementArray[n2];
                    IConfigurationElement[] iConfigurationElementArray2 = paramElements = classElement.getChildren(NewJavaEEDropDownAction.TAG_PARAMETER);
                    int n3 = paramElements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement paramElement = iConfigurationElementArray2[n4];
                        if (NewJavaEEDropDownAction.ATT_MENUINDEX.equals(paramElement.getAttribute("name"))) {
                            return Integer.parseInt(paramElement.getAttribute(NewJavaEEDropDownAction.TAG_VALUE));
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            return Integer.MAX_VALUE;
        }

        protected INewWizard createWizard() throws CoreException {
            return (INewWizard)CoreUtility.createExtension((IConfigurationElement)this.fConfigurationElement, (String)"class");
        }

        public int getMenuIndex() {
            return this.menuIndex;
        }

        public void setMenuIndex(int menuIndex) {
            this.menuIndex = menuIndex;
        }

        public int compareTo(Object o) {
            NewJavaEEWizardAction action = (NewJavaEEWizardAction)o;
            return this.getMenuIndex() - action.getMenuIndex();
        }
    }
}

