/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.widgets;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jpt.ui.internal.util.SWTUtil;
import org.eclipse.jpt.ui.internal.widgets.AbstractChooserPane;
import org.eclipse.jpt.ui.internal.widgets.AbstractPane;
import org.eclipse.jpt.ui.internal.widgets.PostExecution;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileChooserPane<T extends Model>
extends AbstractChooserPane<T> {
    private WritablePropertyValueModel<String> textHolder;

    public FileChooserPane(AbstractPane<? extends T> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    public FileChooserPane(AbstractPane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    @Override
    protected Runnable buildBrowseAction() {
        return new Runnable(){

            public void run() {
                FileChooserPane.this.promptFile();
            }
        };
    }

    protected ViewerFilter buildFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return true;
            }
        };
    }

    @Override
    protected Control buildMainControl(Composite container) {
        return this.buildText(container, this.textHolder);
    }

    private PostExecution<ElementTreeSelectionDialog> buildSelectionDialogPostExecution() {
        return new PostExecution<ElementTreeSelectionDialog>(){

            @Override
            public void execute(ElementTreeSelectionDialog dialog) {
                if (dialog.getReturnCode() == 0) {
                    FileChooserPane.this.textHolder.setValue((Object)dialog.getResult()[0].toString());
                }
            }
        };
    }

    protected abstract WritablePropertyValueModel<String> buildTextHolder();

    protected ISelectionStatusValidator buildValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length != 1) {
                    return new Status(4, "org.eclipse.jpt.ui", "");
                }
                return new Status(0, "org.eclipse.jpt.ui", "");
            }
        };
    }

    protected abstract String dialogMessage();

    protected abstract String dialogTitle();

    protected abstract IResource getDialogInput();

    @Override
    protected void initialize() {
        super.initialize();
        this.textHolder = this.buildTextHolder();
    }

    protected void promptFile() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.shell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setHelpAvailable(false);
        dialog.setValidator(this.buildValidator());
        dialog.setTitle(this.dialogTitle());
        dialog.setMessage(this.dialogMessage());
        dialog.addFilter(this.buildFilter());
        dialog.setInput((Object)this.getDialogInput());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        SWTUtil.show(dialog, this.buildSelectionDialogPostExecution());
    }
}

