/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.orm.details;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.core.context.orm.EntityMappings;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.internal.orm.JptUiOrmMessages;
import org.eclipse.jpt.ui.internal.widgets.AbstractFormPane;
import org.eclipse.jpt.ui.internal.widgets.AbstractPane;
import org.eclipse.jpt.ui.internal.widgets.PackageChooserPane;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmPackageChooser
extends AbstractFormPane<EntityMappings> {
    public OrmPackageChooser(AbstractFormPane<? extends EntityMappings> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    @Override
    protected void initializeLayout(Composite container) {
        this.initializePackageChooserPane(container);
    }

    private void initializePackageChooserPane(Composite container) {
        new PackageChooserPane<EntityMappings>((AbstractPane)this, container){

            @Override
            protected WritablePropertyValueModel<String> buildTextHolder() {
                return new PropertyAspectAdapter<EntityMappings, String>(this.getSubjectHolder(), new String[]{"packageProperty"}){

                    protected String buildValue_() {
                        return ((EntityMappings)this.subject).getPackage();
                    }

                    protected void setValue_(String value) {
                        ((EntityMappings)this.subject).setPackage(value);
                    }
                };
            }

            @Override
            protected String labelText() {
                return JptUiOrmMessages.EntityMappingsDetailsPage_package;
            }

            @Override
            protected IPackageFragmentRoot packageFragmentRoot() {
                IProject project = ((EntityMappings)this.subject()).getJpaProject().getProject();
                IJavaProject root = JavaCore.create((IProject)project);
                try {
                    return root.getAllPackageFragmentRoots()[0];
                }
                catch (JavaModelException e) {
                    JptUiPlugin.log(e);
                    return null;
                }
            }

            @Override
            protected String packageName() {
                return ((EntityMappings)this.subject()).getPackage();
            }

            @Override
            protected void promptPackage() {
                IPackageFragment packageFragment = this.choosePackage();
                if (packageFragment != null) {
                    String packageName = packageFragment.getElementName();
                    ((EntityMappings)this.subject()).setPackage(packageName);
                }
            }
        };
    }
}

