/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.creation.ui.extension;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.consumption.command.common.AssociateModuleWithEARCommand;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateFacetedProjectCommand;
import org.eclipse.jst.ws.internal.consumption.common.FacetUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.plugin.WSPlugin;
import org.eclipse.wst.ws.internal.preferences.PersistentMergeContext;
import org.eclipse.wst.ws.internal.wsrt.IContext;
import org.eclipse.wst.ws.internal.wsrt.IMerger;
import org.eclipse.wst.ws.internal.wsrt.IWebService;

public class PreServiceAssembleCommand
extends AbstractDataModelOperation {
    private IWebService webService_;
    private String project_;
    private String module_;
    private String earProject_;
    private String ear_;
    private IContext context_;
    private IProject initialProject_;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment environment = this.getEnvironment();
        IStatus status = Status.OK_STATUS;
        if (this.context_.getScenario().getValue() == 1) {
            PersistentMergeContext mergeContext = WSPlugin.getInstance().getMergeContext();
            IMerger merger = this.webService_.getWebServiceInfo().getMerger();
            if (mergeContext.isSkeletonMergeEnabled() && merger != null && (status = merger.merge(monitor, this.getEnvironment().getStatusHandler())).getSeverity() == 4) {
                environment.getStatusHandler().reportError(status);
                return status;
            }
        }
        if (this.context_.getAssemble()) {
            if (this.earProject_ == null) {
                return Status.OK_STATUS;
            }
            CreateFacetedProjectCommand command = new CreateFacetedProjectCommand();
            command.setProjectName(this.earProject_);
            command.setTemplateId("template.jst.ear");
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.project_);
            command.setRequiredFacetVersions(FacetUtils.getRequiredEARFacetVersions((IProject)project));
            command.setServerFactoryId(this.webService_.getWebServiceInfo().getServerFactoryId());
            command.setServerInstanceId(this.webService_.getWebServiceInfo().getServerInstanceId());
            status = command.execute(monitor, adaptable);
            if (status.getSeverity() == 4) {
                environment.getStatusHandler().reportError(status);
                return status;
            }
            AssociateModuleWithEARCommand associateCommand = new AssociateModuleWithEARCommand();
            associateCommand.setProject(this.project_);
            associateCommand.setModule(this.module_);
            associateCommand.setEARProject(this.earProject_);
            associateCommand.setEar(this.ear_);
            associateCommand.setEnvironment(environment);
            status = associateCommand.execute(monitor, null);
            if (status.getSeverity() == 4) {
                environment.getStatusHandler().reportError(status);
            }
            if (this.initialProject_ != null && FacetUtils.isJavaProject((IProject)this.initialProject_)) {
                IProject earProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.earProject_);
                this.addJavaProjectAsUtilityInModalCtx(this.initialProject_, earProject, monitor);
            }
        }
        return status;
    }

    private void addJavaProjectAsUtilityInModalCtx(final IProject projectToAdd, final IProject earProject, IProgressMonitor monitor) {
        IRunnableWithProgress addRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                J2EEUtils.addJavaProjectAsUtilityJar((IProject)projectToAdd, (IProject)earProject, (IProgressMonitor)monitor);
            }
        };
        try {
            ModalContext.run((IRunnableWithProgress)addRunnable, (boolean)true, (IProgressMonitor)monitor, (Display)PlatformUI.getWorkbench().getDisplay());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setInitialProject(IProject initialProject) {
        this.initialProject_ = initialProject;
    }

    public IProject getInitialProject() {
        return this.initialProject_;
    }

    public void setProject(String project) {
        this.project_ = project;
    }

    public void setModule(String module) {
        this.module_ = module;
    }

    public void setEarProject(String earProject) {
        this.earProject_ = earProject;
    }

    public void setEar(String ear) {
        this.ear_ = ear;
    }

    public void setWebService(IWebService webService) {
        this.webService_ = webService;
    }

    public void setContext(IContext context) {
        this.context_ = context;
    }
}

