/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.validation;

import java.util.StringTokenizer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.AnnotationInfo;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ISourceValidator;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.IncrementalReporter;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.document.ModelParserAdapterExtension;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.validation.MarkupQuickAssistProcessor;
import org.w3c.dom.Element;

public class MarkupValidator
implements IValidator,
ISourceValidator {
    protected static final String DQUOTE = "\"";
    protected String SEVERITY_ATTR_MISSING_VALUE = "org.eclipse.wst.sse.ui.temp.error";
    protected String SEVERITY_ATTR_NO_VALUE = "org.eclipse.wst.sse.ui.temp.error";
    protected String SEVERITY_GENERIC_ILLFORMED_SYNTAX = "org.eclipse.wst.sse.ui.temp.warning";
    protected String SEVERITY_STRUCTURE = "org.eclipse.wst.sse.ui.temp.error";
    protected String SEVERITY_SYNTAX_ERROR = "org.eclipse.wst.sse.ui.temp.error";
    protected static final String SQUOTE = "'";
    private final String QUICKASSISTPROCESSOR;
    private IDocument fDocument;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public MarkupValidator() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.quickassist.IQuickAssistProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.QUICKASSISTPROCESSOR = clazz.getName();
    }

    protected final void addAttributeError(String messageText, String attributeValueText, int start, int length, int problemId, IStructuredDocumentRegion sdRegion, IReporter reporter) {
        if (sdRegion.isDeleted()) {
            return;
        }
        int lineNo = this.getLineNumber(start);
        LocalizedMessage message = new LocalizedMessage(1, messageText);
        message.setOffset(start);
        message.setLength(length);
        message.setLineNo(lineNo);
        MarkupQuickAssistProcessor processor = new MarkupQuickAssistProcessor();
        processor.setProblemId(problemId);
        processor.setAdditionalFixInfo(attributeValueText);
        message.setAttribute(this.QUICKASSISTPROCESSOR, (Object)processor);
        AnnotationInfo info = new AnnotationInfo((IMessage)message);
        ((IncrementalReporter)reporter).addAnnotationInfo((IValidator)this, info);
    }

    protected final void addAttributeError(String messageText, Object[] additionalInfo, int start, int length, int problemId, IStructuredDocumentRegion sdRegion, IReporter reporter) {
        if (sdRegion.isDeleted()) {
            return;
        }
        int lineNo = this.getLineNumber(start);
        LocalizedMessage message = new LocalizedMessage(1, messageText);
        message.setOffset(start);
        message.setLength(length);
        message.setLineNo(lineNo);
        MarkupQuickAssistProcessor processor = new MarkupQuickAssistProcessor();
        processor.setProblemId(problemId);
        processor.setAdditionalFixInfo(additionalInfo);
        message.setAttribute(this.QUICKASSISTPROCESSOR, (Object)processor);
        AnnotationInfo info = new AnnotationInfo((IMessage)message);
        ((IncrementalReporter)reporter).addAnnotationInfo((IValidator)this, info);
    }

    private void checkAttributesInEndTag(IStructuredDocumentRegion structuredDocumentRegion, IReporter reporter) {
        if (structuredDocumentRegion.isDeleted()) {
            return;
        }
        ITextRegionList textRegions = structuredDocumentRegion.getRegions();
        int errorCount = 0;
        int start = structuredDocumentRegion.getEndOffset();
        int end = structuredDocumentRegion.getEndOffset();
        int i = 0;
        while (i < textRegions.size() && errorCount < 25 && !structuredDocumentRegion.isDeleted()) {
            ITextRegion textRegion = textRegions.get(i);
            if (textRegion.getType() == "XML_TAG_ATTRIBUTE_NAME" || textRegion.getType() == "XML_TAG_ATTRIBUTE_EQUALS" || textRegion.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                if (start > structuredDocumentRegion.getStartOffset(textRegion)) {
                    start = structuredDocumentRegion.getStartOffset(textRegion);
                }
                end = structuredDocumentRegion.getEndOffset(textRegion);
                ++errorCount;
            }
            ++i;
        }
        if (errorCount > 0) {
            String messageText = XMLUIMessages.End_tag_has_attributes;
            LocalizedMessage message = new LocalizedMessage(2, messageText);
            message.setOffset(start);
            message.setLength(end - start);
            message.setLineNo(this.getLineNumber(start));
            MarkupQuickAssistProcessor processor = new MarkupQuickAssistProcessor();
            processor.setProblemId(3);
            message.setAttribute(this.QUICKASSISTPROCESSOR, (Object)processor);
            AnnotationInfo info = new AnnotationInfo((IMessage)message);
            ((IncrementalReporter)reporter).addAnnotationInfo((IValidator)this, info);
        }
    }

    private void checkClosingBracket(IStructuredDocumentRegion structuredDocumentRegion, IReporter reporter) {
        if (structuredDocumentRegion.isDeleted()) {
            return;
        }
        ITextRegionList regions = structuredDocumentRegion.getRegions();
        ITextRegion r = null;
        boolean closed = false;
        int i = 0;
        while (i < regions.size() && !structuredDocumentRegion.isDeleted()) {
            r = regions.get(i);
            if (r.getType() == "XML_TAG_CLOSE" || r.getType() == "XML_EMPTY_TAG_CLOSE") {
                closed = true;
            }
            ++i;
        }
        if (!closed) {
            String messageText = XMLUIMessages.ReconcileStepForMarkup_6;
            int start = structuredDocumentRegion.getStartOffset();
            int length = structuredDocumentRegion.getText().trim().length();
            int lineNo = this.getLineNumber(start);
            LocalizedMessage message = new LocalizedMessage(1, messageText);
            message.setOffset(start);
            message.setLength(length);
            message.setLineNo(lineNo);
            MarkupQuickAssistProcessor processor = new MarkupQuickAssistProcessor();
            processor.setProblemId(14);
            message.setAttribute(this.QUICKASSISTPROCESSOR, (Object)processor);
            AnnotationInfo info = new AnnotationInfo((IMessage)message);
            ((IncrementalReporter)reporter).addAnnotationInfo((IValidator)this, info);
        }
    }

    private void checkEmptyTag(IStructuredDocumentRegion structuredDocumentRegion, IReporter reporter) {
        if (structuredDocumentRegion.isDeleted()) {
            return;
        }
        ITextRegionList regions = structuredDocumentRegion.getRegions();
        if (regions.size() == 2 && regions.get(0).getType() == "XML_TAG_OPEN" && regions.get(1).getType() == "XML_TAG_CLOSE") {
            String messageText = XMLUIMessages.ReconcileStepForMarkup_3;
            int start = structuredDocumentRegion.getStartOffset();
            int length = structuredDocumentRegion.getLength();
            int lineNo = this.getLineNumber(start);
            LocalizedMessage message = new LocalizedMessage(1, messageText);
            message.setOffset(start);
            message.setLength(length);
            message.setLineNo(lineNo);
            MarkupQuickAssistProcessor processor = new MarkupQuickAssistProcessor();
            processor.setProblemId(1);
            message.setAttribute(this.QUICKASSISTPROCESSOR, (Object)processor);
            AnnotationInfo info = new AnnotationInfo((IMessage)message);
            ((IncrementalReporter)reporter).addAnnotationInfo((IValidator)this, info);
        }
    }

    private int getLineNumber(int start) {
        int lineNo = -1;
        try {
            lineNo = this.getDocument().getLineOfOffset(start);
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
        return lineNo;
    }

    protected void checkForAttributeValue(IStructuredDocumentRegion structuredDocumentRegion, IReporter reporter) {
        if (structuredDocumentRegion.isDeleted()) {
            return;
        }
        int attrState = 0;
        ITextRegionList textRegions = structuredDocumentRegion.getRegions();
        int errorCount = 0;
        int i = 0;
        while (i < textRegions.size() && errorCount < 25) {
            ITextRegion textRegion = textRegions.get(i);
            if (textRegion.getType() == "XML_TAG_ATTRIBUTE_NAME" || this.isTagCloseTextRegion(textRegion)) {
                ITextRegion previousRegion;
                int start;
                String messageText;
                Object[] args;
                if (attrState == 2 && i >= 2) {
                    ITextRegion nameRegion = textRegions.get(i - 2);
                    if (!(nameRegion instanceof ITextRegionContainer)) {
                        args = new Object[]{structuredDocumentRegion.getText(nameRegion)};
                        messageText = NLS.bind((String)XMLUIMessages.Attribute__is_missing_a_value, (Object[])args);
                        start = structuredDocumentRegion.getStartOffset(nameRegion);
                        int end = structuredDocumentRegion.getEndOffset();
                        int textLength = structuredDocumentRegion.getText(nameRegion).trim().length();
                        ITextRegion equalsRegion = textRegions.get(i - 2 + 1);
                        int insertOffset = structuredDocumentRegion.getTextEndOffset(equalsRegion) - end;
                        Object[] additionalFixInfo = new Object[]{structuredDocumentRegion.getText(nameRegion), new Integer(insertOffset)};
                        this.addAttributeError(messageText, additionalFixInfo, start, textLength, 4, structuredDocumentRegion, reporter);
                        ++errorCount;
                    }
                } else if (attrState == 1 && i >= 1 && !((previousRegion = textRegions.get(i - 1)) instanceof ITextRegionContainer)) {
                    args = new Object[]{structuredDocumentRegion.getText(previousRegion)};
                    messageText = NLS.bind((String)XMLUIMessages.Attribute__has_no_value, (Object[])args);
                    start = structuredDocumentRegion.getStartOffset(previousRegion);
                    int textLength = structuredDocumentRegion.getText(previousRegion).trim().length();
                    this.addAttributeError(messageText, structuredDocumentRegion.getText(previousRegion), start, textLength, 5, structuredDocumentRegion, reporter);
                    ++errorCount;
                }
                attrState = 1;
            } else if (textRegion.getType() == "XML_TAG_ATTRIBUTE_EQUALS") {
                attrState = 2;
            } else if (textRegion.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                attrState = 0;
            }
            ++i;
        }
    }

    private void checkForSpaceBeforeName(IStructuredDocumentRegion structuredDocumentRegion, IReporter reporter) {
        IStructuredDocumentRegion prev;
        if (structuredDocumentRegion.isDeleted()) {
            return;
        }
        String sdRegionText = structuredDocumentRegion.getFullText();
        if (sdRegionText.startsWith(" ") && (prev = structuredDocumentRegion.getPrevious()) != null && prev.getRegions().size() == 1 && this.isStartTag(prev)) {
            String messageText = XMLUIMessages.ReconcileStepForMarkup_2;
            int start = structuredDocumentRegion.getStartOffset();
            int length = sdRegionText.trim().equals("") ? sdRegionText.length() : sdRegionText.indexOf(sdRegionText.trim());
            LocalizedMessage message = new LocalizedMessage(1, messageText);
            message.setOffset(start);
            message.setLength(length);
            message.setLineNo(this.getLineNumber(start));
            MarkupQuickAssistProcessor processor = new MarkupQuickAssistProcessor();
            processor.setProblemId(6);
            message.setAttribute(this.QUICKASSISTPROCESSOR, (Object)processor);
            AnnotationInfo info = new AnnotationInfo((IMessage)message);
            ((IncrementalReporter)reporter).addAnnotationInfo((IValidator)this, info);
        }
    }

    private void checkNoNamespaceInPI(IStructuredDocumentRegion structuredDocumentRegion, IReporter reporter) {
        if (structuredDocumentRegion.isDeleted()) {
            return;
        }
        ITextRegionList regions = structuredDocumentRegion.getRegions();
        ITextRegion r = null;
        int errorCount = 0;
        int i = 0;
        while (i < regions.size() && errorCount < 25 && !structuredDocumentRegion.isDeleted()) {
            String piText;
            int index;
            r = regions.get(i);
            if (r.getType() == "XML_TAG_NAME" && (index = (piText = structuredDocumentRegion.getText(r)).indexOf(":")) != -1) {
                String messageText = XMLUIMessages.ReconcileStepForMarkup_4;
                int start = structuredDocumentRegion.getStartOffset(r) + index;
                int length = piText.trim().length() - index;
                LocalizedMessage message = new LocalizedMessage(1, messageText);
                message.setOffset(start);
                message.setLength(length);
                message.setLineNo(this.getLineNumber(start));
                MarkupQuickAssistProcessor processor = new MarkupQuickAssistProcessor();
                processor.setProblemId(8);
                message.setAttribute(this.QUICKASSISTPROCESSOR, (Object)processor);
                AnnotationInfo info = new AnnotationInfo((IMessage)message);
                ((IncrementalReporter)reporter).addAnnotationInfo((IValidator)this, info);
                ++errorCount;
            }
            ++i;
        }
    }

    protected void checkQuotesForAttributeValues(IStructuredDocumentRegion structuredDocumentRegion, IReporter reporter) {
        ITextRegionList regions = structuredDocumentRegion.getRegions();
        ITextRegion r = null;
        String attrValueText = "";
        int errorCount = 0;
        int i = 0;
        while (i < regions.size() && errorCount < 25) {
            r = regions.get(i);
            if (r.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                attrValueText = structuredDocumentRegion.getText(r);
                StringTokenizer st = new StringTokenizer(attrValueText, "\"'", true);
                int size = st.countTokens();
                String one = "";
                String two = "";
                if (size > 0) {
                    one = st.nextToken();
                }
                if (size > 1) {
                    two = st.nextToken();
                }
                if (size <= 2) {
                    String message;
                    if (size == 1) {
                        if (one.equals(DQUOTE) || one.equals(SQUOTE)) {
                            message = XMLUIMessages.ReconcileStepForMarkup_0;
                            this.addAttributeError(message, attrValueText, structuredDocumentRegion.getStartOffset(r), attrValueText.trim().length(), 0, structuredDocumentRegion, reporter);
                            ++errorCount;
                        } else {
                            message = XMLUIMessages.ReconcileStepForMarkup_1;
                            this.addAttributeError(message, attrValueText, structuredDocumentRegion.getStartOffset(r), attrValueText.trim().length(), 13, structuredDocumentRegion, reporter);
                            ++errorCount;
                        }
                    } else if (size == 2 && (one.equals(SQUOTE) && !two.equals(SQUOTE) || one.equals(DQUOTE) && !two.equals(DQUOTE))) {
                        message = XMLUIMessages.ReconcileStepForMarkup_0;
                        this.addAttributeError(message, attrValueText, structuredDocumentRegion.getStartOffset(r), attrValueText.trim().length(), 0, structuredDocumentRegion, reporter);
                        ++errorCount;
                    }
                }
            }
            ++i;
        }
    }

    private void checkStartEndTagPairs(IStructuredDocumentRegion sdRegion, IReporter reporter) {
        if (sdRegion.isDeleted()) {
            return;
        }
        IDOMNode xmlNode = this.getXMLNode(sdRegion);
        if (xmlNode == null) {
            return;
        }
        boolean selfClosed = false;
        String tagName = null;
        if (xmlNode.isContainer()) {
            IStructuredDocumentRegion startRegion;
            IStructuredDocumentRegion endRegion = xmlNode.getEndStructuredDocumentRegion();
            if (endRegion == null && (startRegion = xmlNode.getStartStructuredDocumentRegion()) != null && !startRegion.isDeleted() && "XML_TAG_OPEN".equals(startRegion.getFirstRegion().getType())) {
                ITextRegionList regions = startRegion.getRegions();
                ITextRegion r = null;
                int length = 0;
                int i = 0;
                while (i < regions.size()) {
                    r = regions.get(i);
                    if (r.getType() == "XML_TAG_OPEN" || r.getType() == "XML_TAG_CLOSE") {
                        ++length;
                    } else if (r.getType() == "XML_TAG_NAME") {
                        tagName = sdRegion.getText(r);
                        length += tagName.length();
                    } else if (r.getType() == "XML_EMPTY_TAG_CLOSE") {
                        selfClosed = true;
                    }
                    ++i;
                }
                if (!selfClosed && tagName != null) {
                    IDOMDocument document = (IDOMDocument)xmlNode.getOwnerDocument();
                    if (document != null) {
                        INodeAdapter adapter;
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            try {
                                clazz = class$1 = Class.forName("org.eclipse.wst.xml.core.internal.document.ModelParserAdapter");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((adapter = document.getAdapterFor((Object)clazz)) instanceof ModelParserAdapterExtension && xmlNode instanceof Element && ((ModelParserAdapterExtension)adapter).isEndTagOmissible((Element)xmlNode)) {
                            return;
                        }
                    }
                    Object[] args = new Object[]{tagName};
                    String messageText = NLS.bind((String)XMLUIMessages.Missing_end_tag_, (Object[])args);
                    int start = sdRegion.getStart();
                    int lineNumber = this.getLineNumber(start);
                    LocalizedMessage message = new LocalizedMessage(this.getMissingEndTagSeverity(), messageText);
                    message.setOffset(start);
                    message.setLength(length);
                    message.setLineNo(lineNumber);
                    if (reporter instanceof IncrementalReporter) {
                        Object[] additionalFixInfo = this.getStartEndFixInfo(xmlNode, tagName, r);
                        MarkupQuickAssistProcessor processor = new MarkupQuickAssistProcessor();
                        processor.setProblemId(2);
                        processor.setAdditionalFixInfo(additionalFixInfo);
                        message.setAttribute(this.QUICKASSISTPROCESSOR, (Object)processor);
                        AnnotationInfo info = new AnnotationInfo((IMessage)message);
                        ((IncrementalReporter)reporter).addAnnotationInfo((IValidator)this, info);
                    } else {
                        reporter.addMessage((IValidator)this, (IMessage)message);
                    }
                }
            }
        } else {
            IStructuredDocumentRegion endRegion;
            IStructuredDocumentRegion startRegion = xmlNode.getStartStructuredDocumentRegion();
            if (startRegion == null && !(endRegion = xmlNode.getEndStructuredDocumentRegion()).isDeleted()) {
                ITextRegionList regions = endRegion.getRegions();
                ITextRegion r = null;
                int i = 0;
                while (i < regions.size()) {
                    r = regions.get(i);
                    if (r.getType() == "XML_TAG_NAME") {
                        tagName = sdRegion.getText(r);
                    }
                    ++i;
                }
                if (!selfClosed && tagName != null) {
                    String messageText = StringUtils.unpack((String)XMLUIMessages.Indicate_no_grammar_specified_severities)[0];
                    int start = sdRegion.getStart();
                    int lineNumber = this.getLineNumber(start);
                    LocalizedMessage message = new LocalizedMessage(1, messageText);
                    message.setOffset(start);
                    message.setLength(sdRegion.getTextLength());
                    message.setLineNo(lineNumber);
                    reporter.addMessage((IValidator)this, (IMessage)message);
                }
            }
        }
    }

    protected int getMissingEndTagSeverity() {
        return 1;
    }

    private Object[] getStartEndFixInfo(IDOMNode xmlNode, String tagName, ITextRegion r) {
        String tagClose = "/>";
        int tagCloseOffset = xmlNode.getFirstStructuredDocumentRegion().getEndOffset();
        if (r != null && r.getType() == "XML_TAG_CLOSE") {
            tagClose = "/";
            --tagCloseOffset;
        }
        IDOMNode firstChild = (IDOMNode)xmlNode.getFirstChild();
        while (firstChild != null && firstChild.getNodeType() == 3) {
            firstChild = (IDOMNode)firstChild.getNextSibling();
        }
        int endOffset = xmlNode.getEndOffset();
        int firstChildStartOffset = firstChild == null ? endOffset : firstChild.getStartOffset();
        Object[] additionalFixInfo = new Object[]{tagName, tagClose, new Integer(tagCloseOffset), new Integer(xmlNode.getFirstStructuredDocumentRegion().getEndOffset()), new Integer(firstChildStartOffset), new Integer(endOffset)};
        return additionalFixInfo;
    }

    private void checkStartingSpaceForPI(IStructuredDocumentRegion structuredDocumentRegion, IReporter reporter) {
        if (structuredDocumentRegion.isDeleted()) {
            return;
        }
        IStructuredDocumentRegion prev = structuredDocumentRegion.getPrevious();
        if (prev != null && prev.getStartOffset() == 0 && prev.getType() == "XML_CONTENT") {
            String messageText = XMLUIMessages.ReconcileStepForMarkup_5;
            int start = prev.getStartOffset();
            int length = prev.getLength();
            LocalizedMessage message = new LocalizedMessage(1, messageText);
            message.setOffset(start);
            message.setLength(length);
            message.setLineNo(this.getLineNumber(start));
            MarkupQuickAssistProcessor processor = new MarkupQuickAssistProcessor();
            processor.setProblemId(7);
            message.setAttribute(this.QUICKASSISTPROCESSOR, (Object)processor);
            AnnotationInfo info = new AnnotationInfo((IMessage)message);
            ((IncrementalReporter)reporter).addAnnotationInfo((IValidator)this, info);
        }
    }

    public int getScope() {
        return 1;
    }

    /*
     * Exception decompiling
     */
    private IDOMNode getXMLNode(IStructuredDocumentRegion sdRegion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 68->71)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isEndTag(IStructuredDocumentRegion structuredDocumentRegion) {
        if (structuredDocumentRegion == null || structuredDocumentRegion.isDeleted()) {
            return false;
        }
        return structuredDocumentRegion.getFirstRegion().getType() == "XML_END_TAG_OPEN";
    }

    private boolean isPI(IStructuredDocumentRegion structuredDocumentRegion) {
        if (structuredDocumentRegion == null || structuredDocumentRegion.isDeleted()) {
            return false;
        }
        return structuredDocumentRegion.getFirstRegion().getType() == "XML_PI_OPEN";
    }

    private boolean isStartTag(IStructuredDocumentRegion structuredDocumentRegion) {
        if (structuredDocumentRegion == null || structuredDocumentRegion.isDeleted()) {
            return false;
        }
        return structuredDocumentRegion.getFirstRegion().getType() == "XML_TAG_OPEN";
    }

    private boolean isTagCloseTextRegion(ITextRegion textRegion) {
        return textRegion.getType() == "XML_TAG_CLOSE" || textRegion.getType() == "XML_EMPTY_TAG_CLOSE";
    }

    private boolean isXMLContent(IStructuredDocumentRegion structuredDocumentRegion) {
        if (structuredDocumentRegion == null || structuredDocumentRegion.isDeleted()) {
            return false;
        }
        return structuredDocumentRegion.getFirstRegion().getType() == "XML_CONTENT";
    }

    private void setDocument(IDocument doc) {
        this.fDocument = doc;
    }

    private IDocument getDocument() {
        return this.fDocument;
    }

    public void connect(IDocument document) {
        this.setDocument(document);
    }

    public void disconnect(IDocument document) {
        this.setDocument(null);
    }

    public void validate(IRegion dirtyRegion, IValidationContext helper, IReporter reporter) {
        if (this.getDocument() == null) {
            return;
        }
        if (!(reporter instanceof IncrementalReporter)) {
            return;
        }
        if (!(this.getDocument() instanceof IStructuredDocument)) {
            return;
        }
        reporter.removeAllMessages((IValidator)this);
        IStructuredDocumentRegion[] regions = ((IStructuredDocument)this.fDocument).getStructuredDocumentRegions(dirtyRegion.getOffset(), dirtyRegion.getLength());
        int i = 0;
        while (i < regions.length) {
            this.validate(regions[i], reporter);
            ++i;
        }
    }

    public void validate(IStructuredDocumentRegion structuredDocumentRegion, IReporter reporter) {
        if (structuredDocumentRegion == null) {
            return;
        }
        if (this.isStartTag(structuredDocumentRegion)) {
            this.checkForAttributeValue(structuredDocumentRegion, reporter);
            this.checkStartEndTagPairs(structuredDocumentRegion, reporter);
            this.checkEmptyTag(structuredDocumentRegion, reporter);
            this.checkQuotesForAttributeValues(structuredDocumentRegion, reporter);
            this.checkClosingBracket(structuredDocumentRegion, reporter);
        } else if (this.isEndTag(structuredDocumentRegion)) {
            this.checkAttributesInEndTag(structuredDocumentRegion, reporter);
            this.checkClosingBracket(structuredDocumentRegion, reporter);
            this.checkStartEndTagPairs(structuredDocumentRegion, reporter);
        } else if (this.isPI(structuredDocumentRegion)) {
            this.checkStartingSpaceForPI(structuredDocumentRegion, reporter);
            this.checkNoNamespaceInPI(structuredDocumentRegion, reporter);
        } else if (this.isXMLContent(structuredDocumentRegion)) {
            this.checkForSpaceBeforeName(structuredDocumentRegion, reporter);
        }
    }

    public void cleanup(IReporter reporter) {
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        if (this.getDocument() == null) {
            return;
        }
        if (!(reporter instanceof IncrementalReporter)) {
            return;
        }
        if (!(this.getDocument() instanceof IStructuredDocument)) {
            return;
        }
        reporter.removeAllMessages((IValidator)this);
        IStructuredDocumentRegion[] regions = ((IStructuredDocument)this.fDocument).getStructuredDocumentRegions();
        int i = 0;
        while (i < regions.length) {
            this.validate(regions[i], reporter);
            ++i;
        }
    }
}

