/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.test.wssample;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.consumption.codegen.Generator;
import org.eclipse.jst.ws.internal.consumption.sampleapp.codegen.InputFileGenerator;
import org.eclipse.jst.ws.internal.consumption.sampleapp.codegen.MethodFileGenerator;
import org.eclipse.jst.ws.internal.consumption.sampleapp.codegen.ResultFileGenerator;
import org.eclipse.jst.ws.internal.consumption.sampleapp.codegen.TestClientFileGenerator;
import org.eclipse.jst.ws.internal.consumption.sampleapp.command.GeneratePageCommand;
import org.eclipse.jst.ws.internal.consumption.sampleapp.command.JavaToModelCommand;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.test.CopyWebServiceUtilsJarCommand;
import org.eclipse.wst.command.internal.env.ui.eclipse.EnvironmentUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.datamodel.Model;
import org.eclipse.wst.ws.internal.wsrt.TestInfo;

public class GSTCGenerateCommand
extends AbstractDataModelOperation {
    public static String INPUT = "Input.jsp";
    public static String TEST_CLIENT = "TestClient.jsp";
    public static String RESULT = "Result.jsp";
    public static String METHOD = "Method.jsp";
    private TestInfo testInfo;
    private Model proxyModel;
    private String jspfolder;

    public GSTCGenerateCommand(TestInfo testInfo) {
        this.testInfo = testInfo;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = this.getEnvironment();
        IStatus status = Status.OK_STATUS;
        CopyWebServiceUtilsJarCommand copy = new CopyWebServiceUtilsJarCommand();
        copy.setSampleProject(this.testInfo.getGenerationProject());
        copy.setEnvironment(env);
        status = copy.execute(monitor, null);
        if (status.getSeverity() == 4) {
            return status;
        }
        this.setJSPFolder();
        status = this.createModel(env, monitor);
        if (status.getSeverity() == 4) {
            return status;
        }
        status = this.generatePages(env);
        if (status.getSeverity() == 4) {
            return status;
        }
        return status;
    }

    private void setJSPFolder() {
        IProject clientIProject = ProjectUtilities.getProject((String)this.testInfo.getClientProject());
        if (clientIProject != null && !J2EEUtils.isWebComponent((IProject)clientIProject)) {
            IProject project = ProjectUtilities.getProject((String)this.testInfo.getGenerationProject());
            IPath path = J2EEUtils.getWebContentPath((IProject)project);
            int index = this.testInfo.getJspFolder().lastIndexOf("/");
            String jsp = this.testInfo.getJspFolder().substring(index + 1);
            StringBuffer sb = new StringBuffer();
            sb.append("/").append(path.toString()).append("/").append(jsp);
            this.jspfolder = sb.toString();
        } else {
            this.jspfolder = this.testInfo.getJspFolder();
        }
    }

    private IStatus createModel(IEnvironment env, IProgressMonitor monitor) {
        JavaToModelCommand jtmc = new JavaToModelCommand();
        jtmc.setMethods(this.testInfo.getMethods());
        jtmc.setClientProject(this.testInfo.getClientProject());
        jtmc.setProxyBean(this.testInfo.getProxyBean());
        jtmc.setEnvironment(env);
        IStatus status = jtmc.execute(monitor, null);
        if (status.getSeverity() == 4) {
            return status;
        }
        this.proxyModel = jtmc.getJavaDataModel();
        return status;
    }

    private IStatus generatePages(IEnvironment env) {
        IStatus status = Status.OK_STATUS;
        Path fDestinationFolderPath = new Path(this.jspfolder);
        fDestinationFolderPath = fDestinationFolderPath.makeAbsolute();
        IWorkspaceRoot fWorkspace = ResourcesPlugin.getWorkspace().getRoot();
        IPath pathTest = fDestinationFolderPath.append(TEST_CLIENT);
        IFile fileTest = fWorkspace.getFile(pathTest);
        GeneratePageCommand gpcTest = new GeneratePageCommand(EnvironmentUtils.getResourceContext((IEnvironment)env), this.proxyModel, (Generator)new TestClientFileGenerator(INPUT, METHOD, RESULT), fileTest);
        gpcTest.setEnvironment(env);
        status = gpcTest.execute(null, null);
        if (status.getSeverity() == 4) {
            return status;
        }
        IPath pathInput = fDestinationFolderPath.append(INPUT);
        IFile fileInput = fWorkspace.getFile(pathInput);
        InputFileGenerator inputGenerator = new InputFileGenerator(RESULT);
        GeneratePageCommand gpcInput = new GeneratePageCommand(EnvironmentUtils.getResourceContext((IEnvironment)env), this.proxyModel, (Generator)inputGenerator, fileInput);
        gpcInput.setEnvironment(env);
        status = gpcInput.execute(null, null);
        if (status.getSeverity() == 4) {
            return status;
        }
        IPath pathMethod = fDestinationFolderPath.append(METHOD);
        IFile fileMethod = fWorkspace.getFile(pathMethod);
        MethodFileGenerator methodGenerator = new MethodFileGenerator(INPUT);
        methodGenerator.setClientFolderPath(this.jspfolder);
        GeneratePageCommand gpcMethod = new GeneratePageCommand(EnvironmentUtils.getResourceContext((IEnvironment)env), this.proxyModel, (Generator)methodGenerator, fileMethod);
        gpcMethod.setEnvironment(env);
        status = gpcMethod.execute(null, null);
        if (status.getSeverity() == 4) {
            return status;
        }
        IPath pathResult = fDestinationFolderPath.append(RESULT);
        IFile fileResult = fWorkspace.getFile(pathResult);
        ResultFileGenerator rfg = new ResultFileGenerator();
        rfg.setClientFolderPath(this.jspfolder);
        rfg.setSetEndpointMethod(this.testInfo.getSetEndpointMethod());
        GeneratePageCommand gpcResult = new GeneratePageCommand(EnvironmentUtils.getResourceContext((IEnvironment)env), this.proxyModel, (Generator)rfg, fileResult);
        gpcResult.setEnvironment(env);
        status = gpcResult.execute(null, null);
        return status;
    }
}

