/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModelStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.compiler.util.SuffixConstants;
import org.eclipse.wst.jsdt.internal.core.CreateElementInCUOperation;
import org.eclipse.wst.jsdt.internal.core.CreateFieldOperation;
import org.eclipse.wst.jsdt.internal.core.CreateImportOperation;
import org.eclipse.wst.jsdt.internal.core.CreateMethodOperation;
import org.eclipse.wst.jsdt.internal.core.CreatePackageDeclarationOperation;
import org.eclipse.wst.jsdt.internal.core.CreateTypeOperation;
import org.eclipse.wst.jsdt.internal.core.DeleteElementsOperation;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaModelOperation;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.MultiOperation;
import org.eclipse.wst.jsdt.internal.core.RenameResourceElementsOperation;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class CopyElementsOperation
extends MultiOperation
implements SuffixConstants {
    private Map sources = new HashMap();

    public CopyElementsOperation(IJavaScriptElement[] elementsToCopy, IJavaScriptElement[] destContainers, boolean force) {
        super(elementsToCopy, destContainers, force);
    }

    public CopyElementsOperation(IJavaScriptElement[] elementsToCopy, IJavaScriptElement destContainer, boolean force) {
        this(elementsToCopy, new IJavaScriptElement[]{destContainer}, force);
    }

    protected String getMainTaskName() {
        return Messages.operation_copyElementProgress;
    }

    protected JavaModelOperation getNestedOperation(IJavaScriptElement element) {
        try {
            IJavaScriptElement dest = this.getDestinationParent(element);
            switch (element.getElementType()) {
                case 11: {
                    return new CreatePackageDeclarationOperation(element.getElementName(), (IJavaScriptUnit)dest);
                }
                case 13: {
                    IImportDeclaration importDeclaration = (IImportDeclaration)element;
                    return new CreateImportOperation(element.getElementName(), (IJavaScriptUnit)dest, importDeclaration.getFlags());
                }
                case 7: {
                    if (this.isRenamingMainType(element, dest)) {
                        IPath path = element.getPath();
                        String extension = path.getFileExtension();
                        return new RenameResourceElementsOperation(new IJavaScriptElement[]{dest}, new IJavaScriptElement[]{dest.getParent()}, new String[]{String.valueOf(this.getNewNameFor(element)) + '.' + extension}, this.force);
                    }
                    String source = this.getSourceFor(element);
                    String lineSeparator = Util.getLineSeparator(source, element.getJavaScriptProject());
                    return new CreateTypeOperation(dest, String.valueOf(source) + lineSeparator, this.force);
                }
                case 9: {
                    String source = this.getSourceFor(element);
                    String lineSeparator = Util.getLineSeparator(source, element.getJavaScriptProject());
                    return new CreateMethodOperation(dest, String.valueOf(source) + lineSeparator, this.force);
                }
                case 8: {
                    String source = this.getSourceFor(element);
                    String lineSeparator = Util.getLineSeparator(source, element.getJavaScriptProject());
                    return new CreateFieldOperation(dest, String.valueOf(source) + lineSeparator, this.force);
                }
            }
            return null;
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return null;
        }
    }

    private String getSourceFor(IJavaScriptElement element) throws JavaScriptModelException {
        String source = (String)this.sources.get(element);
        if (source == null && element instanceof IMember) {
            source = ((IMember)element).getSource();
            this.sources.put(element, source);
        }
        return source;
    }

    protected boolean isRenamingMainType(IJavaScriptElement element, IJavaScriptElement dest) throws JavaScriptModelException {
        if ((this.isRename() || this.getNewNameFor(element) != null) && dest.getElementType() == 5) {
            String typeName = dest.getElementName();
            typeName = Util.getNameWithoutJavaLikeExtension(typeName);
            return element.getElementName().equals(typeName) && element.getParent().equals(dest);
        }
        return false;
    }

    protected void processElement(IJavaScriptElement element) throws JavaScriptModelException {
        JavaModelOperation op = this.getNestedOperation(element);
        boolean createElementInCUOperation = op instanceof CreateElementInCUOperation;
        if (op == null) {
            return;
        }
        if (createElementInCUOperation) {
            IJavaScriptElement anchor;
            IJavaScriptElement sibling = (IJavaScriptElement)this.insertBeforeElements.get(element);
            if (sibling != null) {
                ((CreateElementInCUOperation)op).setRelativePosition(sibling, 3);
            } else if (this.isRename() && (anchor = this.resolveRenameAnchor(element)) != null) {
                ((CreateElementInCUOperation)op).setRelativePosition(anchor, 2);
            }
            String newName = this.getNewNameFor(element);
            if (newName != null) {
                ((CreateElementInCUOperation)op).setAlteredName(newName);
            }
        }
        this.executeNestedOperation(op, 1);
        JavaElement destination = (JavaElement)this.getDestinationParent(element);
        IJavaScriptUnit unit = destination.getJavaScriptUnit();
        if (!unit.isWorkingCopy()) {
            unit.close();
        }
        if (createElementInCUOperation && this.isMove() && !this.isRenamingMainType(element, destination)) {
            DeleteElementsOperation deleteOp = new DeleteElementsOperation(new IJavaScriptElement[]{element}, this.force);
            this.executeNestedOperation(deleteOp, 1);
        }
    }

    private IJavaScriptElement resolveRenameAnchor(IJavaScriptElement element) throws JavaScriptModelException {
        IParent parent = (IParent)((Object)element.getParent());
        IJavaScriptElement[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            IJavaScriptElement child = children[i];
            if (child.equals(element)) {
                return child;
            }
            ++i;
        }
        return null;
    }

    protected IJavaScriptModelStatus verify() {
        IJavaScriptModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        if (this.renamingsList != null && this.renamingsList.length != this.elementsToProcess.length) {
            return new JavaModelStatus(980);
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    protected void verify(IJavaScriptElement element) throws JavaScriptModelException {
        if (element == null || !element.exists()) {
            this.error(969, element);
        }
        if (element.getElementType() < 7) {
            this.error(967, element);
        }
        if (element.isReadOnly()) {
            this.error(976, element);
        }
        IJavaScriptElement dest = this.getDestinationParent(element);
        this.verifyDestination(element, dest);
        this.verifySibling(element, dest);
        if (this.renamingsList != null) {
            this.verifyRenaming(element);
        }
    }
}

