/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.jsp;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.ITaglibContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.symbol.IBoundedJavaTypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.IComponentSymbol;
import org.eclipse.jst.jsf.context.symbol.IMapTypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.ITypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.context.symbol.source.AbstractContextSymbolFactory;
import org.eclipse.jst.jsf.context.symbol.source.IAdditionalContextSymbolInfo;
import org.eclipse.jst.jsf.designtime.internal.jsp.DataModelVariableFactory;
import org.eclipse.jst.jsf.designtime.internal.jsp.Messages;
import org.eclipse.jst.jsf.designtime.internal.symbols.ResourceBundleMapSourceFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class JSPDefaultSymbolFactory
extends AbstractContextSymbolFactory {
    protected ISymbol internalCreate(String symbolName, int scope, IAdaptable context, List problems, IAdditionalContextSymbolInfo additionInfo) {
        Attr attr;
        Element owningElement;
        Node curNode;
        IStructuredDocumentContext sContext = (IStructuredDocumentContext)context.getAdapter(IStructuredDocumentContext.class);
        IDOMContextResolver domResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(sContext);
        if (domResolver != null && (curNode = domResolver.getNode()) instanceof Attr && (owningElement = (attr = (Attr)curNode).getOwnerElement()) != null) {
            return this.handleSymbolCreation(symbolName, sContext, attr, owningElement, problems);
        }
        return null;
    }

    private ISymbol handleSymbolCreation(String symbolName, IStructuredDocumentContext context, Attr attr, Node owningElement, List problems) {
        ITaglibContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTaglibContextResolver(context);
        if (resolver == null || !resolver.canResolveContext((IModelContext)context)) {
            return null;
        }
        String uri = resolver.getTagURIForNodeName(owningElement);
        if ("http://java.sun.com/jsf/core".equals(uri)) {
            return this.handleCoreTags(symbolName, owningElement, attr, context, problems);
        }
        if ("http://java.sun.com/jsf/html".equals(uri)) {
            return this.handleHtmlTags(symbolName, owningElement, attr, context, problems);
        }
        return null;
    }

    public boolean supports(IAdaptable context) {
        return context != null && context.getAdapter(IStructuredDocumentContext.class) != null;
    }

    private ISymbol handleHtmlTags(String symbolName, Node owningElement, Attr attr, IStructuredDocumentContext context, List problems) {
        String elementName = owningElement.getLocalName();
        String attrName = attr.getName();
        if ("dataTable".equals(elementName) && "var".equals(attrName)) {
            return DataModelVariableFactory.getInstance().createSymbolForDataTableValue(symbolName, (Element)owningElement, context);
        }
        return null;
    }

    private ISymbol handleCoreTags(String symbolName, Node owningElement, Attr attr, IStructuredDocumentContext context, List problems) {
        String elementName = owningElement.getLocalName();
        if ("loadBundle".equals(elementName)) {
            ISymbol symbol = this.handleLoadBundleTag(symbolName, owningElement, attr, context, problems);
            return symbol;
        }
        return null;
    }

    private ISymbol handleLoadBundleTag(String symbolName, Node owningElement, Attr attr, IStructuredDocumentContext context, List problems) {
        NamedNodeMap attrMap;
        Node baseNameNode;
        String attrName = attr.getName();
        if ("var".equals(attrName) && (baseNameNode = (attrMap = owningElement.getAttributes()).getNamedItem("basename")) != null) {
            try {
                IWorkspaceContextResolver wkspaceResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(context);
                IProject project = wkspaceResolver.getProject();
                if (project == null) {
                    throw new RuntimeException("Error acquiring project");
                }
                Map source = ResourceBundleMapSourceFactory.getResourceBundleMapSource(project, baseNameNode.getNodeValue());
                IMapTypeDescriptor typeDesc = SymbolFactory.eINSTANCE.createIMapTypeDescriptor();
                typeDesc.setMapSource(source);
                IComponentSymbol symbol = SymbolFactory.eINSTANCE.createIComponentSymbol();
                symbol.setName(symbolName);
                symbol.setTypeDescriptor((ITypeDescriptor)typeDesc);
                symbol.setDetailedDescription(String.valueOf(Messages.getString("JSPDefaultSymbolFactory.Resource.bundle.map.detailedDescription")) + baseNameNode.getNodeValue() + "</i>");
                return symbol;
            }
            catch (IOException ioe) {
                problems.add(new Status(4, "org.eclipse.jst.jsf.core", 0, Messages.getString("JSPDefaultSymbolFactory.Problem.ErrorCreatingVariable"), (Throwable)ioe));
            }
            catch (JavaModelException jme) {
                problems.add(new Status(4, "org.eclipse.jst.jsf.core", 0, Messages.getString("JSPDefaultSymbolFactory.Problem.ErrorCreatingVariable"), (Throwable)jme));
            }
            catch (CoreException ce) {
                problems.add(new Status(4, "org.eclipse.jst.jsf.core", 0, Messages.getString("JSPDefaultSymbolFactory.Problem.ErrorCreatingVariable"), (Throwable)ce));
            }
            IBoundedJavaTypeDescriptor typeDesc = SymbolFactory.eINSTANCE.createIBoundedJavaTypeDescriptor();
            typeDesc.setTypeSignatureDelegate("Ljava.lang.Object;");
            IComponentSymbol symbol = SymbolFactory.eINSTANCE.createIComponentSymbol();
            symbol.setName(symbolName);
            symbol.setTypeDescriptor((ITypeDescriptor)typeDesc);
            symbol.setDetailedDescription(String.valueOf(Messages.getString("JSPDefaultSymbolFactory.Resource.bundle.map.detailedDescription")) + baseNameNode.getNodeValue() + "</i>");
            return symbol;
        }
        return null;
    }
}

