/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.hyperlink;

import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.jsdt.web.ui.internal.JsUIPlugin;
import org.eclipse.wst.jsdt.web.ui.internal.Logger;

class URLFileHyperlink
implements IHyperlink {
    private IRegion fRegion;
    private URL fURL;

    public URLFileHyperlink(IRegion region, URL url) {
        this.fRegion = region;
        this.fURL = url;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public String getHyperlinkText() {
        return null;
    }

    public String getTypeLabel() {
        return null;
    }

    public void open() {
        if (this.fURL != null) {
            StorageEditorInput input = new StorageEditorInput(new URLStorage(this.fURL));
            try {
                IEditorDescriptor descriptor = IDE.getEditorDescriptor((String)input.getName());
                if (descriptor != null) {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)descriptor.getId(), (boolean)true);
                }
            }
            catch (PartInitException e) {
                Logger.log(202, e.getMessage(), e);
            }
        }
    }

    static class StorageEditorInput
    implements IStorageEditorInput {
        IStorage fStorage = null;

        StorageEditorInput(IStorage storage) {
            this.fStorage = storage;
        }

        public boolean exists() {
            return this.fStorage != null;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public String getName() {
            return this.fStorage.getName();
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public IStorage getStorage() throws CoreException {
            return this.fStorage;
        }

        public String getToolTipText() {
            return this.fStorage.getFullPath() != null ? this.fStorage.getFullPath().toString() : this.fStorage.getName();
        }
    }

    static class URLStorage
    implements IStorage {
        URL fURL = null;

        URLStorage(URL url) {
            this.fURL = url;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public InputStream getContents() throws CoreException {
            InputStream stream = null;
            try {
                stream = this.fURL.openStream();
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, JsUIPlugin.getDefault().getBundle().getSymbolicName(), 4, this.fURL.toString(), (Throwable)e));
            }
            return stream;
        }

        public IPath getFullPath() {
            return new Path(this.fURL.toString());
        }

        public String getName() {
            return new Path(this.fURL.getFile()).lastSegment();
        }

        public boolean isReadOnly() {
            return true;
        }
    }
}

