/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.structure;

import java.util.ArrayList;
import java.util.ListIterator;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.ResourceModel;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.context.persistence.Persistence;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.resource.persistence.PersistenceResourceModel;
import org.eclipse.jpt.ui.internal.jface.AbstractTreeItemContentProvider;
import org.eclipse.jpt.ui.internal.jface.DelegatingTreeContentAndLabelProvider;
import org.eclipse.jpt.ui.internal.structure.ResourceModelItemContentProvider;
import org.eclipse.jpt.ui.jface.DelegatingContentAndLabelProvider;
import org.eclipse.jpt.ui.jface.TreeItemContentProvider;
import org.eclipse.jpt.ui.jface.TreeItemContentProviderFactory;
import org.eclipse.jpt.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;

public class PersistenceItemContentProviderFactory
implements TreeItemContentProviderFactory {
    public TreeItemContentProvider buildItemContentProvider(Object item, DelegatingContentAndLabelProvider contentAndLabelProvider) {
        DelegatingTreeContentAndLabelProvider treeContentProvider = (DelegatingTreeContentAndLabelProvider)contentAndLabelProvider;
        if (item instanceof PersistenceResourceModel) {
            return new ResourceModelItemContentProvider((ResourceModel)((PersistenceResourceModel)item), treeContentProvider);
        }
        if (item instanceof Persistence) {
            return new PersistenceItemContentProvider((Persistence)item, treeContentProvider);
        }
        if (item instanceof PersistenceUnit) {
            return new PersistenceUnitItemContentProvider((PersistenceUnit)item, treeContentProvider);
        }
        if (item instanceof MappingFileRef) {
            return new MappingFileRefItemContentProvider((MappingFileRef)item, treeContentProvider);
        }
        if (item instanceof ClassRef) {
            return new ClassRefItemContentProvider((ClassRef)item, treeContentProvider);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassRefItemContentProvider
    extends AbstractTreeItemContentProvider<ClassRef> {
        public ClassRefItemContentProvider(ClassRef classRef, DelegatingTreeContentAndLabelProvider contentProvider) {
            super((Model)classRef, contentProvider);
        }

        @Override
        public Object getParent() {
            return ((ClassRef)this.model()).getPersistenceUnit();
        }

        @Override
        public boolean hasChildren() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MappingFileRefItemContentProvider
    extends AbstractTreeItemContentProvider<MappingFileRef> {
        public MappingFileRefItemContentProvider(MappingFileRef mappingFileRef, DelegatingTreeContentAndLabelProvider contentProvider) {
            super((Model)mappingFileRef, contentProvider);
        }

        @Override
        public Object getParent() {
            return ((MappingFileRef)this.model()).getPersistenceUnit();
        }

        @Override
        public boolean hasChildren() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PersistenceItemContentProvider
    extends AbstractTreeItemContentProvider<PersistenceUnit> {
        public PersistenceItemContentProvider(Persistence persistence, DelegatingTreeContentAndLabelProvider contentProvider) {
            super((Model)persistence, contentProvider);
        }

        public Persistence model() {
            return (Persistence)super.model();
        }

        @Override
        public Object getParent() {
            return null;
        }

        @Override
        protected ListValueModel<PersistenceUnit> buildChildrenModel() {
            return new ListAspectAdapter<Persistence, PersistenceUnit>("persistenceUnits", this.model()){

                protected ListIterator<PersistenceUnit> listIterator_() {
                    return ((Persistence)this.subject).persistenceUnits();
                }

                protected int size_() {
                    return ((Persistence)this.subject).persistenceUnitsSize();
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PersistenceUnitItemContentProvider
    extends AbstractTreeItemContentProvider<JpaStructureNode> {
        public PersistenceUnitItemContentProvider(PersistenceUnit persistenceUnit, DelegatingTreeContentAndLabelProvider contentProvider) {
            super((Model)persistenceUnit, contentProvider);
        }

        public PersistenceUnit model() {
            return (PersistenceUnit)super.model();
        }

        public Persistence getParent() {
            return this.model().getParent();
        }

        @Override
        protected ListValueModel<JpaStructureNode> buildChildrenModel() {
            ListAspectAdapter<PersistenceUnit, MappingFileRef> specifiedMappingFileLvm = new ListAspectAdapter<PersistenceUnit, MappingFileRef>("specifiedMappingFileRefs", this.model()){

                protected ListIterator<MappingFileRef> listIterator_() {
                    return ((PersistenceUnit)this.subject).specifiedMappingFileRefs();
                }

                protected int size_() {
                    return ((PersistenceUnit)this.subject).specifiedMappingFileRefsSize();
                }
            };
            PropertyListValueModelAdapter impliedMappingFileLvm = new PropertyListValueModelAdapter((PropertyValueModel)new PropertyAspectAdapter<PersistenceUnit, MappingFileRef>("impliedMappingFileRef", this.model()){

                protected MappingFileRef buildValue_() {
                    return ((PersistenceUnit)this.subject).getImpliedMappingFileRef();
                }
            });
            ListAspectAdapter<PersistenceUnit, ClassRef> specifiedClassLvm = new ListAspectAdapter<PersistenceUnit, ClassRef>("specifiedClassRefs", this.model()){

                protected ListIterator<ClassRef> listIterator_() {
                    return ((PersistenceUnit)this.subject).specifiedClassRefs();
                }

                protected int size_() {
                    return ((PersistenceUnit)this.subject).specifiedClassRefsSize();
                }
            };
            ListAspectAdapter<PersistenceUnit, ClassRef> impliedClassLvm = new ListAspectAdapter<PersistenceUnit, ClassRef>("impliedClassRefs", this.model()){

                protected ListIterator<ClassRef> listIterator_() {
                    return ((PersistenceUnit)this.subject).impliedClassRefs();
                }

                protected int size_() {
                    return ((PersistenceUnit)this.subject).impliedClassRefsSize();
                }
            };
            ArrayList<ListAspectAdapter> list = new ArrayList<ListAspectAdapter>(4);
            list.add(specifiedMappingFileLvm);
            list.add((ListAspectAdapter)impliedMappingFileLvm);
            list.add(specifiedClassLvm);
            list.add(impliedClassLvm);
            return new CompositeListValueModel(list);
        }
    }
}

