/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.ArrayList;
import java.util.ListIterator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.PrimaryKeyJoinColumn;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.PrimaryKeyJoinColumnDialog;
import org.eclipse.jpt.ui.internal.mappings.details.PrimaryKeyJoinColumnStateObject;
import org.eclipse.jpt.ui.internal.util.PaneEnabler;
import org.eclipse.jpt.ui.internal.widgets.AbstractPane;
import org.eclipse.jpt.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.ui.internal.widgets.PostExecution;
import org.eclipse.jpt.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListPropertyValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPrimaryKeyJoinColumnsComposite<T extends Entity>
extends AbstractPane<T> {
    protected WritablePropertyValueModel<PrimaryKeyJoinColumn> joinColumnHolder;

    public AbstractPrimaryKeyJoinColumnsComposite(AbstractPane<? extends T> subjectHolder, Composite parent) {
        super(subjectHolder, parent);
    }

    public AbstractPrimaryKeyJoinColumnsComposite(PropertyValueModel<? extends T> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    private void addJoinColumn(PrimaryKeyJoinColumnStateObject stateObject) {
        Entity subject = (Entity)this.subject();
        int index = subject.specifiedPrimaryKeyJoinColumnsSize();
        PrimaryKeyJoinColumn joinColumn = subject.addSpecifiedPrimaryKeyJoinColumn(index);
        stateObject.updateJoinColumn((BaseJoinColumn)joinColumn);
    }

    private void addPrimaryKeyJoinColumn() {
        PrimaryKeyJoinColumnDialog dialog = new PrimaryKeyJoinColumnDialog(this.shell(), (Entity)this.subject(), null);
        dialog.openDialog(this.buildAddPrimaryKeyJoinColumnPostExecution());
    }

    private PostExecution<PrimaryKeyJoinColumnDialog> buildAddPrimaryKeyJoinColumnPostExecution() {
        return new PostExecution<PrimaryKeyJoinColumnDialog>(){

            @Override
            public void execute(PrimaryKeyJoinColumnDialog dialog) {
                if (dialog.wasConfirmed()) {
                    AbstractPrimaryKeyJoinColumnsComposite.this.addJoinColumn((PrimaryKeyJoinColumnStateObject)((Object)dialog.subject()));
                }
            }
        };
    }

    protected abstract ListValueModel<? extends PrimaryKeyJoinColumn> buildDefaultJoinColumnsListHolder();

    private PostExecution<PrimaryKeyJoinColumnDialog> buildEditPrimaryKeyJoinColumnPostExecution() {
        return new PostExecution<PrimaryKeyJoinColumnDialog>(){

            @Override
            public void execute(PrimaryKeyJoinColumnDialog dialog) {
                if (dialog.wasConfirmed()) {
                    AbstractPrimaryKeyJoinColumnsComposite.this.editJoinColumn((PrimaryKeyJoinColumnStateObject)((Object)dialog.subject()));
                }
            }
        };
    }

    private WritablePropertyValueModel<PrimaryKeyJoinColumn> buildJoinColumnHolder() {
        return new SimplePropertyValueModel();
    }

    private String buildJoinColumnLabel(PrimaryKeyJoinColumn joinColumn) {
        if (joinColumn.isVirtual()) {
            return NLS.bind((String)JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParamsDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        if (joinColumn.getSpecifiedName() == null) {
            if (joinColumn.getSpecifiedReferencedColumnName() == null) {
                return NLS.bind((String)JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParamsBothDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
            }
            return NLS.bind((String)JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParamsFirstDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        if (joinColumn.getSpecifiedReferencedColumnName() == null) {
            return NLS.bind((String)JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParamsSecDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        return NLS.bind((String)JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParams, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
    }

    private AddRemovePane.Adapter buildJoinColumnsAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            @Override
            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                AbstractPrimaryKeyJoinColumnsComposite.this.addPrimaryKeyJoinColumn();
            }

            @Override
            public boolean hasOptionalButton() {
                return true;
            }

            @Override
            public String optionalButtonText() {
                return JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_edit;
            }

            @Override
            public void optionOnSelection(ObjectListSelectionModel listSelectionModel) {
                AbstractPrimaryKeyJoinColumnsComposite.this.editPrimaryKeyJoinColumn(listSelectionModel);
            }

            @Override
            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                int[] selectedIndices = listSelectionModel.selectedIndices();
                Entity entity = (Entity)AbstractPrimaryKeyJoinColumnsComposite.this.subject();
                int index = selectedIndices.length;
                while (--index >= 0) {
                    entity.removeSpecifiedPrimaryKeyJoinColumn(selectedIndices[index]);
                }
            }
        };
    }

    private ILabelProvider buildJoinColumnsListLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                return AbstractPrimaryKeyJoinColumnsComposite.this.buildJoinColumnLabel((PrimaryKeyJoinColumn)element);
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildOverrideDefaultJoinColumnHolder() {
        return new OverrideDefaultJoinColumnHolder();
    }

    private ListValueModel<PrimaryKeyJoinColumn> buildPrimaryKeyJoinColumnsListHolder() {
        ArrayList<ListValueModel<PrimaryKeyJoinColumn>> list = new ArrayList<ListValueModel<PrimaryKeyJoinColumn>>();
        list.add(this.buildSpecifiedJoinColumnsListHolder());
        list.add(this.buildDefaultJoinColumnsListHolder());
        return new CompositeListValueModel(list);
    }

    private ListValueModel<PrimaryKeyJoinColumn> buildPrimaryKeyJoinColumnsListModel() {
        return new ItemPropertyListValueModelAdapter(this.buildPrimaryKeyJoinColumnsListHolder(), new String[]{"specifiedNameProperty", "defaultNameProperty", "specifiedReferencedColumnName", "defaultReferencedColumnName"});
    }

    private ListValueModel<PrimaryKeyJoinColumn> buildSpecifiedJoinColumnsListHolder() {
        return new ListAspectAdapter<Entity, PrimaryKeyJoinColumn>(this.getSubjectHolder(), new String[]{"specifiedPrimaryKeyJoinColumnsList"}){

            protected ListIterator<PrimaryKeyJoinColumn> listIterator_() {
                return ((Entity)this.subject).specifiedPrimaryKeyJoinColumns();
            }

            protected int size_() {
                return ((Entity)this.subject).specifiedPrimaryKeyJoinColumnsSize();
            }
        };
    }

    private void editJoinColumn(PrimaryKeyJoinColumnStateObject stateObject) {
        stateObject.updateJoinColumn((BaseJoinColumn)stateObject.getJoinColumn());
    }

    private void editPrimaryKeyJoinColumn(ObjectListSelectionModel listSelectionModel) {
        PrimaryKeyJoinColumn joinColumn = (PrimaryKeyJoinColumn)listSelectionModel.selectedValue();
        PrimaryKeyJoinColumnDialog dialog = new PrimaryKeyJoinColumnDialog(this.shell(), (Entity)this.subject(), joinColumn);
        dialog.openDialog(this.buildEditPrimaryKeyJoinColumnPostExecution());
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.joinColumnHolder = this.buildJoinColumnHolder();
    }

    @Override
    protected void initializeLayout(Composite container) {
        Group groupPane = this.buildTitledPane(container, JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_primaryKeyJoinColumn);
        this.buildCheckBox(this.buildSubPane((Composite)groupPane, 8), JptUiMappingsMessages.PrimaryKeyJoinColumnsComposite_overrideDefaultPrimaryKeyJoinColumns, this.buildOverrideDefaultJoinColumnHolder());
        AddRemoveListPane<Entity> joinColumnsListPane = new AddRemoveListPane<Entity>(this, (Composite)groupPane, this.buildJoinColumnsAdapter(), this.buildPrimaryKeyJoinColumnsListModel(), this.joinColumnHolder, this.buildJoinColumnsListLabelProvider(), "org.eclipse.jpt.ui.mapping_joinTableJoinColumns");
        this.installJoinColumnsListPaneEnabler(joinColumnsListPane);
    }

    private void installJoinColumnsListPaneEnabler(AddRemoveListPane<Entity> pane) {
        new PaneEnabler((PropertyValueModel<Boolean>)this.buildOverrideDefaultJoinColumnHolder(), (AbstractPane<?>)pane);
    }

    private void updateJoinColumns(boolean selected) {
        if (this.isPopulating()) {
            return;
        }
        this.setPopulating(true);
        try {
            if (selected) {
                this.switchDefaultToSpecified();
            } else {
                int index = ((Entity)this.subject()).specifiedPrimaryKeyJoinColumnsSize();
                while (--index >= 0) {
                    ((Entity)this.subject()).removeSpecifiedPrimaryKeyJoinColumn(index);
                }
            }
        }
        finally {
            this.setPopulating(false);
        }
    }

    protected abstract void switchDefaultToSpecified();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OverrideDefaultJoinColumnHolder
    extends ListPropertyValueModelAdapter<Boolean>
    implements WritablePropertyValueModel<Boolean> {
        public OverrideDefaultJoinColumnHolder() {
            super(AbstractPrimaryKeyJoinColumnsComposite.this.buildSpecifiedJoinColumnsListHolder());
        }

        protected Boolean buildValue() {
            if (this.listHolder.size() > 0) {
                return true;
            }
            return false;
        }

        public void setValue(Boolean value) {
            AbstractPrimaryKeyJoinColumnsComposite.this.updateJoinColumns(value);
        }
    }
}

