/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.GlobalConfiguration;
import org.eclipse.wst.validation.internal.InternalValidatorManager;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.TaskListUtility;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.operations.DefaultResourceUtil;
import org.eclipse.wst.validation.internal.operations.IResourceUtil;
import org.eclipse.wst.validation.internal.operations.MessageInfo;
import org.eclipse.wst.validation.internal.operations.WorkbenchReporter;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidatorManager {
    public static final String VALIDATOR_JOB_FAMILY = "validators";
    private static ValidatorManager inst;
    private static IResourceUtil _resourceUtil;
    private static final Class RESOURCEUTIL_DEFAULTCLASS;
    private static Class _resourceUtilClass;
    private static final Set<ValidatorMetaData> EMPTY_SET;
    private static Class _messageLimitOwner;
    private String[] _internalOwners;
    private Map<IValidatorJob, List<MessageInfo>> _validatorMsgs = Collections.synchronizedMap(new HashMap());
    private Set<ValidatorMetaData> _problemValidators = new HashSet<ValidatorMetaData>();

    static {
        RESOURCEUTIL_DEFAULTCLASS = DefaultResourceUtil.class;
        _resourceUtilClass = RESOURCEUTIL_DEFAULTCLASS;
        EMPTY_SET = new HashSet<ValidatorMetaData>();
    }

    private ValidatorManager() {
        this._internalOwners = new String[0];
        this.addInternalOwner(this.getMessageLimitOwner());
    }

    public void disableAllValidators(IProject currentProject, IProgressMonitor monitor) {
        this.setEnabledValidators(currentProject, EMPTY_SET, monitor);
    }

    public void enableValidator(String validatorId) {
        try {
            ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(validatorId);
            GlobalConfiguration gf = ConfigurationManager.getManager().getGlobalConfiguration();
            gf.enableSingleValidator(vmd);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void disableValidator(String validatorId) {
        try {
            ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(validatorId);
            GlobalConfiguration gf = ConfigurationManager.getManager().getGlobalConfiguration();
            gf.disableSingleValidator(vmd);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void enableValidator(String validatorId, IProject project, boolean manualValidation, boolean buildValidation) {
        try {
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            prjp.setDoesProjectOverride(true);
            ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(validatorId);
            if (manualValidation) {
                prjp.enableSingleManualValidator(vmd);
            }
            if (buildValidation) {
                prjp.enableSingleBuildValidator(vmd);
            }
            prjp.store();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void disableValidator(String validatorId, IProject project, boolean manualValidation, boolean buildValidation) {
        try {
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            prjp.setDoesProjectOverride(true);
            ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(validatorId);
            if (manualValidation) {
                prjp.disableSingleManualValidator(vmd);
            }
            if (buildValidation) {
                prjp.disableSingleBuildValidator(vmd);
            }
            prjp.store();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void addProjectBuildValidationSupport(IProject project) {
        if (project == null) {
            return;
        }
        boolean isBuilderAdded = false;
        try {
            IProjectDescription description = project.getDescription();
            ICommand[] commands = description.getBuildSpec();
            if (commands != null) {
                ICommand[] iCommandArray = commands;
                int n = commands.length;
                int n2 = 0;
                while (n2 < n) {
                    ICommand command = iCommandArray[n2];
                    String builderName = command.getBuilderName();
                    if (builderName != null && builderName.equals("org.eclipse.wst.validation.validationbuilder")) {
                        isBuilderAdded = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!isBuilderAdded) {
                ICommand newCommand = description.newCommand();
                newCommand.setBuilderName("org.eclipse.wst.validation.validationbuilder");
                ICommand[] newCommands = null;
                if (commands != null) {
                    newCommands = new ICommand[commands.length + 1];
                    System.arraycopy(commands, 0, newCommands, 0, commands.length);
                    newCommands[commands.length] = newCommand;
                } else {
                    newCommands = new ICommand[]{newCommand};
                }
                description.setBuildSpec(newCommands);
                project.setDescription(description, null);
            }
        }
        catch (CoreException coreException) {
            return;
        }
    }

    public static boolean doesProjectSupportBuildValidation(IProject project) {
        boolean canRunAV = false;
        if (project == null) {
            return canRunAV;
        }
        try {
            IProjectDescription description = project.getDescription();
            ICommand[] commands = description.getBuildSpec();
            if (commands == null) {
                return canRunAV;
            }
            int i = 0;
            while (i < commands.length) {
                String builderName = commands[i].getBuilderName();
                if (builderName != null && builderName.equals("org.eclipse.wst.validation.validationbuilder")) {
                    canRunAV = true;
                    break;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
        return canRunAV;
    }

    public void enableAllValidators(IProject project, IProgressMonitor monitor) {
        try {
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            prjp.setEnabledValidators(prjp.getValidators());
        }
        catch (InvocationTargetException e) {
            ValidationPlugin.getPlugin().handleException(e);
            ValidationPlugin.getPlugin().handleException(e.getTargetException());
        }
    }

    public Set getProjectConfiguredIncrementalValidators(IProject project) {
        try {
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            return InternalValidatorManager.wrapInSet(prjp.getIncrementalValidators());
        }
        catch (InvocationTargetException e) {
            ValidationPlugin.getPlugin().handleException(e);
            ValidationPlugin.getPlugin().handleException(e.getTargetException());
            return Collections.EMPTY_SET;
        }
    }

    public Set getProjectConfiguredValidatorMetaData(IProject project) {
        try {
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            return InternalValidatorManager.wrapInSet(prjp.getValidators());
        }
        catch (InvocationTargetException e) {
            ValidationPlugin.getPlugin().handleException(e);
            ValidationPlugin.getPlugin().handleException(e.getTargetException());
            return Collections.EMPTY_SET;
        }
    }

    public Set getProjectEnabledIncrementalValidators(IProject project) {
        try {
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            return InternalValidatorManager.wrapInSet(prjp.getEnabledIncrementalValidators(true));
        }
        catch (InvocationTargetException e) {
            ValidationPlugin.getPlugin().handleException(e);
            ValidationPlugin.getPlugin().handleException(e.getTargetException());
            return Collections.EMPTY_SET;
        }
    }

    public Collection getProjectEnabledNonIncrementalValidators(IProject project) {
        try {
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            return InternalValidatorManager.wrapInSet(prjp.getEnabledIncrementalValidators(false));
        }
        catch (InvocationTargetException e) {
            ValidationPlugin.getPlugin().handleException(e);
            ValidationPlugin.getPlugin().handleException(e.getTargetException());
            return Collections.EMPTY_SET;
        }
    }

    public Set getProjectEnabledValidators(IProject project) {
        return this.getEnabledValidators(project);
    }

    public static ValidatorManager getManager() {
        if (inst == null) {
            inst = new ValidatorManager();
        }
        return inst;
    }

    public static IResourceUtil getResourceUtil() {
        if (_resourceUtil == null) {
            if (_resourceUtilClass == null) {
                _resourceUtilClass = RESOURCEUTIL_DEFAULTCLASS;
            }
            try {
                _resourceUtil = (IResourceUtil)_resourceUtilClass.newInstance();
            }
            catch (ClassCastException classCastException) {
                _resourceUtil = null;
            }
            catch (InstantiationException instantiationException) {
                _resourceUtil = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                _resourceUtil = null;
            }
        }
        return _resourceUtil;
    }

    public IMarker[] getValidationTasks(int severity, IProject project) {
        return this.getValidationTasks((IResource)project, severity);
    }

    public IMarker[] getValidationTasks(IResource resource, int severity) {
        return TaskListUtility.getValidationTasks(resource, severity);
    }

    public IMarker[] getValidationTasks(IResource resource, String[] validatorNames) {
        return TaskListUtility.getValidationTasks(resource, validatorNames);
    }

    public ValidatorMetaData getValidatorMetaData(IValidator validator) {
        return ValidationRegistryReader.getReader().getValidatorMetaData(validator);
    }

    public Set<ValidatorMetaData> getIncrementalValidators(Collection vmds) {
        if (vmds == null) {
            return new HashSet<ValidatorMetaData>();
        }
        HashSet<ValidatorMetaData> result = new HashSet<ValidatorMetaData>();
        for (ValidatorMetaData vmd : vmds) {
            if (!vmd.isIncremental()) continue;
            result.add(vmd);
        }
        return result;
    }

    public boolean isApplicableTo(String validatorId, IResource res) {
        if (validatorId == null || res == null) {
            return false;
        }
        ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(validatorId);
        if (vmd == null) {
            return false;
        }
        if (!ValidationRegistryReader.getReader().isConfiguredOnProject(vmd, res.getProject())) {
            return false;
        }
        return vmd.isApplicableTo(res);
    }

    public boolean isAutoValidate(IProject project) {
        return this.isAutoValidate(project, this.isGlobalAutoBuildEnabled());
    }

    public boolean isAutoValidateChecked(IProject project) {
        return this.isAutoValidate(project);
    }

    public boolean isAutoValidateChecked(IProject project, boolean isGlobalAutoBuildOn) {
        return this.isAutoValidate(project, isGlobalAutoBuildOn);
    }

    public boolean isAutoValidate(IProject project, boolean isGlobalAutoBuildOn) {
        return false;
    }

    public boolean canAutoValidateButtonBeEnabled(IProject project) {
        return this.canAutoValidateButtonBeEnabled(project, this.isGlobalAutoBuildEnabled());
    }

    public Set getEnabledIncrementalValidators(IProject project) {
        try {
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            ValidatorMetaData[] vmds = prjp.getEnabledIncrementalValidators(true);
            return InternalValidatorManager.wrapInSet(vmds);
        }
        catch (InvocationTargetException e) {
            ValidationPlugin.getPlugin().handleException(e);
            ValidationPlugin.getPlugin().handleException(e.getTargetException());
            return Collections.EMPTY_SET;
        }
    }

    public Set<ValidatorMetaData> getProjectConfiguredValidators(IProject project, Object[] enabledVal, boolean getIncremental) {
        if (project == null || enabledVal == null || enabledVal.length == 0) {
            return new HashSet<ValidatorMetaData>();
        }
        HashSet<ValidatorMetaData> val = new HashSet<ValidatorMetaData>();
        int i = 0;
        while (i < enabledVal.length) {
            ValidatorMetaData vmd = (ValidatorMetaData)enabledVal[i];
            if (vmd.isConfiguredOnProject(project) && (!getIncremental || vmd.isIncremental())) {
                val.add(vmd);
            }
            ++i;
        }
        return val;
    }

    public boolean containsIncrementalValidators(Object[] enabledVal) {
        if (enabledVal == null || enabledVal.length == 0) {
            return false;
        }
        int i = 0;
        while (i < enabledVal.length) {
            ValidatorMetaData vmd = (ValidatorMetaData)enabledVal[i];
            if (vmd.isIncremental()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected Set<ValidatorMetaData> getEnabledValidators(IProject project) {
        try {
            ValidatorMetaData[] vmds = null;
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            vmds = !prjp.useGlobalPreference() ? prjp.getEnabledValidators() : this.getStateOfProjectLevelValidatorsFromGlobal(prjp);
            return InternalValidatorManager.wrapInSet(vmds);
        }
        catch (InvocationTargetException e) {
            ValidationPlugin.getPlugin().handleException(e);
            ValidationPlugin.getPlugin().handleException(e.getTargetException());
            return Collections.EMPTY_SET;
        }
    }

    private ValidatorMetaData[] getStateOfProjectLevelValidatorsFromGlobal(ProjectConfiguration prjp) throws InvocationTargetException {
        ArrayList<ValidatorMetaData> enabledGlobalValidatorsForProject = new ArrayList<ValidatorMetaData>();
        GlobalConfiguration gf = ConfigurationManager.getManager().getGlobalConfiguration();
        List<String> allProjectValidator = this.getAllValidatorUniqueNames(prjp.getValidators());
        ValidatorMetaData[] validatorMetaDataArray = gf.getBuildEnabledValidators();
        int n = validatorMetaDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            ValidatorMetaData vmd = validatorMetaDataArray[n2];
            if (allProjectValidator.contains(vmd.getValidatorUniqueName())) {
                enabledGlobalValidatorsForProject.add(vmd);
            }
            ++n2;
        }
        return enabledGlobalValidatorsForProject.toArray(new ValidatorMetaData[enabledGlobalValidatorsForProject.size()]);
    }

    private List<String> getAllValidatorUniqueNames(ValidatorMetaData[] metaData) {
        ArrayList<String> names = new ArrayList<String>();
        ValidatorMetaData[] validatorMetaDataArray = metaData;
        int n = metaData.length;
        int n2 = 0;
        while (n2 < n) {
            ValidatorMetaData vmd = validatorMetaDataArray[n2];
            names.add(vmd.getValidatorUniqueName());
            ++n2;
        }
        return names;
    }

    protected Set<ValidatorMetaData> getManualEnabledValidators(IProject project) {
        try {
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            ValidatorMetaData[] vmds = prjp.getManualEnabledValidators();
            return InternalValidatorManager.wrapInSet(vmds);
        }
        catch (InvocationTargetException e) {
            ValidationPlugin.getPlugin().handleException(e);
            ValidationPlugin.getPlugin().handleException(e.getTargetException());
            return Collections.EMPTY_SET;
        }
    }

    protected Set<ValidatorMetaData> getBuildEnabledValidators(IProject project) {
        try {
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            ValidatorMetaData[] vmds = prjp.getBuildEnabledValidators();
            return InternalValidatorManager.wrapInSet(vmds);
        }
        catch (InvocationTargetException e) {
            ValidationPlugin.getPlugin().handleException(e);
            ValidationPlugin.getPlugin().handleException(e.getTargetException());
            return Collections.EMPTY_SET;
        }
    }

    public void updateTaskList(IProject project) {
        try {
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            ValidatorMetaData[] vmds = prjp.getDisabledValidators();
            int i = 0;
            while (i < vmds.length) {
                ValidatorMetaData vmd = vmds[i];
                WorkbenchReporter.removeAllMessages((IResource)project, vmd.getValidatorNames(), null);
                ++i;
            }
        }
        catch (InvocationTargetException e) {
            ValidationPlugin.getPlugin().handleException(e);
            ValidationPlugin.getPlugin().handleException(e.getTargetException());
        }
    }

    public boolean canAutoValidateButtonBeEnabled(IProject project, boolean isGlobalAutoBuildOn) {
        try {
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            boolean incrementalValEnabled = prjp.numberOfEnabledIncrementalValidators() > 0;
            return this.canAutoValidateButtonBeEnabled(project, isGlobalAutoBuildOn, incrementalValEnabled);
        }
        catch (InvocationTargetException e) {
            ValidationPlugin.getPlugin().handleException(e);
            ValidationPlugin.getPlugin().handleException(e.getTargetException());
            return false;
        }
    }

    public boolean canAutoValidateButtonBeEnabled(IProject project, boolean isGlobalAutoBuildOn, boolean incrementalValEnabled) {
        boolean doesProjectSupportAutoValidate = ValidatorManager.doesProjectSupportBuildValidation(project);
        return doesProjectSupportAutoValidate && isGlobalAutoBuildOn && incrementalValEnabled;
    }

    public boolean isEnabled(IProject project, String validatorName) {
        try {
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            return prjp.isEnabled(validatorName);
        }
        catch (InvocationTargetException e) {
            ValidationPlugin.getPlugin().handleException(e);
            ValidationPlugin.getPlugin().handleException(e.getTargetException());
            return false;
        }
    }

    public boolean isEnabled(IProject project, ValidatorMetaData vmd) {
        try {
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            return prjp.isEnabled(vmd);
        }
        catch (InvocationTargetException e) {
            ValidationPlugin.getPlugin().handleException(e);
            ValidationPlugin.getPlugin().handleException(e.getTargetException());
            return false;
        }
    }

    public boolean isConfigured(IProject project, ValidatorMetaData vmd) {
        return ValidationRegistryReader.getReader().isConfiguredOnProject(vmd, project);
    }

    public boolean isGlobalAutoBuildEnabled() {
        return ResourcesPlugin.getWorkspace().isAutoBuilding();
    }

    public int numberProjectEnabledValidators(IProject project) {
        if (project == null) {
            return 0;
        }
        try {
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            return prjp.numberOfEnabledValidators();
        }
        catch (InvocationTargetException e) {
            ValidationPlugin.getPlugin().handleException(e);
            ValidationPlugin.getPlugin().handleException(e.getTargetException());
            return 0;
        }
    }

    public void suspendValidation(IProject project, boolean suspend) {
        ValidationFramework.getDefault().suspendValidation(project, suspend);
    }

    public void suspendAllValidation(boolean suspend) {
        ValidationFramework.getDefault().suspendAllValidation(suspend);
    }

    public boolean isSuspended() {
        return ValidationFramework.getDefault().isSuspended();
    }

    public boolean isSuspended(IProject project) {
        return ValidationFramework.getDefault().isSuspended(project);
    }

    public boolean isProjectSuspended(IProject project) {
        return ValidationFramework.getDefault().isProjectSuspended(project);
    }

    public void setEnabledValidators(IProject project, Set<ValidatorMetaData> vmdsSet, IProgressMonitor monitor) {
        try {
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            ValidatorMetaData[] vmds = null;
            if (vmdsSet == null) {
                vmds = new ValidatorMetaData[]{};
            } else {
                vmds = new ValidatorMetaData[vmdsSet.size()];
                vmdsSet.toArray(vmds);
            }
            prjp.setEnabledValidators(vmds);
            this.updateTaskList(project);
        }
        catch (InvocationTargetException e) {
            ValidationPlugin.getPlugin().handleException(e);
            ValidationPlugin.getPlugin().handleException(e.getTargetException());
        }
    }

    public static void setResourceUtilClass(Class clazz) {
        _resourceUtilClass = clazz;
    }

    public void setNoMessageLimit(IProject project) {
    }

    private IMarker[] getLimitMessage(IProject project) {
        IMarker[] exceededMessage = TaskListUtility.getValidationTasks((IResource)project, WorkbenchReporter.getUniqueId(this.getMessageLimitOwner()));
        if (exceededMessage != null && exceededMessage.length != 0) {
            return exceededMessage;
        }
        return null;
    }

    public boolean removeMessageLimitExceeded(IProject project) {
        IMarker[] exceededMessage = this.getLimitMessage(project);
        if (exceededMessage != null) {
            try {
                ResourcesPlugin.getWorkspace().deleteMarkers(exceededMessage);
                return true;
            }
            catch (CoreException e) {
                ValidationPlugin.getPlugin().handleException(e);
            }
        }
        return false;
    }

    public boolean wasValidationTerminated(IProject project) {
        IMarker[] exceededMessage = this.getLimitMessage(project);
        return exceededMessage != null;
    }

    private Class getMessageLimitOwner() {
        if (_messageLimitOwner == null) {
            _messageLimitOwner = this.getClass();
        }
        return _messageLimitOwner;
    }

    public boolean isInternalOwner(String owner) {
        if (owner == null) {
            return false;
        }
        int i = 0;
        while (i < this._internalOwners.length) {
            String internalOwner = this._internalOwners[i];
            if (owner.equals(internalOwner)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addInternalOwner(Class clazz) {
        if (clazz == null) {
            return;
        }
        String[] tempInternalOwners = new String[this._internalOwners.length + 1];
        if (this._internalOwners.length > 0) {
            System.arraycopy(this._internalOwners, 0, tempInternalOwners, 0, this._internalOwners.length);
        }
        tempInternalOwners[this._internalOwners.length] = WorkbenchReporter.getUniqueId(clazz);
        this._internalOwners = tempInternalOwners;
    }

    public void cacheMessage(IValidatorJob validator, MessageInfo info) {
        List<MessageInfo> list = this._validatorMsgs.get(validator);
        if (list == null) {
            list = new ArrayList<MessageInfo>();
            this._validatorMsgs.put(validator, list);
        }
        list.add(info);
    }

    public List<MessageInfo> getMessages(IValidatorJob validator) {
        List<MessageInfo> list = this._validatorMsgs.get(validator);
        if (list == null) {
            list = new ArrayList<MessageInfo>();
        }
        return list;
    }

    public void clearMessages(IValidatorJob validator) {
        List<MessageInfo> list = this._validatorMsgs.get(validator);
        if (list != null) {
            list.clear();
        }
        this._validatorMsgs.remove(validator);
    }

    public Set<ValidatorMetaData> getProblemValidators() {
        return this._problemValidators;
    }
}

