/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.node.AbstractNode;
import org.eclipse.jpt.utility.internal.node.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseJoinColumnStateObject
extends AbstractNode {
    private String columnDefinition;
    private BaseJoinColumn joinColumn;
    private String name;
    private Object owner;
    private String referencedColumnName;
    private String table;
    private Node.Validator validator;
    public static final String COLUMN_DEFINITION_PROPERTY = "columnDefinition";
    public static final String NAME_PROPERTY = "name";
    public static final String NAMES_LIST = "names";
    public static final String REFERENCE_COLUMN_NAMES_LIST = "referenceColumnNames";
    public static final String REFERENCED_COLUMN_NAME_PROPERTY = "referencedColumnName";
    public static final String TABLE_PROPERTY = "table";

    public BaseJoinColumnStateObject(Object owner, BaseJoinColumn joinColumn) {
        super(null);
        this.initialize(owner, joinColumn);
    }

    protected final void checkParent(Node parentNode) {
    }

    private ListIterator<String> columnNames(Table table) {
        if (table == null) {
            return EmptyListIterator.instance();
        }
        List names = CollectionTools.list((Iterator)table.columnNames());
        Collections.sort(names);
        return names.listIterator();
    }

    private int columnsSize(Table table) {
        if (table == null) {
            return 0;
        }
        return table.columnsSize();
    }

    public final String displayString() {
        return "";
    }

    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    public String getDefaultName() {
        if (this.joinColumn == null) {
            return null;
        }
        return this.joinColumn.getDefaultName();
    }

    public String getDefaultReferencedColumnName() {
        if (this.joinColumn == null) {
            return null;
        }
        return this.joinColumn.getDefaultReferencedColumnName();
    }

    public abstract String getDefaultTable();

    public BaseJoinColumn getJoinColumn() {
        return this.joinColumn;
    }

    public String getName() {
        return this.name;
    }

    public abstract Table getNameTable();

    public Object getOwner() {
        return this.owner;
    }

    public String getReferencedColumnName() {
        return this.referencedColumnName;
    }

    public abstract Table getReferencedNameTable();

    public String getTable() {
        return this.table;
    }

    public final Node.Validator getValidator() {
        return this.validator;
    }

    protected void initialize() {
        super.initialize();
        this.validator = NULL_VALIDATOR;
    }

    protected void initialize(Object owner, BaseJoinColumn joinColumn) {
        this.owner = owner;
        this.joinColumn = joinColumn;
        this.table = this.initialTable();
        if (joinColumn != null) {
            this.name = joinColumn.getSpecifiedName();
            this.columnDefinition = joinColumn.getColumnDefinition();
            this.referencedColumnName = joinColumn.getSpecifiedReferencedColumnName();
        }
    }

    protected abstract String initialTable();

    public ListIterator<String> names() {
        return this.columnNames(this.getNameTable());
    }

    public int columnsSize() {
        return this.columnsSize(this.getNameTable());
    }

    public ListIterator<String> referenceColumnNames() {
        return this.columnNames(this.getReferencedNameTable());
    }

    public int referenceColumnsSize() {
        return this.columnsSize(this.getReferencedNameTable());
    }

    public void setColumnDefinition(String columnDefinition) {
        String oldColumnDefinition = this.columnDefinition;
        this.columnDefinition = columnDefinition;
        this.firePropertyChanged(COLUMN_DEFINITION_PROPERTY, oldColumnDefinition, columnDefinition);
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.firePropertyChanged(NAME_PROPERTY, oldName, name);
    }

    public void setReferencedColumnName(String referencedColumnName) {
        String oldReferencedColumnName = this.referencedColumnName;
        this.referencedColumnName = referencedColumnName;
        this.firePropertyChanged(REFERENCED_COLUMN_NAME_PROPERTY, oldReferencedColumnName, referencedColumnName);
    }

    public void setTable(String table) {
        String oldTable = this.table;
        this.table = table;
        this.firePropertyChanged(TABLE_PROPERTY, oldTable, table);
        this.tableChanged();
    }

    public final void setValidator(Node.Validator validator) {
        this.validator = validator;
    }

    protected void tableChanged() {
        this.fireListChanged(NAMES_LIST);
        this.fireListChanged(REFERENCE_COLUMN_NAMES_LIST);
    }

    public ListIterator<String> tables() {
        return EmptyListIterator.instance();
    }

    public void updateJoinColumn(BaseJoinColumn joinColumn) {
        if (this.valuesAreDifferent(this.name, joinColumn.getSpecifiedName())) {
            joinColumn.setSpecifiedName(this.name);
        }
        if (this.valuesAreDifferent(this.referencedColumnName, joinColumn.getSpecifiedReferencedColumnName())) {
            joinColumn.setSpecifiedReferencedColumnName(this.referencedColumnName);
        }
        if (this.valuesAreDifferent(this.columnDefinition, joinColumn.getColumnDefinition())) {
            joinColumn.setColumnDefinition(this.columnDefinition);
        }
    }
}

