/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.j2ee.internal.archive.operations.AppClientArchiveOpsResourceHandler;
import org.eclipse.jst.j2ee.internal.archive.operations.AppClientComponentLoadStrategyImpl;
import org.eclipse.jst.j2ee.internal.archive.operations.J2EEArtifactExportOperation;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class AppClientComponentExportOperation
extends J2EEArtifactExportOperation {
    public AppClientComponentExportOperation(IDataModel model) {
        super(model);
    }

    public void export() throws SaveFailureException, CoreException, InvocationTargetException, InterruptedException {
        SubProgressMonitor subMonitor = new SubProgressMonitor(this.progressMonitor, 1000);
        IArchive archiveFromComponent = null;
        try {
            try {
                archiveFromComponent = JavaEEArchiveUtilities.INSTANCE.openArchive(this.getComponent());
                JavaEEQuickPeek quickPeek = JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(archiveFromComponent);
                if (quickPeek.getJavaEEVersion() == 50) {
                    this.saveArchive(archiveFromComponent, this.getDestinationPath().toOSString(), (IProgressMonitor)subMonitor);
                } else {
                    CommonarchiveFactory caf = ((CommonarchivePackage)EPackage.Registry.INSTANCE.getEPackage("commonarchive.xmi")).getCommonarchiveFactory();
                    AppClientComponentLoadStrategyImpl ls = new AppClientComponentLoadStrategyImpl(this.getComponent());
                    ls.setExportSource(this.isExportSource());
                    this.setModuleFile((ModuleFile)caf.openApplicationClientFile((LoadStrategy)ls, this.getDestinationPath().toOSString()));
                    ls.setProgressMonitor((IProgressMonitor)subMonitor);
                    this.getModuleFile().saveAsNoReopen(this.getDestinationPath().toOSString());
                }
            }
            catch (SaveFailureException ex) {
                throw ex;
            }
            catch (Exception e) {
                throw new SaveFailureException(AppClientArchiveOpsResourceHandler.ARCHIVE_OPERATION_OpeningArchive, e);
            }
        }
        finally {
            if (archiveFromComponent != null) {
                JavaEEArchiveUtilities.INSTANCE.closeArchive(archiveFromComponent);
            }
            subMonitor.done();
        }
    }

    protected String archiveString() {
        return AppClientArchiveOpsResourceHandler.Application_Client_File_UI_;
    }
}

