/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Collator;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PrimitiveType;
import org.eclipse.jpt.db.Column;
import org.eclipse.jpt.db.internal.DTPDatabaseWrapper;
import org.eclipse.jpt.db.internal.DTPTableWrapper;
import org.eclipse.jpt.db.internal.DTPWrapper;
import org.eclipse.jpt.utility.JavaType;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.NameTools;
import org.eclipse.jpt.utility.internal.SimpleJavaType;

final class DTPColumnWrapper
extends DTPWrapper
implements Column {
    private final DTPTableWrapper table;
    private final org.eclipse.datatools.modelbase.sql.tables.Column dtpColumn;
    private static final JavaType DEFAULT_JAVA_TYPE = new SimpleJavaType(Object.class);
    private static final JavaType BLOB_JAVA_TYPE = new SimpleJavaType(Blob.class);
    private static final JavaType BYTE_ARRAY_JAVA_TYPE = new SimpleJavaType(byte[].class);
    private static final JavaType CLOB_JAVA_TYPE = new SimpleJavaType(Clob.class);
    private static final JavaType STRING_JAVA_TYPE = new SimpleJavaType(String.class);
    private static final JavaType UTIL_DATE_JAVA_TYPE = new SimpleJavaType(java.util.Date.class);
    private static final JavaType SQL_DATE_JAVA_TYPE = new SimpleJavaType(Date.class);
    private static final JavaType SQL_TIME_JAVA_TYPE = new SimpleJavaType(Time.class);
    private static final JavaType SQL_TIMESTAMP_JAVA_TYPE = new SimpleJavaType(Timestamp.class);
    private static final JavaType BIG_DECIMAL_JAVA_TYPE = new SimpleJavaType(BigDecimal.class);
    private static final JavaType LONG_JAVA_TYPE = new SimpleJavaType(Long.TYPE);

    DTPColumnWrapper(DTPTableWrapper table, org.eclipse.datatools.modelbase.sql.tables.Column dtpColumn) {
        super(table, dtpColumn);
        this.table = table;
        this.dtpColumn = dtpColumn;
    }

    synchronized void catalogObjectChanged(int eventType) {
        this.getConnectionProfile().columnChanged(this, eventType);
    }

    public String getName() {
        return this.dtpColumn.getName();
    }

    public String getDataTypeName() {
        DataType dataType = this.dtpColumn.getDataType();
        return dataType == null ? null : dataType.getName();
    }

    public String getJavaFieldName() {
        String jName = this.getName();
        if (!this.isCaseSensitive()) {
            jName = jName.toLowerCase();
        }
        return NameTools.convertToJavaIdentifier((String)jName);
    }

    public boolean matchesJavaFieldName(String javaFieldName) {
        return this.isCaseSensitive() ? this.getName().equals(javaFieldName) : this.getName().equalsIgnoreCase(javaFieldName);
    }

    public String getPrimaryKeyJavaTypeDeclaration() {
        return this.getPrimaryKeyJavaType().declaration();
    }

    public JavaType getPrimaryKeyJavaType() {
        return this.jpaSpecCompliantPrimaryKeyJavaType(this.getJavaType());
    }

    private JavaType jpaSpecCompliantPrimaryKeyJavaType(JavaType javaType) {
        if (javaType.isVariablePrimitive() || javaType.isVariablePrimitiveWrapper() || javaType.equals(STRING_JAVA_TYPE) || javaType.equals(UTIL_DATE_JAVA_TYPE) || javaType.equals(SQL_DATE_JAVA_TYPE)) {
            return javaType;
        }
        if (javaType.equals(BIG_DECIMAL_JAVA_TYPE)) {
            return LONG_JAVA_TYPE;
        }
        if (javaType.equals(SQL_TIME_JAVA_TYPE)) {
            return UTIL_DATE_JAVA_TYPE;
        }
        if (javaType.equals(SQL_TIMESTAMP_JAVA_TYPE)) {
            return UTIL_DATE_JAVA_TYPE;
        }
        return STRING_JAVA_TYPE;
    }

    public String getJavaTypeDeclaration() {
        return this.getJavaType().declaration();
    }

    public JavaType getJavaType() {
        DataType dataType = this.dtpColumn.getDataType();
        return dataType instanceof PredefinedDataType ? this.jpaSpecCompliantJavaType(this.javaType((PredefinedDataType)dataType)) : DEFAULT_JAVA_TYPE;
    }

    private JavaType javaType(PredefinedDataType dataType) {
        String dtpJavaClassName = this.predefinedDataTypeDefinition(dataType).getJavaClassName();
        return new SimpleJavaType(ClassTools.classNameForTypeDeclaration((String)dtpJavaClassName));
    }

    private PredefinedDataTypeDefinition predefinedDataTypeDefinition(PredefinedDataType dataType) {
        return this.database().getDtpDefinition().getPredefinedDataTypeDefinition(dataType.getName());
    }

    private JavaType jpaSpecCompliantJavaType(JavaType javaType) {
        if (javaType.equals(BLOB_JAVA_TYPE)) {
            return BYTE_ARRAY_JAVA_TYPE;
        }
        if (javaType.equals(CLOB_JAVA_TYPE)) {
            return STRING_JAVA_TYPE;
        }
        return javaType;
    }

    public boolean dataTypeIsLOB() {
        DataType dataType = this.dtpColumn.getDataType();
        return dataType instanceof PredefinedDataType ? this.primitiveTypeIsLob(((PredefinedDataType)dataType).getPrimitiveType()) : false;
    }

    private boolean primitiveTypeIsLob(PrimitiveType primitiveType) {
        return primitiveType == PrimitiveType.BINARY_LARGE_OBJECT_LITERAL || primitiveType == PrimitiveType.CHARACTER_LARGE_OBJECT_LITERAL || primitiveType == PrimitiveType.NATIONAL_CHARACTER_LARGE_OBJECT_LITERAL;
    }

    public int compareTo(Column column) {
        return Collator.getInstance().compare(this.getName(), column.getName());
    }

    boolean wraps(org.eclipse.datatools.modelbase.sql.tables.Column column) {
        return this.dtpColumn == column;
    }

    boolean isCaseSensitive() {
        return this.table.isCaseSensitive();
    }

    DTPDatabaseWrapper database() {
        return this.table.database();
    }
}

