/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.spelling;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.SpellCheckEngine;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.WordCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.ISpellCheckEngine;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.wst.jsdt.ui.text.java.IInvocationContext;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposal;

public class WordIgnoreProposal
implements IJavaCompletionProposal {
    private IInvocationContext fContext;
    private String fWord;

    public WordIgnoreProposal(String word, IInvocationContext context) {
        this.fWord = word;
        this.fContext = context;
    }

    public final void apply(IDocument document) {
        ISpellCheckEngine engine = SpellCheckEngine.getInstance();
        ISpellChecker checker = engine.getSpellChecker();
        if (checker != null) {
            checker.ignoreWord(this.fWord);
            SpellingProblem.removeAllInActiveEditor((ITextEditor)this.getEditor(), (String)this.fWord);
        }
    }

    private ITextEditor getEditor() {
        IWorkbenchPage activePage = JavaScriptPlugin.getActivePage();
        if (activePage == null) {
            return null;
        }
        IEditorPart editor = activePage.getActiveEditor();
        if (activePage.getActivePart() != editor || !(editor instanceof ITextEditor)) {
            return null;
        }
        return (ITextEditor)editor;
    }

    public String getAdditionalProposalInfo() {
        return Messages.format(JavaUIMessages.Spelling_ignore_info, new String[]{WordCorrectionProposal.getHtmlRepresentation(this.fWord)});
    }

    public final IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return Messages.format(JavaUIMessages.Spelling_ignore_label, new String[]{this.fWord});
    }

    public Image getImage() {
        return JavaPluginImages.get("org.eclipse.wst.jsdt.ui.never_translate.gif");
    }

    public final int getRelevance() {
        return -2147483647;
    }

    public final Point getSelection(IDocument document) {
        return new Point(this.fContext.getSelectionOffset(), this.fContext.getSelectionLength());
    }
}

