/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.wst.jsdt.ui.CodeGeneration;
import org.eclipse.wst.jsdt.ui.JavaScriptElementImageDescriptor;

public class ConstructorFromSuperclassProposal
extends LinkedCorrectionProposal {
    private TypeDeclaration fTypeNode;
    private IFunctionBinding fSuperConstructor;

    public ConstructorFromSuperclassProposal(IJavaScriptUnit cu, TypeDeclaration typeNode, IFunctionBinding superConstructor, int relevance) {
        super("", cu, (ASTRewrite)null, relevance, (Image)null);
        this.fTypeNode = typeNode;
        this.fSuperConstructor = superConstructor;
    }

    public Image getImage() {
        return JavaScriptPlugin.getImageDescriptorRegistry().get((ImageDescriptor)new JavaScriptElementImageDescriptor(JavaPluginImages.DESC_MISC_PUBLIC, 512, JavaElementImageProvider.SMALL_SIZE));
    }

    public String getDisplayString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.fTypeNode.getName().getIdentifier());
        buf.append('(');
        if (this.fSuperConstructor != null) {
            ITypeBinding[] paramTypes = this.fSuperConstructor.getParameterTypes();
            int i = 0;
            while (i < paramTypes.length) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(paramTypes[i].getName());
                ++i;
            }
        }
        buf.append(')');
        return Messages.format(CorrectionMessages.ConstructorFromSuperclassProposal_description, buf.toString());
    }

    protected ASTRewrite getRewrite() throws CoreException {
        AST ast = this.fTypeNode.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        this.createImportRewrite((JavaScriptUnit)this.fTypeNode.getRoot());
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(this.getCompilationUnit().getJavaScriptProject());
        if (!settings.createComments) {
            settings = null;
        }
        FunctionDeclaration newMethodDecl = this.createNewMethodDeclaration(ast, this.fSuperConstructor, rewrite, settings);
        rewrite.getListRewrite((ASTNode)this.fTypeNode, TypeDeclaration.BODY_DECLARATIONS_PROPERTY).insertFirst((ASTNode)newMethodDecl, null);
        this.addLinkedRanges(rewrite, newMethodDecl);
        return rewrite;
    }

    private void addLinkedRanges(ASTRewrite rewrite, FunctionDeclaration newStub) {
        List parameters = newStub.parameters();
        int i = 0;
        while (i < parameters.size()) {
            SingleVariableDeclaration curr = (SingleVariableDeclaration)parameters.get(i);
            String name = curr.getName().getIdentifier();
            this.addLinkedPosition(rewrite.track((ASTNode)curr.getType()), false, "arg_type_" + name);
            this.addLinkedPosition(rewrite.track((ASTNode)curr.getName()), false, "arg_name_" + name);
            ++i;
        }
    }

    private FunctionDeclaration createNewMethodDeclaration(AST ast, IFunctionBinding binding, ASTRewrite rewrite, CodeGenerationSettings commentSettings) throws CoreException {
        String string;
        String name = this.fTypeNode.getName().getIdentifier();
        FunctionDeclaration decl = ast.newFunctionDeclaration();
        decl.setConstructor(true);
        decl.setName(ast.newSimpleName(name));
        Block body = ast.newBlock();
        decl.setBody(body);
        SuperConstructorInvocation invocation = null;
        List parameters = decl.parameters();
        String[] paramNames = this.getArgumentNames(binding);
        ITypeBinding enclosingInstance = this.getEnclosingInstance();
        if (enclosingInstance != null) {
            invocation = this.addEnclosingInstanceAccess(rewrite, parameters, paramNames, enclosingInstance);
        }
        if (binding == null) {
            decl.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        } else {
            decl.modifiers().addAll(ASTNodeFactory.newModifiers(ast, binding.getModifiers()));
            ITypeBinding[] params = binding.getParameterTypes();
            int i = 0;
            while (i < params.length) {
                SingleVariableDeclaration var = ast.newSingleVariableDeclaration();
                var.setType(this.getImportRewrite().addImport(params[i], ast));
                var.setName(ast.newSimpleName(paramNames[i]));
                parameters.add(var);
                ++i;
            }
            List thrownExceptions = decl.thrownExceptions();
            ITypeBinding[] excTypes = binding.getExceptionTypes();
            int i2 = 0;
            while (i2 < excTypes.length) {
                String excTypeName = this.getImportRewrite().addImport(excTypes[i2]);
                thrownExceptions.add(ASTNodeFactory.newName(ast, excTypeName));
                ++i2;
            }
            if (invocation == null) {
                invocation = ast.newSuperConstructorInvocation();
            }
            List arguments = invocation.arguments();
            int i3 = 0;
            while (i3 < paramNames.length) {
                SimpleName argument = ast.newSimpleName(paramNames[i3]);
                arguments.add(argument);
                this.addLinkedPosition(rewrite.track((ASTNode)argument), false, "arg_name_" + paramNames[i3]);
                ++i3;
            }
        }
        String bodyStatement = invocation == null ? "" : ASTNodes.asFormattedString((ASTNode)invocation, 0, String.valueOf('\n'), this.getCompilationUnit().getJavaScriptProject().getOptions(true));
        String placeHolder = CodeGeneration.getMethodBodyContent(this.getCompilationUnit(), name, name, true, bodyStatement, String.valueOf('\n'));
        if (placeHolder != null) {
            ASTNode todoNode = rewrite.createStringPlaceholder(placeHolder, 41);
            body.statements().add(todoNode);
        }
        if (commentSettings != null && (string = CodeGeneration.getMethodComment(this.getCompilationUnit(), name, decl, null, String.valueOf('\n'))) != null) {
            JSdoc javadoc = (JSdoc)rewrite.createStringPlaceholder(string, 29);
            decl.setJavadoc(javadoc);
        }
        return decl;
    }

    private SuperConstructorInvocation addEnclosingInstanceAccess(ASTRewrite rewrite, List parameters, String[] paramNames, ITypeBinding enclosingInstance) throws CoreException {
        AST ast = rewrite.getAST();
        SuperConstructorInvocation invocation = ast.newSuperConstructorInvocation();
        SingleVariableDeclaration var = ast.newSingleVariableDeclaration();
        var.setType(this.getImportRewrite().addImport(enclosingInstance, ast));
        String[] enclosingArgNames = StubUtility.getArgumentNameSuggestions(this.getCompilationUnit().getJavaScriptProject(), enclosingInstance.getTypeDeclaration().getName(), 0, paramNames);
        String firstName = enclosingArgNames[0];
        var.setName(ast.newSimpleName(firstName));
        parameters.add(var);
        SimpleName enclosing = ast.newSimpleName(firstName);
        invocation.setExpression((Expression)enclosing);
        String key = "arg_name_" + firstName;
        this.addLinkedPosition(rewrite.track((ASTNode)enclosing), false, key);
        int i = 0;
        while (i < enclosingArgNames.length) {
            this.addLinkedPositionProposal(key, enclosingArgNames[i], null);
            ++i;
        }
        return invocation;
    }

    private ITypeBinding getEnclosingInstance() {
        ITypeBinding currBinding = this.fTypeNode.resolveBinding();
        if (currBinding == null || Modifier.isStatic((int)currBinding.getModifiers())) {
            return null;
        }
        ITypeBinding superBinding = currBinding.getSuperclass();
        if (superBinding == null || superBinding.getDeclaringClass() == null || Modifier.isStatic((int)superBinding.getModifiers())) {
            return null;
        }
        ITypeBinding enclosing = superBinding.getDeclaringClass();
        while (currBinding != null) {
            if (Bindings.isSuperType(enclosing, currBinding)) {
                return null;
            }
            if (Modifier.isStatic((int)currBinding.getModifiers())) {
                return null;
            }
            currBinding = currBinding.getDeclaringClass();
        }
        return enclosing;
    }

    private String[] getArgumentNames(IFunctionBinding binding) {
        if (binding == null) {
            return new String[0];
        }
        return StubUtility.suggestArgumentNames(this.getCompilationUnit().getJavaScriptProject(), binding);
    }
}

