/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.dnd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;

public class ResourceTransferDragAdapter
extends DragSourceAdapter
implements TransferDragSourceListener {
    private ISelectionProvider fProvider;
    private static final List EMPTY_LIST = new ArrayList(0);
    static /* synthetic */ Class class$0;

    public ResourceTransferDragAdapter(ISelectionProvider provider) {
        this.fProvider = provider;
        Assert.isNotNull((Object)this.fProvider);
    }

    public Transfer getTransfer() {
        return ResourceTransfer.getInstance();
    }

    public void dragStart(DragSourceEvent event) {
        event.doit = this.convertSelection().size() > 0;
    }

    public void dragSetData(DragSourceEvent event) {
        List resources = this.convertSelection();
        event.data = resources.toArray(new IResource[resources.size()]);
    }

    public void dragFinished(DragSourceEvent event) {
        if (!event.doit) {
            return;
        }
        if (event.detail == 2) {
            this.handleFinishedDropMove(event);
        }
    }

    private List convertSelection() {
        ISelection s = this.fProvider.getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return EMPTY_LIST;
        }
        IStructuredSelection selection = (IStructuredSelection)s;
        ArrayList<IResource> result = new ArrayList<IResource>(selection.size());
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            IResource resource = null;
            if (element instanceof IJavaScriptElement) {
                resource = ((IJavaScriptElement)element).getResource();
            } else if (element instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)element;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                resource = (IResource)iAdaptable.getAdapter((Class)clazz);
            }
            if (resource == null) continue;
            result.add(resource);
        }
        return result;
    }

    private void handleFinishedDropMove(DragSourceEvent event) {
        MultiStatus status = new MultiStatus(JavaScriptPlugin.getPluginId(), 10001, JavaUIMessages.ResourceTransferDragAdapter_cannot_delete_resource, null);
        List resources = this.convertSelection();
        Iterator iter = resources.iterator();
        while (iter.hasNext()) {
            IResource resource = (IResource)iter.next();
            try {
                resource.delete(true, null);
            }
            catch (CoreException e) {
                status.add(e.getStatus());
            }
        }
        if (status.getChildren().length > 0) {
            Shell parent = SWTUtil.getShell(event.widget);
            ErrorDialog error = new ErrorDialog(parent, JavaUIMessages.ResourceTransferDragAdapter_moving_resource, JavaUIMessages.ResourceTransferDragAdapter_cannot_delete_files, (IStatus)status, 4);
            error.open();
        }
    }
}

