/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.utilities;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.internal.emf.resource.Translator;
import org.eclipse.wst.common.internal.emf.utilities.Assert;

public class TranslatorManager {
    private static final TranslatorManager INSTANCE = new TranslatorManager();
    private final Set translators = new HashSet();
    private static final TranslatorDescriptor[] NO_EXTENDED_TRANSLATORS = new TranslatorDescriptor[0];

    public static TranslatorManager getInstance() {
        return INSTANCE;
    }

    private TranslatorManager() {
        new TranslatorRegistry().readRegistry();
    }

    private void addTranslatorDescriptor(TranslatorDescriptor descriptor) {
        Assert.isNotNull(descriptor);
        this.translators.add(descriptor);
    }

    public TranslatorDescriptor[] findTranslators() {
        ArrayList<TranslatorDescriptor> result = new ArrayList<TranslatorDescriptor>();
        TranslatorDescriptor descriptor = null;
        Iterator translatorsItr = this.translators.iterator();
        while (translatorsItr.hasNext()) {
            descriptor = (TranslatorDescriptor)translatorsItr.next();
            result.add(descriptor);
        }
        if (result.size() == 0) {
            return NO_EXTENDED_TRANSLATORS;
        }
        return result.toArray(new TranslatorDescriptor[result.size()]);
    }

    public class TranslatorDescriptor {
        public static final String CLASSNAME = "className";
        private final IConfigurationElement configElement;
        private String className;

        public TranslatorDescriptor(IConfigurationElement aConfigElement) {
            this.configElement = aConfigElement;
            this.className = this.configElement.getAttribute(CLASSNAME);
        }

        public String getClassName() {
            return this.className;
        }

        public Translator createTranslator() {
            Translator instance = null;
            try {
                instance = (Translator)this.configElement.createExecutableExtension(CLASSNAME);
            }
            catch (CoreException e) {
                Logger.getLogger().logError((Throwable)e);
            }
            return instance;
        }
    }

    private class TranslatorRegistry
    extends RegistryReader {
        public static final String TRANSLATOR = "translator";

        public TranslatorRegistry() {
            super("org.eclipse.wst.common.emf", "translatorExtension");
        }

        public boolean readElement(IConfigurationElement element) {
            boolean result = false;
            if (TRANSLATOR.equals(element.getName())) {
                TranslatorManager.this.addTranslatorDescriptor(new TranslatorDescriptor(element));
                result = true;
            }
            return result;
        }
    }
}

