/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Collection;
import org.eclipse.jpt.core.context.MultiRelationshipMapping;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.util.ControlEnabler;
import org.eclipse.jpt.ui.internal.widgets.AbstractFormPane;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderingComposite
extends AbstractFormPane<MultiRelationshipMapping> {
    private Text customOrderingText;

    public OrderingComposite(AbstractFormPane<? extends MultiRelationshipMapping> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    public OrderingComposite(PropertyValueModel<? extends MultiRelationshipMapping> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    @Override
    protected void addPropertyNames(Collection<String> propertyNames) {
        super.addPropertyNames(propertyNames);
        propertyNames.add("orderByProperty");
    }

    private ModifyListener buildCustomTextModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!OrderingComposite.this.isPopulating()) {
                    Text text = (Text)e.widget;
                    OrderingComposite.this.valueChanged(text.getText());
                }
            }
        };
    }

    @Override
    protected void doPopulate() {
        super.doPopulate();
        this.populateCustomOrdering();
    }

    @Override
    protected void initializeLayout(Composite container) {
        Group orderByGroup = this.buildTitledPane(container, JptUiMappingsMessages.OrderByComposite_orderByGroup, "org.eclipse.jpt.ui.mapping_orderBy");
        this.buildRadioButton(this.buildSubPane((Composite)orderByGroup, 8), JptUiMappingsMessages.OrderByComposite_noOrdering, this.buildNoOrderingHolder(), "org.eclipse.jpt.ui.mapping_orderByNoOrdering");
        this.buildRadioButton((Composite)orderByGroup, JptUiMappingsMessages.OrderByComposite_primaryKeyOrdering, this.buildPrimaryKeyOrderingHolder(), "org.eclipse.jpt.ui.mapping_orderByPrimaryKeyOrdering");
        this.buildRadioButton((Composite)orderByGroup, JptUiMappingsMessages.OrderByComposite_customOrdering, this.buildCustomOrderingHolder(), "org.eclipse.jpt.ui.mapping_orderByCustomOrdering");
        this.customOrderingText = this.buildText(this.buildSubPane((Composite)orderByGroup, 0, 16), "org.eclipse.jpt.ui.mapping_orderBy");
        this.customOrderingText.addModifyListener(this.buildCustomTextModifyListener());
        this.installCustomTextEnabler(this.customOrderingText);
    }

    private void installCustomTextEnabler(Text text) {
        new ControlEnabler((PropertyValueModel<Boolean>)this.buildCustomOrderingHolder(), (Control)text);
    }

    private WritablePropertyValueModel<Boolean> buildCustomOrderingHolder() {
        return new PropertyAspectAdapter<MultiRelationshipMapping, Boolean>(this.getSubjectHolder(), new String[]{"customOrderingProperty"}){

            protected Boolean buildValue_() {
                return ((MultiRelationshipMapping)this.subject).isCustomOrdering();
            }

            protected void setValue_(Boolean value) {
                ((MultiRelationshipMapping)this.subject).setCustomOrdering(value.booleanValue());
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildNoOrderingHolder() {
        return new PropertyAspectAdapter<MultiRelationshipMapping, Boolean>(this.getSubjectHolder(), new String[]{"noOrderingProperty"}){

            protected Boolean buildValue_() {
                return ((MultiRelationshipMapping)this.subject).isNoOrdering();
            }

            protected void setValue_(Boolean value) {
                ((MultiRelationshipMapping)this.subject).setNoOrdering(value.booleanValue());
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildPrimaryKeyOrderingHolder() {
        return new PropertyAspectAdapter<MultiRelationshipMapping, Boolean>(this.getSubjectHolder(), new String[]{"pkOrderingProperty"}){

            protected Boolean buildValue_() {
                return ((MultiRelationshipMapping)this.subject).isPkOrdering();
            }

            protected void setValue_(Boolean value) {
                ((MultiRelationshipMapping)this.subject).setPkOrdering(value.booleanValue());
            }
        };
    }

    private void populateCustomOrdering() {
        if (this.subject() != null && ((MultiRelationshipMapping)this.subject()).getOrderBy() != null) {
            this.customOrderingText.setText(((MultiRelationshipMapping)this.subject()).getOrderBy());
        } else {
            this.customOrderingText.setText("");
        }
    }

    @Override
    protected void propertyChanged(String propertyName) {
        super.propertyChanged(propertyName);
        if (propertyName == "orderByProperty") {
            this.populateCustomOrdering();
        }
    }

    private void valueChanged(String value) {
        this.setPopulating(true);
        try {
            ((MultiRelationshipMapping)this.subject()).setOrderBy(value);
        }
        finally {
            this.setPopulating(false);
        }
    }
}

