/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.preferences.ui;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jst.jsp.ui.internal.JSPUIMessages;
import org.eclipse.jst.jsp.ui.internal.JSPUIPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.wst.sse.ui.internal.preferences.ui.AbstractPreferencePage;

public class JSPTypingPreferencePage
extends AbstractPreferencePage {
    private Button fCloseBraces;
    private Button fCloseScriptlets;

    protected Control createContents(Composite parent) {
        Composite composite = super.createComposite(parent, 1);
        this.createAutoComplete(composite);
        this.setSize(composite);
        this.loadPreferences();
        return composite;
    }

    private void createAutoComplete(Composite parent) {
        Group group = this.createGroup(parent, 2);
        group.setText(JSPUIMessages.JSPTyping_Auto_Complete);
        this.fCloseBraces = this.createCheckBox((Composite)group, JSPUIMessages.JSPTyping_Complete_Braces);
        ((GridData)this.fCloseBraces.getLayoutData()).horizontalSpan = 2;
        this.fCloseScriptlets = this.createCheckBox((Composite)group, JSPUIMessages.JSPTyping_Complete_Scriptlets);
        ((GridData)this.fCloseScriptlets.getLayoutData()).horizontalSpan = 2;
    }

    public boolean performOk() {
        boolean result = super.performOk();
        JSPUIPlugin.getDefault().savePluginPreferences();
        return result;
    }

    protected void initializeValues() {
        this.initCheckbox(this.fCloseBraces, "typingCompleteElBraces");
        this.initCheckbox(this.fCloseScriptlets, "typingCompleteScriptlets");
    }

    protected void performDefaults() {
        this.defaultCheckbox(this.fCloseBraces, "typingCompleteElBraces");
        this.defaultCheckbox(this.fCloseScriptlets, "typingCompleteScriptlets");
    }

    private void initCheckbox(Button box, String key) {
        if (box != null && key != null) {
            box.setSelection(this.getPreferenceStore().getBoolean(key));
        }
    }

    private void defaultCheckbox(Button box, String key) {
        if (box != null && key != null) {
            box.setSelection(this.getPreferenceStore().getDefaultBoolean(key));
        }
    }

    protected void storeValues() {
        this.getPreferenceStore().setValue("typingCompleteElBraces", this.fCloseBraces != null ? this.fCloseBraces.getSelection() : false);
        this.getPreferenceStore().setValue("typingCompleteScriptlets", this.fCloseScriptlets != null ? this.fCloseScriptlets.getSelection() : false);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return JSPUIPlugin.getDefault().getPreferenceStore();
    }
}

