/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.actions;

import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Part;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.actions.WSDLPropertiesFormAction;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLOperationElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.SOAPHeaderWrapperFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.perspective.InvokeWSDLOperationTool;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.util.SOAPMessageUtils;
import org.eclipse.wst.ws.internal.explorer.transport.ISOAPMessage;
import org.eclipse.wst.wsdl.binding.soap.SOAPHeader;
import org.w3c.dom.Element;

public class SynchronizeFragmentViewsAction
extends WSDLPropertiesFormAction {
    public SynchronizeFragmentViewsAction(Controller controller) {
        super(controller);
    }

    protected boolean processParsedResults(MultipartFormDataParser parser) throws MultipartFormDataException {
        super.processParsedResults(parser);
        Node selectedNode = this.getSelectedNavigatorNode();
        WSDLOperationElement operElement = (WSDLOperationElement)selectedNode.getTreeElement();
        InvokeWSDLOperationTool invokeWSDLOperationTool = (InvokeWSDLOperationTool)selectedNode.getCurrentToolManager().getSelectedTool();
        String viewID = parser.getParameter("::fragmentViewID");
        this.propertyTable_.put("::fragmentViewID", viewID);
        if (viewID.equals("::fragmentViewSwitchFormToSource")) {
            invokeWSDLOperationTool.setFragmentViewID("::fragmentViewSwitchFormToSource");
            operElement.setPropertyAsObject("propSourceContentNS", null);
            return this.processFormViewParsedResultsHeader(parser, operElement) & this.processFormViewParsedResults(parser, operElement);
        }
        invokeWSDLOperationTool.setFragmentViewID("::fragmentViewSwitchSourceToForm");
        String[] nsDeclarations = parser.getParameterValues("::sourceContentNS");
        if (nsDeclarations != null) {
            operElement.setPropertyAsObject("propSourceContentNS", nsDeclarations);
        }
        ISOAPMessage soapMessage = (ISOAPMessage)operElement.getPropertyAsObject("propSOAPRequestTmp");
        boolean rc = this.processSourceViewParsedResultsHeader(parser, operElement, soapMessage) & this.processSourceViewParsedResults(parser, operElement, soapMessage);
        operElement.setPropertyAsObject("propSOAPRequestTmp", null);
        return rc;
    }

    private boolean processFormViewParsedResultsHeader(MultipartFormDataParser parser, WSDLOperationElement operElement) throws MultipartFormDataException {
        operElement.setPropertyAsObject("propSourceContentHeader", null);
        boolean resultsValid = true;
        for (SOAPHeader soapHeader : operElement.getSOAPHeaders()) {
            IXSDFragment frag = operElement.getHeaderFragment(soapHeader);
            if (frag.processParameterValues(parser)) continue;
            resultsValid = false;
        }
        if (resultsValid) {
            operElement.setPropertyAsString("propSourceContentHeader", null);
        }
        return resultsValid;
    }

    private boolean processFormViewParsedResults(MultipartFormDataParser parser, WSDLOperationElement operElement) throws MultipartFormDataException {
        operElement.setPropertyAsObject("propSourceContent", null);
        boolean resultsValid = true;
        for (Part part : operElement.getOrderedBodyParts()) {
            IXSDFragment frag = operElement.getFragment(part);
            if (frag.processParameterValues(parser)) continue;
            resultsValid = false;
        }
        if (resultsValid) {
            operElement.setPropertyAsString("propSourceContent", null);
        }
        return resultsValid;
    }

    private boolean processSourceViewParsedResultsHeader(MultipartFormDataParser parser, WSDLOperationElement operElement, ISOAPMessage soapMessage) throws MultipartFormDataException {
        Iterator it;
        String sourceContent = parser.getParameter("::sourceContentHeader");
        if (sourceContent != null) {
            operElement.setPropertyAsString("propSourceContentHeader", sourceContent);
        }
        if (!(it = operElement.getSOAPHeaders().iterator()).hasNext()) {
            return true;
        }
        try {
            operElement.getSOAPTransportProvider().newTransport().newDeserializer().deserialize(1, sourceContent, soapMessage);
            Element[] instanceDocuments = soapMessage.getHeaderContent();
            Map namespaceTable = soapMessage.getNamespaceTable();
            boolean sourceElementsValid = true;
            int start = 0;
            while (it.hasNext() && start < instanceDocuments.length) {
                SOAPHeader soapHeader = (SOAPHeader)it.next();
                SOAPHeaderWrapperFragment frag = (SOAPHeaderWrapperFragment)operElement.getHeaderFragment(soapHeader);
                int pos = SOAPMessageUtils.findFirstMatchingElement((Part)soapHeader.getEPart(), instanceDocuments, namespaceTable, frag.getName(), start);
                if (pos == -1) continue;
                Element element = instanceDocuments[pos];
                start = pos + 1;
                if (frag.setParameterValuesFromInstanceDocument(element, namespaceTable)) continue;
                sourceElementsValid = false;
            }
            return sourceElementsValid;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private boolean processSourceViewParsedResults(MultipartFormDataParser parser, WSDLOperationElement operElement, ISOAPMessage soapMessage) throws MultipartFormDataException {
        String sourceContent = parser.getParameter("::sourceContent");
        if (sourceContent != null) {
            operElement.setPropertyAsString("propSourceContent", sourceContent);
        }
        Iterator it = operElement.getOrderedBodyParts().iterator();
        try {
            operElement.getSOAPTransportProvider().newTransport().newDeserializer().deserialize(2, sourceContent, soapMessage);
            Element[] instanceDocuments = soapMessage.getBodyContent();
            boolean sourceElementsValid = true;
            while (it.hasNext()) {
                Part part = (Part)it.next();
                IXSDFragment frag = operElement.getFragment(part);
                if (frag.setParameterValuesFromInstanceDocuments(instanceDocuments)) continue;
                sourceElementsValid = false;
            }
            return sourceElementsValid;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean run() {
        return true;
    }
}

