/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.webservice.componentcore.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jst.j2ee.componentcore.EnterpriseArtifactEdit;
import org.eclipse.jst.j2ee.internal.J2EEConstants;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.webservice.plugin.WebServicePlugin;
import org.eclipse.jst.j2ee.internal.webservices.WSDLServiceExtManager;
import org.eclipse.jst.j2ee.internal.webservices.WSDLServiceHelper;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;
import org.eclipse.jst.j2ee.webservice.wsdd.WsddFactory;
import org.eclipse.jst.j2ee.webservice.wsdd.WsddResource;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

public class WSDDArtifactEdit
extends EnterpriseArtifactEdit {
    public static final Class ADAPTER_TYPE = WSDDArtifactEdit.class;
    public static final String WSIL_FILE_EXT = "wsil";
    public static final String WSDL_FILE_EXT = "wsdl";

    public WSDDArtifactEdit(IProject aProject, boolean toAccessAsReadOnly) throws IllegalArgumentException {
        super(aProject, toAccessAsReadOnly);
    }

    public WSDDArtifactEdit(ArtifactEditModel model) {
        super(model);
    }

    public WSDDArtifactEdit(ModuleCoreNature aNature, IVirtualComponent aModule, boolean toAccessAsReadOnly) {
        super(aNature, aModule, toAccessAsReadOnly);
    }

    public WsddResource getWsddXmiResource() {
        return (WsddResource)this.getDeploymentDescriptorResource();
    }

    public int getJ2EEVersion() {
        return this.getWsddXmiResource().getJ2EEVersionID();
    }

    public Resource getDeploymentDescriptorResource() {
        return this.getArtifactEditModel().getResource(this.getWebServicesXmlResourceURI());
    }

    public static void createDeploymentDescriptor(IProject project, int version) {
        WSDDArtifactEdit wsDDEdit = new WSDDArtifactEdit(project, false);
        try {
            wsDDEdit.createModelRoot(version);
            wsDDEdit.save(null);
        }
        finally {
            Resource newRes = wsDDEdit.getDeploymentDescriptorResource();
            WorkbenchResourceHelperBase.getResourceSet((IProject)project).getResources().remove((Object)newRes);
            newRes.unload();
            wsDDEdit.dispose();
        }
    }

    public URI getWebServicesXmlResourceURI() {
        URI resourceURI = J2EEConstants.WEB_SERVICES_WEB_INF_DD_URI_OBJ;
        if (WSDDArtifactEdit.isValidAppClientModule(this.getComponent())) {
            resourceURI = J2EEConstants.WEB_SERVICES_META_INF_DD_URI_OBJ;
        } else if (WSDDArtifactEdit.isValidEJBModule(this.getComponent())) {
            resourceURI = J2EEConstants.WEB_SERVICES_META_INF_DD_URI_OBJ;
        }
        return resourceURI;
    }

    public WebServices getWebServices() {
        if (!this.getProject().isAccessible()) {
            return null;
        }
        if (this.getWsddXmiResource().getContents().isEmpty()) {
            return null;
        }
        return (WebServices)this.getDeploymentDescriptorRoot();
    }

    public EObject getDeploymentDescriptorRoot() {
        EList contents = this.getDeploymentDescriptorResource().getContents();
        if (contents.size() > 0) {
            return (EObject)contents.get(0);
        }
        this.addWebServicesIfNecessary(this.getWsddXmiResource());
        if (contents.isEmpty()) {
            return null;
        }
        return (EObject)contents.get(0);
    }

    protected void addWebServicesIfNecessary(WsddResource aResource) {
        if (aResource != null) {
            if (aResource.getContents() == null || aResource.getContents().isEmpty()) {
                WebServices ws = WsddFactory.eINSTANCE.createWebServices();
                aResource.getContents().add((Object)ws);
            }
            aResource.getContents().get(0);
            this.getArtifactEditModel().getModuleURI();
            try {
                aResource.saveIfNecessary();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static WSDDArtifactEdit getWSDDArtifactEditForRead(IProject aProject) {
        WSDDArtifactEdit artifactEdit = null;
        IVirtualComponent comp = ComponentCore.createComponent((IProject)aProject);
        if (comp != null && WSDDArtifactEdit.isValidWSDDModule(comp)) {
            try {
                artifactEdit = new WSDDArtifactEdit(aProject, true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                artifactEdit = null;
            }
        }
        return artifactEdit;
    }

    public static WSDDArtifactEdit getWSDDArtifactEditForWrite(IProject aProject) {
        WSDDArtifactEdit artifactEdit = null;
        IVirtualComponent comp = ComponentCore.createComponent((IProject)aProject);
        if (comp != null && WSDDArtifactEdit.isValidWSDDModule(comp)) {
            try {
                artifactEdit = new WSDDArtifactEdit(aProject, false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                artifactEdit = null;
            }
        }
        return artifactEdit;
    }

    public static WSDDArtifactEdit getWSDDArtifactEditForRead(IVirtualComponent aModule) {
        IProject project = aModule.getProject();
        ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature((IProject)project);
        if (aModule != null && WSDDArtifactEdit.isValidWSDDModule(aModule)) {
            return new WSDDArtifactEdit(nature, aModule, true);
        }
        return null;
    }

    public static WSDDArtifactEdit getWSDDArtifactEditForWrite(IVirtualComponent aModule) {
        IProject project = aModule.getProject();
        ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature((IProject)project);
        if (aModule != null && WSDDArtifactEdit.isValidWSDDModule(aModule)) {
            return new WSDDArtifactEdit(nature, aModule, false);
        }
        return null;
    }

    public static boolean isValidEJBModule(IVirtualComponent aComponent) {
        return J2EEProjectUtilities.isEJBProject((IProject)aComponent.getProject());
    }

    protected static boolean isValidWSDDModule(IVirtualComponent aComponent) {
        return WSDDArtifactEdit.isValidAppClientModule(aComponent) || WSDDArtifactEdit.isValidWebModule(aComponent) || WSDDArtifactEdit.isValidEJBModule(aComponent);
    }

    public static boolean isValidWebModule(IVirtualComponent aComponent) {
        return J2EEProjectUtilities.isDynamicWebProject((IProject)aComponent.getProject());
    }

    public static boolean isValidAppClientModule(IVirtualComponent aComponent) {
        return J2EEProjectUtilities.isApplicationClientProject((IProject)aComponent.getProject());
    }

    public EObject createModelRoot() {
        return this.createModelRoot(this.getJ2EEVersion());
    }

    public EObject createModelRoot(int version) {
        WsddResource res = (WsddResource)this.getDeploymentDescriptorResource();
        res.setModuleVersionID(version);
        this.addWebServicesIfNecessary(res);
        return this.getWebServices();
    }

    public EObject getContentModelRoot() {
        return this.getWebServices();
    }

    public List getWSILResources() {
        final ArrayList result = new ArrayList();
        try {
            this.getProject().accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    IResource file;
                    IVirtualResource[] vResources;
                    if (proxy.getName().endsWith(WSDDArtifactEdit.WSIL_FILE_EXT) && (vResources = ComponentCore.createResources((IResource)(file = proxy.requestResource()))).length > 0 && !result.contains(file)) {
                        result.add(file);
                    }
                    return true;
                }
            }, 0);
        }
        catch (CoreException e) {
            WebServicePlugin.logError(0, e.getMessage(), e);
        }
        return result;
    }

    public List getWSDLResources() {
        return this.getResources(WSDL_FILE_EXT);
    }

    private List getResources(String ext) {
        List resources = this.getArtifactEditModel().getResources();
        ArrayList<Resource> result = new ArrayList<Resource>();
        int i = 0;
        while (i < resources.size()) {
            Resource res = (Resource)resources.get(i);
            if (res != null && res.getURI().fileExtension() != null && res.getURI().fileExtension().equals(ext)) {
                result.add(res);
            }
            ++i;
        }
        return result;
    }

    public Resource getWsdlResource(String path) {
        if (path == null || path.equals("")) {
            return null;
        }
        Resource res = null;
        try {
            res = this.getArtifactEditModel().getResource(URI.createURI((String)path));
        }
        catch (Exception exception) {}
        WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
        if (res != null && res.isLoaded() && serviceHelper != null && serviceHelper.isWSDLResource((Object)res)) {
            return res;
        }
        return null;
    }

    public IModelProvider create(IProject project) {
        return WSDDArtifactEdit.getWSDDArtifactEditForRead(project);
    }

    public IModelProvider create(IVirtualComponent component) {
        return WSDDArtifactEdit.getWSDDArtifactEditForRead(component);
    }

    protected boolean validProjectVersion(IProject project) {
        return true;
    }

    public void modify(Runnable runnable, IPath modelPath) {
        this.setWritableEdit((ArtifactEdit)WSDDArtifactEdit.getWSDDArtifactEditForWrite(this.getProject()));
        try {
            runnable.run();
            if (this.getWritableEdit() != null) {
                this.getWritableEdit().saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
            }
        }
        finally {
            this.getWritableEdit().dispose();
            this.setWritableEdit(null);
        }
    }
}

