/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModelStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.core.CreateTypeMemberOperation;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.util.Messages;

public class CreateTypeOperation
extends CreateTypeMemberOperation {
    public CreateTypeOperation(IJavaScriptElement parentElement, String source, boolean force) {
        super(parentElement, source, force);
    }

    protected ASTNode generateElementAST(ASTRewrite rewriter, IDocument document, IJavaScriptUnit cu) throws JavaScriptModelException {
        ASTNode node = super.generateElementAST(rewriter, document, cu);
        if (!(node instanceof AbstractTypeDeclaration)) {
            throw new JavaScriptModelException(new JavaModelStatus(984));
        }
        return node;
    }

    protected IJavaScriptElement generateResultHandle() {
        IJavaScriptElement parent = this.getParentElement();
        switch (parent.getElementType()) {
            case 5: {
                return ((IJavaScriptUnit)parent).getType(this.getASTNodeName());
            }
            case 7: {
                return ((IType)parent).getType(this.getASTNodeName());
            }
        }
        return null;
    }

    public String getMainTaskName() {
        return Messages.operation_createTypeProgress;
    }

    protected IType getType() {
        IJavaScriptElement parent = this.getParentElement();
        if (parent.getElementType() == 7) {
            return (IType)parent;
        }
        return null;
    }

    protected IJavaScriptModelStatus verifyNameCollision() {
        IJavaScriptElement parent = this.getParentElement();
        switch (parent.getElementType()) {
            case 5: {
                String typeName = this.getASTNodeName();
                if (!((IJavaScriptUnit)parent).getType(typeName).exists()) break;
                return new JavaModelStatus(977, Messages.bind(Messages.status_nameCollision, typeName));
            }
            case 7: {
                String typeName = this.getASTNodeName();
                if (!((IType)parent).getType(typeName).exists()) break;
                return new JavaModelStatus(977, Messages.bind(Messages.status_nameCollision, typeName));
            }
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    private String getASTNodeName() {
        return ((AbstractTypeDeclaration)this.createdNode).getName().getIdentifier();
    }

    protected SimpleName rename(ASTNode node, SimpleName newName) {
        AbstractTypeDeclaration type = (AbstractTypeDeclaration)node;
        SimpleName oldName = type.getName();
        type.setName(newName);
        return oldName;
    }
}

