/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModelStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaScriptConventions;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.core.JavaElementDelta;
import org.eclipse.wst.jsdt.internal.core.JavaModelOperation;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class CreateCompilationUnitOperation
extends JavaModelOperation {
    protected String fName;
    protected String fSource = null;

    public CreateCompilationUnitOperation(IPackageFragment parentElement, String name, String source, boolean force) {
        super(null, new IJavaScriptElement[]{parentElement}, force);
        this.fName = name;
        this.fSource = source;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeOperation() throws JavaScriptModelException {
        block17: {
            block15: {
                try {
                    block16: {
                        this.beginTask(Messages.operation_createUnitProgress, 2);
                        JavaElementDelta delta = this.newJavaElementDelta();
                        IJavaScriptUnit unit = this.getCompilationUnit();
                        IPackageFragment pkg = (IPackageFragment)this.getParentElement();
                        IContainer folder = (IContainer)pkg.getResource();
                        this.worked(1);
                        IFile compilationUnitFile = folder.getFile((IPath)new Path(this.fName));
                        if (compilationUnitFile.exists()) {
                            if (!this.force) throw new JavaScriptModelException(new JavaModelStatus(977, Messages.bind(Messages.status_nameCollision, compilationUnitFile.getFullPath().toString())));
                            IBuffer buffer = unit.getBuffer();
                            if (buffer == null) {
                                Object var9_9 = null;
                                break block15;
                            }
                            buffer.setContents(this.fSource);
                            unit.save((IProgressMonitor)new NullProgressMonitor(), false);
                            this.resultElements = new IJavaScriptElement[]{unit};
                            if (!Util.isExcluded(unit) && unit.getParent().exists()) {
                                int i = 0;
                                while (true) {
                                    if (i >= this.resultElements.length) {
                                        this.addDelta(delta);
                                        break;
                                    }
                                    delta.changed(this.resultElements[i], 1);
                                    ++i;
                                }
                            }
                        } else {
                            try {
                                String encoding = null;
                                try {
                                    encoding = folder.getDefaultCharset();
                                }
                                catch (CoreException coreException) {}
                                ByteArrayInputStream stream = new ByteArrayInputStream(encoding == null ? this.fSource.getBytes() : this.fSource.getBytes(encoding));
                                this.createFile(folder, unit.getElementName(), stream, this.force);
                                this.resultElements = new IJavaScriptElement[]{unit};
                                if (Util.isExcluded(unit) || !unit.getParent().exists()) break block16;
                                int i = 0;
                                while (true) {
                                    if (i >= this.resultElements.length) {
                                        this.addDelta(delta);
                                        break;
                                    }
                                    delta.added(this.resultElements[i]);
                                    ++i;
                                }
                            }
                            catch (IOException e) {
                                throw new JavaScriptModelException(e, 985);
                            }
                        }
                    }
                    this.worked(1);
                    break block17;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    this.done();
                    throw throwable;
                }
            }
            this.done();
            return;
        }
        Object var9_11 = null;
        this.done();
    }

    protected IJavaScriptUnit getCompilationUnit() {
        return ((IPackageFragment)this.getParentElement()).getJavaScriptUnit(this.fName);
    }

    protected ISchedulingRule getSchedulingRule() {
        IResource resource = this.getCompilationUnit().getResource();
        IWorkspace workspace = resource.getWorkspace();
        if (resource.exists()) {
            return workspace.getRuleFactory().modifyRule(resource);
        }
        return workspace.getRuleFactory().createRule(resource);
    }

    public IJavaScriptModelStatus verify() {
        if (this.getParentElement() == null) {
            return new JavaModelStatus(968);
        }
        IJavaScriptProject project = this.getParentElement().getJavaScriptProject();
        if (JavaScriptConventions.validateCompilationUnitName(this.fName, project.getOption("org.eclipse.wst.jsdt.core.compiler.source", true), project.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true)).getSeverity() == 4) {
            return new JavaModelStatus(983, this.fName);
        }
        if (this.fSource == null) {
            return new JavaModelStatus(984);
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

