/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.frameworks.internal.enablement.EnablementManager;
import org.eclipse.wst.common.internal.emfworkbench.EMFWorkbenchContext;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class ArtifactEditModel
extends EditModel
implements IAdaptable,
IFacetedProjectListener {
    public static final Class ADAPTER_TYPE = ArtifactEditModel.class;
    private final IProject componentProject;
    private final IPath modulePath;
    private URI rootURI;
    private String rootContentType;
    private final IVirtualComponent virtualComponent;
    private final URI componentURI;

    public ArtifactEditModel(String anEditModelId, EMFWorkbenchContext aContext, boolean toMakeReadOnly, URI aModuleURI) {
        this(anEditModelId, aContext, toMakeReadOnly, true, aModuleURI);
    }

    public ArtifactEditModel(String anEditModelId, EMFWorkbenchContext aContext, boolean toMakeReadOnly, boolean toAccessUnknownResourcesAsReadOnly, URI aModuleURI, URI rootURI, String rootContentType) {
        this(anEditModelId, aContext, toMakeReadOnly, toAccessUnknownResourcesAsReadOnly, aModuleURI);
        this.rootURI = rootURI;
        this.rootContentType = rootContentType;
    }

    public ArtifactEditModel(String anEditModelId, EMFWorkbenchContext aContext, boolean toMakeReadOnly, boolean toAccessUnknownResourcesAsReadOnly, URI aModuleURI) {
        block8: {
            super(anEditModelId, aContext, toMakeReadOnly, toAccessUnknownResourcesAsReadOnly);
            IProject aProject = null;
            try {
                aProject = StructureEdit.getContainingProject(aModuleURI);
                IFacetedProject facetProj = ProjectFacetsManager.create((IProject)this.project);
                if (facetProj != null) {
                    facetProj.addListener((IFacetedProjectListener)this);
                }
            }
            catch (UnresolveableURIException e) {
                e.printStackTrace();
                this.componentProject = aProject;
                break block8;
            }
            catch (CoreException e) {
                try {
                    e.printStackTrace();
                    break block8;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.componentProject = aProject;
                }
            }
            this.componentProject = aProject;
        }
        this.virtualComponent = ComponentCore.createComponent(this.componentProject);
        this.componentURI = aModuleURI;
        this.modulePath = new Path(aModuleURI.path());
        this.processLoadedResources(this.componentProject);
    }

    public ArtifactEditModel(String editModelID, EMFWorkbenchContext context, boolean toMakeReadOnly, URI moduleURI, URI rootURI, String rootContentType) {
        this(editModelID, context, toMakeReadOnly, true, moduleURI);
        this.rootURI = rootURI;
        this.rootContentType = rootContentType;
    }

    public Resource getResource(URI aUri) {
        IPath requestPath;
        if (this.rootURI != null && this.rootURI.equals((Object)aUri) && this.rootContentType != null) {
            requestPath = this.modulePath.append((IPath)new Path(this.rootContentType));
            requestPath = requestPath.append((IPath)new Path(aUri.path()));
        } else {
            requestPath = this.modulePath.append((IPath)new Path(aUri.path()));
        }
        URI resourceURI = URI.createURI((String)("module:" + requestPath.toString()));
        return super.getResource(resourceURI);
    }

    public IProject getComponentProject() {
        return this.componentProject;
    }

    public URI getModuleURI() {
        return this.componentURI;
    }

    public Resource getOrCreateResource(URI aUri) {
        return super.getOrCreateResource(aUri);
    }

    protected void processLoadedResources() {
    }

    protected void processLoadedResources(IProject aComponentProject) {
        EList loadedResources = this.getResourceSet().getResources();
        if (!loadedResources.isEmpty()) {
            this.processResourcesIfInterrested((List)loadedResources);
        }
    }

    protected boolean processResourcesIfInterrested(List theResources) {
        int size = theResources.size();
        boolean processed = false;
        int i = 0;
        while (i < size) {
            IFile resourceResource;
            String lastSegment;
            Resource resourceToProcess = (Resource)theResources.get(i);
            if (!(resourceToProcess == null || (lastSegment = resourceToProcess.getURI().lastSegment()) != null && lastSegment.endsWith(".component") || (resourceResource = WorkbenchResourceHelper.getFile((Resource)resourceToProcess)) == null)) {
                IVirtualResource[] virtualResources = ComponentCore.createResources((IResource)resourceResource);
                int resourcesIndex = 0;
                while (resourcesIndex < virtualResources.length) {
                    if (this.virtualComponent.equals(virtualResources[resourcesIndex].getComponent()) && resourceToProcess != null && this.isInterrestedInResource(resourceToProcess)) {
                        this.processResource(resourceToProcess);
                        processed = true;
                    }
                    ++resourcesIndex;
                }
            }
            ++i;
        }
        return processed;
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public IVirtualComponent getVirtualComponent() {
        return this.virtualComponent;
    }

    public void projectChanged() {
        try {
            EnablementManager.INSTANCE.notifyFunctionGroupChanged(null, this.getComponentProject());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void doDispose() {
        try {
            IFacetedProject facetProj = ProjectFacetsManager.create((IProject)this.getComponentProject());
            if (facetProj != null) {
                facetProj.removeListener((IFacetedProjectListener)this);
            }
        }
        catch (Exception e) {
            Logger.getLogger().logError((Throwable)e);
        }
        super.doDispose();
    }
}

