/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.taglib;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.jsp.core.internal.taglib.TaglibHelper;
import org.eclipse.jst.jsp.core.internal.taglib.TaglibHelperCache;

public class TaglibHelperManager
implements IElementChangedListener {
    private static TaglibHelperManager instance = null;
    private TaglibHelperCache fCache = new TaglibHelperCache(3);

    private TaglibHelperManager() {
    }

    public static synchronized TaglibHelperManager getInstance() {
        if (instance == null) {
            instance = new TaglibHelperManager();
        }
        return instance;
    }

    public TaglibHelper getTaglibHelper(IFile f) {
        IProject p = f.getProject();
        return this.getHelperFromCache(p);
    }

    private TaglibHelper getHelperFromCache(IProject project) {
        return this.fCache.getHelper(project);
    }

    public void elementChanged(ElementChangedEvent event) {
        block5: {
            IJavaElementDelta delta;
            block4: {
                delta = event.getDelta();
                if (delta.getElement().getElementType() != 1) break block4;
                IJavaElementDelta[] changed = delta.getChangedChildren();
                int i = 0;
                while (i < changed.length) {
                    if ((changed[i].getFlags() & 0x20000) != 0 || (changed[i].getFlags() & 0x100) != 0 || (changed[i].getFlags() & 0x200000) != 0) {
                        IJavaElement proj = changed[i].getElement();
                        this.handleClasspathChange(changed, i, proj);
                    }
                    ++i;
                }
                break block5;
            }
            if (delta.getElement().getElementType() != 5) break block5;
            IJavaElementDelta[] changed = delta.getChangedChildren();
            int i = 0;
            while (i < changed.length) {
                if ((changed[i].getFlags() & 0x800) != 0) {
                    IJavaElement element = changed[i].getElement();
                    this.handleSuperTypeChange(element);
                }
                ++i;
            }
        }
    }

    private void handleClasspathChange(IJavaElementDelta[] changed, int i, IJavaElement proj) {
        if (proj.getElementType() == 2) {
            String projectName = ((IJavaProject)proj).getProject().getName();
            this.fCache.removeHelper(projectName);
        }
    }

    private void handleSuperTypeChange(IJavaElement element) {
        IJavaProject project = element.getJavaProject();
        if (element instanceof IType) {
            this.fCache.invalidate(project.getProject().getName(), ((IType)element).getFullyQualifiedName());
        }
    }
}

