/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.symbols;

import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.common.internal.resource.IResourceLifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.LifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.ResourceLifecycleEvent;
import org.eclipse.jst.jsf.context.symbol.internal.impl.IMapSourceInfo;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.tld.LoadBundleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResourceBundleMapSource
extends AbstractMap
implements IMapSourceInfo {
    private static final String PROPERTY_QUALIFIER = "org.eclipse.jst.jsf.designtime.internal.jsp";
    private static final String SESSION_PROPERTY_NAME_PROJECT = "ResourceBundleMapSource";
    private static final QualifiedName SESSION_PROPERTY_KEY_PROJECT = new QualifiedName("org.eclipse.jst.jsf.designtime.internal.jsp", "ResourceBundleMapSource");
    private static final Object STATIC_LOCK = new Object();
    private Properties _resourceBundle;
    private final IFile _bundleFile;
    private final String _resourcePathStr;
    private long _lastModificationStamp;

    private static IFile getCachedBundleFile(IProject project, String baseName) {
        BundleFileCacheInfo info;
        Map<String, BundleFileCacheInfo> bundleFileCache;
        if (project != null && (bundleFileCache = ResourceBundleMapSource.getBundleFileCache(project)) != null && (info = bundleFileCache.get(baseName)) != null) {
            return info.getFile();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, BundleFileCacheInfo> getBundleFileCache(final IProject project) {
        Object object = STATIC_LOCK;
        synchronized (object) {
            HashMap bundleFileCache = null;
            try {
                bundleFileCache = (HashMap)project.getSessionProperty(SESSION_PROPERTY_KEY_PROJECT);
                if (bundleFileCache == null) {
                    bundleFileCache = new HashMap();
                    LifecycleListener listener = new LifecycleListener((IResource)project);
                    listener.addListener(new IResourceLifecycleListener(){

                        public IResourceLifecycleListener.EventResult acceptEvent(ResourceLifecycleEvent event) {
                            IResourceLifecycleListener.EventResult result = IResourceLifecycleListener.EventResult.getDefaultEventResult();
                            if (event.getEventType() == ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE) {
                                try {
                                    Map bundleCache = (Map)project.getSessionProperty(SESSION_PROPERTY_KEY_PROJECT);
                                    bundleCache.clear();
                                    project.setSessionProperty(SESSION_PROPERTY_KEY_PROJECT, null);
                                }
                                catch (CoreException ce) {
                                    JSFCorePlugin.log("Error clearing bundle file cache", ce);
                                }
                                result = IResourceLifecycleListener.EventResult.getDisposeAfterEventResult();
                            }
                            return result;
                        }
                    });
                    project.setSessionProperty(SESSION_PROPERTY_KEY_PROJECT, bundleFileCache);
                }
            }
            catch (CoreException ce) {
                JSFCorePlugin.log("Error creating bundle file cache", ce);
            }
            return bundleFileCache;
        }
    }

    private static IFile createCachedBundleFile(final IProject project, final String resourcePathStr) throws IOException, CoreException {
        IStorage storage = LoadBundleUtil.getLoadBundleResource(project, resourcePathStr);
        IFile bundleRes = null;
        if (storage != null && storage.getAdapter(IFile.class) != null) {
            bundleRes = (IFile)storage.getAdapter(IFile.class);
            LifecycleListener listener = new LifecycleListener((IResource)bundleRes);
            listener.addListener(new IResourceLifecycleListener(){

                public IResourceLifecycleListener.EventResult acceptEvent(ResourceLifecycleEvent event) {
                    IResourceLifecycleListener.EventResult result = IResourceLifecycleListener.EventResult.getDefaultEventResult();
                    if (event.getEventType() == ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE) {
                        Map bundleFileCache = ResourceBundleMapSource.getBundleFileCache(project);
                        bundleFileCache.remove(resourcePathStr);
                        result = IResourceLifecycleListener.EventResult.getDisposeAfterEventResult();
                    }
                    return result;
                }
            });
            ResourceBundleMapSource.getBundleFileCache(project).put(resourcePathStr, new BundleFileCacheInfo(bundleRes));
            return bundleRes;
        }
        throw new IOException("Bundle " + resourcePathStr + " not found in classpath for project: " + project.getName());
    }

    ResourceBundleMapSource(IProject context, String resourcePathStr) throws IOException, JavaModelException, CoreException {
        IFile cachedBundleFile = ResourceBundleMapSource.getCachedBundleFile(context, resourcePathStr);
        if (cachedBundleFile == null) {
            cachedBundleFile = ResourceBundleMapSource.createCachedBundleFile(context, resourcePathStr);
        }
        this._bundleFile = cachedBundleFile;
        this._resourcePathStr = resourcePathStr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkAndRefreshBundle() {
        if (this._bundleFile.isAccessible()) {
            if (this._resourceBundle != null && this._bundleFile.isSynchronized(0) && this._bundleFile.getModificationStamp() == this._lastModificationStamp) return;
            InputStream bundleStream = null;
            try {
                try {
                    bundleStream = this._bundleFile.getContents(true);
                    this._resourceBundle = new Properties();
                    this._resourceBundle.load(bundleStream);
                    this._lastModificationStamp = this._bundleFile.getModificationStamp();
                    return;
                }
                catch (CoreException ce) {
                    JSFCorePlugin.log("Error refreshing bundle", ce);
                    if (bundleStream == null) return;
                    try {
                        bundleStream.close();
                        return;
                    }
                    catch (IOException ioe) {
                        JSFCorePlugin.log("Error closing bundle", ioe);
                    }
                    return;
                }
                catch (IOException ioe) {
                    JSFCorePlugin.log("Error refreshing bundle", ioe);
                    if (bundleStream == null) return;
                    try {
                        bundleStream.close();
                        return;
                    }
                    catch (IOException ioe2) {
                        JSFCorePlugin.log("Error closing bundle", ioe2);
                    }
                    return;
                }
            }
            finally {
                if (bundleStream != null) {
                    try {
                        bundleStream.close();
                    }
                    catch (IOException ioe) {
                        JSFCorePlugin.log("Error closing bundle", ioe);
                    }
                }
            }
        }
        Map<String, BundleFileCacheInfo> bundleFileCache = ResourceBundleMapSource.getBundleFileCache(this._bundleFile.getProject());
        if (bundleFileCache != null && bundleFileCache.containsKey(this._resourcePathStr)) {
            bundleFileCache.remove(this._resourcePathStr);
        }
        if (this._resourceBundle == null) return;
        this._resourceBundle.clear();
        this._resourceBundle = null;
    }

    @Override
    public Set entrySet() {
        this.checkAndRefreshBundle();
        if (this._resourceBundle == null) {
            return Collections.EMPTY_SET;
        }
        return this._resourceBundle.entrySet();
    }

    @Override
    public Object get(Object key) {
        this.checkAndRefreshBundle();
        if (this._resourceBundle == null) {
            return null;
        }
        return this._resourceBundle.get(key);
    }

    public final boolean hasChanged(Object key) {
        BundleFileCacheInfo cache = ResourceBundleMapSource.getBundleFileCache(this._bundleFile.getProject()).get(this._resourcePathStr);
        if (cache != null) {
            return cache.hasChanged(key, this._bundleFile.getModificationStamp());
        }
        return true;
    }

    public Object getCachedValue(Object key) {
        BundleFileCacheInfo cache = ResourceBundleMapSource.getBundleFileCache(this._bundleFile.getProject()).get(this._resourcePathStr);
        if (cache != null) {
            return cache.getCachedData(key);
        }
        return null;
    }

    public void putCachedValue(Object key, Object value) {
        BundleFileCacheInfo cache = ResourceBundleMapSource.getBundleFileCache(this._bundleFile.getProject()).get(this._resourcePathStr);
        if (cache != null) {
            cache.putCachedData(key, value, this._lastModificationStamp);
        }
    }

    private static class BundleFileCacheInfo {
        private final IFile _file;
        private final Map<Object, CachedDataItem> _cachedData;

        public BundleFileCacheInfo(IFile file) {
            this._file = file;
            this._cachedData = Collections.synchronizedMap(new HashMap());
        }

        public IFile getFile() {
            return this._file;
        }

        public Object getCachedData(Object key) {
            CachedDataItem item = this._cachedData.get(key);
            if (item != null) {
                return item.getData();
            }
            return null;
        }

        public Object putCachedData(Object key, Object value, long timestamp) {
            CachedDataItem item = new CachedDataItem(value, timestamp);
            CachedDataItem oldItem = this._cachedData.put(key, item);
            if (oldItem != null) {
                return oldItem.getData();
            }
            return null;
        }

        public boolean hasChanged(Object key, long timestamp) {
            CachedDataItem item = this._cachedData.get(key);
            if (item != null) {
                return item.getTimestamp() != timestamp;
            }
            return false;
        }

        private static class CachedDataItem {
            private final Object _data;
            private final long _timestamp;

            public CachedDataItem(Object data, long timestamp) {
                this._data = data;
                this._timestamp = timestamp;
            }

            public final Object getData() {
                return this._data;
            }

            public final long getTimestamp() {
                return this._timestamp;
            }
        }
    }
}

