/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.contentassist.SubjectControlContentAssistant;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.contentassist.ContentAssistHandler;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptConventions;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.AddUnimplementedConstructorsOperation;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.AddUnimplementedMethodsOperation;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.TokenScanner;
import org.eclipse.wst.jsdt.internal.corext.refactoring.StubTypeContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.TypeContextChecker;
import org.eclipse.wst.jsdt.internal.corext.template.java.JavaContext;
import org.eclipse.wst.jsdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Resources;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TableTextCellEditor;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.wst.jsdt.internal.ui.refactoring.contentassist.CompletionContextRequestor;
import org.eclipse.wst.jsdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.wst.jsdt.internal.ui.refactoring.contentassist.JavaPackageCompletionProcessor;
import org.eclipse.wst.jsdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.SuperInterfaceSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.Separator;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringButtonStatusDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.wst.jsdt.ui.CodeGeneration;
import org.eclipse.wst.jsdt.ui.CodeStyleConfiguration;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabelProvider;
import org.eclipse.wst.jsdt.ui.wizards.NewContainerWizardPage;

public abstract class NewTypeWizardPage
extends NewContainerWizardPage {
    public int F_PUBLIC = 1;
    public int F_PRIVATE = 2;
    public int F_PROTECTED = 4;
    public int F_STATIC = 8;
    public int F_FINAL = 16;
    public int F_ABSTRACT = 1024;
    private static final String PAGE_NAME = "NewTypeWizardPage";
    protected static final String PACKAGE = "NewTypeWizardPage.package";
    protected static final String ENCLOSING = "NewTypeWizardPage.enclosing";
    protected static final String ENCLOSINGSELECTION = "NewTypeWizardPage.enclosing.selection";
    protected static final String TYPENAME = "NewTypeWizardPage.typename";
    protected static final String SUPER = "NewTypeWizardPage.superclass";
    protected static final String INTERFACES = "NewTypeWizardPage.interfaces";
    protected static final String MODIFIERS = "NewTypeWizardPage.modifiers";
    protected static final String METHODS = "NewTypeWizardPage.methods";
    private StringButtonStatusDialogField fPackageDialogField;
    private SelectionButtonDialogField fEnclosingTypeSelection;
    private StringButtonDialogField fEnclosingTypeDialogField;
    private boolean fCanModifyPackage;
    private boolean fCanModifyEnclosingType;
    private IPackageFragment fCurrPackage;
    private IType fCurrEnclosingType;
    private IType fCurrType;
    private StringDialogField fTypeNameDialogField;
    private StringButtonDialogField fSuperClassDialogField;
    private ListDialogField fSuperInterfacesDialogField;
    private SelectionButtonDialogFieldGroup fAccMdfButtons;
    private SelectionButtonDialogFieldGroup fOtherMdfButtons;
    private SelectionButtonDialogField fAddCommentButton;
    private boolean fUseAddCommentButtonValue;
    private IType fCreatedType;
    private JavaPackageCompletionProcessor fCurrPackageCompletionProcessor;
    private JavaTypeCompletionProcessor fEnclosingTypeCompletionProcessor;
    private StubTypeContext fSuperClassStubTypeContext;
    private StubTypeContext fSuperInterfaceStubTypeContext;
    protected IStatus fEnclosingTypeStatus;
    protected IStatus fPackageStatus;
    protected IStatus fTypeNameStatus;
    protected IStatus fSuperClassStatus;
    protected IStatus fModifierStatus;
    protected IStatus fSuperInterfacesStatus;
    private final int PUBLIC_INDEX = 0;
    private final int DEFAULT_INDEX = 1;
    private final int PRIVATE_INDEX = 2;
    private final int PROTECTED_INDEX = 3;
    private final int ABSTRACT_INDEX = 0;
    private final int FINAL_INDEX = 1;
    private final int STATIC_INDEX = 2;
    private final int ENUM_ANNOT_STATIC_INDEX = 1;
    private int fTypeKind;
    public static final int CLASS_TYPE = 1;
    public static final int INTERFACE_TYPE = 2;
    public static final int ENUM_TYPE = 3;
    public static final int ANNOTATION_TYPE = 4;

    public NewTypeWizardPage(boolean isClass, String pageName) {
        this(isClass ? 1 : 2, pageName);
    }

    public NewTypeWizardPage(int typeKind, String pageName) {
        super(pageName);
        this.fTypeKind = typeKind;
        this.fCreatedType = null;
        TypeFieldsAdapter adapter = new TypeFieldsAdapter();
        this.fPackageDialogField = new StringButtonStatusDialogField(adapter);
        this.fPackageDialogField.setDialogFieldListener(adapter);
        this.fPackageDialogField.setLabelText(this.getPackageLabel());
        this.fPackageDialogField.setButtonLabel(NewWizardMessages.NewTypeWizardPage_package_button);
        this.fPackageDialogField.setStatusWidthHint(NewWizardMessages.NewTypeWizardPage_default);
        this.fEnclosingTypeSelection = new SelectionButtonDialogField(32);
        this.fEnclosingTypeSelection.setDialogFieldListener(adapter);
        this.fEnclosingTypeSelection.setLabelText(this.getEnclosingTypeLabel());
        this.fEnclosingTypeDialogField = new StringButtonDialogField(adapter);
        this.fEnclosingTypeDialogField.setDialogFieldListener(adapter);
        this.fEnclosingTypeDialogField.setButtonLabel(NewWizardMessages.NewTypeWizardPage_enclosing_button);
        this.fTypeNameDialogField = new StringDialogField();
        this.fTypeNameDialogField.setDialogFieldListener(adapter);
        this.fTypeNameDialogField.setLabelText(this.getTypeNameLabel());
        this.fSuperClassDialogField = new StringButtonDialogField(adapter);
        this.fSuperClassDialogField.setDialogFieldListener(adapter);
        this.fSuperClassDialogField.setLabelText(this.getSuperClassLabel());
        this.fSuperClassDialogField.setButtonLabel(NewWizardMessages.NewTypeWizardPage_superclass_button);
        String[] stringArray = new String[3];
        stringArray[0] = NewWizardMessages.NewTypeWizardPage_interfaces_add;
        stringArray[2] = NewWizardMessages.NewTypeWizardPage_interfaces_remove;
        String[] addButtons = stringArray;
        this.fSuperInterfacesDialogField = new ListDialogField(adapter, addButtons, (ILabelProvider)new InterfacesListLabelProvider());
        this.fSuperInterfacesDialogField.setDialogFieldListener(adapter);
        this.fSuperInterfacesDialogField.setTableColumns(new ListDialogField.ColumnsDescription(1, false));
        this.fSuperInterfacesDialogField.setLabelText(this.getSuperInterfacesLabel());
        this.fSuperInterfacesDialogField.setRemoveButtonIndex(2);
        String[] buttonNames1 = new String[]{NewWizardMessages.NewTypeWizardPage_modifiers_public, NewWizardMessages.NewTypeWizardPage_modifiers_default, NewWizardMessages.NewTypeWizardPage_modifiers_private, NewWizardMessages.NewTypeWizardPage_modifiers_protected};
        this.fAccMdfButtons = new SelectionButtonDialogFieldGroup(16, buttonNames1, 4);
        this.fAccMdfButtons.setDialogFieldListener(adapter);
        this.fAccMdfButtons.setLabelText(this.getModifiersLabel());
        this.fAccMdfButtons.setSelection(0, true);
        String[] buttonNames2 = this.fTypeKind == 1 ? new String[]{NewWizardMessages.NewTypeWizardPage_modifiers_abstract, NewWizardMessages.NewTypeWizardPage_modifiers_final, NewWizardMessages.NewTypeWizardPage_modifiers_static} : (this.fTypeKind == 3 || this.fTypeKind == 4 ? new String[]{NewWizardMessages.NewTypeWizardPage_modifiers_abstract, NewWizardMessages.NewTypeWizardPage_modifiers_static} : new String[]{});
        this.fOtherMdfButtons = new SelectionButtonDialogFieldGroup(32, buttonNames2, 4);
        this.fOtherMdfButtons.setDialogFieldListener(adapter);
        this.fAccMdfButtons.enableSelectionButton(2, false);
        this.fAccMdfButtons.enableSelectionButton(3, false);
        this.fOtherMdfButtons.enableSelectionButton(2, false);
        if (this.fTypeKind == 3 || this.fTypeKind == 4) {
            this.fOtherMdfButtons.enableSelectionButton(0, false);
            this.fOtherMdfButtons.enableSelectionButton(1, false);
        }
        this.fAddCommentButton = new SelectionButtonDialogField(32);
        this.fAddCommentButton.setLabelText(NewWizardMessages.NewTypeWizardPage_addcomment_label);
        this.fUseAddCommentButtonValue = false;
        this.fCurrPackageCompletionProcessor = new JavaPackageCompletionProcessor();
        this.fEnclosingTypeCompletionProcessor = new JavaTypeCompletionProcessor(false, false, true);
        this.fPackageStatus = new StatusInfo();
        this.fEnclosingTypeStatus = new StatusInfo();
        this.fCanModifyPackage = true;
        this.fCanModifyEnclosingType = true;
        this.updateEnableState();
        this.fTypeNameStatus = new StatusInfo();
        this.fSuperClassStatus = new StatusInfo();
        this.fSuperInterfacesStatus = new StatusInfo();
        this.fModifierStatus = new StatusInfo();
    }

    protected void initTypePage(IJavaScriptElement elem) {
        String text;
        String initSuperclass = "java.lang.Object";
        ArrayList<String> initSuperinterfaces = new ArrayList<String>(5);
        IJavaScriptProject project = null;
        IPackageFragment pack = null;
        IType enclosingType = null;
        if (elem != null) {
            project = elem.getJavaScriptProject();
            pack = (IPackageFragment)elem.getAncestor(4);
            IType typeInCU = (IType)elem.getAncestor(7);
            if (typeInCU != null) {
                if (typeInCU.getJavaScriptUnit() != null) {
                    enclosingType = typeInCU;
                }
            } else {
                IJavaScriptUnit cu = (IJavaScriptUnit)elem.getAncestor(5);
                if (cu != null) {
                    enclosingType = cu.findPrimaryType();
                }
            }
            try {
                IType type = null;
                if (elem.getElementType() == 7 && (type = (IType)elem).exists()) {
                    String superName = JavaModelUtil.getFullyQualifiedName(type);
                    if (type.isInterface()) {
                        initSuperinterfaces.add(superName);
                    } else {
                        initSuperclass = superName;
                    }
                }
            }
            catch (JavaScriptModelException e) {
                JavaScriptPlugin.log(e);
            }
        }
        String typeName = "";
        ITextSelection selection = this.getCurrentTextSelection();
        if (selection != null && (text = selection.getText()) != null && NewTypeWizardPage.validateJavaTypeName(text, project).isOK()) {
            typeName = text;
        }
        this.setPackageFragment(pack, true);
        this.setEnclosingType(enclosingType, true);
        this.setEnclosingTypeSelection(false, true);
        this.setTypeName(typeName, true);
        this.setSuperClass(initSuperclass, true);
        this.setSuperInterfaces(initSuperinterfaces, true);
        this.setAddComments(StubUtility.doAddComments(project), true);
    }

    private static IStatus validateJavaTypeName(String text, IJavaScriptProject project) {
        if (project == null || !project.exists()) {
            return JavaScriptConventions.validateJavaScriptTypeName((String)text, (String)"1.3", (String)"1.3");
        }
        String sourceLevel = project.getOption("org.eclipse.wst.jsdt.core.compiler.source", true);
        String compliance = project.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true);
        return JavaScriptConventions.validateJavaScriptTypeName((String)text, (String)sourceLevel, (String)compliance);
    }

    private static IStatus validatePackageName(String text, IJavaScriptProject project) {
        if (project == null || !project.exists()) {
            return JavaScriptConventions.validatePackageName((String)text, (String)"1.3", (String)"1.3");
        }
        String sourceLevel = project.getOption("org.eclipse.wst.jsdt.core.compiler.source", true);
        String compliance = project.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true);
        return JavaScriptConventions.validatePackageName((String)text, (String)sourceLevel, (String)compliance);
    }

    protected String getPackageLabel() {
        return NewWizardMessages.NewTypeWizardPage_package_label;
    }

    protected String getEnclosingTypeLabel() {
        return NewWizardMessages.NewTypeWizardPage_enclosing_selection_label;
    }

    protected String getTypeNameLabel() {
        return NewWizardMessages.NewTypeWizardPage_typename_label;
    }

    protected String getModifiersLabel() {
        return NewWizardMessages.NewTypeWizardPage_modifiers_acc_label;
    }

    protected String getSuperClassLabel() {
        return NewWizardMessages.NewTypeWizardPage_superclass_label;
    }

    protected String getSuperInterfacesLabel() {
        if (this.fTypeKind != 2) {
            return NewWizardMessages.NewTypeWizardPage_interfaces_class_label;
        }
        return NewWizardMessages.NewTypeWizardPage_interfaces_ifc_label;
    }

    protected void createSeparator(Composite composite, int nColumns) {
        new Separator(258).doFillIntoGrid(composite, nColumns, this.convertHeightInCharsToPixels(1));
    }

    protected void createPackageControls(Composite composite, int nColumns) {
        this.fPackageDialogField.doFillIntoGrid(composite, nColumns);
        Text text = this.fPackageDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)text);
        ControlContentAssistHelper.createTextContentAssistant(text, this.fCurrPackageCompletionProcessor);
        TextFieldNavigationHandler.install(text);
    }

    protected void createEnclosingTypeControls(Composite composite, int nColumns) {
        Composite tabGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        tabGroup.setLayout((Layout)layout);
        this.fEnclosingTypeSelection.doFillIntoGrid(tabGroup, 1);
        Text text = this.fEnclosingTypeDialogField.getTextControl(composite);
        text.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = NewWizardMessages.NewTypeWizardPage_enclosing_field_description;
            }
        });
        GridData gd = new GridData(768);
        gd.widthHint = this.getMaxFieldWidth();
        gd.horizontalSpan = 2;
        text.setLayoutData((Object)gd);
        Button button = this.fEnclosingTypeDialogField.getChangeControl(composite);
        gd = new GridData(256);
        gd.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gd);
        ControlContentAssistHelper.createTextContentAssistant(text, this.fEnclosingTypeCompletionProcessor);
        TextFieldNavigationHandler.install(text);
    }

    protected void createTypeNameControls(Composite composite, int nColumns) {
        this.fTypeNameDialogField.doFillIntoGrid(composite, nColumns - 1);
        DialogField.createEmptySpace(composite);
        Text text = this.fTypeNameDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, this.getMaxFieldWidth());
        TextFieldNavigationHandler.install(text);
    }

    protected void createModifierControls(Composite composite, int nColumns) {
        LayoutUtil.setHorizontalSpan((Control)this.fAccMdfButtons.getLabelControl(composite), 1);
        Composite control = this.fAccMdfButtons.getSelectionButtonsGroup(composite);
        GridData gd = new GridData(256);
        gd.horizontalSpan = nColumns - 2;
        control.setLayoutData((Object)gd);
        DialogField.createEmptySpace(composite);
        if (this.fTypeKind == 1) {
            DialogField.createEmptySpace(composite);
            control = this.fOtherMdfButtons.getSelectionButtonsGroup(composite);
            gd = new GridData(256);
            gd.horizontalSpan = nColumns - 2;
            control.setLayoutData((Object)gd);
            DialogField.createEmptySpace(composite);
        }
    }

    protected void createSuperClassControls(Composite composite, int nColumns) {
        this.fSuperClassDialogField.doFillIntoGrid(composite, nColumns);
        Text text = this.fSuperClassDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, this.getMaxFieldWidth());
        JavaTypeCompletionProcessor superClassCompletionProcessor = new JavaTypeCompletionProcessor(false, false, true);
        superClassCompletionProcessor.setCompletionContextRequestor(new CompletionContextRequestor(){

            public StubTypeContext getStubTypeContext() {
                return NewTypeWizardPage.this.getSuperClassStubTypeContext();
            }
        });
        ControlContentAssistHelper.createTextContentAssistant(text, superClassCompletionProcessor);
        TextFieldNavigationHandler.install(text);
    }

    protected void createSuperInterfacesControls(Composite composite, int nColumns) {
        this.fSuperInterfacesDialogField.doFillIntoGrid(composite, nColumns);
        final TableViewer tableViewer = this.fSuperInterfacesDialogField.getTableViewer();
        tableViewer.setColumnProperties(new String[]{"interface"});
        TableTextCellEditor cellEditor = new TableTextCellEditor(tableViewer, 0){

            protected void doSetFocus() {
                if (this.text != null) {
                    this.text.setFocus();
                    this.text.setSelection(this.text.getText().length());
                    this.checkSelection();
                    this.checkDeleteable();
                    this.checkSelectable();
                }
            }
        };
        JavaTypeCompletionProcessor superInterfaceCompletionProcessor = new JavaTypeCompletionProcessor(false, false, true);
        superInterfaceCompletionProcessor.setCompletionContextRequestor(new CompletionContextRequestor(){

            public StubTypeContext getStubTypeContext() {
                return NewTypeWizardPage.this.getSuperInterfacesStubTypeContext();
            }
        });
        SubjectControlContentAssistant contentAssistant = ControlContentAssistHelper.createJavaContentAssistant(superInterfaceCompletionProcessor);
        Text cellEditorText = cellEditor.getText();
        ContentAssistHandler.createHandlerForText((Text)cellEditorText, (SubjectControlContentAssistant)contentAssistant);
        TextFieldNavigationHandler.install(cellEditorText);
        cellEditor.setContentAssistant(contentAssistant);
        tableViewer.setCellEditors(new CellEditor[]{cellEditor});
        tableViewer.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                if (element instanceof Item) {
                    element = ((Item)element).getData();
                }
                ((InterfaceWrapper)element).interfaceName = (String)value;
                NewTypeWizardPage.this.fSuperInterfacesDialogField.elementChanged(element);
            }

            public Object getValue(Object element, String property) {
                return ((InterfaceWrapper)element).interfaceName;
            }

            public boolean canModify(Object element, String property) {
                return true;
            }
        });
        tableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 0x100000B && event.stateMask == 0) {
                    ISelection selection = tableViewer.getSelection();
                    if (!(selection instanceof IStructuredSelection)) {
                        return;
                    }
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    tableViewer.editElement(structuredSelection.getFirstElement(), 0);
                }
            }
        });
        GridData gd = (GridData)this.fSuperInterfacesDialogField.getListControl(null).getLayoutData();
        gd.heightHint = this.fTypeKind == 1 ? this.convertHeightInCharsToPixels(3) : this.convertHeightInCharsToPixels(6);
        gd.grabExcessVerticalSpace = false;
        gd.widthHint = this.getMaxFieldWidth();
    }

    protected void createCommentControls(Composite composite, int nColumns) {
        Link link = new Link(composite, 0);
        link.setText(NewWizardMessages.NewTypeWizardPage_addcomment_description);
        link.addSelectionListener((SelectionListener)new TypeFieldsAdapter());
        link.setLayoutData((Object)new GridData(4, 2, false, false, nColumns, 1));
        DialogField.createEmptySpace(composite);
        this.fAddCommentButton.doFillIntoGrid(composite, nColumns - 1);
    }

    protected void setFocus() {
        this.fTypeNameDialogField.setFocus();
    }

    private void typePageLinkActivated(SelectionEvent e) {
        IJavaScriptProject project = this.getJavaProject();
        if (project != null) {
            PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)project.getProject(), (String)"org.eclipse.wst.jsdt.ui.propertyPages.CodeTemplatePreferencePage", null, null);
            dialog.open();
        } else {
            String title = NewWizardMessages.NewTypeWizardPage_configure_templates_title;
            String message = NewWizardMessages.NewTypeWizardPage_configure_templates_message;
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
        }
    }

    private void typePageChangeControlPressed(DialogField field) {
        IType type;
        if (field == this.fPackageDialogField) {
            IPackageFragment pack = this.choosePackage();
            if (pack != null) {
                this.fPackageDialogField.setText(pack.getElementName());
            }
        } else if (field == this.fEnclosingTypeDialogField) {
            IType type2 = this.chooseEnclosingType();
            if (type2 != null) {
                this.fEnclosingTypeDialogField.setText(JavaModelUtil.getFullyQualifiedName(type2));
            }
        } else if (field == this.fSuperClassDialogField && (type = this.chooseSuperClass()) != null) {
            this.fSuperClassDialogField.setText(JavaModelUtil.getFullyQualifiedName(type));
        }
    }

    private void typePageCustomButtonPressed(DialogField field, int index) {
        if (field == this.fSuperInterfacesDialogField) {
            this.chooseSuperInterfaces();
            List interfaces = this.fSuperInterfacesDialogField.getElements();
            if (!interfaces.isEmpty()) {
                Object element = interfaces.get(interfaces.size() - 1);
                this.fSuperInterfacesDialogField.editElement(element);
            }
        }
    }

    private void typePageDialogFieldChanged(DialogField field) {
        String fieldName = null;
        if (field == this.fPackageDialogField) {
            this.fPackageStatus = this.packageChanged();
            this.updatePackageStatusLabel();
            this.fTypeNameStatus = this.typeNameChanged();
            this.fSuperClassStatus = this.superClassChanged();
            fieldName = PACKAGE;
        } else if (field == this.fEnclosingTypeDialogField) {
            this.fEnclosingTypeStatus = this.enclosingTypeChanged();
            this.fTypeNameStatus = this.typeNameChanged();
            this.fSuperClassStatus = this.superClassChanged();
            fieldName = ENCLOSING;
        } else if (field == this.fEnclosingTypeSelection) {
            this.updateEnableState();
            boolean isEnclosedType = this.isEnclosingTypeSelected();
            if (!isEnclosedType) {
                if (this.fAccMdfButtons.isSelected(2) || this.fAccMdfButtons.isSelected(3)) {
                    this.fAccMdfButtons.setSelection(2, false);
                    this.fAccMdfButtons.setSelection(3, false);
                    this.fAccMdfButtons.setSelection(0, true);
                }
                if (this.fOtherMdfButtons.isSelected(2)) {
                    this.fOtherMdfButtons.setSelection(2, false);
                }
            }
            this.fAccMdfButtons.enableSelectionButton(2, isEnclosedType);
            this.fAccMdfButtons.enableSelectionButton(3, isEnclosedType);
            this.fOtherMdfButtons.enableSelectionButton(2, isEnclosedType);
            this.fTypeNameStatus = this.typeNameChanged();
            this.fSuperClassStatus = this.superClassChanged();
            fieldName = ENCLOSINGSELECTION;
        } else if (field == this.fTypeNameDialogField) {
            this.fTypeNameStatus = this.typeNameChanged();
            fieldName = TYPENAME;
        } else if (field == this.fSuperClassDialogField) {
            this.fSuperClassStatus = this.superClassChanged();
            fieldName = SUPER;
        } else if (field == this.fSuperInterfacesDialogField) {
            this.fSuperInterfacesStatus = this.superInterfacesChanged();
            fieldName = INTERFACES;
        } else if (field == this.fOtherMdfButtons || field == this.fAccMdfButtons) {
            this.fModifierStatus = this.modifiersChanged();
            fieldName = MODIFIERS;
        } else {
            fieldName = METHODS;
        }
        this.handleFieldChanged(fieldName);
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (fieldName == "NewContainerWizardPage.container") {
            this.fPackageStatus = this.packageChanged();
            this.fEnclosingTypeStatus = this.enclosingTypeChanged();
            this.fTypeNameStatus = this.typeNameChanged();
            this.fSuperClassStatus = this.superClassChanged();
            this.fSuperInterfacesStatus = this.superInterfacesChanged();
        }
    }

    public String getPackageText() {
        return this.fPackageDialogField.getText();
    }

    public String getEnclosingTypeText() {
        return this.fEnclosingTypeDialogField.getText();
    }

    public IPackageFragment getPackageFragment() {
        if (!this.isEnclosingTypeSelected()) {
            return this.fCurrPackage;
        }
        if (this.fCurrEnclosingType != null) {
            return this.fCurrEnclosingType.getPackageFragment();
        }
        return null;
    }

    public void setPackageFragment(IPackageFragment pack, boolean canBeModified) {
        this.fCurrPackage = pack;
        this.fCanModifyPackage = canBeModified;
        String str = pack == null ? "" : pack.getElementName();
        this.fPackageDialogField.setText(str);
        this.updateEnableState();
    }

    public IType getEnclosingType() {
        if (this.isEnclosingTypeSelected()) {
            return this.fCurrEnclosingType;
        }
        return null;
    }

    public void setEnclosingType(IType type, boolean canBeModified) {
        this.fCurrEnclosingType = type;
        this.fCanModifyEnclosingType = canBeModified;
        String str = type == null ? "" : JavaModelUtil.getFullyQualifiedName(type);
        this.fEnclosingTypeDialogField.setText(str);
        this.updateEnableState();
    }

    public boolean isEnclosingTypeSelected() {
        return this.fEnclosingTypeSelection.isSelected();
    }

    public void setEnclosingTypeSelection(boolean isSelected, boolean canBeModified) {
        this.fEnclosingTypeSelection.setSelection(isSelected);
        this.fEnclosingTypeSelection.setEnabled(canBeModified);
        this.updateEnableState();
    }

    public String getTypeName() {
        return this.fTypeNameDialogField.getText();
    }

    public void setTypeName(String name, boolean canBeModified) {
        this.fTypeNameDialogField.setText(name);
        this.fTypeNameDialogField.setEnabled(canBeModified);
    }

    public int getModifiers() {
        int mdf = 0;
        if (this.fAccMdfButtons.isSelected(0)) {
            mdf += this.F_PUBLIC;
        } else if (this.fAccMdfButtons.isSelected(2)) {
            mdf += this.F_PRIVATE;
        } else if (this.fAccMdfButtons.isSelected(3)) {
            mdf += this.F_PROTECTED;
        }
        if (this.fOtherMdfButtons.isSelected(0)) {
            mdf += this.F_ABSTRACT;
        }
        if (this.fOtherMdfButtons.isSelected(1)) {
            mdf += this.F_FINAL;
        }
        if (this.fOtherMdfButtons.isSelected(2)) {
            mdf += this.F_STATIC;
        }
        return mdf;
    }

    public void setModifiers(int modifiers, boolean canBeModified) {
        if (Flags.isPublic((int)modifiers)) {
            this.fAccMdfButtons.setSelection(0, true);
        } else if (Flags.isPrivate((int)modifiers)) {
            this.fAccMdfButtons.setSelection(2, true);
        } else if (Flags.isProtected((int)modifiers)) {
            this.fAccMdfButtons.setSelection(3, true);
        } else {
            this.fAccMdfButtons.setSelection(1, true);
        }
        if (Flags.isAbstract((int)modifiers)) {
            this.fOtherMdfButtons.setSelection(0, true);
        }
        if (Flags.isFinal((int)modifiers)) {
            this.fOtherMdfButtons.setSelection(1, true);
        }
        if (Flags.isStatic((int)modifiers)) {
            this.fOtherMdfButtons.setSelection(2, true);
        }
        this.fAccMdfButtons.setEnabled(canBeModified);
        this.fOtherMdfButtons.setEnabled(canBeModified);
    }

    public String getSuperClass() {
        return this.fSuperClassDialogField.getText();
    }

    public void setSuperClass(String name, boolean canBeModified) {
        this.fSuperClassDialogField.setText(name);
        this.fSuperClassDialogField.setEnabled(canBeModified);
    }

    public List getSuperInterfaces() {
        List interfaces = this.fSuperInterfacesDialogField.getElements();
        ArrayList<String> result = new ArrayList<String>(interfaces.size());
        Iterator iter = interfaces.iterator();
        while (iter.hasNext()) {
            InterfaceWrapper wrapper = (InterfaceWrapper)iter.next();
            result.add(wrapper.interfaceName);
        }
        return result;
    }

    public void setSuperInterfaces(List interfacesNames, boolean canBeModified) {
        ArrayList<InterfaceWrapper> interfaces = new ArrayList<InterfaceWrapper>(interfacesNames.size());
        Iterator iter = interfacesNames.iterator();
        while (iter.hasNext()) {
            interfaces.add(new InterfaceWrapper((String)iter.next()));
        }
        this.fSuperInterfacesDialogField.setElements(interfaces);
        this.fSuperInterfacesDialogField.setEnabled(canBeModified);
    }

    public boolean addSuperInterface(String superInterface) {
        return this.fSuperInterfacesDialogField.addElement(new InterfaceWrapper(superInterface));
    }

    public void setAddComments(boolean doAddComments, boolean canBeModified) {
        this.fAddCommentButton.setSelection(doAddComments);
        this.fAddCommentButton.setEnabled(canBeModified);
    }

    public void enableCommentControl(boolean useAddCommentValue) {
        this.fUseAddCommentButtonValue = useAddCommentValue;
    }

    public boolean isAddComments() {
        if (this.fUseAddCommentButtonValue) {
            return this.fAddCommentButton.isSelected();
        }
        return StubUtility.doAddComments(this.getJavaProject());
    }

    public IResource getModifiedResource() {
        IType enclosing = this.getEnclosingType();
        if (enclosing != null) {
            return enclosing.getResource();
        }
        IPackageFragment pack = this.getPackageFragment();
        if (pack != null) {
            String cuName = this.getCompilationUnitName(this.getTypeNameWithoutParameters());
            return pack.getJavaScriptUnit(cuName).getResource();
        }
        return null;
    }

    protected IStatus containerChanged() {
        IStatus status = super.containerChanged();
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (!(this.fTypeKind != 4 && this.fTypeKind != 3 || status.matches(4))) {
            if (root != null && !JavaModelUtil.is50OrHigher(root.getJavaScriptProject())) {
                return new StatusInfo(4, Messages.format(NewWizardMessages.NewTypeWizardPage_warning_NotJDKCompliant, root.getJavaScriptProject().getElementName()));
            }
            if (this.fTypeKind == 3) {
                try {
                    if (this.findType(root.getJavaScriptProject(), "java.lang.Enum") == null) {
                        return new StatusInfo(2, NewWizardMessages.NewTypeWizardPage_warning_EnumClassNotFound);
                    }
                }
                catch (JavaScriptModelException e) {
                    JavaScriptPlugin.log(e);
                }
            }
        }
        this.fCurrPackageCompletionProcessor.setPackageFragmentRoot(root);
        if (root != null) {
            this.fEnclosingTypeCompletionProcessor.setPackageFragment(root.getPackageFragment(""));
        }
        return status;
    }

    protected IStatus packageChanged() {
        StatusInfo status = new StatusInfo();
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        this.fPackageDialogField.enableButton(root != null);
        IJavaScriptProject project = root != null ? root.getJavaScriptProject() : null;
        String packName = this.getPackageText();
        if (packName.length() > 0) {
            IStatus val = NewTypeWizardPage.validatePackageName(packName, project);
            if (val.getSeverity() == 4) {
                status.setError(Messages.format(NewWizardMessages.NewTypeWizardPage_error_InvalidPackageName, val.getMessage()));
                return status;
            }
            if (val.getSeverity() == 2) {
                status.setWarning(Messages.format(NewWizardMessages.NewTypeWizardPage_warning_DiscouragedPackageName, val.getMessage()));
            }
        } else {
            status.setWarning(NewWizardMessages.NewTypeWizardPage_warning_DefaultPackageDiscouraged);
        }
        if (project != null) {
            if (project.exists() && packName.length() > 0) {
                try {
                    IPath packagePath;
                    IPath rootPath = root.getPath();
                    IPath outputPath = project.getOutputLocation();
                    if (rootPath.isPrefixOf(outputPath) && !rootPath.equals((Object)outputPath) && outputPath.isPrefixOf(packagePath = rootPath.append(packName.replace('.', '/')))) {
                        status.setError(NewWizardMessages.NewTypeWizardPage_error_ClashOutputLocation);
                        return status;
                    }
                }
                catch (JavaScriptModelException e) {
                    JavaScriptPlugin.log(e);
                }
            }
            this.fCurrPackage = root.getPackageFragment(packName);
        } else {
            status.setError("");
        }
        return status;
    }

    private void updatePackageStatusLabel() {
        String packName = this.getPackageText();
        if (packName.length() == 0) {
            this.fPackageDialogField.setStatus(NewWizardMessages.NewTypeWizardPage_default);
        } else {
            this.fPackageDialogField.setStatus("");
        }
    }

    private void updateEnableState() {
        boolean enclosing = this.isEnclosingTypeSelected();
        this.fPackageDialogField.setEnabled(this.fCanModifyPackage && !enclosing);
        this.fEnclosingTypeDialogField.setEnabled(this.fCanModifyEnclosingType && enclosing);
        if (this.fTypeKind == 3 || this.fTypeKind == 4) {
            this.fOtherMdfButtons.enableSelectionButton(0, enclosing);
            this.fOtherMdfButtons.enableSelectionButton(1, enclosing);
        }
    }

    protected IStatus enclosingTypeChanged() {
        StatusInfo status = new StatusInfo();
        this.fCurrEnclosingType = null;
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        this.fEnclosingTypeDialogField.enableButton(root != null);
        if (root == null) {
            status.setError("");
            return status;
        }
        String enclName = this.getEnclosingTypeText();
        if (enclName.length() == 0) {
            status.setError(NewWizardMessages.NewTypeWizardPage_error_EnclosingTypeEnterName);
            return status;
        }
        try {
            IType type = this.findType(root.getJavaScriptProject(), enclName);
            if (type == null) {
                status.setError(NewWizardMessages.NewTypeWizardPage_error_EnclosingTypeNotExists);
                return status;
            }
            if (type.getJavaScriptUnit() == null) {
                status.setError(NewWizardMessages.NewTypeWizardPage_error_EnclosingNotInCU);
                return status;
            }
            if (!JavaModelUtil.isEditable(type.getJavaScriptUnit())) {
                status.setError(NewWizardMessages.NewTypeWizardPage_error_EnclosingNotEditable);
                return status;
            }
            this.fCurrEnclosingType = type;
            IPackageFragmentRoot enclosingRoot = JavaModelUtil.getPackageFragmentRoot((IJavaScriptElement)type);
            if (!enclosingRoot.equals(root)) {
                status.setWarning(NewWizardMessages.NewTypeWizardPage_warning_EnclosingNotInSourceFolder);
            }
            return status;
        }
        catch (JavaScriptModelException e) {
            status.setError(NewWizardMessages.NewTypeWizardPage_error_EnclosingTypeNotExists);
            JavaScriptPlugin.log(e);
            return status;
        }
    }

    private IType findType(IJavaScriptProject project, String typeName) throws JavaScriptModelException {
        if (project.exists()) {
            return project.findType(typeName);
        }
        return null;
    }

    private String getTypeNameWithoutParameters() {
        String typeNameWithParameters = this.getTypeName();
        int angleBracketOffset = typeNameWithParameters.indexOf(60);
        if (angleBracketOffset == -1) {
            return typeNameWithParameters;
        }
        return typeNameWithParameters.substring(0, angleBracketOffset);
    }

    protected String getCompilationUnitName(String typeName) {
        return String.valueOf(typeName) + ".js";
    }

    protected IStatus typeNameChanged() {
        StatusInfo status = new StatusInfo();
        this.fCurrType = null;
        String typeNameWithParameters = this.getTypeName();
        if (typeNameWithParameters.length() == 0) {
            status.setError(NewWizardMessages.NewTypeWizardPage_error_EnterTypeName);
            return status;
        }
        String typeName = this.getTypeNameWithoutParameters();
        if (typeName.indexOf(46) != -1) {
            status.setError(NewWizardMessages.NewTypeWizardPage_error_QualifiedName);
            return status;
        }
        IJavaScriptProject project = this.getJavaProject();
        IStatus val = NewTypeWizardPage.validateJavaTypeName(typeName, project);
        if (val.getSeverity() == 4) {
            status.setError(Messages.format(NewWizardMessages.NewTypeWizardPage_error_InvalidTypeName, val.getMessage()));
            return status;
        }
        if (val.getSeverity() == 2) {
            status.setWarning(Messages.format(NewWizardMessages.NewTypeWizardPage_warning_TypeNameDiscouraged, val.getMessage()));
        }
        if (!this.isEnclosingTypeSelected()) {
            IPackageFragment pack = this.getPackageFragment();
            if (pack != null) {
                IJavaScriptUnit cu = pack.getJavaScriptUnit(this.getCompilationUnitName(typeName));
                this.fCurrType = cu.getType(typeName);
                IResource resource = cu.getResource();
                if (resource.exists()) {
                    status.setError(NewWizardMessages.NewTypeWizardPage_error_TypeNameExists);
                    return status;
                }
                URI location = resource.getLocationURI();
                if (location != null) {
                    try {
                        IFileStore store = EFS.getStore((URI)location);
                        if (store.fetchInfo().exists()) {
                            status.setError(NewWizardMessages.NewTypeWizardPage_error_TypeNameExistsDifferentCase);
                            return status;
                        }
                    }
                    catch (CoreException coreException) {
                        status.setError(Messages.format(NewWizardMessages.NewTypeWizardPage_error_uri_location_unkown, Resources.getLocationString(resource)));
                    }
                }
            }
        } else {
            IType type = this.getEnclosingType();
            if (type != null) {
                this.fCurrType = type.getType(typeName);
                if (this.fCurrType.exists()) {
                    status.setError(NewWizardMessages.NewTypeWizardPage_error_TypeNameExists);
                    return status;
                }
            }
        }
        if (!typeNameWithParameters.equals(typeName) && project != null) {
            if (!JavaModelUtil.is50OrHigher(project)) {
                status.setError(NewWizardMessages.NewTypeWizardPage_error_TypeParameters);
                return status;
            }
            String typeDeclaration = "class " + typeNameWithParameters + " {}";
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setSource(typeDeclaration.toCharArray());
            parser.setProject(project);
            JavaScriptUnit compilationUnit = (JavaScriptUnit)parser.createAST(null);
            IProblem[] problems = compilationUnit.getProblems();
            if (problems.length > 0) {
                status.setError(Messages.format(NewWizardMessages.NewTypeWizardPage_error_InvalidTypeName, problems[0].getMessage()));
                return status;
            }
        }
        return status;
    }

    protected IStatus superClassChanged() {
        StatusInfo status = new StatusInfo();
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        this.fSuperClassDialogField.enableButton(root != null);
        this.fSuperClassStubTypeContext = null;
        String sclassName = this.getSuperClass();
        if (sclassName.length() == 0) {
            return status;
        }
        if (root != null) {
            Type type = TypeContextChecker.parseSuperClass(sclassName);
            if (type == null) {
                status.setError(NewWizardMessages.NewTypeWizardPage_error_InvalidSuperClassName);
                return status;
            }
            if (type instanceof ParameterizedType && !JavaModelUtil.is50OrHigher(root.getJavaScriptProject())) {
                status.setError(NewWizardMessages.NewTypeWizardPage_error_SuperClassNotParameterized);
                return status;
            }
        } else {
            status.setError("");
        }
        return status;
    }

    private StubTypeContext getSuperClassStubTypeContext() {
        if (this.fSuperClassStubTypeContext == null) {
            String typeName = this.fCurrType != null ? this.getTypeName() : "$$__$$";
            this.fSuperClassStubTypeContext = TypeContextChecker.createSuperClassStubTypeContext(typeName, this.getEnclosingType(), this.getPackageFragment());
        }
        return this.fSuperClassStubTypeContext;
    }

    protected IStatus superInterfacesChanged() {
        StatusInfo status = new StatusInfo();
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        this.fSuperInterfacesDialogField.enableButton(0, root != null);
        if (root != null) {
            List elements = this.fSuperInterfacesDialogField.getElements();
            int nElements = elements.size();
            int i = 0;
            while (i < nElements) {
                String intfname = ((InterfaceWrapper)elements.get((int)i)).interfaceName;
                Type type = TypeContextChecker.parseSuperInterface(intfname);
                if (type == null) {
                    status.setError(Messages.format(NewWizardMessages.NewTypeWizardPage_error_InvalidSuperInterfaceName, intfname));
                    return status;
                }
                if (type instanceof ParameterizedType && !JavaModelUtil.is50OrHigher(root.getJavaScriptProject())) {
                    status.setError(Messages.format(NewWizardMessages.NewTypeWizardPage_error_SuperInterfaceNotParameterized, intfname));
                    return status;
                }
                ++i;
            }
        }
        return status;
    }

    private StubTypeContext getSuperInterfacesStubTypeContext() {
        if (this.fSuperInterfaceStubTypeContext == null) {
            String typeName = this.fCurrType != null ? this.getTypeName() : "$$__$$";
            this.fSuperInterfaceStubTypeContext = TypeContextChecker.createSuperInterfaceStubTypeContext(typeName, this.getEnclosingType(), this.getPackageFragment());
        }
        return this.fSuperInterfaceStubTypeContext;
    }

    protected IStatus modifiersChanged() {
        StatusInfo status = new StatusInfo();
        int modifiers = this.getModifiers();
        if (Flags.isFinal((int)modifiers) && Flags.isAbstract((int)modifiers)) {
            status.setError(NewWizardMessages.NewTypeWizardPage_error_ModifiersFinalAndAbstract);
        }
        return status;
    }

    protected IPackageFragment choosePackage() {
        IPackageFragmentRoot froot = this.getPackageFragmentRoot();
        Object[] packages = null;
        try {
            if (froot != null && froot.exists()) {
                packages = froot.getChildren();
            }
        }
        catch (JavaScriptModelException e) {
            JavaScriptPlugin.log(e);
        }
        if (packages == null) {
            packages = new IJavaScriptElement[]{};
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaScriptElementLabelProvider(JavaScriptElementLabelProvider.SHOW_DEFAULT));
        dialog.setIgnoreCase(false);
        dialog.setTitle(NewWizardMessages.NewTypeWizardPage_ChoosePackageDialog_title);
        dialog.setMessage(NewWizardMessages.NewTypeWizardPage_ChoosePackageDialog_description);
        dialog.setEmptyListMessage(NewWizardMessages.NewTypeWizardPage_ChoosePackageDialog_empty);
        dialog.setElements(packages);
        dialog.setHelpAvailable(false);
        IPackageFragment pack = this.getPackageFragment();
        if (pack != null) {
            dialog.setInitialSelections(new Object[]{pack});
        }
        if (dialog.open() == 0) {
            return (IPackageFragment)dialog.getFirstResult();
        }
        return null;
    }

    protected IType chooseEnclosingType() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return null;
        }
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{root});
        FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(this.getShell(), false, (IRunnableContext)this.getWizard().getContainer(), scope, 0);
        dialog.setTitle(NewWizardMessages.NewTypeWizardPage_ChooseEnclosingTypeDialog_title);
        dialog.setMessage(NewWizardMessages.NewTypeWizardPage_ChooseEnclosingTypeDialog_description);
        dialog.setInitialPattern(Signature.getSimpleName((String)this.getEnclosingTypeText()));
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return null;
    }

    protected IType chooseSuperClass() {
        IJavaScriptProject project = this.getJavaProject();
        if (project == null) {
            return null;
        }
        IJavaScriptElement[] elements = new IJavaScriptElement[]{project};
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])elements);
        FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(this.getShell(), false, (IRunnableContext)this.getWizard().getContainer(), scope, 5);
        dialog.setTitle(NewWizardMessages.NewTypeWizardPage_SuperClassDialog_title);
        dialog.setMessage(NewWizardMessages.NewTypeWizardPage_SuperClassDialog_message);
        dialog.setInitialPattern(this.getSuperClass());
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return null;
    }

    protected void chooseSuperInterfaces() {
        IJavaScriptProject project = this.getJavaProject();
        if (project == null) {
            return;
        }
        SuperInterfaceSelectionDialog dialog = new SuperInterfaceSelectionDialog(this.getShell(), (IRunnableContext)this.getWizard().getContainer(), this, project);
        dialog.setTitle(this.getInterfaceDialogTitle());
        dialog.setMessage(NewWizardMessages.NewTypeWizardPage_InterfacesDialog_message);
        dialog.open();
    }

    private String getInterfaceDialogTitle() {
        if (this.fTypeKind == 2) {
            return NewWizardMessages.NewTypeWizardPage_InterfacesDialog_interface_title;
        }
        return NewWizardMessages.NewTypeWizardPage_InterfacesDialog_class_title;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createType(IProgressMonitor monitor) throws CoreException, InterruptedException {
        block23: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask(NewWizardMessages.NewTypeWizardPage_operationdesc, 8);
            IPackageFragmentRoot root = this.getPackageFragmentRoot();
            IPackageFragment pack = this.getPackageFragment();
            if (pack == null) {
                pack = root.getPackageFragment("");
            }
            if (!pack.exists()) {
                String packName = pack.getElementName();
                pack = root.createPackageFragment(packName, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                monitor.worked(1);
            }
            IJavaScriptUnit connectedCU = null;
            try {
                String fileComment;
                IType createdType;
                ImportsManager imports;
                Set existingImports;
                boolean needsSave;
                String lineDelimiter;
                int indent;
                boolean isInnerClass;
                block25: {
                    IJavaScriptElement sibling;
                    StringBuffer content;
                    IType enclosingType;
                    block22: {
                        block21: {
                            int max;
                            int i;
                            IField[] fields;
                            IJavaScriptUnit parentCU;
                            block24: {
                                String typeName = this.getTypeNameWithoutParameters();
                                isInnerClass = this.isEnclosingTypeSelected();
                                indent = 0;
                                lineDelimiter = null;
                                if (isInnerClass) break block24;
                                lineDelimiter = StubUtility.getLineDelimiterUsed(pack.getJavaScriptProject());
                                String cuName = this.getCompilationUnitName(typeName);
                                parentCU = pack.createCompilationUnit(cuName, "", false, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                                needsSave = true;
                                parentCU.becomeWorkingCopy((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                connectedCU = parentCU;
                                IBuffer buffer = parentCU.getBuffer();
                                String simpleTypeStub = this.constructSimpleTypeStub();
                                String cuContent = this.constructCUContent(parentCU, simpleTypeStub, lineDelimiter);
                                buffer.setContents(cuContent);
                                JavaScriptUnit astRoot = this.createASTForImports(parentCU);
                                existingImports = this.getExistingImports(astRoot);
                                imports = new ImportsManager(astRoot);
                                imports.addImport(JavaModelUtil.concatenateName(pack.getElementName(), typeName));
                                String typeContent = this.constructTypeStub(parentCU, imports, lineDelimiter);
                                int index = cuContent.lastIndexOf(simpleTypeStub);
                                if (index == -1) {
                                    AbstractTypeDeclaration typeNode = (AbstractTypeDeclaration)astRoot.types().get(0);
                                    int start = ((ASTNode)typeNode.modifiers().get(0)).getStartPosition();
                                    int end = typeNode.getStartPosition() + typeNode.getLength();
                                    buffer.replace(start, end - start, typeContent);
                                } else {
                                    buffer.replace(index, simpleTypeStub.length(), typeContent);
                                }
                                createdType = parentCU.getType(typeName);
                                break block25;
                            }
                            enclosingType = this.getEnclosingType();
                            parentCU = enclosingType.getJavaScriptUnit();
                            needsSave = !parentCU.isWorkingCopy();
                            parentCU.becomeWorkingCopy((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            connectedCU = parentCU;
                            JavaScriptUnit astRoot = this.createASTForImports(parentCU);
                            imports = new ImportsManager(astRoot);
                            existingImports = this.getExistingImports(astRoot);
                            IType[] topLevelTypes = parentCU.getTypes();
                            int i2 = 0;
                            while (true) {
                                if (i2 >= topLevelTypes.length) {
                                    lineDelimiter = StubUtility.getLineDelimiterUsed((IJavaScriptElement)enclosingType);
                                    content = new StringBuffer();
                                    String comment = this.getTypeComment(parentCU, lineDelimiter);
                                    if (comment != null) {
                                        content.append(comment);
                                        content.append(lineDelimiter);
                                    }
                                    content.append(this.constructTypeStub(parentCU, imports, lineDelimiter));
                                    sibling = null;
                                    if (!enclosingType.isEnum()) break block21;
                                    fields = enclosingType.getFields();
                                    if (fields.length > 0) {
                                        i = 0;
                                        max = fields.length;
                                        break;
                                    }
                                    break block22;
                                }
                                imports.addImport(topLevelTypes[i2].getFullyQualifiedName('.'));
                                ++i2;
                            }
                            while (i < max) {
                                if (!fields[i].isEnumConstant()) {
                                    sibling = fields[i];
                                    break block22;
                                }
                                ++i;
                            }
                            break block22;
                        }
                        IJavaScriptElement[] elems = enclosingType.getChildren();
                        sibling = elems.length > 0 ? elems[0] : null;
                    }
                    createdType = enclosingType.createType(content.toString(), sibling, false, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    indent = StubUtility.getIndentUsed((IJavaScriptElement)enclosingType) + 1;
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                IJavaScriptUnit cu = createdType.getJavaScriptUnit();
                imports.create(false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                JavaModelUtil.reconcile(cu);
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                JavaScriptUnit astRoot = this.createASTForImports(imports.getCompilationUnit());
                imports = new ImportsManager(astRoot);
                this.createTypeMembers(createdType, imports, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                imports.create(false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.removeUnusedImports(cu, existingImports, false);
                JavaModelUtil.reconcile(cu);
                ISourceRange range = createdType.getSourceRange();
                IBuffer buf = cu.getBuffer();
                String originalContent = buf.getText(range.getOffset(), range.getLength());
                String formattedContent = CodeFormatterUtil.format(4, originalContent, indent, null, lineDelimiter, pack.getJavaScriptProject());
                formattedContent = Strings.trimLeadingTabsAndSpaces(formattedContent);
                buf.replace(range.getOffset(), range.getLength(), formattedContent);
                if (!isInnerClass && (fileComment = this.getFileComment(cu)) != null && fileComment.length() > 0) {
                    buf.replace(0, 0, String.valueOf(fileComment) + lineDelimiter);
                }
                this.fCreatedType = createdType;
                if (needsSave) {
                    cu.commitWorkingCopy(true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    monitor.worked(1);
                }
            }
            catch (Throwable throwable) {
                Object var24_31 = null;
                if (connectedCU != null) {
                    connectedCU.discardWorkingCopy();
                }
                monitor.done();
                throw throwable;
            }
            {
                Object var24_32 = null;
                if (connectedCU == null) break block23;
            }
            connectedCU.discardWorkingCopy();
        }
        monitor.done();
    }

    private JavaScriptUnit createASTForImports(IJavaScriptUnit cu) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(cu);
        parser.setResolveBindings(false);
        parser.setFocalPosition(0);
        return (JavaScriptUnit)parser.createAST(null);
    }

    private Set getExistingImports(JavaScriptUnit root) {
        List imports = root.imports();
        HashSet<String> res = new HashSet<String>(imports.size());
        int i = 0;
        while (i < imports.size()) {
            res.add(ASTNodes.asString((ASTNode)((ImportDeclaration)imports.get(i))));
            ++i;
        }
        return res;
    }

    private void removeUnusedImports(IJavaScriptUnit cu, Set existingImports, boolean needsSave) throws CoreException {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(cu);
        parser.setResolveBindings(true);
        JavaScriptUnit root = (JavaScriptUnit)parser.createAST(null);
        if (root.getProblems().length == 0) {
            return;
        }
        List importsDecls = root.imports();
        if (importsDecls.isEmpty()) {
            return;
        }
        ImportsManager imports = new ImportsManager(root);
        int importsEnd = ASTNodes.getExclusiveEnd((ASTNode)importsDecls.get(importsDecls.size() - 1));
        IProblem[] problems = root.getProblems();
        int i = 0;
        while (i < problems.length) {
            int id;
            IProblem curr = problems[i];
            if (curr.getSourceEnd() < importsEnd && ((id = curr.getID()) == 268435844 || id == 0x1000003)) {
                int pos = curr.getSourceStart();
                int k = 0;
                while (k < importsDecls.size()) {
                    ImportDeclaration decl = (ImportDeclaration)importsDecls.get(k);
                    if (decl.getStartPosition() <= pos && pos < decl.getStartPosition() + decl.getLength()) {
                        if (!existingImports.isEmpty() && existingImports.contains(ASTNodes.asString((ASTNode)decl))) break;
                        String name = decl.getName().getFullyQualifiedName();
                        if (decl.isOnDemand()) {
                            name = String.valueOf(name) + ".*";
                        }
                        if (decl.isStatic()) {
                            imports.removeStaticImport(name);
                            break;
                        }
                        imports.removeImport(name);
                        break;
                    }
                    ++k;
                }
            }
            ++i;
        }
        imports.create(needsSave, null);
    }

    protected String constructCUContent(IJavaScriptUnit cu, String typeContent, String lineDelimiter) throws CoreException {
        String fileComment = this.getFileComment(cu, lineDelimiter);
        String typeComment = this.getTypeComment(cu, lineDelimiter);
        IPackageFragment pack = (IPackageFragment)cu.getParent();
        String content = CodeGeneration.getCompilationUnitContent(cu, fileComment, typeComment, typeContent, lineDelimiter);
        if (content != null) {
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setProject(cu.getJavaScriptProject());
            parser.setSource(content.toCharArray());
            JavaScriptUnit unit = (JavaScriptUnit)parser.createAST(null);
            if ((pack.isDefaultPackage() || unit.getPackage() != null) && !unit.types().isEmpty()) {
                return content;
            }
        }
        StringBuffer buf = new StringBuffer();
        if (!pack.isDefaultPackage()) {
            buf.append("package ").append(pack.getElementName()).append(';');
        }
        buf.append(lineDelimiter).append(lineDelimiter);
        if (typeComment != null) {
            buf.append(typeComment).append(lineDelimiter);
        }
        buf.append(typeContent);
        return buf.toString();
    }

    public IType getCreatedType() {
        return this.fCreatedType;
    }

    private void writeSuperClass(StringBuffer buf, ImportsManager imports) {
        String superclass = this.getSuperClass();
        if (this.fTypeKind == 1 && superclass.length() > 0 && !"java.lang.Object".equals(superclass)) {
            buf.append(" extends ");
            ITypeBinding binding = null;
            if (this.fCurrType != null) {
                binding = TypeContextChecker.resolveSuperClass(superclass, this.fCurrType, this.getSuperClassStubTypeContext());
            }
            if (binding != null) {
                buf.append(imports.addImport(binding));
            } else {
                buf.append(imports.addImport(superclass));
            }
        }
    }

    private void writeSuperInterfaces(StringBuffer buf, ImportsManager imports) {
        List interfaces = this.getSuperInterfaces();
        int last = interfaces.size() - 1;
        if (last >= 0) {
            if (this.fTypeKind != 2) {
                buf.append(" implements ");
            } else {
                buf.append(" extends ");
            }
            String[] intfs = interfaces.toArray(new String[interfaces.size()]);
            ITypeBinding[] bindings = this.fCurrType != null ? TypeContextChecker.resolveSuperInterfaces(intfs, this.fCurrType, this.getSuperInterfacesStubTypeContext()) : new ITypeBinding[intfs.length];
            int i = 0;
            while (i <= last) {
                ITypeBinding binding = bindings[i];
                if (binding != null) {
                    buf.append(imports.addImport(binding));
                } else {
                    buf.append(imports.addImport(intfs[i]));
                }
                if (i < last) {
                    buf.append(',');
                }
                ++i;
            }
        }
    }

    private String constructSimpleTypeStub() {
        StringBuffer buf = new StringBuffer("public class ");
        buf.append(this.getTypeName());
        buf.append("{ }");
        return buf.toString();
    }

    private String constructTypeStub(IJavaScriptUnit parentCU, ImportsManager imports, String lineDelimiter) throws CoreException {
        StringBuffer buf = new StringBuffer();
        int modifiers = this.getModifiers();
        buf.append(Flags.toString((int)modifiers));
        if (modifiers != 0) {
            buf.append(' ');
        }
        String type = "";
        String templateID = "";
        switch (this.fTypeKind) {
            case 1: {
                type = "class ";
                templateID = "org.eclipse.wst.jsdt.ui.text.codetemplates.classbody";
                break;
            }
            case 2: {
                type = "interface ";
                templateID = "org.eclipse.wst.jsdt.ui.text.codetemplates.interfacebody";
                break;
            }
            case 3: {
                type = "enum ";
                templateID = "org.eclipse.wst.jsdt.ui.text.codetemplates.enumbody";
                break;
            }
            case 4: {
                type = "@interface ";
                templateID = "org.eclipse.wst.jsdt.ui.text.codetemplates.annotationbody";
            }
        }
        buf.append(type);
        buf.append(this.getTypeName());
        this.writeSuperClass(buf, imports);
        this.writeSuperInterfaces(buf, imports);
        buf.append(" {").append(lineDelimiter);
        String typeBody = CodeGeneration.getTypeBody(templateID, parentCU, this.getTypeName(), lineDelimiter);
        if (typeBody != null) {
            buf.append(typeBody);
        } else {
            buf.append(lineDelimiter);
        }
        buf.append('}').append(lineDelimiter);
        return buf.toString();
    }

    protected void createTypeMembers(IType newType, ImportsManager imports, IProgressMonitor monitor) throws CoreException {
    }

    protected String getFileComment(IJavaScriptUnit parentCU) {
        return null;
    }

    protected String getFileComment(IJavaScriptUnit parentCU, String lineDelimiter) throws CoreException {
        if (this.isAddComments()) {
            return CodeGeneration.getFileComment(parentCU, lineDelimiter);
        }
        return null;
    }

    private boolean isValidComment(String template) {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(template.toCharArray());
        try {
            int next = scanner.getNextToken();
            while (TokenScanner.isComment(next)) {
                next = scanner.getNextToken();
            }
            return next == 158;
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
    }

    protected String getTypeComment(IJavaScriptUnit parentCU, String lineDelimiter) {
        if (this.isAddComments()) {
            try {
                StringBuffer typeName = new StringBuffer();
                if (this.isEnclosingTypeSelected()) {
                    typeName.append(JavaModelUtil.getTypeQualifiedName(this.getEnclosingType())).append('.');
                }
                typeName.append(this.getTypeNameWithoutParameters());
                String[] typeParamNames = new String[]{};
                String comment = CodeGeneration.getTypeComment(parentCU, typeName.toString(), typeParamNames, lineDelimiter);
                if (comment != null && this.isValidComment(comment)) {
                    return comment;
                }
            }
            catch (CoreException e) {
                JavaScriptPlugin.log(e);
            }
        }
        return null;
    }

    protected String getTemplate(String name, IJavaScriptUnit parentCU, int pos) {
        try {
            Template template = JavaScriptPlugin.getDefault().getTemplateStore().findTemplate(name);
            if (template != null) {
                return JavaContext.evaluateTemplate(template, parentCU, pos);
            }
        }
        catch (CoreException e) {
            JavaScriptPlugin.log(e);
        }
        catch (BadLocationException e) {
            JavaScriptPlugin.log(e);
        }
        catch (TemplateException e) {
            JavaScriptPlugin.log(e);
        }
        return null;
    }

    protected IFunction[] createInheritedMethods(IType type, boolean doConstructors, boolean doUnimplementedMethods, ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        IJavaScriptUnit cu = type.getJavaScriptUnit();
        JavaModelUtil.reconcile(cu);
        IFunction[] typeMethods = type.getFunctions();
        HashSet<String> handleIds = new HashSet<String>(typeMethods.length);
        int index = 0;
        while (index < typeMethods.length) {
            handleIds.add(typeMethods[index].getHandleIdentifier());
            ++index;
        }
        ArrayList<IFunction> newMethods = new ArrayList<IFunction>();
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(type.getJavaScriptProject());
        settings.createComments = this.isAddComments();
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setResolveBindings(true);
        parser.setSource(cu);
        JavaScriptUnit unit = (JavaScriptUnit)parser.createAST((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        ITypeBinding binding = ASTNodes.getTypeBinding(unit, type);
        if (binding != null) {
            Object operation;
            if (doUnimplementedMethods) {
                operation = new AddUnimplementedMethodsOperation(unit, binding, null, -1, false, true, false);
                ((AddUnimplementedMethodsOperation)operation).setCreateComments(this.isAddComments());
                ((AddUnimplementedMethodsOperation)operation).run(monitor);
                this.createImports(imports, ((AddUnimplementedMethodsOperation)operation).getCreatedImports());
            }
            if (doConstructors) {
                operation = new AddUnimplementedConstructorsOperation(unit, binding, null, -1, false, true, false);
                ((AddUnimplementedConstructorsOperation)operation).setOmitSuper(true);
                ((AddUnimplementedConstructorsOperation)operation).setCreateComments(this.isAddComments());
                ((AddUnimplementedConstructorsOperation)operation).run(monitor);
                this.createImports(imports, ((AddUnimplementedConstructorsOperation)operation).getCreatedImports());
            }
        }
        JavaModelUtil.reconcile(cu);
        typeMethods = type.getFunctions();
        int index2 = 0;
        while (index2 < typeMethods.length) {
            if (!handleIds.contains(typeMethods[index2].getHandleIdentifier())) {
                newMethods.add(typeMethods[index2]);
            }
            ++index2;
        }
        IFunction[] methods = new IFunction[newMethods.size()];
        newMethods.toArray(methods);
        return methods;
    }

    private void createImports(ImportsManager imports, String[] createdImports) {
        int index = 0;
        while (index < createdImports.length) {
            imports.addImport(createdImports[index]);
            ++index;
        }
    }

    public IRunnableWithProgress getRunnable() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    NewTypeWizardPage.this.createType(monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
    }

    public static class ImportsManager {
        private ImportRewrite fImportsRewrite;

        ImportsManager(JavaScriptUnit astRoot) throws CoreException {
            this.fImportsRewrite = CodeStyleConfiguration.createImportRewrite(astRoot, true);
        }

        IJavaScriptUnit getCompilationUnit() {
            return this.fImportsRewrite.getCompilationUnit();
        }

        public String addImport(String qualifiedTypeName) {
            return this.fImportsRewrite.addImport(qualifiedTypeName);
        }

        public String addImport(ITypeBinding typeBinding) {
            return this.fImportsRewrite.addImport(typeBinding);
        }

        public String addStaticImport(String declaringTypeName, String simpleName, boolean isField) {
            return this.fImportsRewrite.addStaticImport(declaringTypeName, simpleName, isField);
        }

        void create(boolean needsSave, IProgressMonitor monitor) throws CoreException {
            TextEdit edit = this.fImportsRewrite.rewriteImports(monitor);
            JavaModelUtil.applyEdit(this.fImportsRewrite.getCompilationUnit(), edit, needsSave, null);
        }

        void removeImport(String qualifiedName) {
            this.fImportsRewrite.removeImport(qualifiedName);
        }

        void removeStaticImport(String qualifiedName) {
            this.fImportsRewrite.removeStaticImport(qualifiedName);
        }
    }

    private static class InterfaceWrapper {
        public String interfaceName;

        public InterfaceWrapper(String interfaceName) {
            this.interfaceName = interfaceName;
        }

        public int hashCode() {
            return this.interfaceName.hashCode();
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass().equals(obj.getClass()) && ((InterfaceWrapper)obj).interfaceName.equals(this.interfaceName);
        }
    }

    private static class InterfacesListLabelProvider
    extends LabelProvider {
        private Image fInterfaceImage = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.int_obj.gif");

        public String getText(Object element) {
            return ((InterfaceWrapper)element).interfaceName;
        }

        public Image getImage(Object element) {
            return this.fInterfaceImage;
        }
    }

    private class TypeFieldsAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener,
    IListAdapter,
    SelectionListener {
        private TypeFieldsAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            NewTypeWizardPage.this.typePageChangeControlPressed(field);
        }

        public void customButtonPressed(ListDialogField field, int index) {
            NewTypeWizardPage.this.typePageCustomButtonPressed(field, index);
        }

        public void selectionChanged(ListDialogField field) {
        }

        public void dialogFieldChanged(DialogField field) {
            NewTypeWizardPage.this.typePageDialogFieldChanged(field);
        }

        public void doubleClicked(ListDialogField field) {
        }

        public void widgetSelected(SelectionEvent e) {
            NewTypeWizardPage.this.typePageLinkActivated(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            NewTypeWizardPage.this.typePageLinkActivated(e);
        }
    }
}

