/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.generics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.internal.corext.refactoring.generics.InferTypeArgumentsTCModel;
import org.eclipse.wst.jsdt.internal.corext.refactoring.generics.InferTypeArgumentsUpdate;
import org.eclipse.wst.jsdt.internal.corext.refactoring.generics.ParametricStructureComputer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.ArrayType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.HierarchyType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.EnumeratedTypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SingletonTypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.TypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.TypeSetEnvironment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ArrayElementVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ArrayTypeVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.CastVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.CollectionElementVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ConstraintVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ITypeConstraint2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.IndependentTypeVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.TTypes;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.TypeEquivalenceSet;

public class InferTypeArgumentsConstraintsSolver {
    private static final String CHOSEN_TYPE = "chosenType";
    private final InferTypeArgumentsTCModel fTCModel;
    private TypeSetEnvironment fTypeSetEnvironment;
    private LinkedList fWorkList;
    private InferTypeArgumentsUpdate fUpdate;
    private static final int MAX_CACHE = 1024;
    private Map fInterfaceTaggingCache = new LinkedHashMap(1024, 0.75f, true){
        private static final long serialVersionUID = 1L;

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 1024;
        }
    };

    public InferTypeArgumentsConstraintsSolver(InferTypeArgumentsTCModel typeConstraintFactory) {
        this.fTCModel = typeConstraintFactory;
        this.fWorkList = new LinkedList();
    }

    public InferTypeArgumentsUpdate solveConstraints(IProgressMonitor pm) {
        TypeEquivalenceSet typeEquivalenceSet;
        pm.beginTask("", 2);
        this.fUpdate = new InferTypeArgumentsUpdate();
        ConstraintVariable2[] allConstraintVariables = this.fTCModel.getAllConstraintVariables();
        if (allConstraintVariables.length == 0) {
            return this.fUpdate;
        }
        this.fTypeSetEnvironment = new TypeSetEnvironment(this.fTCModel.getTypeEnvironment());
        ParametricStructureComputer parametricStructureComputer = new ParametricStructureComputer(allConstraintVariables, this.fTCModel);
        Collection newVars = parametricStructureComputer.createElemConstraintVariables();
        ArrayList<ConstraintVariable2> newAllConstraintVariables = new ArrayList<ConstraintVariable2>();
        newAllConstraintVariables.addAll(Arrays.asList(allConstraintVariables));
        newAllConstraintVariables.addAll(newVars);
        allConstraintVariables = newAllConstraintVariables.toArray(new ConstraintVariable2[newAllConstraintVariables.size()]);
        HashSet<TypeEquivalenceSet> allTypeEquivalenceSets = new HashSet<TypeEquivalenceSet>();
        int i = 0;
        while (i < allConstraintVariables.length) {
            typeEquivalenceSet = allConstraintVariables[i].getTypeEquivalenceSet();
            if (typeEquivalenceSet != null) {
                allTypeEquivalenceSets.add(typeEquivalenceSet);
            }
            ++i;
        }
        Iterator iter = allTypeEquivalenceSets.iterator();
        while (iter.hasNext()) {
            typeEquivalenceSet = (TypeEquivalenceSet)iter.next();
            ConstraintVariable2[] contributingVariables = typeEquivalenceSet.getContributingVariables();
            int i2 = 0;
            while (i2 < contributingVariables.length) {
                int j = i2 + 1;
                while (j < contributingVariables.length) {
                    ConstraintVariable2 first = contributingVariables[i2];
                    ConstraintVariable2 second = contributingVariables[j];
                    this.fTCModel.createElementEqualsConstraints(first, second);
                    ++j;
                }
                ++i2;
            }
        }
        ITypeConstraint2[] allTypeConstraints = this.fTCModel.getAllTypeConstraints();
        int i3 = 0;
        while (i3 < allTypeConstraints.length) {
            ITypeConstraint2 typeConstraint = allTypeConstraints[i3];
            this.fTCModel.createElementEqualsConstraints(typeConstraint.getLeft(), typeConstraint.getRight());
            ++i3;
        }
        this.initializeTypeEstimates(allConstraintVariables);
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.fWorkList.addAll(Arrays.asList(allConstraintVariables));
        this.runSolver(new SubProgressMonitor(pm, 1));
        this.chooseTypes(allConstraintVariables, new SubProgressMonitor(pm, 1));
        this.findCastsToRemove(this.fTCModel.getCastVariables());
        return this.fUpdate;
    }

    private void initializeTypeEstimates(ConstraintVariable2[] allConstraintVariables) {
        int i = 0;
        while (i < allConstraintVariables.length) {
            ConstraintVariable2 cv = allConstraintVariables[i];
            TypeEquivalenceSet set = cv.getTypeEquivalenceSet();
            if (set == null) {
                set = new TypeEquivalenceSet(cv);
                set.setTypeEstimate(this.createInitialEstimate(cv));
                cv.setTypeEquivalenceSet(set);
            } else {
                TypeSet typeEstimate = (TypeSet)cv.getTypeEstimate();
                if (typeEstimate == null) {
                    ConstraintVariable2[] cvs = set.getContributingVariables();
                    typeEstimate = this.fTypeSetEnvironment.getUniverseTypeSet();
                    int j = 0;
                    while (j < cvs.length) {
                        typeEstimate = typeEstimate.intersectedWith(this.createInitialEstimate(cvs[j]));
                        ++j;
                    }
                    set.setTypeEstimate(typeEstimate);
                }
            }
            ++i;
        }
    }

    private TypeSet createInitialEstimate(ConstraintVariable2 cv) {
        TType type = cv.getType();
        if (type == null) {
            return this.fTypeSetEnvironment.getUniverseTypeSet();
        }
        if (cv instanceof IndependentTypeVariable2) {
            return this.fTypeSetEnvironment.getUniverseTypeSet();
        }
        if (cv instanceof ArrayTypeVariable2) {
            return this.fTypeSetEnvironment.getUniverseTypeSet();
        }
        if (cv instanceof ArrayElementVariable2) {
            if (cv.getType() != null && cv.getType().isTypeVariable()) {
                return this.fTypeSetEnvironment.getUniverseTypeSet();
            }
            return new SingletonTypeSet(type, this.fTypeSetEnvironment);
        }
        if (type.isVoidType()) {
            return this.fTypeSetEnvironment.getEmptyTypeSet();
        }
        return new SingletonTypeSet(type, this.fTypeSetEnvironment);
    }

    private void runSolver(SubProgressMonitor pm) {
        pm.beginTask("", this.fWorkList.size() * 3);
        while (!this.fWorkList.isEmpty()) {
            ConstraintVariable2 cv = (ConstraintVariable2)this.fWorkList.removeFirst();
            List usedIn = this.fTCModel.getUsedIn(cv);
            this.processConstraints(usedIn, cv);
            pm.worked(1);
            if (!pm.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        pm.done();
    }

    private void processConstraints(List usedIn, ConstraintVariable2 changedCv) {
        int i = 0;
        Iterator iter = usedIn.iterator();
        while (iter.hasNext()) {
            ITypeConstraint2 tc = (ITypeConstraint2)iter.next();
            this.maintainSimpleConstraint(changedCv, tc);
            ++i;
        }
    }

    private void maintainSimpleConstraint(ConstraintVariable2 changedCv, ITypeConstraint2 stc) {
        TypeSet xsection;
        ConstraintVariable2 left = stc.getLeft();
        ConstraintVariable2 right = stc.getRight();
        TypeEquivalenceSet leftSet = left.getTypeEquivalenceSet();
        TypeEquivalenceSet rightSet = right.getTypeEquivalenceSet();
        TypeSet leftEstimate = (TypeSet)leftSet.getTypeEstimate();
        TypeSet rightEstimate = (TypeSet)rightSet.getTypeEstimate();
        if (leftEstimate.isUniverse() && rightEstimate.isUniverse()) {
            return;
        }
        if (leftEstimate.equals(rightEstimate)) {
            return;
        }
        TypeSet lhsSuperTypes = leftEstimate.superTypes();
        TypeSet rhsSubTypes = rightEstimate.subTypes();
        if (!rhsSubTypes.containsAll(leftEstimate)) {
            xsection = leftEstimate.intersectedWith(rhsSubTypes);
            leftSet.setTypeEstimate(xsection);
            this.fWorkList.addAll(Arrays.asList(leftSet.getContributingVariables()));
        }
        if (!lhsSuperTypes.containsAll(rightEstimate)) {
            xsection = rightEstimate.intersectedWith(lhsSuperTypes);
            rightSet.setTypeEstimate(xsection);
            this.fWorkList.addAll(Arrays.asList(rightSet.getContributingVariables()));
        }
    }

    private void chooseTypes(ConstraintVariable2[] allConstraintVariables, SubProgressMonitor pm) {
        pm.beginTask("", allConstraintVariables.length);
        int i = 0;
        while (i < allConstraintVariables.length) {
            ConstraintVariable2 cv = allConstraintVariables[i];
            TypeEquivalenceSet set = cv.getTypeEquivalenceSet();
            if (set != null) {
                TType type = this.chooseSingleType((TypeSet)cv.getTypeEstimate());
                InferTypeArgumentsConstraintsSolver.setChosenType(cv, type);
                if (cv instanceof CollectionElementVariable2) {
                    CollectionElementVariable2 elementCv = (CollectionElementVariable2)cv;
                    this.fUpdate.addDeclaration(elementCv);
                }
                pm.worked(1);
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
            }
            ++i;
        }
        pm.done();
    }

    private TType chooseSingleType(TypeSet typeEstimate) {
        if (typeEstimate.isUniverse() || typeEstimate.isEmpty()) {
            return null;
        }
        if (typeEstimate.hasUniqueLowerBound()) {
            return typeEstimate.uniqueLowerBound();
        }
        EnumeratedTypeSet lowerBound = typeEstimate.lowerBound().enumerate();
        ArrayList<TType> interfaceCandidates = null;
        Iterator iter = lowerBound.iterator();
        while (iter.hasNext()) {
            TType type = (TType)iter.next();
            if (!type.isInterface()) {
                return type;
            }
            if (interfaceCandidates == null) {
                interfaceCandidates = new ArrayList<TType>(2);
            }
            interfaceCandidates.add(type);
        }
        if (interfaceCandidates == null || interfaceCandidates.size() == 0) {
            return null;
        }
        if (interfaceCandidates.size() == 1) {
            return (TType)interfaceCandidates.get(0);
        }
        ArrayList nontaggingCandidates = this.getNonTaggingInterfaces(interfaceCandidates);
        if (nontaggingCandidates.size() != 0) {
            return (TType)Collections.min(nontaggingCandidates, TTypeComparator.INSTANCE);
        }
        return (TType)Collections.min(interfaceCandidates, TTypeComparator.INSTANCE);
    }

    private ArrayList getNonTaggingInterfaces(ArrayList interfaceCandidates) {
        ArrayList<TType> unresolvedTypes = new ArrayList<TType>();
        ArrayList<TType> nonTagging = new ArrayList<TType>();
        int i = 0;
        while (i < interfaceCandidates.size()) {
            TType interf = (TType)interfaceCandidates.get(i);
            Object isTagging = this.fInterfaceTaggingCache.get(interf);
            if (isTagging == null) {
                unresolvedTypes.add(interf);
            } else if (isTagging == Boolean.FALSE) {
                nonTagging.add(interf);
            }
            ++i;
        }
        if (unresolvedTypes.size() != 0) {
            TType[] interfaces = unresolvedTypes.toArray(new TType[unresolvedTypes.size()]);
            HierarchyType firstInterface = (HierarchyType)interfaces[0];
            IJavaScriptProject javaProject = firstInterface.getJavaElementType().getJavaScriptProject();
            ITypeBinding[] interfaceBindings = TypeEnvironment.createTypeBindings(interfaces, javaProject);
            int i2 = 0;
            while (i2 < interfaceBindings.length) {
                if (interfaceBindings[i2].getDeclaredMethods().length == 0) {
                    this.fInterfaceTaggingCache.put(interfaces[i2], Boolean.TRUE);
                } else {
                    this.fInterfaceTaggingCache.put(interfaces[i2], Boolean.FALSE);
                    nonTagging.add(interfaces[i2]);
                }
                ++i2;
            }
        }
        return nonTagging;
    }

    private void findCastsToRemove(CastVariable2[] castVariables) {
        int i = 0;
        while (i < castVariables.length) {
            TType chosenArrayElementType;
            ArrayElementVariable2 arrayElementCv;
            CastVariable2 castCv = castVariables[i];
            ConstraintVariable2 expressionVariable = castCv.getExpressionVariable();
            TType chosenType = InferTypeArgumentsConstraintsSolver.getChosenType(expressionVariable);
            TType castType = castCv.getType();
            TType expressionType = expressionVariable.getType();
            if (chosenType != null && TTypes.canAssignTo(chosenType, castType)) {
                if (!chosenType.equals(expressionType)) {
                    this.fUpdate.addCastToRemove(castCv);
                }
            } else if (expressionVariable instanceof ArrayTypeVariable2 && castType.isArrayType() && (arrayElementCv = this.fTCModel.getArrayElementVariable(expressionVariable)) != null && (chosenArrayElementType = InferTypeArgumentsConstraintsSolver.getChosenType(arrayElementCv)) != null && TTypes.canAssignTo(chosenArrayElementType, ((ArrayType)castType).getComponentType()) && (!(expressionType instanceof ArrayType) || !chosenArrayElementType.equals(((ArrayType)expressionType).getComponentType()))) {
                this.fUpdate.addCastToRemove(castCv);
            }
            ++i;
        }
    }

    public static TType getChosenType(ConstraintVariable2 cv) {
        TType type = (TType)cv.getData(CHOSEN_TYPE);
        if (type != null) {
            return type;
        }
        TypeEquivalenceSet set = cv.getTypeEquivalenceSet();
        if (set == null) {
            return null;
        }
        return cv.getTypeEstimate().chooseSingleType();
    }

    private static void setChosenType(ConstraintVariable2 cv, TType type) {
        cv.setData(CHOSEN_TYPE, type);
    }

    private static class TTypeComparator
    implements Comparator {
        public static TTypeComparator INSTANCE = new TTypeComparator();

        private TTypeComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((TType)o1).getPrettySignature().compareTo(((TType)o2).getPrettySignature());
        }
    }
}

