/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.validation.internal.EventManager;
import org.eclipse.wst.validation.internal.RegistryConstants;
import org.eclipse.wst.validation.internal.ResourceHandler;
import org.eclipse.wst.validation.internal.Tracing;
import org.eclipse.wst.validation.internal.ValMessages;
import org.eclipse.wst.validation.internal.ValidatorFilter;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.ValidatorNameFilter;
import org.eclipse.wst.validation.internal.delegates.ValidatorDelegatesRegistry;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidationRegistryReader
implements RegistryConstants {
    private static ValidationRegistryReader _inst = new ValidationRegistryReader();
    private final Map<String, Set<ValidatorMetaData>> _validators;
    private final Map<String, ValidatorMetaData> _indexedValidators;
    private final Set<ValidatorMetaData> _defaultEnabledValidators;
    private static final String IRESOURCE = "org.eclipse.core.resources.IResource";
    private static final String UNKNOWN_PROJECT = "UNKNOWN";
    private static final String EXCLUDED_PROJECT = "EXCLUDED";
    public HashMap<IProject, Set<ValidatorMetaData>> projectValidationMetaData = new HashMap();

    private ValidationRegistryReader() {
        this._validators = new HashMap<String, Set<ValidatorMetaData>>();
        this._indexedValidators = new HashMap<String, ValidatorMetaData>();
        this._defaultEnabledValidators = new HashSet<ValidatorMetaData>();
        try {
            this.readRegistry();
            this.buildCache();
        }
        catch (Exception e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
    }

    private void buildCache() {
        for (ValidatorMetaData vmd : this._indexedValidators.values()) {
            this.buildProjectNatureCache(vmd);
            this.buildDefaultEnabledCache(vmd);
        }
        this.addRemainder();
        this._validators.remove(EXCLUDED_PROJECT);
        if (Tracing.isTraceV1()) {
            Tracing.log("ValidationRegistryReader-01: ", this.debug());
        }
    }

    private void buildProjectNatureCache(ValidatorMetaData vmd) {
        ValidatorNameFilter[] projNatureIds = vmd.getProjectNatureFilters();
        String[] facetFilters = vmd.getFacetFilters();
        if (projNatureIds == null) {
            if (facetFilters == null && vmd.getEnablementExpresion() == null) {
                this.add(UNKNOWN_PROJECT, vmd);
            }
        } else {
            boolean noneIncluded = true;
            int i = 0;
            while (i < projNatureIds.length) {
                ValidatorNameFilter pn = projNatureIds[i];
                if (pn.isInclude()) {
                    noneIncluded = false;
                    this.add(pn.getNameFilter(), vmd);
                }
                ++i;
            }
            if (noneIncluded) {
                this.add(EXCLUDED_PROJECT, vmd);
            }
        }
    }

    private void buildDefaultEnabledCache(ValidatorMetaData vmd) {
        if (vmd == null) {
            return;
        }
        if (vmd.isEnabledByDefault()) {
            this._defaultEnabledValidators.add(vmd);
        }
    }

    private void add(ValidatorMetaData vmd) {
        if (vmd == null) {
            return;
        }
        this._indexedValidators.put(vmd.getValidatorUniqueName(), vmd);
    }

    private void addRemainder() {
        this.addAnyRemainder();
        this.addExcludedRemainder();
    }

    private void addExcludedRemainder() {
        Set<ValidatorMetaData> excludedProjVmds = this._validators.get(EXCLUDED_PROJECT);
        if (excludedProjVmds == null) {
            return;
        }
        for (ValidatorMetaData vmd : excludedProjVmds) {
            boolean noneIncluded = true;
            for (String projId : this._validators.keySet()) {
                if (projId.equals(UNKNOWN_PROJECT) || projId.equals(EXCLUDED_PROJECT)) continue;
                ValidatorNameFilter filter = vmd.findProjectNature(projId);
                if (filter != null) {
                    if (!filter.isInclude()) continue;
                    noneIncluded = false;
                    continue;
                }
                this.add(projId, vmd);
            }
            if (!noneIncluded) continue;
            this.add(UNKNOWN_PROJECT, vmd);
        }
    }

    private void addAnyRemainder() {
        Set<ValidatorMetaData> anyProjVmds = this._validators.get(UNKNOWN_PROJECT);
        if (anyProjVmds == null) {
            return;
        }
        for (String projId : this._validators.keySet()) {
            if (projId.equals(UNKNOWN_PROJECT) || projId.equals(EXCLUDED_PROJECT)) continue;
            this.add(projId, anyProjVmds);
        }
    }

    private void add(String projectNatureId, Set<ValidatorMetaData> vmdList) {
        if (vmdList == null || vmdList.size() == 0) {
            return;
        }
        Set<ValidatorMetaData> pnVal = this.createSet(projectNatureId);
        pnVal.addAll(vmdList);
        this._validators.put(projectNatureId, pnVal);
    }

    private void add(String projectNatureId, ValidatorMetaData vmd) {
        if (vmd == null) {
            return;
        }
        Set<ValidatorMetaData> pnVal = this.createSet(projectNatureId);
        pnVal.add(vmd);
        this._validators.put(projectNatureId, pnVal);
    }

    public void disableValidator(ValidatorMetaData vmd) {
        this._indexedValidators.remove(vmd.getValidatorUniqueName());
        this._defaultEnabledValidators.remove(vmd);
        for (String projId : this._validators.keySet()) {
            Set<ValidatorMetaData> value = this._validators.get(projId);
            if (value == null || !value.contains(vmd)) continue;
            value.remove(vmd);
            this._validators.put(projId, value);
        }
    }

    private Set<ValidatorMetaData> createSet(String projNature) {
        Set<ValidatorMetaData> v = this._validators.get(projNature);
        if (v == null) {
            v = new HashSet<ValidatorMetaData>();
        }
        return v;
    }

    private String[] getAggregateValidatorsNames(IConfigurationElement element) {
        IConfigurationElement[] filters = element.getChildren("aggregateValidator");
        if (filters.length == 0) {
            return null;
        }
        String[] names = new String[filters.length];
        int i = 0;
        while (i < names.length) {
            String nameFilter = filters[i].getAttribute("class");
            if (nameFilter != null) {
                nameFilter = nameFilter.intern();
            }
            names[i] = nameFilter;
            ++i;
        }
        return names;
    }

    private String[] getContentTypeBindings(IConfigurationElement element) {
        IConfigurationElement[] bindings = element.getChildren("contentTypeBinding");
        if (bindings.length == 0) {
            return null;
        }
        String[] cTypeIDs = new String[bindings.length];
        int i = 0;
        while (i < bindings.length) {
            cTypeIDs[i] = bindings[i].getAttribute("contentTypeId");
            ++i;
        }
        return cTypeIDs;
    }

    private ValidatorFilter[] getFilters(IConfigurationElement element) {
        IConfigurationElement[] filters = element.getChildren("filter");
        if (filters.length == 0) {
            return null;
        }
        ValidatorFilter[] vf = new ValidatorFilter[filters.length];
        int i = 0;
        while (i < filters.length) {
            vf[i] = new ValidatorFilter(IRESOURCE);
            String nameFilter = filters[i].getAttribute("nameFilter");
            if (nameFilter != null) {
                nameFilter = nameFilter.intern();
            }
            String isCaseSensitive = filters[i].getAttribute("caseSensitive");
            vf[i].setNameFilter(nameFilter, isCaseSensitive);
            String objectClass = filters[i].getAttribute("objectClass");
            if (objectClass != null) {
                objectClass = objectClass.intern();
            }
            vf[i].setTypeFilter(objectClass);
            String actionFilter = filters[i].getAttribute("action");
            if (actionFilter != null) {
                actionFilter = actionFilter.intern();
            }
            vf[i].setActionFilter(actionFilter);
            ++i;
        }
        return vf;
    }

    public boolean getDependentValidatorValue(IConfigurationElement element) {
        IConfigurationElement[] depValidatorElement = element.getChildren("dependentValidator");
        if (depValidatorElement.length == 0) {
            return false;
        }
        String depValue = depValidatorElement[0].getAttribute("depValValue");
        boolean depBoolValue = new Boolean(depValue);
        return depBoolValue;
    }

    public String[] getMarkerIdsValue(IConfigurationElement element) {
        IConfigurationElement[] markerId = element.getChildren("markerId");
        if (markerId.length == 0) {
            return null;
        }
        String[] markerIds = new String[markerId.length];
        int i = 0;
        while (i < markerIds.length) {
            markerIds[i] = markerId[i].getAttribute("markerIdValue");
            ++i;
        }
        return markerIds;
    }

    public String[] getFacetIds(IConfigurationElement element) {
        IConfigurationElement[] facets = element.getChildren("facet");
        if (facets.length == 0) {
            return null;
        }
        String[] facetIds = new String[facets.length];
        int i = 0;
        while (i < facets.length) {
            facetIds[i] = facets[i].getAttribute("facetId");
            ++i;
        }
        return facetIds;
    }

    private String getHelperName(IConfigurationElement element) {
        IConfigurationElement[] helpers = element.getChildren("helper");
        if (helpers.length == 0) {
            return null;
        }
        return helpers[0].getAttribute("class");
    }

    static IWorkbenchContext createHelper(IConfigurationElement element, String helperClassName) {
        IWorkbenchContext wh = null;
        try {
            wh = (IWorkbenchContext)element.createExecutableExtension("helper");
        }
        catch (Exception exc) {
            ValidationPlugin.getPlugin().handleException(exc);
            String result = MessageFormat.format(ResourceHandler.getExternalizedMessage("VBF_EXC_SYNTAX_NO_HELPER_THROWABLE"), helperClassName);
            ValidationPlugin.getPlugin().logMessage(4, result);
            return null;
        }
        return wh;
    }

    static IValidator createValidator(IConfigurationElement element, String validatorClassName) {
        IValidator validator = null;
        try {
            validator = (IValidator)element.createExecutableExtension("class");
        }
        catch (Exception e) {
            String result = MessageFormat.format(ResourceHandler.getExternalizedMessage("VBF_EXC_SYNTAX_NO_VAL_THROWABLE"), validatorClassName);
            ValidationPlugin.getPlugin().logMessage(4, result);
            ValidationPlugin.getPlugin().handleException(e);
        }
        if (validator == null) {
            if (Tracing.isTraceV1()) {
                Tracing.log("ValidationRegistryReader-02: ", NLS.bind((String)ValMessages.VbfExcSyntaxNoValNull, (Object)validatorClassName));
            }
            return null;
        }
        return validator;
    }

    private boolean getEnabledByDefault(IConfigurationElement element) {
        IConfigurationElement[] runChildren = element.getChildren("run");
        String inc = runChildren[0].getAttribute("enabled");
        if (inc == null) {
            return true;
        }
        return Boolean.valueOf(inc.trim().toLowerCase());
    }

    private boolean getIncremental(IConfigurationElement element) {
        IConfigurationElement[] runChildren = element.getChildren("run");
        String inc = runChildren[0].getAttribute("incremental");
        if (inc == null) {
            return true;
        }
        return Boolean.valueOf(inc.trim().toLowerCase());
    }

    private boolean getFullBuild(IConfigurationElement element) {
        IConfigurationElement[] runChildren = element.getChildren("run");
        String fb = runChildren[0].getAttribute("fullBuild");
        if (fb == null) {
            return true;
        }
        return Boolean.valueOf(fb.trim().toLowerCase());
    }

    private boolean getAsync(IConfigurationElement element) {
        IConfigurationElement[] runChildren = element.getChildren("run");
        String async = runChildren[0].getAttribute("async");
        if (async == null) {
            return false;
        }
        return Boolean.valueOf(async.trim().toLowerCase());
    }

    private int getRuleGroup(IConfigurationElement element) {
        IConfigurationElement[] runChildren = element.getChildren("run");
        String pass = runChildren[0].getAttribute("ruleGroup");
        if (pass == null) {
            return 1;
        }
        StringTokenizer tokenizer = new StringTokenizer(pass, ",", false);
        int result = 0;
        while (tokenizer.hasMoreTokens()) {
            String nextAction = tokenizer.nextToken().trim();
            if (nextAction.equals("fast")) {
                result |= 1;
                continue;
            }
            if (!nextAction.equals("full")) continue;
            result |= 3;
        }
        if (result == 0) {
            return 1;
        }
        return result;
    }

    private ValidatorMetaData.MigrationMetaData getMigrationMetaData(IConfigurationElement element) {
        IConfigurationElement[] runChildren = element.getChildren("migrate");
        if (runChildren == null || runChildren.length == 0) {
            return null;
        }
        IConfigurationElement migrate = runChildren[0];
        IConfigurationElement[] migrateChildren = migrate.getChildren("validator");
        if (migrateChildren == null || migrateChildren.length == 0) {
            return null;
        }
        ValidatorMetaData.MigrationMetaData mmd = new ValidatorMetaData.MigrationMetaData();
        int i = 0;
        while (i < migrateChildren.length) {
            String to;
            IConfigurationElement migrateChild = migrateChildren[i];
            String from = migrateChild.getAttribute("from");
            if (from != null && (to = migrateChild.getAttribute("to")) != null) {
                mmd.addId(from, to);
            }
            ++i;
        }
        return mmd;
    }

    private ValidatorNameFilter[] getProjectNatureFilters(IConfigurationElement element) {
        IConfigurationElement[] filters = element.getChildren("projectNature");
        if (filters.length == 0) {
            return null;
        }
        ValidatorNameFilter[] vf = new ValidatorNameFilter[filters.length];
        int i = 0;
        while (i < filters.length) {
            vf[i] = new ValidatorNameFilter();
            String nameFilter = filters[i].getAttribute("id");
            if (nameFilter != null) {
                nameFilter = nameFilter.intern();
            }
            vf[i].setNameFilter(nameFilter);
            String include = filters[i].getAttribute("include");
            vf[i].setInclude(include);
            ++i;
        }
        return vf;
    }

    public static ValidationRegistryReader getReader() {
        return _inst;
    }

    public static boolean isActivated() {
        return EventManager.getManager().isActive();
    }

    private IExtensionPoint getValidatorExtensionPoint() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.wst.validation", "validator");
        if (extensionPoint == null && Tracing.isTraceV1()) {
            String result = MessageFormat.format(ResourceHandler.getExternalizedMessage("VBF_EXC_MISSING_VALIDATOR_EP"), "org.eclipse.wst.validation.validator");
            Tracing.log("ValidationRegistryReader-03: ", result);
        }
        return extensionPoint;
    }

    public ValidatorMetaData getValidatorMetaData(IValidator validator) {
        if (validator == null) {
            String message = ResourceHandler.getExternalizedMessage("VBF_EXC_ORPHAN_IVALIDATOR", new String[]{"null"});
            ValidationPlugin.getPlugin().logMessage(4, message);
            return null;
        }
        String validatorClassName = validator.getClass().getName();
        ValidatorMetaData vmd = this.getValidatorMetaData(validatorClassName);
        if (vmd != null) {
            return vmd;
        }
        String message = ResourceHandler.getExternalizedMessage("VBF_EXC_ORPHAN_IVALIDATOR", new String[]{validatorClassName});
        ValidationPlugin.getPlugin().logMessage(4, message);
        return null;
    }

    public Set<ValidatorMetaData> getValidatorMetaData(IWorkspaceRoot root) {
        HashSet<ValidatorMetaData> copy = new HashSet<ValidatorMetaData>();
        this.clone(this._indexedValidators.values(), copy);
        return copy;
    }

    public Set<ValidatorMetaData> getValidatorMetaData(IProject project) {
        HashSet<ValidatorMetaData> copy = new HashSet<ValidatorMetaData>();
        this.getValidatorMetaData(project, copy);
        return copy;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getValidatorMetaData(IProject project, Set<ValidatorMetaData> vmds) {
        block14: {
            block15: {
                if (vmds == null) {
                    return;
                }
                vmds.clear();
                executionMap = 0;
                if (Tracing.isTraceV1()) {
                    Tracing.log("ValidationRegistryReader-04: IProject is " + String.valueOf(project));
                }
                if (project == null) {
                    executionMap |= 1;
                }
                projectNatures = null;
                try {
                    projectNatures = project.getDescription().getNatureIds();
                }
                catch (CoreException e) {
                    executionMap |= 2;
                    ValidationPlugin.getPlugin().handleException(e);
                }
                if (projectNatures != null && projectNatures.length != 0) break block15;
                executionMap |= 4;
                validatorsWithEnablementExpression = new HashSet<ValidatorMetaData>();
                var7_16 = this.getAllValidators().iterator();
                if (true) ** GOTO lbl51
            }
            executionMap |= 8;
            if (Tracing.isTraceV1()) {
                Tracing.log(new Object[]{"ValidationRegistryReader-05: ", projectNatures.toString()});
            }
            this.calculateVmdsForNatureAndFacets(vmds, projectNatures, project);
            this.removeExcludedProjects(project, vmds);
            if (vmds.size() == 0) {
                executionMap |= 32;
                this.clone(this.getValidatorMetaDataUnknownProject(), vmds);
            }
            finally {
                if (!Tracing.isTraceV1()) break block14;
                buffer = new StringBuffer();
                ** for (vmd : vmds)
            }
lbl-1000:
            // 1 sources

            {
                buffer.append(vmd.getValidatorUniqueName());
                buffer.append("\n");
                continue;
            }
lbl44:
            // 1 sources

            Tracing.log(new Object[]{"ValidationRegistryReader-06: ", buffer.toString()});
        }
        return;
        do {
            if (!this.isFacetEnabled(vmd = var7_16.next(), project)) continue;
            validatorsWithEnablementExpression.add(vmd);
lbl51:
            // 3 sources

        } while (var7_16.hasNext());
        if (validatorsWithEnablementExpression.size() > 0) {
            validatorsWithEnablementExpression.addAll(this.getValidatorMetaDataUnknownProject());
            this.clone(validatorsWithEnablementExpression, vmds);
        }
        this.clone(this.getValidatorMetaDataUnknownProject(), vmds);
    }

    private void calculateVmdsForNatureAndFacets(Set<ValidatorMetaData> vmds, String[] projectNatures, IProject project) {
        String[] projectFacetIds = this.getProjectFacetIds(project);
        for (ValidatorMetaData vmd : this.getAllValidators()) {
            if (!this.containsProjectFacet(vmd, projectFacetIds) && !this.isFacetEnabled(vmd, project)) continue;
            vmds.add(vmd);
        }
        String[] stringArray = projectNatures;
        int n = projectNatures.length;
        int n2 = 0;
        while (n2 < n) {
            String projectNatureId = stringArray[n2];
            Set<ValidatorMetaData> projVmds = this._validators.get(projectNatureId);
            if (projVmds != null) {
                for (ValidatorMetaData vmd : projVmds) {
                    if (vmds.contains(vmd) || vmd.getFacetFilters() != null && vmd.getFacetFilters().length != 0) continue;
                    if (vmd.getEnablementExpresion() == null) {
                        vmds.add(vmd);
                        continue;
                    }
                    if (!this.isFacetEnabled(vmd, project)) continue;
                    vmds.add(vmd);
                }
            }
            ++n2;
        }
    }

    private boolean containsProjectFacet(ValidatorMetaData vmd, String[] projectFacetIds) {
        String[] validatorFacets = vmd.getFacetFilters();
        return validatorFacets != null && validatorFacets.length > 0 && projectFacetIds != null && projectFacetIds.length > 0 && Arrays.asList(projectFacetIds).containsAll((Collection)Arrays.asList(validatorFacets));
    }

    private boolean isFacetEnabled(ValidatorMetaData vmd, IProject project) {
        try {
            Expression expression = vmd.getEnablementExpresion();
            if (expression != null) {
                EvaluationContext context = new EvaluationContext(null, (Object)project);
                context.setAllowPluginActivation(true);
                EvaluationResult result = expression.evaluate((IEvaluationContext)context);
                return result == EvaluationResult.TRUE;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    private String[] getProjectFacetIds(IProject project) {
        try {
            IFacetedProject fProject = ProjectFacetsManager.create((IProject)project);
            if (fProject != null) {
                Object[] projectFacets = fProject.getProjectFacets().toArray();
                String[] projectFacetIds = new String[projectFacets.length];
                int i = 0;
                while (i < projectFacets.length) {
                    IProjectFacet projectFacet = ((IProjectFacetVersion)projectFacets[i]).getProjectFacet();
                    projectFacetIds[i] = projectFacet.getId();
                    ++i;
                }
                return projectFacetIds;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    private void removeExcludedProjects(IProject project, Set<ValidatorMetaData> vmds) {
        if (Tracing.isTraceV1()) {
            StringBuffer buffer = new StringBuffer("\nValidationRegistryReader-12: before:\n");
            for (ValidatorMetaData vmd : vmds) {
                buffer.append(vmd.getValidatorUniqueName());
                buffer.append("\n");
            }
            Tracing.log(buffer);
        }
        String[] projectNatures = null;
        try {
            projectNatures = project.getDescription().getNatureIds();
        }
        catch (CoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
            return;
        }
        if (projectNatures == null || projectNatures.length == 0) {
            return;
        }
        int i = 0;
        while (i < projectNatures.length) {
            String nature = projectNatures[i];
            Iterator<ValidatorMetaData> iterator = vmds.iterator();
            block4: while (iterator.hasNext()) {
                ValidatorMetaData vmd = iterator.next();
                ValidatorNameFilter[] natureFilters = vmd.getProjectNatureFilters();
                if (natureFilters == null) continue;
                ValidatorNameFilter[] validatorNameFilterArray = natureFilters;
                int n = natureFilters.length;
                int n2 = 0;
                while (n2 < n) {
                    ValidatorNameFilter pn = validatorNameFilterArray[n2];
                    if (nature.equals(pn.getNameFilter()) && !pn.isInclude()) {
                        iterator.remove();
                        continue block4;
                    }
                    ++n2;
                }
            }
            ++i;
        }
        if (Tracing.isTraceV1()) {
            StringBuffer buffer = new StringBuffer("\nValidationRegistryReader-13: after:\n");
            for (ValidatorMetaData vmd : vmds) {
                buffer.append(vmd.getValidatorUniqueName());
                buffer.append("\n");
            }
            Tracing.log(buffer);
        }
    }

    private Collection clone(Collection input, Collection copy) {
        if (input == null || copy == null) {
            return null;
        }
        copy.clear();
        copy.addAll(input);
        return copy;
    }

    public String debug() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Project nature => validators configured");
        buffer.append("\n");
        for (String projId : this._validators.keySet()) {
            buffer.append("projId: ");
            buffer.append(projId);
            buffer.append("\n");
            Set<ValidatorMetaData> validators = this._validators.get(projId);
            for (ValidatorMetaData vmd : validators) {
                buffer.append("\t");
                buffer.append(vmd.getValidatorUniqueName());
                buffer.append("\n");
            }
        }
        buffer.append("\n");
        buffer.append("Enable/disable validator by default");
        buffer.append("\n");
        for (ValidatorMetaData vmd : this._indexedValidators.values()) {
            buffer.append(vmd.getValidatorUniqueName());
            buffer.append(" enabled? ");
            buffer.append(vmd.isEnabledByDefault());
            buffer.append("\n");
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConfiguredOnProject(ValidatorMetaData vmd, IProject project) {
        Set<ValidatorMetaData> vmds = null;
        HashMap<IProject, Set<ValidatorMetaData>> hashMap = this.projectValidationMetaData;
        synchronized (hashMap) {
            vmds = this.projectValidationMetaData.get(project);
        }
        if (vmds != null) {
            return vmds.contains(vmd);
        }
        Set<ValidatorMetaData> prjVmds = this.getValidatorMetaData(project);
        if (prjVmds == null || prjVmds.size() == 0) {
            return false;
        }
        HashMap<IProject, Set<ValidatorMetaData>> hashMap2 = this.projectValidationMetaData;
        synchronized (hashMap2) {
            this.projectValidationMetaData.put(project, prjVmds);
        }
        return prjVmds.contains(vmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCachedMaps() {
        HashMap<IProject, Set<ValidatorMetaData>> hashMap = this.projectValidationMetaData;
        synchronized (hashMap) {
            this.projectValidationMetaData.clear();
        }
    }

    private Set<ValidatorMetaData> getValidatorMetaDataUnknownProject() {
        Set<ValidatorMetaData> projVmds = this._validators.get(UNKNOWN_PROJECT);
        if (projVmds == null) {
            projVmds = new HashSet<ValidatorMetaData>();
        }
        return projVmds;
    }

    public Set<ValidatorMetaData> getValidatorMetaDataEnabledByDefault() {
        HashSet<ValidatorMetaData> copy = new HashSet<ValidatorMetaData>();
        this.clone(this._defaultEnabledValidators, copy);
        return copy;
    }

    public ValidatorMetaData[] getValidatorMetaDataArrayEnabledByDefault() {
        ValidatorMetaData[] result = new ValidatorMetaData[this._defaultEnabledValidators.size()];
        this._defaultEnabledValidators.toArray(result);
        return result;
    }

    public ValidatorMetaData getValidatorMetaData(String validatorClassName) {
        if (validatorClassName == null) {
            return null;
        }
        ValidatorMetaData vmd2 = this._indexedValidators.get(validatorClassName);
        if (vmd2 != null) {
            return vmd2;
        }
        for (ValidatorMetaData vmd : this._indexedValidators.values()) {
            Set<String[]> idList;
            ValidatorMetaData.MigrationMetaData mmd;
            if (vmd == null) continue;
            if (vmd.getValidatorUniqueName().equals(validatorClassName)) {
                return vmd;
            }
            String[] aggregateNames = vmd.getAggregatedValidatorNames();
            if (aggregateNames != null) {
                String[] stringArray = aggregateNames;
                int n = aggregateNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String aggregateName = stringArray[n2];
                    if (validatorClassName.equals(aggregateName)) {
                        return vmd;
                    }
                    ++n2;
                }
            }
            if ((mmd = vmd.getMigrationMetaData()) == null || (idList = mmd.getIds()) == null) continue;
            for (String[] ids : idList) {
                String from;
                if (ids.length != 2 || (from = ids[0]) == null || !from.equals(validatorClassName)) continue;
                return vmd;
            }
        }
        return null;
    }

    public boolean isExistingValidator(String validatorClassName) {
        return this.getValidatorMetaData(validatorClassName) != null;
    }

    private ValidatorMetaData initializeValidator(IConfigurationElement element, String validatorName, String pluginId) {
        IConfigurationElement[] runChildren = element.getChildren("run");
        if (runChildren == null || runChildren.length < 1) {
            if (Tracing.isLogging()) {
                Tracing.log("ValidationRegistryReader-07: ", NLS.bind((String)ValMessages.VbfExcSyntaxNoValRun, (Object)validatorName));
            }
            return null;
        }
        String validatorImplName = runChildren[0].getAttribute("class");
        if (validatorImplName == null) {
            if (Tracing.isLogging()) {
                Tracing.log("ValidationRegistryReader-08: ", NLS.bind((String)ValMessages.VbfExcSyntaxNoValClass, (Object)validatorName));
            }
            return null;
        }
        String helperImplName = this.getHelperName(element);
        if (helperImplName == null) {
            if (Tracing.isLogging()) {
                Tracing.log("ValidationRegistryReader-09: ", NLS.bind((String)ValMessages.VbfExcSyntaxNoValRun, (Object)validatorImplName));
            }
            return null;
        }
        boolean async = this.getAsync(element);
        String[] markerIds = this.initializeValidatorCustomMarkers(element, pluginId);
        ValidatorMetaData vmd = new ValidatorMetaData(async, this.getAggregateValidatorsNames(element), this.getEnabledByDefault(element), this.getIncremental(element), this.getFullBuild(element), element, helperImplName, this.getMigrationMetaData(element), pluginId, this.getRuleGroup(element), runChildren[0], validatorName.intern(), validatorImplName.intern(), this.getContentTypeBindings(element), this.getDependentValidatorValue(element), this.getEnablementElement(element), this.getFacetIds(element), this.getFilters(element), this.getProjectNatureFilters(element), markerIds, this.getRunStragety(element));
        if (Tracing.isTraceV1()) {
            Tracing.log("ValidationRegistryReader-10: validator loaded: " + validatorImplName);
        }
        return vmd;
    }

    private String[] initializeValidatorCustomMarkers(IConfigurationElement element, String pluginId) {
        String[] qualifiedMarkerIds = null;
        String[] customMarkerIds = this.getMarkerIdsValue(element);
        if (customMarkerIds != null && customMarkerIds.length > 0) {
            qualifiedMarkerIds = new String[customMarkerIds.length];
            int i = 0;
            while (i < customMarkerIds.length) {
                String pluginID;
                Bundle bundle;
                String markerid = customMarkerIds[i];
                qualifiedMarkerIds[i] = markerid.lastIndexOf(".") != -1 ? ((bundle = Platform.getBundle((String)(pluginID = markerid.substring(0, markerid.lastIndexOf("."))))) == null ? String.valueOf(pluginId) + "." + customMarkerIds[i] : customMarkerIds[i]) : String.valueOf(pluginId) + "." + customMarkerIds[i];
                ++i;
            }
        }
        return qualifiedMarkerIds;
    }

    private Expression getEnablementElement(IConfigurationElement element) {
        IConfigurationElement[] enablements = element.getChildren("enablement");
        if (enablements.length == 0) {
            return null;
        }
        try {
            return ExpressionConverter.getDefault().perform(enablements[0]);
        }
        catch (CoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
            return null;
        }
    }

    public Collection<ValidatorMetaData> getAllValidators() {
        HashSet<ValidatorMetaData> validators = new HashSet<ValidatorMetaData>(50);
        this.clone(this._indexedValidators.values(), validators);
        return validators;
    }

    public int numberOfValidators() {
        return this._indexedValidators.size();
    }

    private void readExtension(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            String label = extension.getLabel();
            if (label == null || label.equals("")) {
                if (Tracing.isTraceV1()) {
                    Object[] msgParm = new String[]{extension.getUniqueIdentifier()};
                    String result = MessageFormat.format(ResourceHandler.getExternalizedMessage("VBF_EXC_VALIDATORNAME_IS_NULL"), msgParm);
                    Tracing.log("ValidationRegistryReader-11: ", result);
                }
            } else {
                ValidatorMetaData vmd;
                String pluginId = extension.getContributor().getName();
                if (Tracing.isEnabled(extension.getUniqueIdentifier()) && (vmd = this.initializeValidator(element, label, pluginId)) != null) {
                    this.add(vmd);
                }
            }
            ++i;
        }
    }

    private void readRegistry() {
        this._validators.clear();
        IExtensionPoint validatorEP = this.getValidatorExtensionPoint();
        if (validatorEP == null) {
            return;
        }
        IExtension[] extensions = validatorEP.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            this.readExtension(extensions[i]);
            ++i;
        }
        ValidatorDelegatesRegistry.getInstance();
    }

    public IValidator getValidator(String validatorClassName) throws InstantiationException {
        ValidatorMetaData vmd = this._indexedValidators.get(validatorClassName);
        if (vmd != null) {
            return vmd.getValidator();
        }
        return null;
    }

    private boolean getRunStragety(IConfigurationElement element) {
        IConfigurationElement[] runChildren = element.getChildren("runStrategy");
        if (runChildren == null || runChildren.length < 1) {
            return false;
        }
        String project = runChildren[0].getAttribute("project");
        if (project == null) {
            return false;
        }
        return Boolean.valueOf(project.trim());
    }
}

