/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IFunctionContainer;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaScriptConventions;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.JavaScriptRefactoringDescriptor;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.RenameJavaScriptElementDescriptor;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.MethodDeclarationMatch;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.delegates.DelegateMethodCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.MethodOccurenceCollector;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameAnalyzeUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IDelegateUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.SearchUtils;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;

public abstract class RenameMethodProcessor
extends JavaRenameProcessor
implements IReferenceUpdating,
IDelegateUpdating {
    private static final String ATTRIBUTE_DELEGATE = "delegate";
    private static final String ATTRIBUTE_DEPRECATE = "deprecate";
    private SearchResultGroup[] fOccurrences;
    private boolean fUpdateReferences;
    private IFunction fMethod;
    private Set fMethodsToRename;
    private TextChangeManager fChangeManager;
    private WorkingCopyOwner fWorkingCopyOwner;
    private boolean fIsComposite;
    private GroupCategorySet fCategorySet;
    private boolean fDelegateUpdating;
    private boolean fDelegateDeprecation;
    protected boolean fInitialized = false;
    public static final String IDENTIFIER = "org.eclipse.wst.jsdt.ui.renameMethodProcessor";

    protected RenameMethodProcessor(IFunction method) {
        this(method, new TextChangeManager(true), null);
        this.fIsComposite = false;
    }

    protected RenameMethodProcessor(IFunction method, TextChangeManager manager, GroupCategorySet categorySet) {
        this.initialize(method);
        this.fChangeManager = manager;
        this.fCategorySet = categorySet;
        this.fDelegateUpdating = false;
        this.fDelegateDeprecation = true;
        this.fIsComposite = true;
    }

    protected void initialize(IFunction method) {
        this.fMethod = method;
        if (!this.fInitialized) {
            if (method != null) {
                this.setNewElementName(method.getElementName());
            }
            this.fUpdateReferences = true;
            this.initializeWorkingCopyOwner();
        }
    }

    protected void initializeWorkingCopyOwner() {
        this.fWorkingCopyOwner = new WorkingCopyOwner(){};
    }

    protected void setData(RenameMethodProcessor other) {
        this.fUpdateReferences = other.fUpdateReferences;
        this.setNewElementName(other.getNewElementName());
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fMethod);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameMethodRefactoring_name;
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaScriptElement)this.fMethod);
    }

    public Object[] getElements() {
        return new Object[]{this.fMethod};
    }

    protected RenameModifications computeRenameModifications() throws CoreException {
        RenameModifications result = new RenameModifications();
        RenameArguments args = new RenameArguments(this.getNewElementName(), this.getUpdateReferences());
        Iterator iter = this.fMethodsToRename.iterator();
        while (iter.hasNext()) {
            IFunction method = (IFunction)iter.next();
            result.rename(method, args);
        }
        return result;
    }

    protected IFile[] getChangedFiles() throws CoreException {
        return ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
    }

    public int getSaveMode() {
        return 3;
    }

    public final String getCurrentElementName() {
        return this.fMethod.getElementName();
    }

    public final RefactoringStatus checkNewElementName(String newName) {
        Assert.isNotNull((Object)newName, (String)"new name");
        RefactoringStatus status = Checks.checkName(newName, JavaScriptConventions.validateFunctionName((String)newName));
        if (status.isOK() && Checks.startsWithUpperCase(newName)) {
            status = RefactoringStatus.createWarningStatus((String)(this.fIsComposite ? Messages.format(RefactoringCoreMessages.Checks_method_names_lowercase2, new String[]{newName, this.fMethod.getDeclaringType().getElementName()}) : RefactoringCoreMessages.Checks_method_names_lowercase));
        }
        if (Checks.isAlreadyNamed((IJavaScriptElement)this.fMethod, newName)) {
            status.addFatalError(this.fIsComposite ? Messages.format(RefactoringCoreMessages.RenameMethodRefactoring_same_name2, new String[]{newName, this.fMethod.getDeclaringType().getElementName()}) : RefactoringCoreMessages.RenameMethodRefactoring_same_name, JavaStatusContext.create((IMember)this.fMethod));
        }
        return status;
    }

    public Object getNewElement() {
        if (this.fMethod.getDeclaringType() != null) {
            return this.fMethod.getDeclaringType().getFunction(this.getNewElementName(), this.fMethod.getParameterTypes());
        }
        return this.fMethod.getJavaScriptUnit().getFunction(this.getNewElementName(), this.fMethod.getParameterTypes());
    }

    public final IFunction getMethod() {
        return this.fMethod;
    }

    private void initializeMethodsToRename(IProgressMonitor pm) throws CoreException {
        if (this.fMethodsToRename == null) {
            this.fMethodsToRename = new HashSet<IFunction>(Arrays.asList(MethodChecks.getOverriddenMethods(this.getMethod(), pm)));
        }
    }

    protected void setMethodsToRename(IFunction[] methods) {
        this.fMethodsToRename = new HashSet<IFunction>(Arrays.asList(methods));
    }

    protected Set getMethodsToRename() {
        return this.fMethodsToRename;
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public final void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public boolean canEnableDelegateUpdating() {
        return true;
    }

    public boolean getDelegateUpdating() {
        return this.fDelegateUpdating;
    }

    public void setDelegateUpdating(boolean updating) {
        this.fDelegateUpdating = updating;
    }

    public boolean getDeprecateDelegates() {
        return this.fDelegateDeprecation;
    }

    public void setDeprecateDelegates(boolean deprecate) {
        this.fDelegateDeprecation = deprecate;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        if (!this.fMethod.exists()) {
            String message = Messages.format(RefactoringCoreMessages.RenameMethodRefactoring_deleted, this.fMethod.getJavaScriptUnit().getElementName());
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        RefactoringStatus result = Checks.checkAvailability((IJavaScriptElement)this.fMethod);
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(Checks.checkIfCuBroken((IMember)this.fMethod));
        if (JdtFlags.isNative((IMember)this.fMethod)) {
            result.addError(RefactoringCoreMessages.RenameMethodRefactoring_no_native);
        }
        return result;
    }

    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        boolean mustAnalyzeShadowing;
        RefactoringStatus result;
        block14: {
            block13: {
                block12: {
                    block11: {
                        RefactoringStatus refactoringStatus;
                        try {
                            result = new RefactoringStatus();
                            pm.beginTask("", 9);
                            if (Checks.isAvailable((IJavaScriptElement)this.fMethod)) break block11;
                            result.addFatalError(RefactoringCoreMessages.RenameMethodProcessor_is_binary, JavaStatusContext.create((IMember)this.fMethod));
                            refactoringStatus = result;
                            Object var8_9 = null;
                        }
                        catch (Throwable throwable) {
                            Object var8_14 = null;
                            pm.done();
                            throw throwable;
                        }
                        pm.done();
                        return refactoringStatus;
                    }
                    result.merge(Checks.checkIfCuBroken((IMember)this.fMethod));
                    if (!result.hasFatalError()) break block12;
                    RefactoringStatus refactoringStatus = result;
                    Object var8_10 = null;
                    pm.done();
                    return refactoringStatus;
                }
                pm.setTaskName(RefactoringCoreMessages.RenameMethodRefactoring_taskName_checkingPreconditions);
                result.merge(this.checkNewElementName(this.getNewElementName()));
                if (!result.hasFatalError()) break block13;
                RefactoringStatus refactoringStatus = result;
                Object var8_11 = null;
                pm.done();
                return refactoringStatus;
            }
            IFunction[] newNameMethods = this.searchForDeclarationsOfClashingMethods((IProgressMonitor)new SubProgressMonitor(pm, 1));
            if (newNameMethods.length == 0) {
                mustAnalyzeShadowing = false;
                pm.worked(1);
            } else {
                boolean hasOldRefsInInnerTypes;
                IType[] outerTypes = this.searchForOuterTypesOfReferences(newNameMethods, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                mustAnalyzeShadowing = outerTypes.length > 0 ? true : (hasOldRefsInInnerTypes = true);
            }
            this.initializeMethodsToRename((IProgressMonitor)new SubProgressMonitor(pm, 1));
            pm.setTaskName(RefactoringCoreMessages.RenameMethodRefactoring_taskName_searchingForReferences);
            this.fOccurrences = this.getOccurrences((IProgressMonitor)new SubProgressMonitor(pm, 3), result);
            pm.setTaskName(RefactoringCoreMessages.RenameMethodRefactoring_taskName_checkingPreconditions);
            if (this.fUpdateReferences) {
                result.merge(this.checkRelatedMethods());
            }
            result.merge(this.analyzeCompilationUnits());
            pm.worked(1);
            if (!result.hasFatalError()) break block14;
            RefactoringStatus refactoringStatus = result;
            Object var8_12 = null;
            pm.done();
            return refactoringStatus;
        }
        this.createChanges((IProgressMonitor)new SubProgressMonitor(pm, 1), result);
        if (this.fUpdateReferences & mustAnalyzeShadowing) {
            result.merge(this.analyzeRenameChanges((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        } else {
            pm.worked(1);
        }
        RefactoringStatus refactoringStatus = result;
        Object var8_13 = null;
        pm.done();
        return refactoringStatus;
    }

    private IType[] searchForOuterTypesOfReferences(IFunction[] newNameMethods, IProgressMonitor pm) throws CoreException {
        final HashSet outerTypesOfReferences = new HashSet();
        SearchPattern pattern = RefactoringSearchEngine.createOrPattern((IJavaScriptElement[])newNameMethods, 2);
        IJavaScriptSearchScope scope = RenameMethodProcessor.createRefactoringScope(this.getMethod());
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                IMember member = (IMember)match.getElement();
                IType declaring = member.getDeclaringType();
                if (declaring == null) {
                    return;
                }
                IType outer = declaring.getDeclaringType();
                if (outer != null) {
                    outerTypesOfReferences.add(declaring);
                }
            }
        };
        new SearchEngine().search(pattern, SearchUtils.getDefaultSearchParticipants(), scope, requestor, pm);
        return outerTypesOfReferences.toArray(new IType[outerTypesOfReferences.size()]);
    }

    private IFunction[] searchForDeclarationsOfClashingMethods(IProgressMonitor pm) throws CoreException {
        final ArrayList results = new ArrayList();
        SearchPattern pattern = this.createNewMethodPattern();
        IJavaScriptSearchScope scope = RefactoringScopeFactory.create((IJavaScriptElement)this.getMethod().getJavaScriptProject());
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                Object method = match.getElement();
                if (method instanceof IFunction) {
                    results.add(method);
                } else {
                    JavaScriptPlugin.logErrorMessage("Unexpected element in search match: " + match.toString());
                }
            }
        };
        new SearchEngine().search(pattern, SearchUtils.getDefaultSearchParticipants(), scope, requestor, pm);
        return results.toArray(new IFunction[results.size()]);
    }

    private SearchPattern createNewMethodPattern() throws JavaScriptModelException {
        StringBuffer stringPattern = new StringBuffer(this.getNewElementName()).append('(');
        int paramCount = this.getMethod().getNumberOfParameters();
        int i = 0;
        while (i < paramCount) {
            if (i > 0) {
                stringPattern.append(',');
            }
            stringPattern.append('*');
            ++i;
        }
        stringPattern.append(')');
        return SearchPattern.createPattern((String)stringPattern.toString(), (int)13, (int)0, (int)24);
    }

    protected final IJavaScriptSearchScope createRefactoringScope() throws CoreException {
        return RenameMethodProcessor.createRefactoringScope(this.fMethod);
    }

    protected static final IJavaScriptSearchScope createRefactoringScope(IFunction method) throws CoreException {
        return RefactoringScopeFactory.create((IJavaScriptElement)method);
    }

    SearchPattern createOccurrenceSearchPattern() {
        HashSet<IFunction> methods = new HashSet<IFunction>(this.fMethodsToRename);
        methods.add(this.fMethod);
        IFunction[] ms = methods.toArray(new IFunction[methods.size()]);
        return RefactoringSearchEngine.createOrPattern((IJavaScriptElement[])ms, 3);
    }

    SearchResultGroup[] getOccurrences() {
        return this.fOccurrences;
    }

    protected SearchResultGroup[] getOccurrences(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        SearchPattern pattern = this.createOccurrenceSearchPattern();
        return RefactoringSearchEngine.search(pattern, this.createRefactoringScope(), new MethodOccurenceCollector(this.getMethod().getElementName()), pm, status);
    }

    private RefactoringStatus checkRelatedMethods() throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        Iterator iter = this.fMethodsToRename.iterator();
        while (iter.hasNext()) {
            IFunction method = (IFunction)iter.next();
            if (method.getDeclaringType() != null) {
                result.merge(Checks.checkIfConstructorName(method, this.getNewElementName(), method.getDeclaringType().getElementName()));
            }
            Object[] msgData = new String[]{method.getElementName(), method.getJavaScriptUnit().getElementName()};
            if (!method.exists()) {
                result.addFatalError(Messages.format(RefactoringCoreMessages.RenameMethodRefactoring_not_in_model, msgData));
                continue;
            }
            if (method.isBinary()) {
                result.addFatalError(Messages.format(RefactoringCoreMessages.RenameMethodRefactoring_no_binary, msgData));
            }
            if (method.isReadOnly()) {
                result.addFatalError(Messages.format(RefactoringCoreMessages.RenameMethodRefactoring_no_read_only, msgData));
            }
            if (!JdtFlags.isNative((IMember)method)) continue;
            result.addError(Messages.format(RefactoringCoreMessages.RenameMethodRefactoring_no_native_1, msgData));
        }
        return result;
    }

    private RefactoringStatus analyzeCompilationUnits() throws CoreException {
        if (this.fOccurrences.length == 0) {
            return null;
        }
        RefactoringStatus result = new RefactoringStatus();
        this.fOccurrences = Checks.excludeCompilationUnits(this.fOccurrences, result);
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(Checks.checkCompileErrorsInAffectedFiles(this.fOccurrences));
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RefactoringStatus analyzeRenameChanges(IProgressMonitor pm) throws CoreException {
        int i3;
        Throwable throwable2;
        IJavaScriptUnit[] newDeclarationWCs;
        block10: {
            RefactoringStatus refactoringStatus;
            newDeclarationWCs = null;
            try {
                pm.beginTask("", 4);
                RefactoringStatus result = new RefactoringStatus();
                IJavaScriptUnit[] declarationCUs = this.getDeclarationCUs();
                newDeclarationWCs = RenameAnalyzeUtil.createNewWorkingCopies(declarationCUs, this.fChangeManager, this.fWorkingCopyOwner, new SubProgressMonitor(pm, 1));
                IFunction[] wcOldMethods = new IFunction[this.fMethodsToRename.size()];
                IFunction[] wcNewMethods = new IFunction[this.fMethodsToRename.size()];
                int i2 = 0;
                Iterator iter = this.fMethodsToRename.iterator();
                while (true) {
                    if (!iter.hasNext()) {
                        SearchResultGroup[] newOccurrences = this.batchFindNewOccurrences(wcNewMethods, wcOldMethods, newDeclarationWCs, (IProgressMonitor)new SubProgressMonitor(pm, 3), result);
                        result.merge(RenameAnalyzeUtil.analyzeRenameChanges2(this.fChangeManager, this.fOccurrences, newOccurrences, this.getNewElementName()));
                        refactoringStatus = result;
                        Object var12_13 = null;
                        break;
                    }
                    IFunction method = (IFunction)iter.next();
                    IJavaScriptUnit newCu = RenameAnalyzeUtil.findWorkingCopyForCu(newDeclarationWCs, method.getJavaScriptUnit());
                    IFunctionContainer typeWc = (IFunctionContainer)JavaModelUtil.findInCompilationUnit(newCu, method.getParent());
                    if (typeWc != null) {
                        wcOldMethods[i2] = this.getMethodInWorkingCopy(method, this.getCurrentElementName(), typeWc);
                        wcNewMethods[i2] = this.getMethodInWorkingCopy(method, this.getNewElementName(), typeWc);
                    }
                    ++i2;
                }
            }
            catch (Throwable throwable2) {
                Object var12_14 = null;
                pm.done();
                if (newDeclarationWCs == null) throw throwable2;
                i3 = 0;
                break block10;
            }
            pm.done();
            if (newDeclarationWCs == null) return refactoringStatus;
            int i3 = 0;
            while (true) {
                if (i3 >= newDeclarationWCs.length) {
                    return refactoringStatus;
                }
                newDeclarationWCs[i3].discardWorkingCopy();
                ++i3;
            }
        }
        while (true) {
            if (i3 >= newDeclarationWCs.length) {
                throw throwable2;
            }
            newDeclarationWCs[i3].discardWorkingCopy();
            ++i3;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SearchResultGroup[] batchFindNewOccurrences(IFunction[] wcNewMethods, final IFunction[] wcOldMethods, IJavaScriptUnit[] newDeclarationWCs, IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        pm.beginTask("", 2);
        refsPattern = RefactoringSearchEngine.createOrPattern((IJavaScriptElement[])wcNewMethods, 2);
        searchParticipants = SearchUtils.getDefaultSearchParticipants();
        scope = RefactoringScopeFactory.create((IMember[])wcNewMethods);
        requestor = this.getDelegateUpdating() != false ? new MethodOccurenceCollector(this.getNewElementName()){

            public void acceptSearchMatch(IJavaScriptUnit unit, SearchMatch match) throws CoreException {
                int i = 0;
                while (i < wcOldMethods.length) {
                    if (wcOldMethods[i].equals(match.getElement())) {
                        return;
                    }
                    ++i;
                }
                super.acceptSearchMatch(unit, match);
            }
        } : new MethodOccurenceCollector(this.getNewElementName());
        searchEngine = new SearchEngine(this.fWorkingCopyOwner);
        needWCs = new ArrayList<IJavaScriptUnit>();
        declaringCUs = new HashSet<IJavaScriptUnit>(newDeclarationWCs.length);
        i = 0;
        while (true) {
            if (i >= newDeclarationWCs.length) break;
            declaringCUs.add(newDeclarationWCs[i].getPrimary());
            ++i;
        }
        i = 0;
        while (true) {
            if (i >= this.fOccurrences.length) {
                otherWCs = null;
                ** try [egrp 0[TRYBLOCK] [0 : 186->251)] { 
lbl21:
                // 1 sources

                break;
            }
            cu = this.fOccurrences[i].getCompilationUnit();
            if (!declaringCUs.contains(cu)) {
                needWCs.add(cu);
            }
            ++i;
        }
        {
            otherWCs = RenameAnalyzeUtil.createNewWorkingCopies(needWCs.toArray(new IJavaScriptUnit[needWCs.size()]), this.fChangeManager, this.fWorkingCopyOwner, new SubProgressMonitor(pm, 1));
            searchEngine.search(refsPattern, searchParticipants, scope, (SearchRequestor)requestor, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            ** GOTO lbl-1000
        }
lbl31:
        // 1 sources

        catch (Throwable var15_16) {
            cu = null;
            pm.done();
            if (otherWCs == null) throw var15_16;
            i = 0;
        }
        while (i < otherWCs.length) {
            otherWCs[i].discardWorkingCopy();
            ++i;
        }
        throw var15_16;
lbl-1000:
        // 1 sources

        {
            cu = null;
        }
        pm.done();
        if (otherWCs == null) return RefactoringSearchEngine.groupByCu(requestor.getResults(), status);
        i = 0;
        while (i < otherWCs.length) {
            otherWCs[i].discardWorkingCopy();
            ++i;
        }
        return RefactoringSearchEngine.groupByCu(requestor.getResults(), status);
    }

    private IJavaScriptUnit[] getDeclarationCUs() {
        HashSet<IJavaScriptUnit> cus = new HashSet<IJavaScriptUnit>();
        Iterator iter = this.fMethodsToRename.iterator();
        while (iter.hasNext()) {
            IFunction method = (IFunction)iter.next();
            cus.add(method.getJavaScriptUnit());
        }
        return cus.toArray(new IJavaScriptUnit[cus.size()]);
    }

    private IFunction getMethodInWorkingCopy(IFunction method, String elementName, IFunctionContainer typeWc) throws CoreException {
        String[] paramTypeSignatures = method.getParameterTypes();
        return typeWc.getFunction(elementName, paramTypeSignatures);
    }

    private static IFunction[] classesDeclareMethodName(ITypeHierarchy hier, List classes, IFunction method, String newName) throws CoreException {
        HashSet<IFunction> result = new HashSet<IFunction>();
        IType type = method.getDeclaringType();
        List<IType> subtypes = Arrays.asList(hier.getAllSubtypes(type));
        int parameterCount = method.getParameterTypes().length;
        boolean isMethodPrivate = JdtFlags.isPrivate((IMember)method);
        Iterator iter = classes.iterator();
        while (iter.hasNext()) {
            IType clazz = (IType)iter.next();
            IFunction[] methods = clazz.getFunctions();
            boolean isSubclass = subtypes.contains(clazz);
            int j = 0;
            while (j < methods.length) {
                IFunction foundMethod = Checks.findMethod(newName, parameterCount, false, new IFunction[]{methods[j]});
                if (foundMethod != null) {
                    if (isSubclass || type.equals(clazz)) {
                        result.add(foundMethod);
                    } else if (!isMethodPrivate && !JdtFlags.isPrivate((IMember)methods[j])) {
                        result.add(foundMethod);
                    }
                }
                ++j;
            }
        }
        return result.toArray(new IFunction[result.size()]);
    }

    static final IFunction[] hierarchyDeclaresMethodName(IProgressMonitor pm, ITypeHierarchy hierarchy, IFunction method, String newName) throws CoreException {
        IType[] implementingClasses;
        IFunction[] foundInImplementingClasses;
        IFunction[] foundInHierarchyClasses;
        HashSet<IFunction> result = new HashSet<IFunction>();
        IType type = method.getDeclaringType();
        IFunction foundMethod = Checks.findMethod(newName, method.getParameterTypes().length, false, type);
        if (foundMethod != null) {
            result.add(foundMethod);
        }
        if ((foundInHierarchyClasses = RenameMethodProcessor.classesDeclareMethodName(hierarchy, Arrays.asList(hierarchy.getAllClasses()), method, newName)) != null) {
            result.addAll(Arrays.asList(foundInHierarchyClasses));
        }
        if ((foundInImplementingClasses = RenameMethodProcessor.classesDeclareMethodName(hierarchy, Arrays.asList(implementingClasses = hierarchy.getImplementingClasses(type)), method, newName)) != null) {
            result.addAll(Arrays.asList(foundInImplementingClasses));
        }
        return result.toArray(new IFunction[result.size()]);
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        DynamicValidationRefactoringChange dynamicValidationRefactoringChange;
        try {
            TextChange[] changes = this.fChangeManager.getAllChanges();
            ArrayList<TextChange> list = new ArrayList<TextChange>(changes.length);
            list.addAll(Arrays.asList(changes));
            String project = null;
            IJavaScriptProject javaProject = this.fMethod.getJavaScriptProject();
            if (javaProject != null) {
                project = javaProject.getElementName();
            }
            int flags = 589826;
            try {
                if (!Flags.isPrivate((int)this.fMethod.getFlags())) {
                    flags |= 4;
                }
            }
            catch (JavaScriptModelException exception) {
                JavaScriptPlugin.log(exception);
            }
            IType declaring = this.fMethod.getDeclaringType();
            try {
                if (declaring != null && (declaring.isAnonymous() || declaring.isLocal())) {
                    flags |= 0x40000;
                }
            }
            catch (JavaScriptModelException exception) {
                JavaScriptPlugin.log(exception);
            }
            String description = Messages.format(RefactoringCoreMessages.RenameMethodProcessor_descriptor_description_short, this.fMethod.getElementName());
            String header = Messages.format(RefactoringCoreMessages.RenameMethodProcessor_descriptor_description, new String[]{JavaScriptElementLabels.getTextLabel(this.fMethod, JavaScriptElementLabels.ALL_FULLY_QUALIFIED), this.getNewElementName()});
            String comment = new JDTRefactoringDescriptorComment(project, this, header).asString();
            RenameJavaScriptElementDescriptor descriptor = new RenameJavaScriptElementDescriptor("org.eclipse.wst.jsdt.ui.rename.method");
            descriptor.setProject(project);
            descriptor.setDescription(description);
            descriptor.setComment(comment);
            descriptor.setFlags(flags);
            descriptor.setJavaElement((IJavaScriptElement)this.fMethod);
            descriptor.setNewName(this.getNewElementName());
            descriptor.setUpdateReferences(this.fUpdateReferences);
            descriptor.setKeepOriginal(this.fDelegateUpdating);
            descriptor.setDeprecateDelegate(this.fDelegateDeprecation);
            dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange((JavaScriptRefactoringDescriptor)descriptor, RefactoringCoreMessages.RenameMethodProcessor_change_name, list.toArray(new Change[list.size()]));
            Object var12_15 = null;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return dynamicValidationRefactoringChange;
    }

    private TextChangeManager createChanges(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        if (!this.fIsComposite) {
            this.fChangeManager.clear();
        }
        this.addOccurrences(this.fChangeManager, pm, status);
        return this.fChangeManager;
    }

    void addOccurrences(TextChangeManager manager, IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        pm.beginTask("", this.fOccurrences.length);
        int i = 0;
        while (i < this.fOccurrences.length) {
            IJavaScriptUnit cu = this.fOccurrences[i].getCompilationUnit();
            if (cu != null) {
                SearchMatch element;
                SearchMatch[] results = this.fOccurrences[i].getSearchResults();
                ArrayList<SearchMatch> declarationsInThisCu = new ArrayList<SearchMatch>();
                ArrayList<SearchMatch> referencesInThisCu = new ArrayList<SearchMatch>();
                int j = 0;
                while (j < results.length) {
                    if (results[j] instanceof MethodDeclarationMatch) {
                        declarationsInThisCu.add(results[j]);
                    } else {
                        referencesInThisCu.add(results[j]);
                    }
                    ++j;
                }
                if (declarationsInThisCu.size() > 0) {
                    if (this.fDelegateUpdating) {
                        CompilationUnitRewrite rewrite = new CompilationUnitRewrite(cu);
                        rewrite.setResolveBindings(true);
                        Iterator iter = declarationsInThisCu.iterator();
                        while (iter.hasNext()) {
                            SearchMatch element2 = (SearchMatch)iter.next();
                            FunctionDeclaration method = ASTNodeSearchUtil.getMethodDeclarationNode((IFunction)element2.getElement(), rewrite.getRoot());
                            DelegateMethodCreator creator = new DelegateMethodCreator();
                            creator.setDeclareDeprecated(this.fDelegateDeprecation);
                            creator.setDeclaration((BodyDeclaration)method);
                            creator.setSourceRewrite(rewrite);
                            creator.setNewElementName(this.getNewElementName());
                            creator.prepareDelegate();
                            creator.createEdit();
                        }
                        CompilationUnitChange changeForThisCu = rewrite.createChange();
                        changeForThisCu.setKeepPreviewEdits(true);
                        manager.manage(cu, (TextChange)changeForThisCu);
                    }
                    Iterator iter = declarationsInThisCu.iterator();
                    while (iter.hasNext()) {
                        element = (SearchMatch)iter.next();
                        this.simpleUpdate(element, cu, manager.get(cu));
                    }
                }
                if (this.fUpdateReferences) {
                    Iterator iter = referencesInThisCu.iterator();
                    while (iter.hasNext()) {
                        element = (SearchMatch)iter.next();
                        this.simpleUpdate(element, cu, manager.get(cu));
                    }
                }
                pm.worked(1);
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
            }
            ++i;
        }
        pm.done();
    }

    private void simpleUpdate(SearchMatch element, IJavaScriptUnit cu, TextChange textChange) {
        String editName = RefactoringCoreMessages.RenameMethodRefactoring_update_occurrence;
        ReplaceEdit replaceEdit = this.createReplaceEdit(element, cu);
        this.addTextEdit(textChange, editName, replaceEdit);
    }

    protected final ReplaceEdit createReplaceEdit(SearchMatch searchResult, IJavaScriptUnit cu) {
        if (searchResult.isImplicit()) {
            StringBuffer sb = new StringBuffer(this.getNewElementName());
            if ("insert".equals(cu.getJavaScriptProject().getOption("org.eclipse.wst.jsdt.core.formatter.insert_space_before_assignment_operator", true))) {
                sb.append(' ');
            }
            sb.append('=');
            if ("insert".equals(cu.getJavaScriptProject().getOption("org.eclipse.wst.jsdt.core.formatter.insert_space_after_assignment_operator", true))) {
                sb.append(' ');
            }
            return new ReplaceEdit(searchResult.getOffset(), 0, sb.toString());
        }
        return new ReplaceEdit(searchResult.getOffset(), searchResult.getLength(), this.getNewElementName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RefactoringStatus initialize(RefactoringArguments arguments) {
        if (!(arguments instanceof JavaRefactoringArguments)) return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        this.fInitialized = true;
        JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
        String handle = extended.getAttribute("input");
        if (handle == null) return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        IJavaScriptElement element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
        String refactoring = this.getRefactoring().getName();
        if (!(element instanceof IFunction)) return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        IFunction method = (IFunction)element;
        IType declaring = method.getDeclaringType();
        if (declaring != null && declaring.exists()) {
            IFunction[] methods = declaring.findMethods(method);
            if (methods == null || methods.length != 1 || methods[0] == null) return ScriptableRefactoring.createInputFatalStatus(null, refactoring, "org.eclipse.wst.jsdt.ui.rename.method");
            if (!methods[0].exists()) {
                return ScriptableRefactoring.createInputFatalStatus(methods[0], refactoring, "org.eclipse.wst.jsdt.ui.rename.method");
            }
            this.fMethod = methods[0];
            this.initializeWorkingCopyOwner();
        } else {
            IJavaScriptUnit unit = method.getJavaScriptUnit();
            if (unit == null || !unit.exists()) return ScriptableRefactoring.createInputFatalStatus(element, refactoring, "org.eclipse.wst.jsdt.ui.rename.method");
            IFunction[] methods = unit.findFunctions(method);
            if (methods == null || methods.length != 1 || methods[0] == null) return ScriptableRefactoring.createInputFatalStatus(null, refactoring, "org.eclipse.wst.jsdt.ui.rename.method");
            if (!methods[0].exists()) {
                return ScriptableRefactoring.createInputFatalStatus(methods[0], refactoring, "org.eclipse.wst.jsdt.ui.rename.method");
            }
            this.fMethod = methods[0];
            this.initializeWorkingCopyOwner();
        }
        String name = extended.getAttribute("name");
        if (name == null || "".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
        }
        this.setNewElementName(name);
        String references = extended.getAttribute("references");
        if (references == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "references"));
        }
        this.fUpdateReferences = Boolean.valueOf(references);
        String delegate = extended.getAttribute(ATTRIBUTE_DELEGATE);
        if (delegate == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_DELEGATE));
        }
        this.fDelegateUpdating = Boolean.valueOf(delegate);
        String deprecate = extended.getAttribute(ATTRIBUTE_DEPRECATE);
        if (deprecate == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_DEPRECATE));
        }
        this.fDelegateDeprecation = Boolean.valueOf(deprecate);
        return new RefactoringStatus();
    }

    protected void addTextEdit(TextChange change, String editName, ReplaceEdit replaceEdit) {
        if (this.fIsComposite) {
            TextChangeCompatibility.addTextEdit(change, editName, (TextEdit)replaceEdit, this.fCategorySet);
        } else {
            TextChangeCompatibility.addTextEdit(change, editName, (TextEdit)replaceEdit);
        }
    }
}

