/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.java.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslationExtension;
import org.eclipse.jst.jsp.core.internal.java.search.JSPSearchSupport;
import org.eclipse.jst.jsp.core.internal.java.search.JavaSearchDocumentDelegate;

public class BasicJSPSearchRequestor
extends SearchRequestor {
    private static final boolean DEBUG;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/jspsearch");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public void acceptSearchMatch(SearchMatch match) throws CoreException {
        if (JSPSearchSupport.getInstance().isCanceled()) {
            return;
        }
        String matchDocumentPath = match.getResource().getFullPath().toString();
        SearchDocument searchDoc = JSPSearchSupport.getInstance().getSearchDocument(matchDocumentPath);
        if (searchDoc != null && searchDoc instanceof JavaSearchDocumentDelegate) {
            JavaSearchDocumentDelegate javaSearchDoc = (JavaSearchDocumentDelegate)searchDoc;
            int jspStart = javaSearchDoc.getJspOffset(match.getOffset());
            int jspEnd = javaSearchDoc.getJspOffset(match.getOffset() + match.getLength());
            JSPTranslationExtension trans = javaSearchDoc.getJspTranslation();
            String jspText = trans.getJspText();
            String javaText = javaSearchDoc.getJavaText();
            if (DEBUG) {
                this.displayDebugInfo(match, jspStart, jspEnd, jspText, javaText);
            }
            if (jspStart > -1 && jspEnd > -1) {
                this.addSearchMatch((IDocument)new Document(trans.getJspText()), javaSearchDoc.getFile(), jspStart, jspEnd, jspText);
            }
        }
    }

    protected void addSearchMatch(IDocument jspDocument, IFile jspFile, int jspStart, int jspEnd, String jspText) {
    }

    public void beginReporting() {
        if (DEBUG) {
            System.out.println("JSP Search requestor: beginReporting()");
        }
    }

    public void endReporting() {
        if (DEBUG) {
            System.out.println("JSP Search requestor: endReporting()");
        }
    }

    public void enterParticipant(SearchParticipant participant) {
        if (DEBUG) {
            System.out.println("JSP Search requestor: enterParticipant()");
        }
    }

    public void exitParticipant(SearchParticipant participant) {
        if (DEBUG) {
            System.out.println("JSP Search requestor: exitParticipant()");
        }
    }

    private void displayDebugInfo(SearchMatch origMatch, int jspStart, int jspEnd, String jspText, String javaText) {
        if (origMatch == null || jspStart == -1 || jspEnd == -1 || jspEnd < jspStart || jspText == null || javaText == null) {
            return;
        }
        System.out.println("+-----------------------------------------+");
        System.out.println("accept possible match [jspDoc: " + origMatch.getResource().getFullPath().toOSString() + " " + origMatch.getOffset() + ":" + origMatch.getOffset() + origMatch.getLength() + "]?");
        System.out.println("match info:");
        System.out.println("the java text is:" + javaText.substring(origMatch.getOffset(), origMatch.getOffset() + origMatch.getLength()));
        System.out.println("java search match translates to jsp coords [start: " + jspStart + " end:" + jspEnd + "]");
        System.out.println(" the jsp text is:" + jspText.substring(jspStart, jspEnd));
    }
}

