/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import java.text.Collator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.jpt.db.Column;
import org.eclipse.jpt.db.ForeignKey;
import org.eclipse.jpt.db.internal.DTPColumnWrapper;
import org.eclipse.jpt.db.internal.DTPDatabaseWrapper;
import org.eclipse.jpt.db.internal.DTPTableWrapper;
import org.eclipse.jpt.db.internal.DTPWrapper;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DTPForeignKeyWrapper
extends DTPWrapper
implements ForeignKey {
    private final DTPTableWrapper baseTable;
    private final org.eclipse.datatools.modelbase.sql.constraints.ForeignKey dtpForeignKey;
    private DTPTableWrapper referencedTable;
    private LocalColumnPair[] columnPairs;
    private String defaultEntityFieldName;
    private boolean defaultEntityFieldNameCalculated = false;

    DTPForeignKeyWrapper(DTPTableWrapper baseTable, org.eclipse.datatools.modelbase.sql.constraints.ForeignKey dtpForeignKey) {
        super(baseTable, dtpForeignKey);
        this.baseTable = baseTable;
        this.dtpForeignKey = dtpForeignKey;
    }

    @Override
    synchronized void catalogObjectChanged(int eventType) {
        this.dispose_();
        this.getConnectionProfile().foreignKeyChanged(this, eventType);
    }

    @Override
    public String getName() {
        return this.dtpForeignKey.getName();
    }

    @Override
    public DTPTableWrapper getBaseTable() {
        return this.baseTable;
    }

    @Override
    public synchronized DTPTableWrapper getReferencedTable() {
        if (this.referencedTable == null) {
            this.referencedTable = this.baseTable.table((Table)this.dtpForeignKey.getUniqueConstraint().getBaseTable());
        }
        return this.referencedTable;
    }

    @Override
    public Iterator<ForeignKey.ColumnPair> columnPairs() {
        return new ArrayIterator((Object[])this.columnPairs_());
    }

    @Override
    public LocalColumnPair columnPair() {
        LocalColumnPair[] pairs = this.columnPairs_();
        if (pairs.length != 1) {
            throw new IllegalStateException("multiple column pairs: " + pairs.length);
        }
        return pairs[0];
    }

    private Iterator<LocalColumnPair> localColumnPairs() {
        return new ArrayIterator((Object[])this.columnPairs_());
    }

    private synchronized LocalColumnPair[] columnPairs_() {
        if (this.columnPairs == null) {
            this.columnPairs = this.buildColumnPairs();
        }
        return this.columnPairs;
    }

    private LocalColumnPair[] buildColumnPairs() {
        List<org.eclipse.datatools.modelbase.sql.tables.Column> baseColumns = this.dtpBaseColumns();
        int size = baseColumns.size();
        List<org.eclipse.datatools.modelbase.sql.tables.Column> refColumns = this.dtpRefColumns();
        if (refColumns.size() != size) {
            throw new IllegalStateException(String.valueOf(this.getBaseTable().getName()) + "." + this.getName() + " - mismatched sizes: " + size + " vs. " + refColumns.size());
        }
        LocalColumnPair[] result = new LocalColumnPair[baseColumns.size()];
        int i = baseColumns.size();
        while (i-- > 0) {
            DTPColumnWrapper baseColumn = this.baseTable.column(baseColumns.get(i));
            DTPColumnWrapper refColumn = this.baseTable.column(refColumns.get(i));
            result[i] = new LocalColumnPair(baseColumn, refColumn);
        }
        return result;
    }

    private List<org.eclipse.datatools.modelbase.sql.tables.Column> dtpBaseColumns() {
        return this.dtpForeignKey.getMembers();
    }

    private List<org.eclipse.datatools.modelbase.sql.tables.Column> dtpRefColumns() {
        return this.dtpForeignKey.getUniqueConstraint().getMembers();
    }

    @Override
    public int columnPairsSize() {
        return this.columnPairs_().length;
    }

    @Override
    public Iterator<Column> baseColumns() {
        return new TransformationIterator<LocalColumnPair, Column>(this.localColumnPairs()){

            protected Column transform(LocalColumnPair pair) {
                return pair.baseColumn();
            }
        };
    }

    boolean baseColumnsContains(Column column) {
        return CollectionTools.contains(this.baseColumns(), (Object)column);
    }

    @Override
    public Iterator<Column> nonPrimaryKeyBaseColumns() {
        return new FilteringIterator<Column, Column>(this.baseColumns()){

            protected boolean accept(Column column) {
                return !DTPForeignKeyWrapper.this.getBaseTable().primaryKeyColumnsContains(column);
            }
        };
    }

    @Override
    public Iterator<Column> referencedColumns() {
        return new TransformationIterator<LocalColumnPair, Column>(this.localColumnPairs()){

            protected Column transform(LocalColumnPair columnPair) {
                return columnPair.referencedColumn();
            }
        };
    }

    private synchronized String defaultEntityFieldName() {
        if (!this.defaultEntityFieldNameCalculated) {
            this.defaultEntityFieldNameCalculated = true;
            this.defaultEntityFieldName = this.buildDefaultEntityFieldName();
        }
        return this.defaultEntityFieldName;
    }

    private String buildDefaultEntityFieldName() {
        if (!this.referencesSingleColumnPrimaryKey()) {
            return null;
        }
        LocalColumnPair columnPair = this.columnPairs_()[0];
        String baseColName = columnPair.baseColumn().getName();
        String refColName = columnPair.referencedColumn().getName();
        if (baseColName.length() <= refColName.length() + 1) {
            return null;
        }
        if (!baseColName.endsWith(refColName)) {
            return null;
        }
        int _index = baseColName.length() - refColName.length() - 1;
        if (baseColName.charAt(_index) != '_') {
            return null;
        }
        String name = baseColName.substring(0, _index);
        return this.isCaseSensitive() ? name : name.toLowerCase();
    }

    @Override
    public String getJavaFieldName() {
        String fieldName = this.defaultEntityFieldName();
        return fieldName != null ? fieldName : this.nonDefaultEntityFieldName();
    }

    @Override
    public boolean defaultMatchesJavaFieldName(String javaFieldName) {
        return this.isCaseSensitive() ? javaFieldName.equals(this.defaultEntityFieldName()) : javaFieldName.equalsIgnoreCase(this.defaultEntityFieldName());
    }

    @Override
    public boolean isDefaultFor(String javaFieldName) {
        if (this.columnPairsSize() != 1) {
            return false;
        }
        if (this.getReferencedTable().primaryKeyColumnsSize() != 1) {
            return false;
        }
        LocalColumnPair columnPair = this.columnPairs_()[0];
        DTPColumnWrapper pkColumn = this.getReferencedTable().primaryKeyColumn();
        if (columnPair.referencedColumn() != pkColumn) {
            return false;
        }
        return columnPair.baseColumn().matchesJavaFieldName(String.valueOf(javaFieldName) + "_" + pkColumn.getName());
    }

    @Override
    public boolean referencesSingleColumnPrimaryKey() {
        if (this.columnPairsSize() != 1) {
            return false;
        }
        if (this.getReferencedTable().primaryKeyColumnsSize() != 1) {
            return false;
        }
        return this.columnPair().referencedColumn() == this.getReferencedTable().primaryKeyColumn();
    }

    private String nonDefaultEntityFieldName() {
        return this.columnPairsSize() == 1 ? this.columnPair().baseColumn().getJavaFieldName() : this.getReferencedTable().getJavaFieldName();
    }

    @Override
    public int compareTo(ForeignKey foreignKey) {
        return Collator.getInstance().compare(this.getName(), foreignKey.getName());
    }

    boolean wraps(org.eclipse.datatools.modelbase.sql.constraints.ForeignKey foreignKey) {
        return this.dtpForeignKey == foreignKey;
    }

    boolean isCaseSensitive() {
        return this.baseTable.isCaseSensitive();
    }

    DTPDatabaseWrapper database() {
        return this.baseTable.database();
    }

    @Override
    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)(String.valueOf(this.getName()) + ": " + Arrays.asList(this.columnPairs_())));
    }

    @Override
    synchronized void dispose() {
        this.dispose_();
        super.dispose();
    }

    private void dispose_() {
        this.defaultEntityFieldNameCalculated = false;
        this.defaultEntityFieldName = null;
        this.columnPairs = null;
        this.referencedTable = null;
    }

    private static class LocalColumnPair
    implements ForeignKey.ColumnPair {
        private final DTPColumnWrapper baseColumn;
        private final DTPColumnWrapper referencedColumn;

        LocalColumnPair(DTPColumnWrapper baseColumn, DTPColumnWrapper referencedColumn) {
            this.baseColumn = baseColumn;
            this.referencedColumn = referencedColumn;
        }

        public DTPColumnWrapper baseColumn() {
            return this.baseColumn;
        }

        public DTPColumnWrapper referencedColumn() {
            return this.referencedColumn;
        }

        public int compareTo(ForeignKey.ColumnPair columnPair) {
            return Collator.getInstance().compare(this.baseColumn().getName(), columnPair.baseColumn().getName());
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)(String.valueOf(this.baseColumn.getName()) + "=>" + this.referencedColumn.getName()));
        }
    }
}

