/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.internal.contentproperties;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.SSECorePlugin;
import org.eclipse.wst.sse.internal.contentproperties.IContentSettings;
import org.eclipse.wst.sse.internal.contentproperties.SimpleNodeOperator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ContentSettings
implements IContentSettings {
    private static final String contentSettingsName = ".contentsettings";
    private static SimpleNodeOperator domOperator;
    private static IProject preProject;
    private static final IContentSettings singleton;
    private String contentSettingsPath = null;
    private IProject currProject = null;
    private final String fileElementName = "file";
    private final String PATHATTR = "path";
    private final String projectElementName = "project";
    private final String rootElementName = "contentsettings";

    static {
        singleton = new ContentSettings();
    }

    public static final String getContentSettingsName() {
        return contentSettingsName;
    }

    public static synchronized IContentSettings getInstance() {
        return singleton;
    }

    private ContentSettings() {
    }

    private void _setProperties(IResource resource, Map properties) {
        if (resource == null || properties == null || properties.isEmpty()) {
            return;
        }
        if (resource.getType() != 4 && resource.getType() != 1) {
            return;
        }
        this.contentSettingsPath = this.getContentSettingsPath(resource);
        if (this.contentSettingsPath == null) {
            return;
        }
        try {
            if (!this.existsContentSettings()) {
                this.createNewDOMTree();
            } else {
                this.createDOMTree();
            }
        }
        catch (SimpleNodeOperator.ReadContentSettingsFailureException e) {
            Logger.logException(e);
            try {
                this.createNewDOMTree();
                this.writeDOMDocument();
            }
            catch (SimpleNodeOperator.CreateContentSettingsFailureException e2) {
                Logger.logException(e2);
                preProject = this.currProject;
                return;
            }
            catch (SimpleNodeOperator.WriteContentSettingsFailureException e2) {
                Logger.logException(e2);
                preProject = this.currProject;
                return;
            }
        }
        catch (SimpleNodeOperator.CreateContentSettingsFailureException e) {
            Logger.logException(e);
            preProject = this.currProject;
            return;
        }
        Element e = null;
        if (resource.getType() == 4) {
            e = (Element)domOperator.getElementWithNodeName("project");
            if (e == null) {
                e = (Element)domOperator.addElementUnderRoot("project");
            }
        } else if (resource.getType() == 1 && (e = (Element)domOperator.getElementWithAttribute(this.getPathAttr(), this.getRelativePathFromProject(resource))) == null) {
            e = (Element)domOperator.addElementUnderRoot("file");
            domOperator.addAttributeAt(e, this.getPathAttr(), this.getRelativePathFromProject(resource));
        }
        Map attrList = domOperator.getAttributesOf(e);
        boolean hasAttr = true;
        if (attrList == null || attrList.isEmpty()) {
            hasAttr = false;
        }
        Set keys = properties.keySet();
        Iterator ii = keys.iterator();
        while (ii.hasNext()) {
            String propertyName = (String)ii.next();
            String propertyValue = (String)properties.get(propertyName);
            if (!hasAttr || (String)attrList.get(propertyName) == null) {
                domOperator.addAttributeAt(e, propertyName, propertyValue);
                continue;
            }
            domOperator.updateAttributeAt(e, propertyName, propertyValue);
        }
        try {
            this.writeDOMDocument();
        }
        catch (SimpleNodeOperator.WriteContentSettingsFailureException ex) {
            Logger.logException(ex);
            preProject = this.currProject;
            return;
        }
        preProject = this.currProject;
    }

    private void _setProperty(IResource resource, String propertyName, String propertyValue) {
        Map attrList;
        if (resource == null || propertyName == null) {
            return;
        }
        if (resource.getType() != 4 && resource.getType() != 1) {
            return;
        }
        this.contentSettingsPath = this.getContentSettingsPath(resource);
        if (this.contentSettingsPath == null) {
            return;
        }
        try {
            if (!this.existsContentSettings()) {
                this.createNewDOMTree();
            } else {
                this.createDOMTree();
            }
        }
        catch (SimpleNodeOperator.ReadContentSettingsFailureException e) {
            Logger.logException(e);
            try {
                this.createNewDOMTree();
                this.writeDOMDocument();
            }
            catch (SimpleNodeOperator.CreateContentSettingsFailureException e2) {
                Logger.logException(e2);
                preProject = this.currProject;
                return;
            }
            catch (SimpleNodeOperator.WriteContentSettingsFailureException e2) {
                Logger.logException(e2);
                preProject = this.currProject;
                return;
            }
        }
        catch (SimpleNodeOperator.CreateContentSettingsFailureException e) {
            Logger.logException(e);
            preProject = this.currProject;
            return;
        }
        Element e = null;
        if (resource.getType() == 4) {
            e = (Element)domOperator.getElementWithNodeName("project");
            if (e == null) {
                e = (Element)domOperator.addElementUnderRoot("project");
            }
        } else if (resource.getType() == 1 && (e = (Element)domOperator.getElementWithAttribute(this.getPathAttr(), this.getRelativePathFromProject(resource))) == null) {
            e = (Element)domOperator.addElementUnderRoot("file");
            domOperator.addAttributeAt(e, this.getPathAttr(), this.getRelativePathFromProject(resource));
        }
        if ((attrList = domOperator.getAttributesOf(e)) == null || attrList.isEmpty() || (String)attrList.get(propertyName) == null) {
            domOperator.addAttributeAt(e, propertyName, propertyValue);
        } else {
            domOperator.updateAttributeAt(e, propertyName, propertyValue);
        }
        try {
            this.writeDOMDocument();
        }
        catch (SimpleNodeOperator.WriteContentSettingsFailureException ex) {
            Logger.logException(ex);
            preProject = this.currProject;
            return;
        }
        preProject = this.currProject;
    }

    private void createDOMTree() throws SimpleNodeOperator.ReadContentSettingsFailureException {
        if (domOperator == null || this.currProject != null && !this.currProject.equals((Object)preProject) && this.contentSettingsPath != null) {
            domOperator = new SimpleNodeOperator(this.contentSettingsPath);
        }
    }

    private void createNewDOMTree() throws SimpleNodeOperator.CreateContentSettingsFailureException {
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            Logger.logException("exception creating document", e);
        }
        catch (FactoryConfigurationError e) {
            Logger.logException("exception creating document", e);
        }
        if (document != null) {
            document.appendChild(document.createElement("contentsettings"));
            domOperator = new SimpleNodeOperator(document);
        }
    }

    public synchronized void deleteAllProperties(IResource deletedFile) {
        if (deletedFile == null) {
            return;
        }
        if (deletedFile.getType() != 1 && deletedFile.getType() != 4) {
            return;
        }
        this.contentSettingsPath = this.getContentSettingsPath(deletedFile);
        if (this.contentSettingsPath == null) {
            return;
        }
        if (!this.existsContentSettings()) {
            return;
        }
        try {
            this.createDOMTree();
        }
        catch (SimpleNodeOperator.ReadContentSettingsFailureException e) {
            Logger.logException(e);
            return;
        }
        Element e = null;
        if (deletedFile.getType() == 4) {
            e = (Element)domOperator.getElementWithNodeName("project");
        } else if (deletedFile.getType() == 1) {
            e = (Element)domOperator.getElementWithAttribute(this.getPathAttr(), this.getRelativePathFromProject(deletedFile));
        }
        if (e == null) {
            preProject = this.currProject;
            return;
        }
        if (deletedFile.getType() == 4) {
            domOperator.removeElementWith("project");
        } else if (deletedFile.getType() == 1) {
            domOperator.removeElementWith(this.getPathAttr(), this.getRelativePathFromProject(deletedFile));
        }
        try {
            this.writeDOMDocument();
        }
        catch (SimpleNodeOperator.WriteContentSettingsFailureException ex) {
            Logger.logException(ex);
            preProject = this.currProject;
            return;
        }
        preProject = this.currProject;
    }

    public synchronized void deleteProperty(IResource resource, String propertyName) {
        if (resource == null) {
            return;
        }
        if (resource.getType() != 4 && resource.getType() != 1) {
            return;
        }
        this.contentSettingsPath = this.getContentSettingsPath(resource);
        if (this.contentSettingsPath == null) {
            return;
        }
        if (!this.existsContentSettings()) {
            return;
        }
        try {
            this.createDOMTree();
        }
        catch (SimpleNodeOperator.ReadContentSettingsFailureException e) {
            Logger.logException(e);
            try {
                this.createNewDOMTree();
                this.writeDOMDocument();
            }
            catch (SimpleNodeOperator.CreateContentSettingsFailureException e2) {
                Logger.logException(e2);
                preProject = this.currProject;
                return;
            }
            catch (SimpleNodeOperator.WriteContentSettingsFailureException e2) {
                Logger.logException(e2);
                preProject = this.currProject;
                return;
            }
        }
        Element e = null;
        if (resource.getType() == 4) {
            e = (Element)domOperator.getElementWithNodeName("project");
        } else if (resource.getType() == 1) {
            e = (Element)domOperator.getElementWithAttribute(this.getPathAttr(), this.getRelativePathFromProject(resource));
        }
        if (e != null) {
            domOperator.removeAttributeAt(e, propertyName);
            try {
                this.writeDOMDocument();
            }
            catch (SimpleNodeOperator.WriteContentSettingsFailureException ex) {
                Logger.logException(ex);
                preProject = this.currProject;
                return;
            }
        }
        preProject = this.currProject;
    }

    private boolean existsContentSettings() {
        if (this.contentSettingsPath == null) {
            return false;
        }
        IFile file = this.currProject.getFile(contentSettingsName);
        if (file == null) {
            return false;
        }
        return file.isAccessible();
    }

    public boolean existsProperties(IResource resource) {
        if (resource == null) {
            return false;
        }
        if (resource.getType() != 4 && resource.getType() != 1) {
            return false;
        }
        this.contentSettingsPath = this.getContentSettingsPath(resource);
        if (this.contentSettingsPath == null) {
            return false;
        }
        if (!this.existsContentSettings()) {
            return false;
        }
        try {
            this.createDOMTree();
        }
        catch (SimpleNodeOperator.ReadContentSettingsFailureException readContentSettingsFailureException) {
            return false;
        }
        Element e = null;
        if (resource.getType() == 4) {
            e = (Element)domOperator.getElementWithNodeName("project");
        } else if (resource.getType() == 1) {
            e = (Element)domOperator.getElementWithAttribute(this.getPathAttr(), this.getRelativePathFromProject(resource));
        }
        preProject = this.currProject;
        if (e == null) {
            return false;
        }
        Map properties = domOperator.getAttributesOf(e);
        if (properties == null) {
            return false;
        }
        properties.remove(this.getPathAttr());
        return !properties.isEmpty();
    }

    private String getContentSettingsPath(IResource resource) {
        IProject project = null;
        project = resource.getType() == 4 ? (IProject)resource : resource.getProject();
        IPath projectLocation = project.getLocation();
        if (projectLocation == null) {
            return SSECorePlugin.getDefault().getStateLocation().append("contentsettings").append(project.getName()).toString();
        }
        return projectLocation.addTrailingSeparator().append(contentSettingsName).toString();
    }

    public final String getPathAttr() {
        return "path";
    }

    public synchronized Map getProperties(IResource resource) {
        if (resource == null) {
            return null;
        }
        if (resource.getType() != 4 && resource.getType() != 1) {
            return null;
        }
        this.contentSettingsPath = this.getContentSettingsPath(resource);
        if (this.contentSettingsPath == null) {
            return null;
        }
        if (!this.existsContentSettings()) {
            return null;
        }
        try {
            this.createDOMTree();
        }
        catch (SimpleNodeOperator.ReadContentSettingsFailureException e1) {
            Logger.logException(e1);
            try {
                this.createNewDOMTree();
                this.writeDOMDocument();
            }
            catch (SimpleNodeOperator.CreateContentSettingsFailureException e2) {
                Logger.logException(e2);
                preProject = this.currProject;
                return null;
            }
            catch (SimpleNodeOperator.WriteContentSettingsFailureException e2) {
                Logger.logException(e2);
                preProject = this.currProject;
                return null;
            }
        }
        Element e = null;
        if (resource.getType() == 4) {
            e = (Element)domOperator.getElementWithNodeName("project");
        } else if (resource.getType() == 1) {
            e = (Element)domOperator.getElementWithAttribute(this.getPathAttr(), this.getRelativePathFromProject(resource));
        }
        if (e != null) {
            Map properties = domOperator.getAttributesOf(e);
            preProject = this.currProject;
            if (properties == null) {
                return null;
            }
            if (properties.isEmpty()) {
                return null;
            }
            properties.remove(this.getPathAttr());
            return properties;
        }
        preProject = this.currProject;
        return null;
    }

    public synchronized String getProperty(IResource resource, String propertyName) {
        if (resource == null) {
            return null;
        }
        if (resource.getType() != 4 && resource.getType() != 1) {
            return null;
        }
        this.contentSettingsPath = this.getContentSettingsPath(resource);
        if (this.contentSettingsPath == null) {
            return null;
        }
        if (!this.existsContentSettings()) {
            return null;
        }
        try {
            this.createDOMTree();
        }
        catch (SimpleNodeOperator.ReadContentSettingsFailureException e1) {
            Logger.logException(e1);
            try {
                this.createNewDOMTree();
                this.writeDOMDocument();
            }
            catch (SimpleNodeOperator.CreateContentSettingsFailureException e2) {
                Logger.logException(e2);
                preProject = this.currProject;
                return null;
            }
            catch (SimpleNodeOperator.WriteContentSettingsFailureException e2) {
                Logger.logException(e2);
                preProject = this.currProject;
                return null;
            }
        }
        Element e = null;
        if (resource.getType() == 4) {
            e = (Element)domOperator.getElementWithNodeName("project");
        } else if (resource.getType() == 1) {
            e = (Element)domOperator.getElementWithAttribute(this.getPathAttr(), this.getRelativePathFromProject(resource));
        }
        if (e != null) {
            String result = e.getAttribute(propertyName);
            preProject = this.currProject;
            return result;
        }
        preProject = this.currProject;
        return null;
    }

    private String getRelativePathFromProject(IResource resource) {
        if (resource == null) {
            return null;
        }
        IPath path = resource.getProjectRelativePath();
        if (path == null) {
            return null;
        }
        String resourcePath = path.toString();
        return resourcePath;
    }

    public synchronized void releaseCache() {
        domOperator = null;
    }

    public synchronized void setProperties(IResource resource, Map properties) {
        Set keys = properties.keySet();
        Iterator ii = keys.iterator();
        while (ii.hasNext()) {
            if (!this.getPathAttr().equals(ii.next())) continue;
            return;
        }
        this._setProperties(resource, properties);
    }

    public synchronized void setProperty(IResource resource, String propertyName, String propertyValue) {
        if (this.getPathAttr().equals(propertyName)) {
            return;
        }
        this._setProperty(resource, propertyName, propertyValue);
    }

    private void writeDOMDocument() throws SimpleNodeOperator.WriteContentSettingsFailureException {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            domOperator.writeDocument(outputStream);
            outputStream.flush();
            outputStream.close();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            IFile outputFile = this.currProject.getFile(contentSettingsName);
            if (outputFile.exists()) {
                outputFile.setContents((InputStream)inputStream, true, true, null);
            } else {
                outputFile.create((InputStream)inputStream, true, null);
            }
            inputStream.close();
        }
        catch (CoreException e) {
            Logger.logException(e);
            throw new SimpleNodeOperator.WriteContentSettingsFailureException("invalid outputFile in writeDOMDocument()");
        }
        catch (IOException e) {
            Logger.logException(e);
            throw new SimpleNodeOperator.WriteContentSettingsFailureException("invalid outputStream or inputStream in writeDOMDocument()");
        }
    }
}

