/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core;

import java.util.StringTokenizer;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptModelStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.parser.Scanner;
import org.eclipse.wst.jsdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.wst.jsdt.internal.core.ClasspathEntry;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public final class JavaScriptConventions {
    private static final char DOT = '.';
    private static final Scanner SCANNER = new Scanner(false, true, false, 0x2F0000L, null, null, true);

    private JavaScriptConventions() {
    }

    private static synchronized char[] scannedIdentifier(String id, String sourceLevel, String complianceLevel) {
        block7: {
            if (id == null) {
                return null;
            }
            JavaScriptConventions.SCANNER.sourceLevel = sourceLevel == null ? 0x2F0000L : CompilerOptions.versionToJdkLevel(sourceLevel);
            JavaScriptConventions.SCANNER.complianceLevel = complianceLevel == null ? 0x2F0000L : CompilerOptions.versionToJdkLevel(complianceLevel);
            try {
                SCANNER.setSource(id.toCharArray());
                int token = SCANNER.scanIdentifier();
                if (token == 32) break block7;
                return null;
            }
            catch (InvalidInputException invalidInputException) {
                return null;
            }
        }
        if (JavaScriptConventions.SCANNER.currentPosition == JavaScriptConventions.SCANNER.eofPosition) {
            try {
                return SCANNER.getCurrentIdentifierSource();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
        }
        return null;
    }

    public static IStatus validateCompilationUnitName(String name) {
        return JavaScriptConventions.validateCompilationUnitName(name, "1.3", "1.3");
    }

    public static IStatus validateCompilationUnitName(String name, String sourceLevel, String complianceLevel) {
        if (name == null) {
            return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.convention_unit_nullName, null);
        }
        if (!Util.isJavaLikeFileName(name)) {
            return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.convention_unit_notJavaName, null);
        }
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.convention_unit_notJavaName, null);
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    public static IStatus validateClassFileName(String name, String sourceLevel, String complianceLevel) {
        if (name == null) {
            return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.convention_classFile_nullName, null);
        }
        if (!org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(name)) {
            return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.convention_classFile_notClassFileName, null);
        }
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.convention_classFile_notClassFileName, null);
        }
        IStatus status = ResourcesPlugin.getWorkspace().validateName(name, 1);
        if (!status.isOK()) {
            return status;
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    public static IStatus validateFieldName(String name) {
        return JavaScriptConventions.validateIdentifier(name, "1.3", "1.3");
    }

    public static IStatus validateFieldName(String name, String sourceLevel, String complianceLevel) {
        return JavaScriptConventions.validateIdentifier(name, sourceLevel, complianceLevel);
    }

    public static IStatus validateIdentifier(String id) {
        return JavaScriptConventions.validateIdentifier(id, "1.3", "1.3");
    }

    public static IStatus validateIdentifier(String id, String sourceLevel, String complianceLevel) {
        if (JavaScriptConventions.scannedIdentifier(id, sourceLevel, complianceLevel) != null) {
            return JavaModelStatus.VERIFIED_OK;
        }
        return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.bind(Messages.convention_illegalIdentifier, id), null);
    }

    public static IStatus validateImportDeclaration(String name, String sourceLevel, String complianceLevel) {
        if (name == null || name.length() == 0) {
            return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.convention_import_nullImport, null);
        }
        if (name.charAt(name.length() - 1) == '*') {
            if (name.charAt(name.length() - 2) == '.') {
                return JavaScriptConventions.validatePackageName(name.substring(0, name.length() - 2), sourceLevel, complianceLevel);
            }
            return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.convention_import_unqualifiedImport, null);
        }
        return JavaScriptConventions.validatePackageName(name, sourceLevel, complianceLevel);
    }

    public static IStatus validateJavaScriptTypeName(String name) {
        return JavaScriptConventions.validateJavaScriptTypeName(name, "1.3", "1.3");
    }

    public static IStatus validateJavaScriptTypeName(String name, String sourceLevel, String complianceLevel) {
        char[] scannedID;
        if (name == null) {
            return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.convention_type_nullName, null);
        }
        String trimmed = name.trim();
        if (!name.equals(trimmed)) {
            return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.convention_type_nameWithBlanks, null);
        }
        int index = name.lastIndexOf(46);
        if (index == -1) {
            scannedID = JavaScriptConventions.scannedIdentifier(name, sourceLevel, complianceLevel);
        } else {
            String pkg = name.substring(0, index).trim();
            IStatus status = JavaScriptConventions.validatePackageName(pkg, sourceLevel, complianceLevel);
            if (!status.isOK()) {
                return status;
            }
            String type = name.substring(index + 1).trim();
            scannedID = JavaScriptConventions.scannedIdentifier(type, sourceLevel, complianceLevel);
        }
        if (scannedID != null) {
            IStatus status = ResourcesPlugin.getWorkspace().validateName(new String(scannedID), 1);
            if (!status.isOK()) {
                return status;
            }
            if (CharOperation.contains('$', scannedID)) {
                return new Status(2, "org.eclipse.wst.jsdt.core", -1, Messages.convention_type_dollarName, null);
            }
            if (scannedID.length > 0 && ScannerHelper.isLowerCase(scannedID[0])) {
                return new Status(2, "org.eclipse.wst.jsdt.core", -1, Messages.convention_type_lowercaseName, null);
            }
            return JavaModelStatus.VERIFIED_OK;
        }
        return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.bind(Messages.convention_type_invalidName, name), null);
    }

    public static IStatus validateFunctionName(String name) {
        return JavaScriptConventions.validateFunctionName(name, "1.3", "1.3");
    }

    public static IStatus validateFunctionName(String name, String sourceLevel, String complianceLevel) {
        return JavaScriptConventions.validateIdentifier(name, sourceLevel, complianceLevel);
    }

    public static IStatus validatePackageName(String name) {
        return JavaScriptConventions.validatePackageName(name, "1.3", "1.3");
    }

    public static IStatus validatePackageName(String name, String sourceLevel, String complianceLevel) {
        if (name == null) {
            return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.convention_package_nullName, null);
        }
        int length = name.length();
        if (length == 0) {
            return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.convention_package_emptyName, null);
        }
        if (name.charAt(0) == '.' || name.charAt(length - 1) == '.') {
            return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.convention_package_dotName, null);
        }
        if (CharOperation.isWhitespace(name.charAt(0)) || CharOperation.isWhitespace(name.charAt(name.length() - 1))) {
            return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.convention_package_nameWithBlanks, null);
        }
        int dot = 0;
        while (dot != -1 && dot < length - 1) {
            if ((dot = name.indexOf(46, dot + 1)) == -1 || dot >= length - 1 || name.charAt(dot + 1) != '.') continue;
            return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.convention_package_consecutiveDotsName, null);
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        StringTokenizer st = new StringTokenizer(name, ".");
        boolean firstToken = true;
        Status warningStatus = null;
        while (st.hasMoreTokens()) {
            String typeName = st.nextToken();
            char[] scannedID = JavaScriptConventions.scannedIdentifier(typeName = typeName.trim(), sourceLevel, complianceLevel);
            if (scannedID == null) {
                return new Status(4, "org.eclipse.wst.jsdt.core", -1, Messages.bind(Messages.convention_illegalIdentifier, typeName), null);
            }
            IStatus status = workspace.validateName(new String(scannedID), 2);
            if (!status.isOK()) {
                return status;
            }
            if (firstToken && scannedID.length > 0 && ScannerHelper.isUpperCase(scannedID[0]) && warningStatus == null) {
                warningStatus = new Status(2, "org.eclipse.wst.jsdt.core", -1, Messages.convention_package_uppercaseName, null);
            }
            firstToken = false;
        }
        if (warningStatus != null) {
            return warningStatus;
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    public static IJavaScriptModelStatus validateClasspath(IJavaScriptProject javaProject, IIncludePathEntry[] rawClasspath, IPath projectOutputLocation) {
        return ClasspathEntry.validateClasspath(javaProject, rawClasspath, projectOutputLocation);
    }

    public static IJavaScriptModelStatus validateClasspathEntry(IJavaScriptProject project, IIncludePathEntry entry, boolean checkSourceAttachment) {
        IJavaScriptModelStatus status = ClasspathEntry.validateClasspathEntry(project, entry, checkSourceAttachment, true);
        if (status.getCode() == 964 && ((ClasspathEntry)entry).isOptional()) {
            return JavaModelStatus.VERIFIED_OK;
        }
        return status;
    }

    public static IStatus validateTypeVariableName(String name) {
        return JavaScriptConventions.validateIdentifier(name, "1.3", "1.3");
    }

    public static IStatus validateTypeVariableName(String name, String sourceLevel, String complianceLevel) {
        return JavaScriptConventions.validateIdentifier(name, sourceLevel, complianceLevel);
    }
}

