/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.ModulecorePlugin;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.impl.IResourceFactoryExtPtConstants;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.impl.PlatformURLModuleConnection;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.internal.emf.resource.FileNameResourceFactoryRegistry;
import org.eclipse.wst.common.internal.emf.resource.ResourceFactoryDescriptor;
import org.eclipse.wst.common.internal.emf.utilities.DefaultOverridableResourceFactoryRegistry;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.common.internal.emfworkbench.edit.EMFWorkbenchEditContextFactory;

public class WTPResourceFactoryRegistry
extends FileNameResourceFactoryRegistry {
    public static final WTPResourceFactoryRegistry INSTANCE = new WTPResourceFactoryRegistry();
    private static final boolean LOG_WARNINGS = false;
    private WTPResourceFactoryRegistryKey[] sortedDescriptors = null;

    private WTPResourceFactoryRegistry() {
        new ResourceFactoryRegistryReader().readRegistry();
    }

    public Resource.Factory delegatedGetFactory(URI uri) {
        if (INSTANCE == this) {
            return super.delegatedGetFactory(uri);
        }
        return INSTANCE.getFactory(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource.Factory getFactory(URI uri, IContentDescription description) {
        IProject componentProject = null;
        try {
            componentProject = StructureEdit.getContainingProject(uri);
        }
        catch (UnresolveableURIException unresolveableURIException) {}
        ILock lock = EMFWorkbenchEditContextFactory.getProjectLockObject((IProject)componentProject);
        try {
            if (lock != null) {
                lock.acquire();
            }
            WTPResourceFactoryRegistry wTPResourceFactoryRegistry = this;
            synchronized (wTPResourceFactoryRegistry) {
                Resource.Factory resourceFactory = null;
                if (uri != null && uri.lastSegment() != null) {
                    ResourceFactoryDescriptor descriptor = null;
                    descriptor = description == null ? this.getDescriptor(uri) : this.getDescriptor(uri, description);
                    if (descriptor != null) {
                        resourceFactory = this.getFactory(descriptor);
                    }
                }
                if (resourceFactory == null) {
                    resourceFactory = super.getFactory(uri);
                }
                Resource.Factory factory = resourceFactory;
                return factory;
            }
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
    }

    public Resource.Factory getFactory(URI uri) {
        return this.getFactory(uri, null);
    }

    public synchronized void registerLastFileSegment(String aSimpleFileName, Resource.Factory aFactory) {
        super.registerLastFileSegment(aSimpleFileName, aFactory);
    }

    private WTPResourceFactoryRegistryKey getKey(ResourceFactoryDescriptor descriptor) {
        WTPResourceFactoryRegistryKey key = new WTPResourceFactoryRegistryKey();
        key.shortName = descriptor.getShortSegment();
        key.type = descriptor.getContentType();
        key.isDefault = descriptor.isDefault();
        if (descriptor instanceof ConfigurationResourceFactoryDescriptor) {
            ConfigurationResourceFactoryDescriptor configurationDescriptor = (ConfigurationResourceFactoryDescriptor)descriptor;
            key.factoryClassName = configurationDescriptor.getFactoryClassName();
            key.overridesFactoryClassName = configurationDescriptor.getOverridesFactoryClassName();
        }
        return key;
    }

    protected void addDescriptor(ResourceFactoryDescriptor descriptor) {
        this.getDescriptors().put(this.getKey(descriptor), descriptor);
    }

    private WTPResourceFactoryRegistryKey[] getSortedDescriptorKeys() {
        if (this.sortedDescriptors == null || this.sortedDescriptors.length != this.getDescriptors().size()) {
            Set keys = this.getDescriptors().keySet();
            WTPResourceFactoryRegistryKey[] array = new WTPResourceFactoryRegistryKey[keys.size()];
            int count = 0;
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                WTPResourceFactoryRegistryKey key;
                array[count] = key = (WTPResourceFactoryRegistryKey)iterator.next();
                ++count;
            }
            Arrays.sort(array, new Comparator<WTPResourceFactoryRegistryKey>(){

                @Override
                public int compare(WTPResourceFactoryRegistryKey key1, WTPResourceFactoryRegistryKey key2) {
                    return key1.compareTo(key2);
                }
            });
            this.sortedDescriptors = array;
        }
        return this.sortedDescriptors;
    }

    protected synchronized ResourceFactoryDescriptor getDescriptor(URI uri, IContentDescription description) {
        ResourceFactoryDescriptor descriptor;
        WTPResourceFactoryRegistryKey key;
        int n;
        int n2;
        WTPResourceFactoryRegistryKey[] wTPResourceFactoryRegistryKeyArray;
        WTPResourceFactoryRegistryKey[] keys = this.getSortedDescriptorKeys();
        ResourceFactoryDescriptor defaultDescriptor = null;
        if (description != null) {
            wTPResourceFactoryRegistryKeyArray = keys;
            n2 = keys.length;
            n = 0;
            while (n < n2) {
                key = wTPResourceFactoryRegistryKeyArray[n];
                descriptor = (ResourceFactoryDescriptor)this.getDescriptors().get(key);
                if (key.type != null && description.getContentType().equals(key.type) && (defaultDescriptor == null || key.isDefault)) {
                    defaultDescriptor = descriptor;
                }
                ++n;
            }
        }
        wTPResourceFactoryRegistryKeyArray = keys;
        n2 = keys.length;
        n = 0;
        while (n < n2) {
            key = wTPResourceFactoryRegistryKeyArray[n];
            descriptor = (ResourceFactoryDescriptor)this.getDescriptors().get(key);
            if (key.shortName != null && uri.lastSegment().equals(key.shortName) && (defaultDescriptor == null || description == null && key.isDefault)) {
                defaultDescriptor = descriptor;
            }
            ++n;
        }
        return defaultDescriptor;
    }

    private URI newPlatformURI(URI aNewURI, IProject project) {
        if (project == null) {
            return ModuleURIUtil.trimToDeployPathSegment(aNewURI);
        }
        try {
            IVirtualComponent component = ComponentCore.createComponent(project);
            URI deployPathSegment = ModuleURIUtil.trimToDeployPathSegment(aNewURI);
            IVirtualFolder rootFolder = component.getRootFolder();
            IVirtualFile newFile = rootFolder.getFile((IPath)new Path(deployPathSegment.path()));
            return URI.createPlatformResourceURI((String)newFile.getWorkspaceRelativePath().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private IContentDescription getDescriptionFromURI(URI uri) {
        String contentTypeIdentifier = ModuleURIUtil.getContentTypeName(uri);
        if (contentTypeIdentifier != null) {
            return Platform.getContentTypeManager().getContentType(contentTypeIdentifier).getDefaultDescription();
        }
        return null;
    }

    protected synchronized ResourceFactoryDescriptor getDescriptor(URI uri) {
        ResourceFactoryDescriptor defaultDesc;
        IContentDescription description;
        block9: {
            IFile file = WorkbenchResourceHelper.getPlatformFile((URI)uri);
            description = null;
            if (file != null && file.exists()) {
                try {
                    description = file.getContentDescription();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            if (description == null) {
                description = this.getDescriptionFromURI(uri);
                try {
                    if (description == null) break block9;
                    IProject componentProject = null;
                    try {
                        componentProject = StructureEdit.getContainingProject(uri);
                    }
                    catch (UnresolveableURIException e) {
                        e.printStackTrace();
                    }
                    uri = PlatformURLModuleConnection.resolve(uri);
                    uri = this.newPlatformURI(uri, componentProject);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if ((defaultDesc = this.getDescriptor(uri, description)) != null) {
            return defaultDesc;
        }
        return super.getDescriptor(uri);
    }

    static /* synthetic */ Resource.Factory access$0() {
        return DefaultOverridableResourceFactoryRegistry.GLOBAL_FACTORY;
    }

    private class ConfigurationResourceFactoryDescriptor
    extends ResourceFactoryDescriptor
    implements IResourceFactoryExtPtConstants {
        private String shortSegment;
        private IContentType contentType;
        private boolean isDefault = true;
        private String factoryClassName = null;
        private String overridesFactoryClassName = null;
        private final IConfigurationElement element;

        public ConfigurationResourceFactoryDescriptor(IConfigurationElement ext) throws CoreException {
            Assert.isNotNull((Object)ext);
            this.element = ext;
            this.init();
        }

        public String getOverridesFactoryClassName() {
            return this.overridesFactoryClassName;
        }

        public String getFactoryClassName() {
            return this.factoryClassName;
        }

        private void init() throws CoreException {
            this.shortSegment = this.element.getAttribute("shortSegment");
            IConfigurationElement[] bindings = this.element.getChildren("contentTypeBinding");
            if (bindings.length > 0) {
                String contentTypeId = null;
                contentTypeId = bindings[0].getAttribute("contentTypeId");
                if (contentTypeId != null) {
                    this.contentType = Platform.getContentTypeManager().getContentType(contentTypeId);
                }
            }
            if ((this.shortSegment == null || this.shortSegment.trim().length() == 0) && this.contentType == null) {
                throw new CoreException(ModulecorePlugin.createErrorStatus(0, "Either the shortSegment attribute or the contentType element of resourceFactory must be specified in " + this.element.getNamespaceIdentifier() + ".  The shortSegment attribute is specified with a valid, non-null, " + "non-empty value, and the contentType element is specified with a " + "valid, non-null, non-empty contentTypeId.", null));
            }
            if ("false".equals(this.element.getAttribute("isDefault"))) {
                this.isDefault = false;
            }
            this.factoryClassName = this.element.getAttribute("class");
            this.overridesFactoryClassName = this.element.getAttribute("overridesFactoryClass");
        }

        public boolean isEnabledFor(URI fileURI) {
            if (fileURI != null && fileURI.lastSegment() != null && this.shortSegment != null) {
                return this.shortSegment.equals(fileURI.lastSegment());
            }
            return false;
        }

        public Resource.Factory createFactory() {
            final Resource.Factory[] factory = new Resource.Factory[1];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    factory[0] = (Resource.Factory)ConfigurationResourceFactoryDescriptor.this.element.createExecutableExtension("class");
                }

                public void handleException(Throwable exception) {
                    ModulecorePlugin.log(ModulecorePlugin.createErrorStatus(0, exception.getMessage(), exception));
                }
            });
            return factory[0] != null ? factory[0] : WTPResourceFactoryRegistry.access$0();
        }

        public String getShortSegment() {
            return this.shortSegment;
        }

        public IContentType getContentType() {
            return this.contentType;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public int hashCode() {
            int hashCode = 0;
            if (this.getContentType() != null) {
                hashCode |= this.getContentType().hashCode();
            }
            if (this.getShortSegment() != null) {
                hashCode |= this.getShortSegment().hashCode();
            }
            return hashCode;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ResourceFactoryDescriptor)) {
                return false;
            }
            ResourceFactoryDescriptor rfdo = (ResourceFactoryDescriptor)o;
            boolean equals = true;
            equals &= this.getContentType() == null ? rfdo.getContentType() == null : this.getContentType().equals(rfdo.getContentType());
            return equals &= this.getShortSegment() == null ? rfdo.getShortSegment() == null : this.getShortSegment().equals(rfdo.getShortSegment());
        }
    }

    private class ResourceFactoryRegistryReader
    extends RegistryReader
    implements IResourceFactoryExtPtConstants {
        public ResourceFactoryRegistryReader() {
            super("org.eclipse.wst.common.modulecore", "resourceFactories");
        }

        public boolean readElement(final IConfigurationElement element) {
            if (element != null && "resourceFactory".equals(element.getName())) {
                final boolean[] success = new boolean[]{true};
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        WTPResourceFactoryRegistry.this.addDescriptor(new ConfigurationResourceFactoryDescriptor(element));
                    }

                    public void handleException(Throwable exception) {
                        ModulecorePlugin.log(ModulecorePlugin.createErrorStatus(0, exception.getMessage(), exception));
                        success[0] = false;
                    }
                });
                return success[0];
            }
            return false;
        }
    }

    private class WTPResourceFactoryRegistryKey {
        public String overridesFactoryClassName;
        public String factoryClassName;
        public String shortName;
        public IContentType type;
        public boolean isDefault = true;

        public int compareTo(WTPResourceFactoryRegistryKey other) {
            if (this == other) {
                return 0;
            }
            if (this.shortName == null && other.shortName == null) {
                return 0;
            }
            if (this.shortName == null) {
                return 1;
            }
            if (other.shortName == null) {
                return -1;
            }
            int shortNameCompare = this.shortName.compareTo(other.shortName);
            if (shortNameCompare != 0) {
                return shortNameCompare;
            }
            if (this.isDefault != other.isDefault) {
                if (this.isDefault) {
                    return -1;
                }
                return 1;
            }
            if (this.factoryClassName == null && other.factoryClassName == null) {
                return 0;
            }
            if (other.factoryClassName == null) {
                return -1;
            }
            if (this.factoryClassName == null) {
                return 1;
            }
            if (other.factoryClassName.equals(this.overridesFactoryClassName)) {
                return -1;
            }
            if (this.factoryClassName.equals(other.overridesFactoryClassName)) {
                return 1;
            }
            return this.factoryClassName.compareTo(other.factoryClassName);
        }
    }
}

