/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.contentmodel.tld;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.CMAttributeDeclarationImpl;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.CMDocumentImpl;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.CMElementDeclarationImpl;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDFunctionImpl;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDInitParamImpl;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDListenerImpl;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDValidatorImpl;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDVariableImpl;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDFunction;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDInitParam;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDListener;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDValidator;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDVariable;
import org.eclipse.jst.jsp.core.internal.modelhandler.ModelHandlerForJSP;
import org.eclipse.jst.jsp.core.internal.util.DocumentProvider;
import org.eclipse.jst.jsp.core.internal.util.FacetModuleCoreSupport;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.factory.CMDocumentFactory;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CMDocumentFactoryTLD
implements CMDocumentFactory {
    static final boolean _debug = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/tldcmdocument/factory"));

    public CMDocument buildCMDocument(String baselocation, InputStream input) {
        DocumentProvider provider = new DocumentProvider();
        provider.setValidating(false);
        provider.setRootElementName("taglib");
        provider.setInputStream(input);
        if (baselocation != null) {
            provider.setBaseReference(baselocation);
        }
        return this.loadDocument(baselocation, provider.getRootElement());
    }

    private CMDocumentImpl buildCMDocumentFromFolder(IPath path) {
        if (_debug) {
            System.out.println("tagdir loading for " + path);
        }
        CMDocumentImpl document = new CMDocumentImpl();
        document.setBaseLocation(path.toString());
        document.setTlibversion("1.0");
        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
        try {
            IResource[] tagfiles = folder.members();
            int i = 0;
            while (i < tagfiles.length) {
                CMElementDeclaration ed;
                String extension;
                if (tagfiles[i].getType() == 1 && tagfiles[i].getType() == 1 && (extension = tagfiles[i].getFileExtension()) != null && (extension.equals("tag") || extension.equals("tagx")) && (ed = this.createElementDeclaration((CMDocument)document, (IFile)tagfiles[i])) != null) {
                    document.fElements.setNamedItem(ed.getNodeName(), (CMNode)ed);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        return document;
    }

    protected CMDocument buildCMDocumentFromFile(String fileName) {
        DocumentProvider provider = new DocumentProvider();
        provider.setValidating(false);
        provider.setBaseReference(fileName);
        provider.setRootElementName("taglib");
        provider.setFileName(fileName);
        Node rootElement = provider.getRootElement();
        return this.loadDocument(fileName, rootElement);
    }

    protected CMDocument buildCMDocumentFromFile(IFile file) {
        InputStream input = null;
        try {
            if (file.isAccessible()) {
                input = file.getContents(false);
            }
        }
        catch (CoreException coreException) {
            input = new ByteArrayInputStream(new byte[0]);
        }
        if (input != null) {
            return this.buildCMDocument(file.getFullPath().toString(), input);
        }
        return null;
    }

    protected CMDocument buildCMDocumentFromJar(String jarFileName) {
        return this.buildCMDocumentFromJar(jarFileName, "META-INF/taglib.tld");
    }

    protected CMDocument buildCMDocumentFromJar(String jarFileName, String contentFileName) {
        DocumentProvider provider = new DocumentProvider();
        provider.setValidating(false);
        provider.setBaseReference(jarFileName);
        provider.setRootElementName("taglib");
        provider.setJarFileName(jarFileName);
        provider.setFileName(contentFileName);
        CMDocument document = this.loadDocument("jar:file://" + jarFileName + "!" + contentFileName, provider.getRootElement());
        return document;
    }

    protected CMAttributeDeclaration createAttributeDeclaration(CMDocument document, Node attrNode) {
        CMAttributeDeclarationImpl attr = new CMAttributeDeclarationImpl(document);
        Node child = attrNode.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                if (child.getNodeName().equals("name") && child.hasChildNodes()) {
                    attr.setNodeName(this.getContainedText(child));
                } else if (child.getNodeName().equals("description") && child.hasChildNodes()) {
                    attr.setDescription(this.getContainedText(child));
                } else if (child.getNodeName().equals("id") && child.hasChildNodes()) {
                    attr.setId(this.getContainedText(child));
                } else if (child.getNodeName().equals("required") && child.hasChildNodes()) {
                    attr.setRequiredString(this.getContainedText(child));
                } else if (child.getNodeName().equals("rtexprvalue") && child.hasChildNodes()) {
                    attr.setRtexprvalue(this.getContainedText(child));
                } else if (child.getNodeName().equals("fragment") && child.hasChildNodes()) {
                    attr.setFragment(Boolean.valueOf(this.getContainedText(child)));
                }
            }
            child = child.getNextSibling();
        }
        return attr;
    }

    public CMDocument createCMDocument(String uri) {
        CMDocument result = null;
        URL url = null;
        try {
            url = new URL(uri);
        }
        catch (MalformedURLException malformedURLException) {
            result = this.createCMDocumentFromFile(uri);
        }
        if (result == null && url != null && url.getProtocol().equals("file")) {
            result = this.createCMDocumentFromFile(url.getFile());
        }
        if (result == null) {
            result = new CMDocumentImpl();
        }
        return result;
    }

    private CMDocument createCMDocumentFromFile(String fileName) {
        CMDocument result = null;
        if (fileName.endsWith(".jar")) {
            result = this.buildCMDocumentFromJar(fileName);
        } else {
            File file = new File(fileName);
            try {
                result = file.isDirectory() ? this.buildCMDocumentFromDirectory(file) : this.buildCMDocumentFromFile(fileName);
            }
            catch (SecurityException securityException) {
                result = null;
            }
        }
        return result;
    }

    private CMDocument buildCMDocumentFromDirectory(File file) {
        IFile[] foundFilesForLocation = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(file.getPath()));
        int i = 0;
        while (i < foundFilesForLocation.length) {
            if (foundFilesForLocation[i].isAccessible() && foundFilesForLocation[i].getType() == 2) {
                return this.buildCMDocumentFromFolder(foundFilesForLocation[i].getFullPath());
            }
            ++i;
        }
        return null;
    }

    protected CMElementDeclaration createElementDeclaration(CMDocumentImpl document, Element tagFileNode, String path) {
        IFile tagFile;
        CMElementDeclarationImpl ed = new CMElementDeclarationImpl(document);
        IPath tagPath = FacetModuleCoreSupport.resolve((IPath)new Path(document.getBaseLocation()), path);
        if (tagPath.segmentCount() > 1 && (tagFile = ResourcesPlugin.getWorkspace().getRoot().getFile(tagPath)).isAccessible()) {
            ed.setPath(tagFile.getFullPath().toString());
            if (tagPath.getFileExtension().equals("tag")) {
                this.loadTagFile(ed, tagFile, true);
            } else if (tagPath.getFileExtension().equals("tagx")) {
                this.loadTagXFile(ed, tagFile, true);
            }
            if (tagFile.getLocation() != null && ed.getSmallIcon() != null) {
                ed.setSmallIconURL(URIHelper.normalize((String)ed.getSmallIcon(), (String)("file:" + tagFile.getLocation().toString()), (String)tagFile.getLocation().removeLastSegments(1).toString()));
            }
        }
        Node child = tagFileNode.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                String nodeName = child.getNodeName();
                if (nodeName.equals("description") && child.hasChildNodes()) {
                    ed.setDescription(this.getContainedText(child));
                } else if (nodeName.equals("display-name") && child.hasChildNodes()) {
                    ed.setDisplayName(this.getContainedText(child));
                } else if (nodeName.equals("example") && child.hasChildNodes()) {
                    ed.setExample(this.getContainedText(child));
                } else if (nodeName.equals("icon") && child.hasChildNodes()) {
                    ed.setSmallIcon(this.getContainedText(child));
                } else if (nodeName.equals("name") && child.hasChildNodes()) {
                    ed.setNodeName(this.getContainedText(child));
                } else if (nodeName.equals("path") && child.hasChildNodes()) {
                    ed.setPath(this.getContainedText(child));
                } else if (nodeName.equals("tag-extension")) {
                    ed.getExtensions().add(child);
                }
            }
            child = child.getNextSibling();
        }
        return ed;
    }

    protected CMElementDeclaration createElementDeclaration(CMDocument document, Node tagNode) {
        CMElementDeclarationImpl ed = new CMElementDeclarationImpl(document);
        Node child = tagNode.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                String nodeName = child.getNodeName();
                if (nodeName.equals("name") && child.hasChildNodes()) {
                    ed.setNodeName(this.getContainedText(child));
                } else if ((nodeName.equals("tagclass") || nodeName.equals("tag-class")) && child.hasChildNodes()) {
                    ed.setTagclass(this.getContainedText(child));
                } else if ((nodeName.equals("teiclass") || nodeName.equals("tei-class")) && child.hasChildNodes()) {
                    ed.setTeiclass(this.getContainedText(child));
                } else if ((nodeName.equals("bodycontent") || nodeName.equals("body-content")) && child.hasChildNodes()) {
                    String bodycontent = this.getContainedText(child);
                    if (bodycontent.equalsIgnoreCase("JSP")) {
                        ed.setBodycontent("JSP");
                    } else if (bodycontent.equalsIgnoreCase("tagdependent")) {
                        ed.setBodycontent("tagdependent");
                    } else if (bodycontent.equalsIgnoreCase("empty")) {
                        ed.setBodycontent("empty");
                    } else if (bodycontent.equalsIgnoreCase("scriptless")) {
                        ed.setBodycontent("scriptless");
                    }
                } else if ((nodeName.equals("info") || nodeName.equals("description")) && child.hasChildNodes()) {
                    ed.setDescription(this.getContainedText(child));
                } else if (nodeName.equals("attribute")) {
                    CMAttributeDeclaration attr = this.createAttributeDeclaration(document, child);
                    ed.fAttributes.setNamedItem(attr.getAttrName(), (CMNode)attr);
                } else if (nodeName.equals("variable")) {
                    ed.getVariables().add(this.createVariable(child));
                } else if (nodeName.equals("large-icon") && child.hasChildNodes()) {
                    ed.setLargeIcon(this.getContainedText(child));
                } else if (nodeName.equals("small-icon") && child.hasChildNodes()) {
                    ed.setSmallIcon(this.getContainedText(child));
                } else if (nodeName.equals("tag-extension") && child.getNodeType() == 1) {
                    ed.getExtensions().add(child);
                }
            }
            child = child.getNextSibling();
        }
        return ed;
    }

    private CMElementDeclaration createElementDeclaration(CMDocument document, IFile tagFile) {
        CMElementDeclarationImpl ed = new CMElementDeclarationImpl(document);
        ed.setBodycontent("scriptless");
        String shortFilename = tagFile.getName();
        String fileExtension = tagFile.getFileExtension();
        if (fileExtension != null && fileExtension.length() > 0) {
            shortFilename = shortFilename.substring(0, shortFilename.length() - fileExtension.length() - 1);
        }
        ed.setNodeName(shortFilename);
        ed.setPath(tagFile.getFullPath().toString());
        if (fileExtension.equals("tag")) {
            this.loadTagFile(ed, tagFile, true);
        } else if (fileExtension.equals("tagx")) {
            this.loadTagXFile(ed, tagFile, true);
        }
        if (tagFile.getLocation() != null && ed.getSmallIcon() != null) {
            ed.setSmallIconURL(URIHelper.normalize((String)ed.getSmallIcon(), (String)("file:" + tagFile.getLocation().toString()), (String)tagFile.getLocation().removeLastSegments(1).toString()));
        }
        return ed;
    }

    protected TLDFunction createFunction(CMDocument document, Node functionNode) {
        TLDFunctionImpl function = new TLDFunctionImpl(document);
        boolean hasName = false;
        Node child = functionNode.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                String nodeName = child.getNodeName();
                if (nodeName.equals("description") && child.hasChildNodes()) {
                    function.setDescription(this.getContainedText(child));
                } else if (nodeName.equals("display-name") && child.hasChildNodes()) {
                    function.setName(this.getContainedText(child));
                } else if (nodeName.equals("example") && child.hasChildNodes()) {
                    function.setExample(this.getContainedText(child));
                } else if (nodeName.equals("function-class") && child.hasChildNodes()) {
                    function.setClassName(this.getContainedText(child));
                } else if (nodeName.equals("function-extension") && child.hasChildNodes()) {
                    function.getExtensions().add(child);
                } else if (nodeName.equals("function-signature") && child.hasChildNodes()) {
                    function.setSignature(this.getContainedText(child));
                } else if (nodeName.equals("icon") && child.hasChildNodes()) {
                    function.setIcon(this.getContainedText(child));
                } else if (nodeName.equals("name") && child.hasChildNodes()) {
                    function.setName(this.getContainedText(child));
                    hasName = function.getName().trim().length() > 0;
                }
            }
            child = child.getNextSibling();
        }
        if (hasName) {
            return function;
        }
        return null;
    }

    protected TLDInitParam createInitParam(Node initParamNode) {
        TLDInitParamImpl initParam = new TLDInitParamImpl();
        Node child = initParamNode.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                String nodeName = child.getNodeName();
                if (nodeName.equals("param-name") && child.hasChildNodes()) {
                    initParam.setName(this.getContainedText(child));
                } else if (nodeName.equals("param-value") && child.hasChildNodes()) {
                    initParam.setValue(this.getContainedText(child));
                } else if (nodeName.equals("description") && child.hasChildNodes()) {
                    initParam.setDescription(this.getContainedText(child));
                }
            }
            child = child.getNextSibling();
        }
        return initParam;
    }

    protected TLDListener createListener(Node listenerNode) {
        TLDListenerImpl listener = new TLDListenerImpl();
        Node child = listenerNode.getFirstChild();
        while (child != null) {
            String nodeName;
            if (child.getNodeType() == 1 && (nodeName = child.getNodeName()).equals("listener-class") && child.hasChildNodes()) {
                listener.setListenerClass(this.getContainedText(child));
            }
            child = child.getNextSibling();
        }
        return listener;
    }

    protected TLDValidator createValidator(Node validatorNode) {
        TLDValidatorImpl validator = new TLDValidatorImpl();
        Node child = validatorNode.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                String nodeName = child.getNodeName();
                if (nodeName.equals("validator-class") && child.hasChildNodes()) {
                    validator.setValidatorClass(this.getContainedText(child));
                } else if (nodeName.equals("init-param") && child.hasChildNodes()) {
                    validator.getInitParams().add(this.createInitParam(child));
                }
            }
            child = child.getNextSibling();
        }
        return validator;
    }

    protected TLDVariable createVariable(Node variableNode) {
        TLDVariableImpl variable = new TLDVariableImpl();
        Node child = variableNode.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                String nodeName = child.getNodeName();
                if (nodeName.equals("variable-class") && child.hasChildNodes()) {
                    variable.setVariableClass(this.getContainedText(child));
                } else if (nodeName.equals("declare") && child.hasChildNodes()) {
                    variable.setDeclareString(this.getContainedText(child));
                } else if (nodeName.equals("name-from-attribute") && child.hasChildNodes()) {
                    variable.setNameFromAttribute(this.getContainedText(child));
                } else if (nodeName.equals("name-given") && child.hasChildNodes()) {
                    variable.setNameGiven(this.getContainedText(child));
                } else if (nodeName.equals("scope") && child.hasChildNodes()) {
                    variable.setScope(this.getContainedText(child));
                } else if (nodeName.equals("description") && child.hasChildNodes()) {
                    variable.setDescription(this.getContainedText(child));
                }
            }
            child = child.getNextSibling();
        }
        return variable;
    }

    protected String getContainedText(Node parent) {
        NodeList children = parent.getChildNodes();
        if (children.getLength() == 1) {
            return this.getValue(children.item(0));
        }
        StringBuffer s = new StringBuffer();
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 5) {
                String reference = ((EntityReference)child).getNodeValue();
                if (reference == null && child.getNodeName() != null) {
                    reference = "&" + child.getNodeName() + ";";
                }
                if (reference != null) {
                    s.append(reference.trim());
                }
            } else {
                s.append(this.getValue(child));
            }
            child = child.getNextSibling();
        }
        return s.toString().trim();
    }

    private String getValue(Node n) {
        if (n == null) {
            return "";
        }
        String value = n.getNodeValue();
        if (value == null) {
            return "";
        }
        return value.trim();
    }

    public boolean isBuilderForGrammar(String grammarFileName) {
        String fileName = grammarFileName.toLowerCase();
        return fileName.endsWith(".tld") || fileName.endsWith(".jar");
    }

    private CMDocument loadDocument(String baseLocation, Node taglib) {
        Node root = taglib;
        CMDocumentImpl document = new CMDocumentImpl();
        document.setBaseLocation(baseLocation);
        if (root == null) {
            if (_debug) {
                System.out.println("null \"taglib\" element for TLD " + baseLocation);
            }
            return document;
        }
        Node child = root.getFirstChild();
        while (child != null) {
            if (child.getNodeType() != 1) {
                child = child.getNextSibling();
                continue;
            }
            String nodeName = child.getNodeName();
            if (nodeName.indexOf(58) > 0) {
                nodeName = nodeName.substring(nodeName.indexOf(58));
            }
            if (nodeName.equals("tag")) {
                CMElementDeclaration ed = this.createElementDeclaration((CMDocument)document, child);
                if (ed != null) {
                    document.fElements.setNamedItem(ed.getNodeName(), (CMNode)ed);
                }
            } else if (nodeName.equals("tag-file") && child.getNodeType() == 1 && child.hasChildNodes()) {
                Element tagFileElement = (Element)child;
                Node path = tagFileElement.getFirstChild();
                while (path != null) {
                    CMElementDeclarationImpl ed;
                    String pathValue;
                    if (path.getNodeType() == 1 && ("path".equals(path.getNodeName()) || "path".equals(path.getLocalName())) && (pathValue = this.getContainedText(path)) != null && pathValue.length() > 0 && (ed = (CMElementDeclarationImpl)this.createElementDeclaration(document, tagFileElement, pathValue)) != null) {
                        document.fElements.setNamedItem(ed.getNodeName(), (CMNode)ed);
                    }
                    path = path.getNextSibling();
                }
            } else if ((nodeName.equals("jspversion") || nodeName.equals("jsp-version")) && child.hasChildNodes()) {
                document.setJspversion(this.getContainedText(child));
            } else if ((nodeName.equals("tlibversion") || nodeName.equals("tlib-version")) && child.hasChildNodes()) {
                document.setTlibversion(this.getContainedText(child));
            } else if ((nodeName.equals("shortname") || nodeName.equals("short-name")) && child.hasChildNodes()) {
                document.setShortname(this.getContainedText(child));
            } else if ((nodeName.equals("uri") || nodeName.equals("urn")) && child.hasChildNodes()) {
                document.setUri(this.getContainedText(child));
            } else if (nodeName.equals("info") && child.hasChildNodes()) {
                document.setInfo(this.getContainedText(child));
            } else if (nodeName.equals("description") && child.hasChildNodes()) {
                document.setDescription(this.getContainedText(child));
            } else if (nodeName.equals("display-name") && child.hasChildNodes()) {
                document.setDisplayName(this.getContainedText(child));
            } else if (nodeName.equals("large-icon") && child.hasChildNodes()) {
                document.setLargeIcon(this.getContainedText(child));
            } else if (nodeName.equals("small-icon") && child.hasChildNodes()) {
                document.setSmallIcon(this.getContainedText(child));
            } else if (nodeName.equals("validator")) {
                document.setValidator(this.createValidator(child));
            } else if (nodeName.equals("listener")) {
                document.getListeners().add(this.createListener(child));
            } else if (nodeName.equals("function")) {
                TLDFunction function = this.createFunction(document, child);
                if (function != null) {
                    document.getFunctions().add(function);
                }
            } else if (nodeName.equals("taglib-extension")) {
                document.getExtensions().add(child);
            }
            child = child.getNextSibling();
        }
        return document;
    }

    private void loadTagXFile(final CMElementDeclarationImpl ed, IFile tagxFile, boolean allowIncludes) {
        ed.setPath(tagxFile.getFullPath().toString());
        ed.setTagSource("JSP Tag 2.0 File");
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            InputSource inputSource = new InputSource(tagxFile.getFullPath().toString());
            InputStream input = tagxFile.getContents(false);
            inputSource.setByteStream(input);
            parser.parse(inputSource, new DefaultHandler(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
                    InputSource inputSource2 = new InputSource(systemId);
                    inputSource2.setByteStream(new ByteArrayInputStream(new byte[0]));
                    return inputSource2;
                }

                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    super.startElement(uri, localName, qName, attributes);
                    if (qName.equals("jsp:directive.tag")) {
                        if (attributes.getIndex("display-name") >= 0) {
                            ed.setDisplayName(attributes.getValue("display-name"));
                        }
                        if (attributes.getIndex("body-content") >= 0) {
                            ed.setBodycontent(attributes.getValue("body-content"));
                        }
                        if (attributes.getIndex("dynamic-attributes") >= 0) {
                            ed.setDynamicAttributes(attributes.getValue("dynamic-attributes"));
                        }
                        if (attributes.getIndex("small-icon") >= 0) {
                            ed.setSmallIcon(attributes.getValue("small-icon"));
                        }
                        if (attributes.getIndex("large-icon") >= 0) {
                            ed.setLargeIcon(attributes.getValue("large-icon"));
                        }
                        if (attributes.getIndex("description") >= 0) {
                            ed.setDescription(attributes.getValue("description"));
                        }
                        if (attributes.getIndex("example") >= 0) {
                            ed.setExample(attributes.getValue("example"));
                        }
                        if (attributes.getIndex("language") >= 0) {
                            ed.setScriptingLanguage(attributes.getValue("language"));
                        }
                        if (attributes.getIndex("import") >= 0) {
                            ed.setImport(attributes.getValue("import"));
                        }
                        if (attributes.getIndex("pageEncoding") >= 0) {
                            ed.setPageEncoding(attributes.getValue("pageEncoding"));
                        }
                        if (attributes.getIndex("isELIgnored") >= 0) {
                            ed.setIsELIgnored(attributes.getValue("isELIgnored"));
                        }
                    } else if (qName.equals("jsp:directive.attribute")) {
                        CMAttributeDeclarationImpl attribute = new CMAttributeDeclarationImpl(ed.getOwnerDocument());
                        String nameValue = attributes.getValue("name");
                        attribute.setNodeName(nameValue);
                        if (attributes.getIndex("fragment") >= 0) {
                            attribute.setFragment(Boolean.valueOf(attributes.getValue("fragment")));
                        }
                        if (attributes.getIndex("rtexprvalue") >= 0) {
                            attribute.setRtexprvalue(attributes.getValue("rtexprvalue"));
                        }
                        if (attributes.getIndex("type") >= 0) {
                            attribute.setType(attributes.getValue("type"));
                        }
                        if (attributes.getIndex("description") >= 0) {
                            attribute.setDescription(attributes.getValue("description"));
                        }
                        if (attributes.getIndex("required") >= 0) {
                            attribute.setRequiredString(attributes.getValue("required"));
                        }
                        if (nameValue != null && nameValue.length() > 0) {
                            ed.fAttributes.setNamedItem(nameValue, (CMNode)attribute);
                        }
                    } else if (qName.equals("jsp:directive.variable")) {
                        TLDVariableImpl variable = new TLDVariableImpl();
                        if (attributes.getIndex("name-given") >= 0) {
                            variable.setNameGiven(attributes.getValue("name-given"));
                        }
                        if (attributes.getIndex("name-from-attribute") >= 0) {
                            variable.setNameFromAttribute(attributes.getValue("name-from-attribute"));
                        }
                        if (attributes.getIndex("alias") >= 0) {
                            variable.setAlias(attributes.getValue("alias"));
                        }
                        if (attributes.getIndex("variable-class") >= 0) {
                            variable.setVariableClass(attributes.getValue("variable-class"));
                        }
                        if (attributes.getIndex("declare") >= 0) {
                            variable.setDeclareString(attributes.getValue("declare"));
                        }
                        if (attributes.getIndex("scope") >= 0) {
                            variable.setScope(attributes.getValue("scope"));
                        }
                        if (attributes.getIndex("description") >= 0) {
                            variable.setDescription(attributes.getValue("description"));
                        }
                        if (variable.getAlias() != null || variable.getNameFromAttribute() != null || variable.getNameGiven() != null) {
                            ed.getVariables().add(variable);
                        }
                    } else if (qName.equals("jsp:directive.include")) {
                        IPath filePath = null;
                        String text = attributes.getValue("file");
                        if (text != null) {
                            filePath = FacetModuleCoreSupport.resolve((IPath)new Path(((CMDocumentImpl)ed.getOwnerDocument()).getBaseLocation()), text);
                            IFile includedFile = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
                            if (includedFile.isAccessible()) {
                                CMDocumentFactoryTLD.this.loadTagXFile(ed, includedFile, false);
                            }
                        }
                    }
                }
            });
            input.close();
        }
        catch (ParserConfigurationException e) {
            Logger.logException(e);
        }
        catch (SAXException e) {
            Logger.logException(e);
        }
        catch (IOException e) {
            Logger.logException(e);
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        ed.setLocationString(tagxFile.getFullPath().toString());
    }

    private void loadTagFile(CMElementDeclarationImpl ed, IFile tagFile, boolean allowIncludes) {
        try {
            ed.setPath(tagFile.getFullPath().toString());
            ed.setTagSource("JSP Tag 2.0 File");
            ed.setLocationString(tagFile.getFullPath().toString());
            if (!tagFile.isAccessible()) {
                return;
            }
            IStructuredDocument document = (IStructuredDocument)new ModelHandlerForJSP().getDocumentLoader().createNewStructuredDocument(tagFile);
            IStructuredDocumentRegion documentRegion = document.getFirstStructuredDocumentRegion();
            while (documentRegion != null) {
                if (documentRegion.getType().equals("JSP_DIRECTIVE_NAME") && documentRegion.getNumberOfRegions() > 2) {
                    String text;
                    ITextRegion region;
                    String text2;
                    ITextRegion region2;
                    String attrName;
                    ITextRegionList regions = documentRegion.getRegions();
                    String directiveName = documentRegion.getText(regions.get(1));
                    if ("tag".equals(directiveName)) {
                        attrName = null;
                        int i = 2;
                        while (i < documentRegion.getNumberOfRegions()) {
                            region2 = regions.get(i);
                            text2 = documentRegion.getText(region2);
                            if (region2.getType() == "XML_TAG_ATTRIBUTE_NAME") {
                                attrName = text2;
                            } else if (region2.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                                text2 = StringUtils.strip((String)text2);
                                if ("display-name".equals(attrName)) {
                                    ed.setDisplayName(text2);
                                } else if ("body-content".equals(attrName)) {
                                    ed.setBodycontent(text2);
                                } else if ("dynamic-attributes".equals(attrName)) {
                                    ed.setDynamicAttributes(text2);
                                } else if ("small-icon".equals(attrName)) {
                                    ed.setSmallIcon(text2);
                                } else if ("large-icon".equals(attrName)) {
                                    ed.setLargeIcon(text2);
                                } else if ("description".equals(attrName)) {
                                    ed.setDescription(text2);
                                } else if ("example".equals(attrName)) {
                                    ed.setExample(text2);
                                } else if ("language".equals(attrName)) {
                                    ed.setScriptingLanguage(text2);
                                } else if ("import".equals(attrName)) {
                                    ed.setImport(text2);
                                } else if ("pageEncoding".equals(attrName)) {
                                    ed.setPageEncoding(text2);
                                } else if ("isELIgnored".equals(attrName)) {
                                    ed.setIsELIgnored(text2);
                                }
                            }
                            ++i;
                        }
                    } else if ("attribute".equals(directiveName)) {
                        CMAttributeDeclarationImpl attribute = new CMAttributeDeclarationImpl(ed.getOwnerDocument());
                        String attrName2 = null;
                        int i = 2;
                        while (i < documentRegion.getNumberOfRegions()) {
                            region = regions.get(i);
                            text = documentRegion.getText(region);
                            if (region.getType() == "XML_TAG_ATTRIBUTE_NAME") {
                                attrName2 = text;
                            } else if (region.getType() == "XML_TAG_ATTRIBUTE_VALUE" && attrName2 != null) {
                                text = StringUtils.strip((String)text);
                                if ("name".equals(attrName2)) {
                                    attribute.setNodeName(text);
                                } else if ("fragment".equals(attrName2)) {
                                    attribute.setFragment(Boolean.valueOf(text));
                                } else if ("rtexprvalue".equals(attrName2)) {
                                    attribute.setRtexprvalue(text);
                                } else if ("type".equals(attrName2)) {
                                    attribute.setType(text);
                                } else if ("description".equals(attrName2)) {
                                    attribute.setDescription(text);
                                } else if ("required".equals(attrName2)) {
                                    attribute.setRequiredString(text);
                                }
                            }
                            ++i;
                        }
                        if (attribute.getNodeName() != null) {
                            ed.fAttributes.setNamedItem(attribute.getNodeName(), (CMNode)attribute);
                        }
                    } else if ("variable".equals(directiveName)) {
                        TLDVariableImpl variable = new TLDVariableImpl();
                        String attrName3 = null;
                        int i = 2;
                        while (i < documentRegion.getNumberOfRegions()) {
                            region = regions.get(i);
                            text = documentRegion.getText(region);
                            if (region.getType() == "XML_TAG_ATTRIBUTE_NAME") {
                                attrName3 = text;
                            } else if (region.getType() == "XML_TAG_ATTRIBUTE_VALUE" && attrName3 != null) {
                                text = StringUtils.strip((String)text);
                                if ("name-given".equals(attrName3)) {
                                    variable.setNameGiven(text);
                                } else if ("name-from-attribute".equals(attrName3)) {
                                    variable.setNameFromAttribute(text);
                                } else if ("alias".equals(attrName3)) {
                                    variable.setAlias(text);
                                } else if ("variable-class".equals(attrName3)) {
                                    variable.setVariableClass(text);
                                } else if ("declare".equals(attrName3)) {
                                    variable.setDeclareString(text);
                                } else if ("scope".equals(attrName3)) {
                                    variable.setScope(text);
                                } else if ("description".equals(attrName3)) {
                                    variable.setDescription(text);
                                }
                            }
                            ++i;
                        }
                        if (variable.getAlias() != null || variable.getNameFromAttribute() != null || variable.getNameGiven() != null) {
                            ed.getVariables().add(variable);
                        }
                    } else if ("include".equals(directiveName) && allowIncludes) {
                        attrName = null;
                        int i = 2;
                        while (i < documentRegion.getNumberOfRegions()) {
                            region2 = regions.get(i);
                            text2 = documentRegion.getText(region2);
                            if (region2.getType() == "XML_TAG_ATTRIBUTE_NAME") {
                                attrName = text2;
                            } else if (region2.getType() == "XML_TAG_ATTRIBUTE_VALUE" && attrName != null) {
                                text2 = StringUtils.strip((String)text2);
                                if ("file".equals(attrName)) {
                                    IPath filePath = FacetModuleCoreSupport.resolve((IPath)new Path(((CMDocumentImpl)ed.getOwnerDocument()).getBaseLocation()), text2);
                                    IFile includedFile = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
                                    if (includedFile.isAccessible()) {
                                        this.loadTagFile(ed, includedFile, false);
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                }
                documentRegion = documentRegion.getNext();
            }
        }
        catch (IOException iOException) {
        }
        catch (CoreException coreException) {}
    }

    /*
     * Exception decompiling
     */
    public CMDocument createCMDocument(ITaglibRecord reference) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 745->748)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

