/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IAbstractVariableDeclaration;
import org.eclipse.wst.jsdt.core.ast.IAnnotation;
import org.eclipse.wst.jsdt.core.ast.IExpression;
import org.eclipse.wst.jsdt.core.ast.IJsDoc;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.internal.compiler.ast.Annotation;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Javadoc;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public abstract class AbstractVariableDeclaration
extends Statement
implements IAbstractVariableDeclaration,
InvocationSite {
    public int declarationEnd;
    public int declarationSourceEnd;
    public int declarationSourceStart;
    public int hiddenVariableDepth;
    public Expression initialization;
    public int modifiers;
    public int modifiersSourceStart;
    public Annotation[] annotations;
    public Javadoc javadoc;
    public InferredType inferredType;
    public char[] name;
    public TypeReference type;
    public AbstractVariableDeclaration nextLocal;
    public static final int FIELD = 1;
    public static final int INITIALIZER = 2;
    public static final int ENUM_CONSTANT = 3;
    public static final int LOCAL_VARIABLE = 4;
    public static final int PARAMETER = 5;
    public static final int TYPE_PARAMETER = 6;

    public InferredType getInferredType() {
        return this.inferredType;
    }

    public IAnnotation[] getAnnotation() {
        return this.annotations;
    }

    public void setInferredType(InferredType type) {
        this.inferredType = type;
    }

    public char[] getName() {
        return this.name;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return flowInfo;
    }

    public TypeBinding[] genericTypeArguments() {
        return null;
    }

    public abstract int getKind();

    public boolean isSuperAccess() {
        return false;
    }

    public boolean isTypeAccess() {
        return false;
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        this.printAsExpression(indent, output);
        switch (this.getKind()) {
            case 3: {
                return output.append(',');
            }
        }
        return output.append(';');
    }

    public StringBuffer printAsExpression(int indent, StringBuffer output) {
        AbstractVariableDeclaration.printIndent(indent, output);
        AbstractVariableDeclaration.printModifiers(this.modifiers, output);
        output.append("var ");
        if (this.annotations != null) {
            AbstractVariableDeclaration.printAnnotations(this.annotations, output);
        }
        this.printFragment(indent, output);
        if (this.nextLocal != null) {
            output.append(", ");
            this.nextLocal.printFragment(indent, output);
        }
        return output;
    }

    protected void printFragment(int indent, StringBuffer output) {
        if (this.type != null) {
            this.type.print(0, output).append(' ');
        }
        output.append(this.name);
        switch (this.getKind()) {
            case 3: {
                if (this.initialization == null) break;
                this.initialization.printExpression(indent, output);
                break;
            }
            default: {
                if (this.initialization == null) break;
                output.append(" = ");
                this.initialization.printExpression(indent, output);
            }
        }
    }

    public void resolve(BlockScope scope) {
    }

    public void setActualReceiverType(ReferenceBinding receiverType) {
    }

    public void setDepth(int depth) {
        this.hiddenVariableDepth = depth;
    }

    public void setFieldIndex(int depth) {
    }

    public TypeBinding getTypeBinding() {
        if (this.type != null) {
            return this.type.resolvedType;
        }
        if (this.inferredType != null) {
            return this.inferredType.binding;
        }
        return null;
    }

    public int getASTType() {
        return 2;
    }

    public IJsDoc getJsDoc() {
        return this.javadoc;
    }

    public IExpression getInitialization() {
        return this.initialization;
    }
}

