/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.view.servers.AbstractServerAction;

public class PublishCleanAction
extends AbstractServerAction {
    public PublishCleanAction(Shell shell, ISelectionProvider selectionProvider) {
        super(shell, selectionProvider, Messages.actionPublishClean);
        this.setToolTipText(Messages.actionPublishCleanToolTip);
        try {
            this.selectionChanged((IStructuredSelection)selectionProvider.getSelection());
        }
        catch (Exception exception) {}
    }

    public boolean accept(IServer server) {
        return server.canPublish().isOK();
    }

    public void perform(IServer server) {
        if (!ServerUIPlugin.promptIfDirty(this.shell, server)) {
            return;
        }
        if (!ServerUIPlugin.saveEditors()) {
            return;
        }
        if (MessageDialog.openConfirm((Shell)this.shell, (String)Messages.defaultDialogTitle, (String)Messages.dialogPublishClean)) {
            IAdaptable info = new IAdaptable(){

                public Object getAdapter(Class adapter) {
                    if (Shell.class.equals((Object)adapter)) {
                        return PublishCleanAction.this.shell;
                    }
                    return null;
                }
            };
            server.publish(4, null, info, null);
        }
    }
}

