/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.core.search.TypeNameMatchRequestor;
import org.eclipse.wst.jsdt.core.search.TypeNameRequestor;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.OpenTypeHistory;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.corext.util.TypeFilter;
import org.eclipse.wst.jsdt.internal.corext.util.TypeInfoFilter;
import org.eclipse.wst.jsdt.internal.corext.util.TypeInfoRequestorAdapter;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.wst.jsdt.launching.IVMInstall;
import org.eclipse.wst.jsdt.launching.IVMInstallType;
import org.eclipse.wst.jsdt.launching.JavaRuntime;
import org.eclipse.wst.jsdt.launching.LibraryLocation;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;
import org.eclipse.wst.jsdt.ui.dialogs.ITypeInfoFilterExtension;
import org.eclipse.wst.jsdt.ui.dialogs.ITypeInfoImageProvider;

public class TypeInfoViewer {
    private Display fDisplay;
    private String fProgressMessage;
    private Label fProgressLabel;
    private int fProgressCounter;
    private ProgressUpdateJob fProgressUpdateJob;
    private OpenTypeHistory fHistory;
    private int fNextElement;
    private List fItems;
    private TypeNameMatch[] fHistoryMatches;
    private TypeNameMatch[] fSearchMatches;
    private int fNumberOfVisibleItems;
    private int fExpectedItemCount;
    private Color fDashLineColor;
    private int fScrollbarWidth;
    private int fTableWidthDelta;
    private int fDashLineIndex = -1;
    private Image fSeparatorIcon;
    private DashLine fDashLine = new DashLine();
    private boolean fFullyQualifySelection;
    private TableItem[] fLastSelection;
    private String[] fLastLabels;
    private TypeInfoLabelProvider fLabelProvider;
    private ImageManager fImageManager;
    private Table fTable;
    private SyncJob fSyncJob;
    private TypeInfoFilter fTypeInfoFilter;
    private ITypeInfoFilterExtension fFilterExtension;
    private TypeNameMatch[] fLastCompletedResult;
    private TypeInfoFilter fLastCompletedFilter;
    private int fSearchJobTicket;
    protected int fElementKind;
    protected IJavaScriptSearchScope fSearchScope;
    private AbstractSearchJob fSearchJob;
    private static final int HISTORY = 1;
    private static final int INDEX = 2;
    private static final int FULL = 3;
    private static final char SEPARATOR = '-';
    private static final boolean DEBUG = false;
    private static final boolean VIRTUAL = false;
    private static final TypeNameMatch[] EMTPY_TYPE_INFO_ARRAY = new TypeNameMatch[0];
    private static final TypeNameMatch DASH_LINE = SearchEngine.createTypeNameMatch(null, (int)0);

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TypeInfoViewer(Composite parent, int flags, Label progressLabel, IJavaScriptSearchScope scope, int elementKind, String initialFilter, ITypeInfoFilterExtension filterExtension, ITypeInfoImageProvider imageExtension) {
        Assert.isNotNull((Object)scope);
        this.fDisplay = parent.getDisplay();
        this.fProgressLabel = progressLabel;
        this.fSearchScope = scope;
        this.fElementKind = elementKind;
        this.fFilterExtension = filterExtension;
        this.fFullyQualifySelection = (flags & 2) != 0;
        this.fTable = new Table(parent, 0x800B00 | flags);
        this.fTable.setFont(parent.getFont());
        this.fLabelProvider = new TypeInfoLabelProvider(imageExtension);
        this.fItems = new ArrayList(500);
        this.fTable.setHeaderVisible(false);
        this.addPopupMenu();
        this.fTable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                int itemHeight = TypeInfoViewer.this.fTable.getItemHeight();
                Rectangle clientArea = TypeInfoViewer.this.fTable.getClientArea();
                TypeInfoViewer.this.fNumberOfVisibleItems = clientArea.height / itemHeight + 1;
            }
        });
        this.fTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    TypeInfoViewer.this.deleteHistoryEntry();
                } else if (e.keyCode == 0x1000002) {
                    int index = TypeInfoViewer.this.fTable.getSelectionIndex();
                    if (index == TypeInfoViewer.this.fDashLineIndex - 1) {
                        e.doit = false;
                        TypeInfoViewer.this.setTableSelection(index + 2);
                    }
                } else if (e.keyCode == 0x1000001) {
                    int index = TypeInfoViewer.this.fTable.getSelectionIndex();
                    if (TypeInfoViewer.this.fDashLineIndex != -1 && index == TypeInfoViewer.this.fDashLineIndex + 1) {
                        e.doit = false;
                        TypeInfoViewer.this.setTableSelection(index - 2);
                    }
                }
            }
        });
        this.fTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TypeInfoViewer.this.fLastSelection != null) {
                    int i = 0;
                    while (i < TypeInfoViewer.this.fLastSelection.length) {
                        TableItem item = TypeInfoViewer.this.fLastSelection[i];
                        if (!item.isDisposed()) {
                            item.setText(TypeInfoViewer.this.fLastLabels[i]);
                        }
                        ++i;
                    }
                }
                TableItem[] items = TypeInfoViewer.this.fTable.getSelection();
                TypeInfoViewer.this.fLastSelection = new TableItem[items.length];
                TypeInfoViewer.this.fLastLabels = new String[items.length];
                int i = 0;
                while (i < items.length) {
                    String qualifiedText;
                    TableItem item;
                    ((TypeInfoViewer)TypeInfoViewer.this).fLastSelection[i] = item = items[i];
                    ((TypeInfoViewer)TypeInfoViewer.this).fLastLabels[i] = item.getText();
                    Object data = item.getData();
                    if (data instanceof TypeNameMatch && (qualifiedText = TypeInfoViewer.this.getQualifiedText((TypeNameMatch)data)).length() > TypeInfoViewer.this.fLastLabels[i].length()) {
                        item.setText(qualifiedText);
                    }
                    ++i;
                }
            }
        });
        this.fTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TypeInfoViewer.this.stop(true, true);
                TypeInfoViewer.this.fDashLineColor.dispose();
                TypeInfoViewer.this.fSeparatorIcon.dispose();
                TypeInfoViewer.this.fImageManager.dispose();
                if (TypeInfoViewer.this.fProgressUpdateJob != null) {
                    TypeInfoViewer.this.fProgressUpdateJob.stop();
                    TypeInfoViewer.this.fProgressUpdateJob = null;
                }
            }
        });
        this.fDashLineColor = this.computeDashLineColor();
        this.fScrollbarWidth = this.computeScrollBarWidth();
        this.fTableWidthDelta = this.fTable.computeTrim((int)0, (int)0, (int)0, (int)0).width - this.fScrollbarWidth;
        this.fSeparatorIcon = JavaPluginImages.DESC_OBJS_TYPE_SEPARATOR.createImage((Device)this.fTable.getDisplay());
        this.fImageManager = new ImageManager();
        this.fHistory = OpenTypeHistory.getInstance();
        if (initialFilter != null && initialFilter.length() > 0) {
            this.fTypeInfoFilter = this.createTypeInfoFilter(initialFilter);
        }
        GC gc = null;
        try {
            gc = new GC((Drawable)this.fTable);
            gc.setFont(this.fTable.getFont());
            this.fDashLine.initialize(gc);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            gc.dispose();
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        gc.dispose();
        if (this.fTypeInfoFilter == null) {
            this.scheduleSyncJob();
        }
    }

    void startup() {
        if (this.fTypeInfoFilter == null) {
            this.reset();
        } else {
            this.scheduleSearchJob(3);
        }
    }

    public Table getTable() {
        return this.fTable;
    }

    TypeInfoLabelProvider getLabelProvider() {
        return this.fLabelProvider;
    }

    private int getNumberOfVisibleItems() {
        return this.fNumberOfVisibleItems;
    }

    public void setFocus() {
        this.fTable.setFocus();
    }

    public void setQualificationStyle(boolean value) {
        if (this.fFullyQualifySelection == value) {
            return;
        }
        this.fFullyQualifySelection = value;
        if (this.fLastSelection != null) {
            int i = 0;
            while (i < this.fLastSelection.length) {
                TableItem item = this.fLastSelection[i];
                Object data = item.getData();
                if (data instanceof TypeNameMatch) {
                    item.setText(this.getQualifiedText((TypeNameMatch)data));
                }
                ++i;
            }
        }
    }

    public TypeNameMatch[] getSelection() {
        TableItem[] items = this.fTable.getSelection();
        ArrayList<Object> result = new ArrayList<Object>(items.length);
        int i = 0;
        while (i < items.length) {
            Object data = items[i].getData();
            if (data instanceof TypeNameMatch) {
                result.add(data);
            }
            ++i;
        }
        return result.toArray(new TypeNameMatch[result.size()]);
    }

    public void stop() {
        this.stop(true, false);
    }

    public void stop(boolean stopSyncJob, boolean dispose) {
        if (this.fSyncJob != null && stopSyncJob) {
            this.fSyncJob.stop();
            this.fSyncJob = null;
        }
        if (this.fSearchJob != null) {
            this.fSearchJob.stop();
            this.fSearchJob = null;
        }
    }

    public void forceSearch() {
        this.stop(false, false);
        if (this.fTypeInfoFilter == null) {
            this.reset();
        } else {
            this.fLastCompletedFilter = null;
            this.fLastCompletedResult = null;
            this.scheduleSearchJob(this.isSyncJobRunning() ? 1 : 3);
        }
    }

    public void setSearchPattern(String text) {
        this.stop(false, false);
        if (text.length() == 0 || "*".equals(text)) {
            this.fTypeInfoFilter = null;
            this.reset();
        } else {
            this.fTypeInfoFilter = this.createTypeInfoFilter(text);
            this.scheduleSearchJob(this.isSyncJobRunning() ? 1 : 3);
        }
    }

    public void setSearchScope(IJavaScriptSearchScope scope, boolean refresh) {
        this.fSearchScope = scope;
        if (!refresh) {
            return;
        }
        this.stop(false, false);
        this.fLastCompletedFilter = null;
        this.fLastCompletedResult = null;
        if (this.fTypeInfoFilter == null) {
            this.reset();
        } else {
            this.scheduleSearchJob(this.isSyncJobRunning() ? 1 : 3);
        }
    }

    public void setFullyQualifyDuplicates(boolean value, boolean refresh) {
        this.fLabelProvider.setFullyQualifyDuplicates(value);
        if (!refresh) {
            return;
        }
        this.stop(false, false);
        if (this.fTypeInfoFilter == null) {
            this.reset();
        } else {
            this.scheduleSearchJob(this.isSyncJobRunning() ? 1 : 3);
        }
    }

    public void reset() {
        this.fLastSelection = null;
        this.fLastLabels = null;
        this.fExpectedItemCount = 0;
        this.fDashLineIndex = -1;
        TypeInfoFilter filter = this.fTypeInfoFilter != null ? this.fTypeInfoFilter : new TypeInfoFilter("*", this.fSearchScope, this.fElementKind, this.fFilterExtension);
        this.fNextElement = 0;
        TypeNameMatch[] historyItems = this.fHistory.getFilteredTypeInfos(filter);
        if (historyItems.length == 0) {
            this.shortenTable();
            return;
        }
        this.fExpectedItemCount = historyItems.length;
        int lastIndex = historyItems.length - 1;
        TypeNameMatch last = null;
        TypeNameMatch type = historyItems[0];
        int i = 0;
        while (i < historyItems.length) {
            TypeNameMatch next = i == lastIndex ? null : historyItems[i + 1];
            this.addSingleElement(type, this.fLabelProvider.getImageDescriptor(type), this.fLabelProvider.getText(last, type, next));
            last = type;
            type = next;
            ++i;
        }
        this.shortenTable();
    }

    protected TypeInfoFilter createTypeInfoFilter(String text) {
        if ("**".equals(text)) {
            text = "*";
        }
        return new TypeInfoFilter(text, this.fSearchScope, this.fElementKind, this.fFilterExtension);
    }

    private void addPopupMenu() {
        Menu menu = new Menu((Decorations)this.fTable.getShell(), 8);
        this.fTable.setMenu(menu);
        final MenuItem remove = new MenuItem(menu, 0);
        remove.setText(JavaUIMessages.TypeInfoViewer_remove_from_history);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                TableItem[] selection = TypeInfoViewer.this.fTable.getSelection();
                remove.setEnabled(TypeInfoViewer.this.canEnable(selection));
            }
        });
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TypeInfoViewer.this.deleteHistoryEntry();
            }
        });
    }

    private boolean canEnable(TableItem[] selection) {
        if (selection.length == 0) {
            return false;
        }
        int i = 0;
        while (i < selection.length) {
            TableItem item = selection[i];
            Object data = item.getData();
            if (!(data instanceof TypeNameMatch)) {
                return false;
            }
            if (!this.fHistory.contains((TypeNameMatch)data)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void deleteHistoryEntry() {
        int index = this.fTable.getSelectionIndex();
        if (index == -1) {
            return;
        }
        TableItem item = this.fTable.getItem(index);
        Object element = item.getData();
        if (!(element instanceof TypeNameMatch)) {
            return;
        }
        if (this.fHistory.remove(element) != null) {
            item.dispose();
            this.fItems.remove(index);
            int count = this.fTable.getItemCount();
            if (count > 0) {
                item = this.fTable.getItem(0);
                if (item.getData() instanceof DashLine) {
                    item.dispose();
                    this.fItems.remove(0);
                    this.fDashLineIndex = -1;
                    if (count > 1) {
                        this.setTableSelection(0);
                    }
                } else {
                    if (index >= count) {
                        index = count - 1;
                    }
                    this.setTableSelection(index);
                }
            } else {
                this.fTable.notifyListeners(13, new Event());
            }
        }
    }

    private void clear(int ticket) {
        this.syncExec(ticket, new Runnable(){

            public void run() {
                TypeInfoViewer.this.fNextElement = 0;
                TypeInfoViewer.this.fDashLineIndex = -1;
                TypeInfoViewer.this.fLastSelection = null;
                TypeInfoViewer.this.fLastLabels = null;
                TypeInfoViewer.this.fExpectedItemCount = 0;
            }
        });
    }

    private void rememberResult(int ticket, final TypeNameMatch[] result) {
        this.syncExec(ticket, new Runnable(){

            public void run() {
                if (TypeInfoViewer.this.fLastCompletedResult == null) {
                    TypeInfoViewer.this.fLastCompletedFilter = TypeInfoViewer.this.fTypeInfoFilter;
                    TypeInfoViewer.this.fLastCompletedResult = result;
                }
            }
        });
    }

    private void addHistory(int ticket, List elements, List imageDescriptors, List labels) {
        this.addAll(ticket, elements, imageDescriptors, labels);
    }

    private void addAll(int ticket, final List elements, final List imageDescriptors, final List labels) {
        this.syncExec(ticket, new Runnable(){

            public void run() {
                int size = elements.size();
                int i = 0;
                while (i < size) {
                    TypeInfoViewer.this.addSingleElement(elements.get(i), (ImageDescriptor)imageDescriptors.get(i), (String)labels.get(i));
                    ++i;
                }
            }
        });
    }

    private void addDashLineAndUpdateLastHistoryEntry(int ticket, final TypeNameMatch next) {
        this.syncExec(ticket, new Runnable(){

            public void run() {
                if (TypeInfoViewer.this.fNextElement > 0) {
                    TableItem last;
                    TableItem item = TypeInfoViewer.this.fTable.getItem(TypeInfoViewer.this.fNextElement - 1);
                    String label = item.getText();
                    String newLabel = TypeInfoViewer.this.fLabelProvider.getText(null, (TypeNameMatch)item.getData(), next);
                    if (newLabel.length() != label.length()) {
                        item.setText(newLabel);
                    }
                    if (TypeInfoViewer.this.fLastSelection != null && TypeInfoViewer.this.fLastSelection.length > 0 && (last = TypeInfoViewer.this.fLastSelection[TypeInfoViewer.this.fLastSelection.length - 1]) == item) {
                        ((TypeInfoViewer)TypeInfoViewer.this).fLastLabels[((TypeInfoViewer)TypeInfoViewer.this).fLastLabels.length - 1] = newLabel;
                    }
                }
                TypeInfoViewer.this.fDashLineIndex = TypeInfoViewer.this.fNextElement;
                TypeInfoViewer.this.addDashLine();
            }
        });
    }

    private void addDashLine() {
        TableItem item = null;
        if (this.fItems.size() > this.fNextElement) {
            item = (TableItem)this.fItems.get(this.fNextElement);
        } else {
            item = new TableItem(this.fTable, 0);
            this.fItems.add(item);
        }
        this.fillDashLine(item);
        ++this.fNextElement;
    }

    private void addSingleElement(Object element, ImageDescriptor imageDescriptor, String label) {
        TableItem item = null;
        Object old = null;
        if (this.fItems.size() > this.fNextElement) {
            item = (TableItem)this.fItems.get(this.fNextElement);
            old = item.getData();
            item.setForeground(null);
        } else {
            item = new TableItem(this.fTable, 0);
            this.fItems.add(item);
        }
        item.setData(element);
        item.setImage(this.fImageManager.get(imageDescriptor));
        if (this.fNextElement == 0) {
            if (this.needsSelectionChange(old, element) || this.fLastSelection != null) {
                item.setText(label);
                this.fTable.setSelection(0);
                this.fTable.notifyListeners(13, new Event());
            } else {
                this.fLastSelection = new TableItem[]{item};
                this.fLastLabels = new String[]{label};
            }
        } else {
            item.setText(label);
        }
        ++this.fNextElement;
    }

    private boolean needsSelectionChange(Object oldElement, Object newElement) {
        int[] selected = this.fTable.getSelectionIndices();
        if (selected.length != 1) {
            return true;
        }
        if (selected[0] != 0) {
            return true;
        }
        if (oldElement == null) {
            return true;
        }
        return !oldElement.equals(newElement);
    }

    private void scheduleSearchJob(int mode) {
        ++this.fSearchJobTicket;
        if (this.fLastCompletedFilter != null && this.fTypeInfoFilter.isSubFilter(this.fLastCompletedFilter.getText())) {
            this.fSearchJob = new CachedResultJob(this.fSearchJobTicket, this.fLastCompletedResult, this, this.fTypeInfoFilter, this.fHistory, this.fNumberOfVisibleItems, mode);
        } else {
            this.fLastCompletedFilter = null;
            this.fLastCompletedResult = null;
            this.fSearchJob = new SearchEngineJob(this.fSearchJobTicket, this, this.fTypeInfoFilter, this.fHistory, this.fNumberOfVisibleItems, mode, this.fSearchScope, this.fElementKind);
        }
        this.fSearchJob.schedule();
    }

    private void searchJobDone(int ticket) {
        this.syncExec(ticket, new Runnable(){

            public void run() {
                TypeInfoViewer.this.shortenTable();
                TypeInfoViewer.this.checkEmptyList();
                TypeInfoViewer.this.fSearchJob = null;
            }
        });
    }

    private void searchJobCanceled(int ticket, final boolean removePendingItems) {
        this.syncExec(ticket, new Runnable(){

            public void run() {
                if (removePendingItems) {
                    TypeInfoViewer.this.shortenTable();
                    TypeInfoViewer.this.checkEmptyList();
                }
                TypeInfoViewer.this.fSearchJob = null;
            }
        });
    }

    private synchronized void searchJobFailed(int ticket, CoreException e) {
        this.searchJobDone(ticket);
        JavaScriptPlugin.log(e);
    }

    private void setHistoryResult(int ticket, final TypeNameMatch[] types) {
        this.syncExec(ticket, new Runnable(){

            public void run() {
                TypeInfoViewer.this.fExpectedItemCount = types.length;
                int lastHistoryLength = TypeInfoViewer.this.fHistoryMatches.length;
                TypeInfoViewer.this.fHistoryMatches = types;
                int length = TypeInfoViewer.this.fHistoryMatches.length + TypeInfoViewer.this.fSearchMatches.length;
                int dash = TypeInfoViewer.this.fHistoryMatches.length > 0 && TypeInfoViewer.this.fSearchMatches.length > 0 ? 1 : 0;
                TypeInfoViewer.this.fTable.setItemCount(length + dash);
                if (length == 0) {
                    TypeInfoViewer.this.fTable.redraw();
                    return;
                }
                int update = Math.max(lastHistoryLength, TypeInfoViewer.this.fHistoryMatches.length);
                if (update > 0) {
                    TypeInfoViewer.this.fTable.clear(0, update + dash - 1);
                }
            }
        });
    }

    private void setSearchResult(int ticket, final TypeNameMatch[] types) {
        this.syncExec(ticket, new Runnable(){

            public void run() {
                TypeInfoViewer typeInfoViewer = TypeInfoViewer.this;
                typeInfoViewer.fExpectedItemCount = typeInfoViewer.fExpectedItemCount + types.length;
                TypeInfoViewer.this.fSearchMatches = types;
                int length = TypeInfoViewer.this.fHistoryMatches.length + TypeInfoViewer.this.fSearchMatches.length;
                int dash = TypeInfoViewer.this.fHistoryMatches.length > 0 && TypeInfoViewer.this.fSearchMatches.length > 0 ? 1 : 0;
                TypeInfoViewer.this.fTable.setItemCount(length + dash);
                if (length == 0) {
                    TypeInfoViewer.this.fTable.redraw();
                    return;
                }
                if (TypeInfoViewer.this.fHistoryMatches.length == 0) {
                    TypeInfoViewer.this.fTable.clear(0, length + dash - 1);
                } else {
                    TypeInfoViewer.this.fTable.clear(TypeInfoViewer.this.fHistoryMatches.length - 1, length + dash - 1);
                }
            }
        });
    }

    private void setData(TableItem item) {
        int index = this.fTable.indexOf(item);
        TypeNameMatch type = this.getTypeInfo(index);
        if (type == DASH_LINE) {
            item.setData((Object)this.fDashLine);
            this.fillDashLine(item);
        } else {
            item.setData((Object)type);
            item.setImage(this.fImageManager.get(this.fLabelProvider.getImageDescriptor(type)));
            item.setText(this.fLabelProvider.getText(this.getTypeInfo(index - 1), type, this.getTypeInfo(index + 1)));
            item.setForeground(null);
        }
    }

    private TypeNameMatch getTypeInfo(int index) {
        int dash;
        if (index < 0) {
            return null;
        }
        if (index < this.fHistoryMatches.length) {
            return this.fHistoryMatches[index];
        }
        int n = dash = this.fHistoryMatches.length > 0 && this.fSearchMatches.length > 0 ? 1 : 0;
        if (index == this.fHistoryMatches.length && dash == 1) {
            return DASH_LINE;
        }
        if ((index = index - this.fHistoryMatches.length - dash) >= this.fSearchMatches.length) {
            return null;
        }
        return this.fSearchMatches[index];
    }

    private void scheduleSyncJob() {
        this.fSyncJob = new SyncJob(this);
        this.fSyncJob.schedule();
    }

    private void syncJobDone() {
        this.syncExec(new Runnable(){

            public void run() {
                TypeInfoViewer.this.fSyncJob = null;
                if (TypeInfoViewer.this.fTypeInfoFilter != null) {
                    TypeInfoViewer.this.scheduleSearchJob(3);
                }
            }
        });
    }

    private boolean isSyncJobRunning() {
        return this.fSyncJob != null;
    }

    private void scheduleProgressUpdateJob() {
        this.syncExec(new Runnable(){

            public void run() {
                if (TypeInfoViewer.this.fProgressCounter == 0) {
                    TypeInfoViewer.this.clearProgressMessage();
                    TypeInfoViewer.this.fProgressUpdateJob = new ProgressUpdateJob(TypeInfoViewer.this.fDisplay, TypeInfoViewer.this);
                    TypeInfoViewer.this.fProgressUpdateJob.schedule(300L);
                }
                TypeInfoViewer typeInfoViewer = TypeInfoViewer.this;
                typeInfoViewer.fProgressCounter = typeInfoViewer.fProgressCounter + 1;
            }
        });
    }

    private void stopProgressUpdateJob() {
        this.syncExec(new Runnable(){

            public void run() {
                TypeInfoViewer typeInfoViewer = TypeInfoViewer.this;
                typeInfoViewer.fProgressCounter = typeInfoViewer.fProgressCounter - 1;
                if (TypeInfoViewer.this.fProgressCounter == 0 && TypeInfoViewer.this.fProgressUpdateJob != null) {
                    TypeInfoViewer.this.fProgressUpdateJob.stop();
                    TypeInfoViewer.this.fProgressUpdateJob = null;
                    TypeInfoViewer.this.clearProgressMessage();
                }
            }
        });
    }

    private void setProgressMessage(String message) {
        this.fProgressMessage = message;
    }

    private void clearProgressMessage() {
        this.fProgressMessage = "";
        this.fProgressLabel.setText(this.fProgressMessage);
    }

    private void updateProgressMessage() {
        this.fProgressLabel.setText(this.fProgressMessage);
    }

    private void syncExec(final Runnable runnable) {
        if (this.fDisplay.isDisposed()) {
            return;
        }
        this.fDisplay.syncExec(new Runnable(){

            public void run() {
                if (TypeInfoViewer.this.fTable.isDisposed()) {
                    return;
                }
                runnable.run();
            }
        });
    }

    private void syncExec(final int ticket, final Runnable runnable) {
        if (this.fDisplay.isDisposed()) {
            return;
        }
        this.fDisplay.syncExec(new Runnable(){

            public void run() {
                if (TypeInfoViewer.this.fTable.isDisposed() || ticket != TypeInfoViewer.this.fSearchJobTicket) {
                    return;
                }
                runnable.run();
            }
        });
    }

    private void fillDashLine(TableItem item) {
        Rectangle bounds = item.getImageBounds(0);
        Rectangle area = this.fTable.getBounds();
        boolean willHaveScrollBar = this.fExpectedItemCount + 1 > this.fNumberOfVisibleItems;
        item.setText(this.fDashLine.getText(area.width - bounds.x - bounds.width - this.fTableWidthDelta - (willHaveScrollBar ? this.fScrollbarWidth : 0)));
        item.setImage(this.fSeparatorIcon);
        item.setForeground(this.fDashLineColor);
        item.setData((Object)this.fDashLine);
    }

    private void shortenTable() {
        if (this.fNextElement < this.fItems.size()) {
            this.fTable.setRedraw(false);
            this.fTable.remove(this.fNextElement, this.fItems.size() - 1);
            this.fTable.setRedraw(true);
        }
        int i = this.fItems.size() - 1;
        while (i >= this.fNextElement) {
            this.fItems.remove(i);
            --i;
        }
    }

    private void checkEmptyList() {
        if (this.fTable.getItemCount() == 0) {
            this.fTable.notifyListeners(13, new Event());
        }
    }

    private void setTableSelection(int index) {
        this.fTable.setSelection(index);
        this.fTable.notifyListeners(13, new Event());
    }

    private Color computeDashLineColor() {
        Color fg = this.fTable.getForeground();
        int fGray = (int)(0.3 * (double)fg.getRed() + 0.59 * (double)fg.getGreen() + 0.11 * (double)fg.getBlue());
        Color bg = this.fTable.getBackground();
        int bGray = (int)(0.3 * (double)bg.getRed() + 0.59 * (double)bg.getGreen() + 0.11 * (double)bg.getBlue());
        int gray = (int)((double)(fGray + bGray) * 0.66);
        return new Color((Device)this.fDisplay, gray, gray, gray);
    }

    private int computeScrollBarWidth() {
        Composite t = new Composite((Composite)this.fTable.getShell(), 512);
        int result = t.computeTrim((int)0, (int)0, (int)0, (int)0).width;
        t.dispose();
        return result;
    }

    private String getQualifiedText(TypeNameMatch type) {
        return this.fFullyQualifySelection ? this.fLabelProvider.getFullyQualifiedText(type) : this.fLabelProvider.getQualifiedText(type);
    }

    private static abstract class AbstractJob
    extends Job {
        protected TypeInfoViewer fViewer;

        protected AbstractJob(String name, TypeInfoViewer viewer) {
            super(name);
            this.fViewer = viewer;
            this.setSystem(true);
        }

        protected final IStatus run(IProgressMonitor parent) {
            IStatus iStatus;
            ProgressMonitor monitor = new ProgressMonitor(parent, this.fViewer);
            try {
                this.fViewer.scheduleProgressUpdateJob();
                iStatus = this.doRun(monitor);
                Object var3_4 = null;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.fViewer.stopProgressUpdateJob();
                throw throwable;
            }
            this.fViewer.stopProgressUpdateJob();
            return iStatus;
        }

        protected abstract IStatus doRun(ProgressMonitor var1);
    }

    private static abstract class AbstractSearchJob
    extends AbstractJob {
        private int fMode;
        protected int fTicket;
        protected TypeInfoLabelProvider fLabelProvider;
        protected TypeInfoFilter fFilter;
        protected OpenTypeHistory fHistory;

        protected AbstractSearchJob(int ticket, TypeInfoViewer viewer, TypeInfoFilter filter, OpenTypeHistory history, int numberOfVisibleItems, int mode) {
            super(JavaUIMessages.TypeInfoViewer_job_label, viewer);
            this.fMode = mode;
            this.fTicket = ticket;
            this.fViewer = viewer;
            this.fLabelProvider = this.fViewer.getLabelProvider();
            this.fFilter = filter;
            this.fHistory = history;
        }

        public void stop() {
            this.cancel();
        }

        protected IStatus doRun(ProgressMonitor monitor) {
            try {
                this.internalRun(monitor);
            }
            catch (CoreException e) {
                this.fViewer.searchJobFailed(this.fTicket, e);
                return new Status(4, JavaScriptPlugin.getPluginId(), 4, JavaUIMessages.TypeInfoViewer_job_error, (Throwable)e);
            }
            catch (InterruptedException e) {
                return this.canceled(e, true);
            }
            catch (OperationCanceledException e) {
                return this.canceled((Exception)((Object)e), false);
            }
            this.fViewer.searchJobDone(this.fTicket);
            return this.ok();
        }

        protected abstract TypeNameMatch[] getSearchResult(Set var1, ProgressMonitor var2) throws CoreException;

        private void internalRun(ProgressMonitor monitor) throws CoreException, InterruptedException {
            block9: {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.fViewer.clear(this.fTicket);
                TypeNameMatch last = null;
                TypeNameMatch type = null;
                TypeNameMatch next = null;
                ArrayList<TypeNameMatch> elements = new ArrayList<TypeNameMatch>();
                ArrayList<ImageDescriptor> imageDescriptors = new ArrayList<ImageDescriptor>();
                ArrayList<String> labels = new ArrayList<String>();
                HashSet<TypeNameMatch> filteredMatches = new HashSet<TypeNameMatch>();
                TypeNameMatch[] matchingTypes = this.fHistory.getFilteredTypeInfos(this.fFilter);
                if (matchingTypes.length > 0) {
                    Arrays.sort(matchingTypes, new TypeInfoComparator(this.fLabelProvider, this.fFilter));
                    type = matchingTypes[0];
                    int i = 1;
                    while (type != null) {
                        next = i == matchingTypes.length ? null : matchingTypes[i];
                        elements.add(type);
                        filteredMatches.add(type);
                        imageDescriptors.add(this.fLabelProvider.getImageDescriptor(type));
                        labels.add(this.fLabelProvider.getText(last, type, next));
                        last = type;
                        type = next;
                        ++i;
                    }
                }
                matchingTypes = null;
                this.fViewer.fExpectedItemCount = elements.size();
                this.fViewer.addHistory(this.fTicket, elements, imageDescriptors, labels);
                if ((this.fMode & 2) == 0) {
                    return;
                }
                TypeNameMatch[] result = this.getSearchResult(filteredMatches, monitor);
                TypeInfoViewer typeInfoViewer = this.fViewer;
                typeInfoViewer.fExpectedItemCount = typeInfoViewer.fExpectedItemCount + result.length;
                if (result.length == 0) {
                    return;
                }
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                int processed = 0;
                int nextIndex = 1;
                type = result[0];
                if (!filteredMatches.isEmpty()) {
                    this.fViewer.addDashLineAndUpdateLastHistoryEntry(this.fTicket, type);
                }
                do {
                    long startTime = System.currentTimeMillis();
                    elements.clear();
                    imageDescriptors.clear();
                    labels.clear();
                    int delta = Math.min(nextIndex == 1 ? this.fViewer.getNumberOfVisibleItems() : 10, result.length - processed);
                    if (delta == 0) break block9;
                    processed += delta;
                    while (delta > 0) {
                        next = nextIndex == result.length ? null : result[nextIndex];
                        elements.add(type);
                        labels.add(this.fLabelProvider.getText(last, type, next));
                        imageDescriptors.add(this.fLabelProvider.getImageDescriptor(type));
                        last = type;
                        type = next;
                        ++nextIndex;
                        --delta;
                    }
                    this.fViewer.addAll(this.fTicket, elements, imageDescriptors, labels);
                    long sleep = 100L - (System.currentTimeMillis() - startTime);
                    if (sleep <= 0L) continue;
                    Thread.sleep(sleep);
                } while (!monitor.isCanceled());
                throw new OperationCanceledException();
            }
        }

        private void internalRunVirtual(ProgressMonitor monitor) throws CoreException, InterruptedException {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fViewer.clear(this.fTicket);
            TypeNameMatch[] matchingTypes = this.fHistory.getFilteredTypeInfos(this.fFilter);
            this.fViewer.setHistoryResult(this.fTicket, matchingTypes);
            if ((this.fMode & 2) == 0) {
                return;
            }
            HashSet<TypeNameMatch> filteredMatches = new HashSet<TypeNameMatch>(matchingTypes.length * 2);
            int i = 0;
            while (i < matchingTypes.length) {
                filteredMatches.add(matchingTypes[i]);
                ++i;
            }
            TypeNameMatch[] result = this.getSearchResult(filteredMatches, monitor);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fViewer.setSearchResult(this.fTicket, result);
        }

        private IStatus canceled(Exception e, boolean removePendingItems) {
            this.fViewer.searchJobCanceled(this.fTicket, removePendingItems);
            return new Status(8, JavaScriptPlugin.getPluginId(), 8, JavaUIMessages.TypeInfoViewer_job_cancel, (Throwable)e);
        }

        private IStatus ok() {
            return new Status(0, JavaScriptPlugin.getPluginId(), 0, "", null);
        }
    }

    private static class CachedResultJob
    extends AbstractSearchJob {
        private TypeNameMatch[] fLastResult;

        public CachedResultJob(int ticket, TypeNameMatch[] lastResult, TypeInfoViewer viewer, TypeInfoFilter filter, OpenTypeHistory history, int numberOfVisibleItems, int mode) {
            super(ticket, viewer, filter, history, numberOfVisibleItems, mode);
            this.fLastResult = lastResult;
        }

        protected TypeNameMatch[] getSearchResult(Set filteredHistory, ProgressMonitor monitor) throws CoreException {
            ArrayList<TypeNameMatch> result = new ArrayList<TypeNameMatch>(2048);
            int i = 0;
            while (i < this.fLastResult.length) {
                TypeNameMatch type = this.fLastResult[i];
                if (!filteredHistory.contains(type) && this.fFilter.matchesCachedResult(type)) {
                    result.add(type);
                }
                ++i;
            }
            TypeNameMatch[] types = result.toArray(new TypeNameMatch[result.size()]);
            if (this.fFilter.isCamelCasePattern()) {
                Arrays.sort(types, new TypeInfoComparator(this.fLabelProvider, this.fFilter));
            }
            return types;
        }
    }

    private static class DashLine {
        private int fSeparatorWidth;
        private String fMessage;
        private int fMessageLength;

        private DashLine() {
        }

        public String getText(int width) {
            StringBuffer dashes = new StringBuffer();
            int chars = (width - this.fMessageLength) / this.fSeparatorWidth / 2 - 2;
            int i = 0;
            while (i < chars) {
                dashes.append('-');
                ++i;
            }
            StringBuffer result = new StringBuffer();
            result.append(dashes);
            result.append(this.fMessage);
            result.append(dashes);
            return result.toString();
        }

        public void initialize(GC gc) {
            this.fSeparatorWidth = gc.getAdvanceWidth('-');
            this.fMessage = " " + JavaUIMessages.TypeInfoViewer_separator_message + " ";
            this.fMessageLength = gc.textExtent((String)this.fMessage).x;
        }
    }

    private static class ImageManager {
        private Map fImages = new HashMap(20);

        private ImageManager() {
        }

        public Image get(ImageDescriptor descriptor) {
            Image result;
            if (descriptor == null) {
                descriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            if ((result = (Image)this.fImages.get(descriptor)) != null) {
                return result;
            }
            result = descriptor.createImage();
            if (result != null) {
                this.fImages.put(descriptor, result);
            }
            return result;
        }

        public void dispose() {
            Iterator iter = this.fImages.values().iterator();
            while (iter.hasNext()) {
                Image image = (Image)iter.next();
                image.dispose();
            }
            this.fImages.clear();
        }
    }

    private static class ProgressMonitor
    extends ProgressMonitorWrapper {
        private TypeInfoViewer fViewer;
        private String fName;
        private int fTotalWork;
        private double fWorked;
        private boolean fDone;

        public ProgressMonitor(IProgressMonitor monitor, TypeInfoViewer viewer) {
            super(monitor);
            this.fViewer = viewer;
        }

        public void setTaskName(String name) {
            super.setTaskName(name);
            this.fName = name;
        }

        public void beginTask(String name, int totalWork) {
            super.beginTask(name, totalWork);
            if (this.fName == null) {
                this.fName = name;
            }
            this.fTotalWork = totalWork;
        }

        public void worked(int work) {
            super.worked(work);
            this.internalWorked(work);
        }

        public void done() {
            this.fDone = true;
            this.fViewer.setProgressMessage("");
            super.done();
        }

        public void internalWorked(double work) {
            this.fWorked += work;
            this.fViewer.setProgressMessage(this.getMessage());
        }

        private String getMessage() {
            if (this.fDone) {
                return "";
            }
            if (this.fTotalWork == 0) {
                return this.fName;
            }
            return Messages.format(JavaUIMessages.TypeInfoViewer_progress_label, new Object[]{this.fName, new Integer((int)(this.fWorked * 100.0 / (double)this.fTotalWork))});
        }
    }

    private static class ProgressUpdateJob
    extends UIJob {
        private TypeInfoViewer fViewer;
        private boolean fStopped;

        public ProgressUpdateJob(Display display, TypeInfoViewer viewer) {
            super(display, JavaUIMessages.TypeInfoViewer_progressJob_label);
            this.fViewer = viewer;
        }

        public void stop() {
            this.fStopped = true;
            this.cancel();
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (this.stopped()) {
                return new Status(8, JavaScriptPlugin.getPluginId(), 8, "", null);
            }
            this.fViewer.updateProgressMessage();
            if (!this.stopped()) {
                this.schedule(300L);
            }
            return new Status(0, JavaScriptPlugin.getPluginId(), 0, "", null);
        }

        private boolean stopped() {
            return this.fStopped || this.fViewer.getTable().isDisposed();
        }
    }

    private static class SearchEngineJob
    extends AbstractSearchJob {
        private IJavaScriptSearchScope fScope;
        private int fElementKind;
        private SearchRequestor fReqestor;

        public SearchEngineJob(int ticket, TypeInfoViewer viewer, TypeInfoFilter filter, OpenTypeHistory history, int numberOfVisibleItems, int mode, IJavaScriptSearchScope scope, int elementKind) {
            super(ticket, viewer, filter, history, numberOfVisibleItems, mode);
            this.fScope = scope;
            this.fElementKind = elementKind;
            this.fReqestor = new SearchRequestor(filter);
        }

        public void stop() {
            this.fReqestor.cancel();
            super.stop();
        }

        protected TypeNameMatch[] getSearchResult(Set matchIdsInHistory, ProgressMonitor monitor) throws CoreException {
            System.currentTimeMillis();
            this.fReqestor.setHistory(matchIdsInHistory);
            SearchEngine engine = new SearchEngine(null);
            String packPattern = this.fFilter.getPackagePattern();
            monitor.setTaskName(JavaUIMessages.TypeInfoViewer_searchJob_taskName);
            engine.searchAllTypeNames(packPattern == null ? null : packPattern.toCharArray(), this.fFilter.getPackageFlags(), this.fFilter.getNamePattern().toCharArray(), this.fFilter.getSearchFlags(), this.fElementKind, this.fScope, (TypeNameMatchRequestor)this.fReqestor, 3, (IProgressMonitor)monitor);
            TypeNameMatch[] result = this.fReqestor.getResult();
            Arrays.sort(result, new TypeInfoComparator(this.fLabelProvider, this.fFilter));
            this.fViewer.rememberResult(this.fTicket, result);
            return result;
        }
    }

    private static class SearchRequestor
    extends TypeNameMatchRequestor {
        private volatile boolean fStop;
        private Set fHistory;
        private TypeInfoFilter fFilter;
        private List fResult = new ArrayList(2048);

        public SearchRequestor(TypeInfoFilter filter) {
            this.fFilter = filter;
        }

        public TypeNameMatch[] getResult() {
            return this.fResult.toArray(new TypeNameMatch[this.fResult.size()]);
        }

        public void cancel() {
            this.fStop = true;
        }

        public void setHistory(Set history) {
            this.fHistory = history;
        }

        public void acceptTypeNameMatch(TypeNameMatch match) {
            if (this.fStop) {
                return;
            }
            if (TypeFilter.isFiltered(match)) {
                return;
            }
            if (this.fHistory.contains(match)) {
                return;
            }
            if (this.fFilter.matchesFilterExtension(match)) {
                this.fResult.add(match);
            }
        }
    }

    private static class SyncJob
    extends AbstractJob {
        public SyncJob(TypeInfoViewer viewer) {
            super(JavaUIMessages.TypeInfoViewer_syncJob_label, viewer);
        }

        public void stop() {
            this.cancel();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus doRun(ProgressMonitor monitor) {
            try {
                try {
                    monitor.setTaskName(JavaUIMessages.TypeInfoViewer_syncJob_taskName);
                    new SearchEngine().searchAllTypeNames(null, 0, "_______________".toCharArray(), 8, 7, SearchEngine.createWorkspaceScope(), new TypeNameRequestor(this){
                        final /* synthetic */ SyncJob this$1;
                        {
                            this.this$1 = syncJob;
                        }
                    }, 3, (IProgressMonitor)monitor);
                }
                catch (JavaScriptModelException e) {
                    JavaScriptPlugin.log(e);
                    Status status = new Status(4, JavaScriptPlugin.getPluginId(), 4, JavaUIMessages.TypeInfoViewer_job_error, (Throwable)e);
                    Object var3_6 = null;
                    this.fViewer.syncJobDone();
                    return status;
                }
                catch (OperationCanceledException e) {
                    Status status = new Status(8, JavaScriptPlugin.getPluginId(), 8, JavaUIMessages.TypeInfoViewer_job_cancel, (Throwable)e);
                    Object var3_7 = null;
                    this.fViewer.syncJobDone();
                    return status;
                }
            }
            catch (Throwable throwable) {
                Object var3_8 = null;
                this.fViewer.syncJobDone();
                throw throwable;
            }
            {
                Object var3_9 = null;
            }
            this.fViewer.syncJobDone();
            return new Status(0, JavaScriptPlugin.getPluginId(), 0, "", null);
        }
    }

    protected static class TypeInfoComparator
    implements Comparator {
        private TypeInfoLabelProvider fLabelProvider;
        private TypeInfoFilter fFilter;

        public TypeInfoComparator(TypeInfoLabelProvider labelProvider, TypeInfoFilter filter) {
            this.fLabelProvider = labelProvider;
            this.fFilter = filter;
        }

        public int compare(Object left, Object right) {
            int rightCategory;
            TypeNameMatch leftInfo = (TypeNameMatch)left;
            TypeNameMatch rightInfo = (TypeNameMatch)right;
            int leftCategory = this.getCamelCaseCategory(leftInfo);
            if (leftCategory < (rightCategory = this.getCamelCaseCategory(rightInfo))) {
                return -1;
            }
            if (leftCategory > rightCategory) {
                return 1;
            }
            int result = this.compareName(leftInfo.getSimpleTypeName(), rightInfo.getSimpleTypeName());
            if (result != 0) {
                return result;
            }
            result = this.compareTypeContainerName(leftInfo.getTypeContainerName(), rightInfo.getTypeContainerName());
            if (result != 0) {
                return result;
            }
            leftCategory = this.getElementTypeCategory(leftInfo);
            if (leftCategory < (rightCategory = this.getElementTypeCategory(rightInfo))) {
                return -1;
            }
            if (leftCategory > rightCategory) {
                return 1;
            }
            return this.compareContainerName(leftInfo, rightInfo);
        }

        private int compareName(String leftString, String rightString) {
            int result = leftString.compareToIgnoreCase(rightString);
            if (result != 0 || rightString.length() == 0) {
                return result;
            }
            if (Strings.isLowerCase(leftString.charAt(0)) && !Strings.isLowerCase(rightString.charAt(0))) {
                return 1;
            }
            if (Strings.isLowerCase(rightString.charAt(0)) && !Strings.isLowerCase(leftString.charAt(0))) {
                return -1;
            }
            return leftString.compareTo(rightString);
        }

        private int compareTypeContainerName(String leftString, String rightString) {
            int leftLength = leftString.length();
            int rightLength = rightString.length();
            if (leftLength == 0 && rightLength > 0) {
                return -1;
            }
            if (leftLength == 0 && rightLength == 0) {
                return 0;
            }
            if (leftLength > 0 && rightLength == 0) {
                return 1;
            }
            return this.compareName(leftString, rightString);
        }

        private int compareContainerName(TypeNameMatch leftType, TypeNameMatch rightType) {
            return this.fLabelProvider.getContainerName(leftType).compareTo(this.fLabelProvider.getContainerName(rightType));
        }

        private int getCamelCaseCategory(TypeNameMatch type) {
            if (this.fFilter == null) {
                return 0;
            }
            if (!this.fFilter.isCamelCasePattern()) {
                return 0;
            }
            return this.fFilter.matchesRawNamePattern(type) ? 0 : 1;
        }

        private int getElementTypeCategory(TypeNameMatch type) {
            try {
                if (type.getPackageFragmentRoot().getKind() == 1) {
                    return 0;
                }
            }
            catch (JavaScriptModelException e) {
                e.printStackTrace();
            }
            return 1;
        }
    }

    protected static class TypeInfoLabelProvider {
        private ITypeInfoImageProvider fProviderExtension;
        private TypeInfoRequestorAdapter fAdapter = new TypeInfoRequestorAdapter();
        private Map fLib2Name = new HashMap();
        private String[] fInstallLocations;
        private String[] fVMNames;
        private boolean fFullyQualifyDuplicates;

        public TypeInfoLabelProvider(ITypeInfoImageProvider extension) {
            this.fProviderExtension = extension;
            ArrayList locations = new ArrayList();
            ArrayList labels = new ArrayList();
            IVMInstallType[] installs = JavaRuntime.getVMInstallTypes();
            int i = 0;
            while (i < installs.length) {
                this.processVMInstallType(installs[i], locations, labels);
                ++i;
            }
            this.fInstallLocations = locations.toArray(new String[locations.size()]);
            this.fVMNames = labels.toArray(new String[labels.size()]);
        }

        public void setFullyQualifyDuplicates(boolean value) {
            this.fFullyQualifyDuplicates = value;
        }

        private void processVMInstallType(IVMInstallType installType, List locations, List labels) {
            if (installType != null) {
                IVMInstall[] installs = installType.getVMInstalls();
                boolean isMac = "macosx".equals(Platform.getOS());
                int i = 0;
                while (i < installs.length) {
                    String label = this.getFormattedLabel(installs[i].getName());
                    LibraryLocation[] libLocations = installs[i].getLibraryLocations();
                    if (libLocations != null) {
                        this.processLibraryLocation(libLocations, label);
                    } else {
                        String filePath = installs[i].getInstallLocation().getAbsolutePath();
                        if (isMac && filePath.endsWith("/Home")) {
                            filePath = filePath.substring(0, filePath.length() - "/Home".length() + 1);
                        }
                        locations.add(filePath);
                        labels.add(label);
                    }
                    ++i;
                }
            }
        }

        private void processLibraryLocation(LibraryLocation[] libLocations, String label) {
            int l = 0;
            while (l < libLocations.length) {
                LibraryLocation location = libLocations[l];
                this.fLib2Name.put(location.getSystemLibraryPath().toString(), label);
                ++l;
            }
        }

        private String getFormattedLabel(String name) {
            return Messages.format(JavaUIMessages.TypeInfoViewer_library_name_format, name);
        }

        public String getText(Object element) {
            return ((TypeNameMatch)element).getSimpleTypeName();
        }

        public String getQualifiedText(TypeNameMatch type) {
            StringBuffer result = new StringBuffer();
            result.append(type.getSimpleTypeName());
            String containerName = type.getTypeContainerName();
            result.append(JavaScriptElementLabels.CONCAT_STRING);
            if (containerName.length() > 0) {
                result.append(containerName);
            } else {
                result.append(JavaUIMessages.TypeInfoViewer_default_package);
            }
            return result.toString();
        }

        public String getFullyQualifiedText(TypeNameMatch type) {
            StringBuffer result = new StringBuffer();
            result.append(type.getSimpleTypeName());
            String containerName = type.getTypeContainerName();
            if (containerName.length() > 0) {
                result.append(JavaScriptElementLabels.CONCAT_STRING);
                result.append(containerName);
            }
            result.append(JavaScriptElementLabels.CONCAT_STRING);
            result.append(this.getContainerName(type));
            return result.toString();
        }

        public String getText(TypeNameMatch last, TypeNameMatch current, TypeNameMatch next) {
            StringBuffer result = new StringBuffer();
            int qualifications = 0;
            String currentTN = current.getSimpleTypeName();
            result.append(currentTN);
            String currentTCN = this.getTypeContainerName(current);
            if (last != null) {
                String lastTN = last.getSimpleTypeName();
                String lastTCN = this.getTypeContainerName(last);
                if (currentTCN.equals(lastTCN)) {
                    if (currentTN.equals(lastTN)) {
                        result.append(JavaScriptElementLabels.CONCAT_STRING);
                        result.append(currentTCN);
                        result.append(JavaScriptElementLabels.CONCAT_STRING);
                        result.append(this.getContainerName(current));
                        return result.toString();
                    }
                } else if (currentTN.equals(lastTN)) {
                    qualifications = 1;
                }
            }
            if (next != null) {
                String nextTN = next.getSimpleTypeName();
                String nextTCN = this.getTypeContainerName(next);
                if (currentTCN.equals(nextTCN)) {
                    if (currentTN.equals(nextTN)) {
                        result.append(JavaScriptElementLabels.CONCAT_STRING);
                        result.append(currentTCN);
                        result.append(JavaScriptElementLabels.CONCAT_STRING);
                        result.append(this.getContainerName(current));
                        return result.toString();
                    }
                } else if (currentTN.equals(nextTN)) {
                    qualifications = 1;
                }
            }
            if (qualifications > 0) {
                result.append(JavaScriptElementLabels.CONCAT_STRING);
                result.append(currentTCN);
                if (this.fFullyQualifyDuplicates) {
                    result.append(JavaScriptElementLabels.CONCAT_STRING);
                    result.append(this.getContainerName(current));
                }
            }
            return result.toString();
        }

        public String getQualificationText(TypeNameMatch type) {
            StringBuffer result = new StringBuffer();
            String containerName = type.getTypeContainerName();
            if (containerName.length() > 0) {
                result.append(containerName);
                result.append(JavaScriptElementLabels.CONCAT_STRING);
            }
            result.append(this.getContainerName(type));
            return result.toString();
        }

        private boolean isInnerType(TypeNameMatch match) {
            return match.getTypeQualifiedName().indexOf(46) != -1;
        }

        public ImageDescriptor getImageDescriptor(Object element) {
            TypeNameMatch type = (TypeNameMatch)element;
            if (this.fProviderExtension != null) {
                this.fAdapter.setMatch(type);
                ImageDescriptor descriptor = this.fProviderExtension.getImageDescriptor(this.fAdapter);
                if (descriptor != null) {
                    return descriptor;
                }
            }
            return JavaElementImageProvider.getTypeImageDescriptor(this.isInnerType(type), false, type.getModifiers(), false);
        }

        private String getTypeContainerName(TypeNameMatch info) {
            String result = info.getTypeContainerName();
            if (result.length() > 0) {
                return result;
            }
            return JavaUIMessages.TypeInfoViewer_default_package;
        }

        private String getContainerName(TypeNameMatch type) {
            IPackageFragmentRoot root = type.getPackageFragmentRoot();
            if (root.isExternal()) {
                String name = root.getPath().toOSString();
                int i = 0;
                while (i < this.fInstallLocations.length) {
                    if (name.startsWith(this.fInstallLocations[i])) {
                        return this.fVMNames[i];
                    }
                    ++i;
                }
                String lib = (String)this.fLib2Name.get(name);
                if (lib != null) {
                    return lib;
                }
            }
            StringBuffer buf = new StringBuffer();
            JavaScriptElementLabels.getPackageFragmentRootLabel(root, 0x30000000000L, buf);
            return buf.toString();
        }
    }
}

