/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.componentcore.util.EARVirtualComponent;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.application.Application;
import org.eclipse.jst.jee.ui.internal.navigator.AbstractGroupProvider;
import org.eclipse.jst.jee.ui.internal.navigator.JEE5ContentProvider;
import org.eclipse.jst.jee.ui.internal.navigator.ear.AbstractEarNode;
import org.eclipse.jst.jee.ui.internal.navigator.ear.GroupEARProvider;
import org.eclipse.jst.jee.ui.plugin.JEEUIPlugin;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class Ear5ContentProvider
extends JEE5ContentProvider {
    public static final String EAR_DEFAULT_LIB = "/lib";

    private List getComponentReferencesAsList(List componentTypes, IVirtualComponent virtualComponent, IPath runtimePath) {
        ArrayList<IVirtualReference> components = new ArrayList<IVirtualReference>();
        IVirtualComponent earComponent = virtualComponent;
        if (earComponent != null) {
            IVirtualReference[] refComponents = earComponent.getReferences();
            int i = 0;
            while (i < refComponents.length) {
                IVirtualComponent module = refComponents[i].getReferencedComponent();
                if (module != null) {
                    if (componentTypes == null || componentTypes.size() == 0) {
                        components.add(refComponents[i]);
                    } else if (componentTypes.contains(JavaEEProjectUtilities.getJ2EEComponentType((IVirtualComponent)module))) {
                        components.add(refComponents[i]);
                    }
                }
                ++i;
            }
        }
        return components;
    }

    public IVirtualReference[] getUtilityModuleReferences(IVirtualComponent component) {
        List explicitUtilityReferences = this.getComponentReferencesAsList(Collections.singletonList("jst.utility"), component, null);
        List<String> implicitUtilityReferenceTypes = Arrays.asList("jst.appclient", "jst.web", "jst.ejb");
        List implicitUtilityReferences = this.getComponentReferencesAsList(implicitUtilityReferenceTypes, component, null);
        ArrayList allUtilityModuleReferences = new ArrayList();
        allUtilityModuleReferences.addAll(explicitUtilityReferences);
        allUtilityModuleReferences.addAll(implicitUtilityReferences);
        if (allUtilityModuleReferences.size() > 0) {
            return allUtilityModuleReferences.toArray(new IVirtualReference[allUtilityModuleReferences.size()]);
        }
        return new IVirtualReference[0];
    }

    public Object[] getChildren(Object aParentElement) {
        ArrayList<GroupEARProvider> children;
        block14: {
            IProject project = null;
            children = new ArrayList<GroupEARProvider>();
            if (aParentElement instanceof GroupEARProvider) {
                project = ((GroupEARProvider)aParentElement).getProject();
                IVirtualComponent projectComponent = ComponentCore.createComponent((IProject)project);
                try {
                    IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                    if (facetedProject == null || !facetedProject.hasProjectFacet(ProjectFacetsManager.getProjectFacet((String)"jst.ear").getVersion("5.0"))) break block14;
                    List libs = this.getComponentReferencesAsList(Collections.singletonList("jst.utility"), projectComponent, (IPath)new Path("//lib"));
                    ArrayList bundledLibs = new ArrayList();
                    ArrayList appLibsInTheRoot = new ArrayList();
                    int i = 0;
                    while (i < libs.size()) {
                        IVirtualReference reference = (IVirtualReference)libs.get(i);
                        IPath runtimePath = reference.getRuntimePath();
                        if (runtimePath != null && runtimePath.segment(0) != null && !runtimePath.isRoot()) {
                            bundledLibs.add(libs.get(i));
                        } else {
                            appLibsInTheRoot.add(libs.get(i));
                        }
                        ++i;
                    }
                    if (J2EEProjectUtilities.isJEEProject((IProject)project)) {
                        String oldLibDir = ((Application)ModelProviderManager.getModelProvider((IProject)project).getModelObject()).getLibraryDirectory();
                        if (oldLibDir == null) {
                            oldLibDir = EAR_DEFAULT_LIB;
                        }
                    }
                }
                catch (CoreException e) {
                    String msg = "Error in the JEEContentProvider.getChildren() for parent:" + aParentElement;
                    JEEUIPlugin.getDefault();
                    JEEUIPlugin.logError(msg, (Exception)((Object)e));
                }
            } else {
                if (aParentElement instanceof AbstractEarNode) {
                    return ((AbstractEarNode)aParentElement).getModules().toArray();
                }
                if (aParentElement instanceof IAdaptable && (project = (IProject)((IAdaptable)aParentElement).getAdapter(IPROJECT_CLASS)) != null && J2EEProjectUtilities.isEARProject((IProject)project)) {
                    try {
                        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                        if (facetedProject != null && facetedProject.hasProjectFacet(ProjectFacetsManager.getProjectFacet((String)"jst.ear").getVersion("5.0"))) {
                            GroupEARProvider element = (GroupEARProvider)this.getCachedContentProvider(project);
                            children.add(element);
                        }
                    }
                    catch (CoreException e) {
                        String msg = "Error in the JEEContentProvider.getChildren() for parent:" + aParentElement;
                        JEEUIPlugin.getDefault();
                        JEEUIPlugin.logError(msg, (Exception)((Object)e));
                    }
                }
            }
        }
        return children.toArray();
    }

    public boolean hasChildren(Object element) {
        if (element instanceof AbstractEarNode) {
            return ((AbstractEarNode)element).getModules().size() > 0;
        }
        return element instanceof GroupEARProvider;
    }

    public Object getParent(Object object) {
        if (object instanceof AbstractEarNode) {
            return ((AbstractEarNode)object).getEarProject();
        }
        return null;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    protected AbstractGroupProvider getNewContentProviderInstance(IProject project) {
        return new GroupEARProvider((Application)this.getCachedModelProvider(project).getModelObject(), (EARVirtualComponent)ComponentCore.createComponent((IProject)project));
    }

    public EarLibVisitor getVisitor() {
        return new EarLibVisitor();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        super.resourceChanged(event);
        if (event.getType() == 1) {
            EarLibVisitor visitor = this.getVisitor();
            if (visitor == null) {
                return;
            }
            try {
                event.getDelta().accept((IResourceDeltaVisitor)visitor);
                Set<IProject> changedProject = visitor.getChangedProject();
                for (IProject project : changedProject) {
                    this.projectChanged(project);
                }
            }
            catch (CoreException e) {
                JEEUIPlugin.logError("Could not refresh changed project.", (Exception)((Object)e));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EarLibVisitor
    implements IResourceDeltaVisitor {
        private Set<IProject> projects = new HashSet<IProject>();

        protected EarLibVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResourceDelta[] affectedChildren = delta.getAffectedChildren(262147);
            if (affectedChildren != null) {
                int i = 0;
                while (i < affectedChildren.length) {
                    if (affectedChildren[i].getResource() != null && affectedChildren[i].getResource().getName() != null && affectedChildren[i].getResource().getName().toLowerCase().endsWith(".jar")) {
                        this.projects.add(affectedChildren[i].getResource().getProject());
                    }
                    ++i;
                }
            }
            return true;
        }

        protected Set<IProject> getChangedProject() {
            return this.projects;
        }
    }
}

