/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import java.text.Collator;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.datatools.connectivity.ConnectEvent;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.IManagedConnectionListener;
import org.eclipse.datatools.connectivity.IManagedConnectionOfflineListener;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.jpt.db.ConnectionListener;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.internal.ConnectionProfileHolder;
import org.eclipse.jpt.db.internal.DTPCatalogWrapper;
import org.eclipse.jpt.db.internal.DTPColumnWrapper;
import org.eclipse.jpt.db.internal.DTPDatabaseWrapper;
import org.eclipse.jpt.db.internal.DTPForeignKeyWrapper;
import org.eclipse.jpt.db.internal.DTPSchemaWrapper;
import org.eclipse.jpt.db.internal.DTPSequenceWrapper;
import org.eclipse.jpt.db.internal.DTPTableWrapper;
import org.eclipse.jpt.db.internal.InternalDatabase;
import org.eclipse.jpt.db.internal.NullDatabase;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;

final class DTPConnectionProfileWrapper
implements ConnectionProfile,
ConnectionProfileHolder {
    private final IConnectionProfile dtpConnectionProfile;
    private final IManagedConnection dtpManagedConnection;
    private final LocalConnectionListener connectionListener;
    private InternalDatabase database;
    public static final String LIVE_DTP_CONNECTION_TYPE = "java.sql.Connection";
    public static final String OFFLINE_DTP_CONNECTION_TYPE = ConnectionInfo.class.getName();
    public static final String DATABASE_PRODUCT_PROP_ID = "org.eclipse.datatools.connectivity.server.version";
    public static final String POSTGRESQL_VENDOR = "postgres";
    public static final String POSTGRESQL_DEFAULT_SCHEMA_NAME = "public";

    DTPConnectionProfileWrapper(IConnectionProfile dtpConnectionProfile) {
        this.dtpConnectionProfile = dtpConnectionProfile;
        this.dtpManagedConnection = this.buildDTPManagedConnection();
        this.connectionListener = new LocalConnectionListener();
        this.dtpManagedConnection.addConnectionListener((IManagedConnectionListener)this.connectionListener);
    }

    private IManagedConnection buildDTPManagedConnection() {
        String connectionType = this.dtpConnectionProfile.supportsWorkOfflineMode() ? OFFLINE_DTP_CONNECTION_TYPE : LIVE_DTP_CONNECTION_TYPE;
        return this.dtpConnectionProfile.getManagedConnection(connectionType);
    }

    public DTPConnectionProfileWrapper getConnectionProfile() {
        return this;
    }

    public String getName() {
        return this.dtpConnectionProfile.getName();
    }

    public boolean isNull() {
        return false;
    }

    public void connect() {
        if (this.isDisconnected()) {
            this.checkStatus(this.dtpConnectionProfile.connect());
        }
    }

    public void disconnect() {
        this.checkStatus(this.dtpConnectionProfile.disconnect());
    }

    public boolean isActive() {
        return this.isConnected() || this.isWorkingOffline();
    }

    public boolean isInactive() {
        return !this.isActive();
    }

    public boolean isConnected() {
        return this.dtpManagedConnection.isConnected() && !this.dtpManagedConnection.isWorkingOffline();
    }

    public boolean isDisconnected() {
        return !this.isConnected();
    }

    public boolean isWorkingOffline() {
        return this.dtpManagedConnection.isWorkingOffline();
    }

    public boolean supportsWorkOfflineMode() {
        return this.dtpConnectionProfile.supportsWorkOfflineMode();
    }

    public boolean canWorkOffline() {
        return this.dtpConnectionProfile.canWorkOffline();
    }

    public IStatus saveWorkOfflineData() {
        return this.dtpConnectionProfile.saveWorkOfflineData();
    }

    public IStatus workOffline() {
        return this.dtpConnectionProfile.workOffline();
    }

    public String getDatabaseVendor() {
        return this.getProperty("org.eclipse.datatools.connectivity.db.vendor");
    }

    public String getDatabaseName() {
        return this.getProperty("org.eclipse.datatools.connectivity.db.databaseName");
    }

    public String getDatabaseProduct() {
        return this.getProperty(DATABASE_PRODUCT_PROP_ID);
    }

    public String getDatabaseVersion() {
        return this.getProperty("org.eclipse.datatools.connectivity.db.version");
    }

    public String getUserName() {
        String userName = this.getProperty("org.eclipse.datatools.connectivity.db.username");
        if (userName.contains(" ")) {
            return userName.split("\\s")[0];
        }
        return userName;
    }

    public String getUserPassword() {
        return this.getProperty("org.eclipse.datatools.connectivity.db.password");
    }

    public synchronized InternalDatabase getDatabase() {
        if (this.database == null) {
            this.database = this.buildDatabase();
        }
        return this.database;
    }

    public DTPCatalogWrapper getDefaultCatalog() {
        return this.getDatabase().getDefaultCatalog();
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.connectionListener.addConnectionListener(listener);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this.connectionListener.removeConnectionListener(listener);
    }

    public Schema getDefaultSchema() {
        return this.getDatabase().schemaNamed(this.getDefaultSchemaName());
    }

    public String getDriverClassName() {
        return this.getProperty("org.eclipse.datatools.connectivity.db.driverClass");
    }

    public String getUrl() {
        return this.getProperty("org.eclipse.datatools.connectivity.db.URL");
    }

    public String getInstanceID() {
        return this.dtpConnectionProfile.getInstanceID();
    }

    public String getProviderID() {
        return this.dtpConnectionProfile.getProviderId();
    }

    public String getDriverDefinitionID() {
        return this.getProperty("org.eclipse.datatools.connectivity.driverDefinitionID");
    }

    public String getDriverJarList() {
        return DriverManager.getInstance().getDriverInstanceByID(this.getDriverDefinitionID()).getJarList();
    }

    private void checkStatus(IStatus status) {
        if (status.isOK()) {
            return;
        }
        if (status.isMultiStatus()) {
            status = status.getChildren()[0];
        }
        throw new RuntimeException(status.getMessage(), status.getException());
    }

    private InternalDatabase buildDatabase() {
        if (this.isInactive()) {
            return NullDatabase.instance();
        }
        if (this.isWorkingOffline()) {
            ConnectionInfo connectionInfo = (ConnectionInfo)this.dtpManagedConnection.getConnection().getRawConnection();
            return new DTPDatabaseWrapper(this, connectionInfo.getSharedDatabase());
        }
        return new DTPDatabaseWrapper(this, ProfileUtil.getDatabase((DatabaseIdentifier)new DatabaseIdentifier(this.getName(), this.getDatabaseName()), (boolean)true));
    }

    boolean wraps(IConnectionProfile dtpCP) {
        return this.dtpConnectionProfile == dtpCP;
    }

    void databaseChanged(DTPDatabaseWrapper db, int eventType) {
        this.connectionListener.databaseChanged(db, eventType);
    }

    void catalogChanged(DTPCatalogWrapper catalog, int eventType) {
        this.connectionListener.catalogChanged(catalog, eventType);
    }

    void schemaChanged(DTPSchemaWrapper schema, int eventType) {
        this.connectionListener.schemaChanged(schema, eventType);
    }

    void sequenceChanged(DTPSequenceWrapper sequence, int eventType) {
        this.connectionListener.sequenceChanged(sequence, eventType);
    }

    void tableChanged(DTPTableWrapper table, int eventType) {
        this.connectionListener.tableChanged(table, eventType);
    }

    void columnChanged(DTPColumnWrapper column, int eventType) {
        this.connectionListener.columnChanged(column, eventType);
    }

    void foreignKeyChanged(DTPForeignKeyWrapper foreignKey, int eventType) {
        this.connectionListener.foreignKeyChanged(foreignKey, eventType);
    }

    private String getDefaultSchemaName() {
        if (this.getDatabase().getVendor().equalsIgnoreCase(POSTGRESQL_VENDOR)) {
            return POSTGRESQL_DEFAULT_SCHEMA_NAME;
        }
        return this.getUserName();
    }

    private String getProperty(String propertyName) {
        return this.dtpConnectionProfile.getBaseProperties().getProperty(propertyName);
    }

    synchronized void dispose() {
        this.disposeDatabase();
        this.dtpManagedConnection.removeConnectionListener((IManagedConnectionListener)this.connectionListener);
    }

    synchronized void disposeDatabase() {
        if (this.database != null) {
            this.database.dispose();
            this.database = null;
        }
    }

    public int compareTo(ConnectionProfile connectionProfile) {
        return Collator.getInstance().compare(this.getName(), connectionProfile.getName());
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LocalConnectionListener
    implements IManagedConnectionOfflineListener {
        private Vector<ConnectionListener> listeners = new Vector();

        LocalConnectionListener() {
        }

        void addConnectionListener(ConnectionListener listener) {
            this.listeners.add(listener);
        }

        void removeConnectionListener(ConnectionListener listener) {
            this.listeners.remove(listener);
        }

        private Iterator<ConnectionListener> listeners() {
            return new CloneIterator(this.listeners);
        }

        public void opened(ConnectEvent event) {
            DTPConnectionProfileWrapper.this.disposeDatabase();
            Iterator<ConnectionListener> stream = this.listeners();
            while (stream.hasNext()) {
                stream.next().opened(DTPConnectionProfileWrapper.this);
            }
        }

        public void modified(ConnectEvent event) {
            Iterator<ConnectionListener> stream = this.listeners();
            while (stream.hasNext()) {
                stream.next().modified(DTPConnectionProfileWrapper.this);
            }
        }

        public boolean okToClose(ConnectEvent event) {
            Iterator<ConnectionListener> stream = this.listeners();
            while (stream.hasNext()) {
                if (stream.next().okToClose(DTPConnectionProfileWrapper.this)) continue;
                return false;
            }
            return true;
        }

        public void aboutToClose(ConnectEvent event) {
            Iterator<ConnectionListener> stream = this.listeners();
            while (stream.hasNext()) {
                stream.next().aboutToClose(DTPConnectionProfileWrapper.this);
            }
        }

        public void closed(ConnectEvent event) {
            DTPConnectionProfileWrapper.this.disposeDatabase();
            Iterator<ConnectionListener> stream = this.listeners();
            while (stream.hasNext()) {
                stream.next().closed(DTPConnectionProfileWrapper.this);
            }
        }

        public boolean okToDetach(ConnectEvent event) {
            return true;
        }

        public void aboutToDetach(ConnectEvent event) {
        }

        public void workingOffline(ConnectEvent event) {
            DTPConnectionProfileWrapper.this.disposeDatabase();
            Iterator<ConnectionListener> stream = this.listeners();
            while (stream.hasNext()) {
                stream.next().opened(DTPConnectionProfileWrapper.this);
            }
        }

        public void aboutToAttach(ConnectEvent event) {
        }

        void databaseChanged(DTPDatabaseWrapper db, int eventType) {
            Iterator<ConnectionListener> stream = this.listeners();
            while (stream.hasNext()) {
                stream.next().databaseChanged(DTPConnectionProfileWrapper.this, db);
            }
        }

        void catalogChanged(DTPCatalogWrapper catalog, int eventType) {
            Iterator<ConnectionListener> stream = this.listeners();
            while (stream.hasNext()) {
                stream.next().catalogChanged(DTPConnectionProfileWrapper.this, catalog);
            }
        }

        void schemaChanged(DTPSchemaWrapper schema, int eventType) {
            Iterator<ConnectionListener> stream = this.listeners();
            while (stream.hasNext()) {
                stream.next().schemaChanged(DTPConnectionProfileWrapper.this, schema);
            }
        }

        void sequenceChanged(DTPSequenceWrapper sequence, int eventType) {
            Iterator<ConnectionListener> stream = this.listeners();
            while (stream.hasNext()) {
                stream.next().sequenceChanged(DTPConnectionProfileWrapper.this, sequence);
            }
        }

        void tableChanged(DTPTableWrapper table, int eventType) {
            Iterator<ConnectionListener> stream = this.listeners();
            while (stream.hasNext()) {
                stream.next().tableChanged(DTPConnectionProfileWrapper.this, table);
            }
        }

        void columnChanged(DTPColumnWrapper column, int eventType) {
            Iterator<ConnectionListener> stream = this.listeners();
            while (stream.hasNext()) {
                stream.next().columnChanged(DTPConnectionProfileWrapper.this, column);
            }
        }

        void foreignKeyChanged(DTPForeignKeyWrapper foreignKey, int eventType) {
            Iterator<ConnectionListener> stream = this.listeners();
            while (stream.hasNext()) {
                stream.next().foreignKeyChanged(DTPConnectionProfileWrapper.this, foreignKey);
            }
        }
    }
}

