/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.el.operators;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.common.internal.types.LiteralType;
import org.eclipse.jst.jsf.common.internal.types.NullLiteralType;
import org.eclipse.jst.jsf.common.internal.types.SignatureBasedType;
import org.eclipse.jst.jsf.common.internal.types.TypeCoercer;
import org.eclipse.jst.jsf.common.internal.types.ValueType;
import org.eclipse.jst.jsf.context.symbol.IMethodSymbol;
import org.eclipse.jst.jsf.context.symbol.IObjectSymbol;
import org.eclipse.jst.jsf.context.symbol.IPropertySymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.internal.util.IMethodSymbolBasedType;
import org.eclipse.jst.jsf.context.symbol.internal.util.IObjectSymbolBasedValueType;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.designtime.DesignTimeApplicationManager;
import org.eclipse.jst.jsf.designtime.el.AbstractDTMethodResolver;
import org.eclipse.jst.jsf.designtime.el.AbstractDTPropertyResolver;
import org.eclipse.jst.jsf.validation.internal.el.diagnostics.DiagnosticFactory;

public abstract class MemberAccessorOperator {
    protected final IFile _file;
    protected final DiagnosticFactory _diagnosticFactory;

    protected MemberAccessorOperator(IFile file, DiagnosticFactory diagnosticFactory) {
        this._file = file;
        this._diagnosticFactory = diagnosticFactory;
    }

    public Diagnostic validate(ValueType firstArg, ValueType secondArg) {
        if ("Ljava.lang.Object;".equals(firstArg.getSignature())) {
            return Diagnostic.OK_INSTANCE;
        }
        if (!(firstArg instanceof IObjectSymbolBasedValueType)) {
            throw new AssertionError((Object)"The first argument of the member operator must always be a symbol resolvable value type");
        }
        if (TypeCoercer.typeIsNull((String)secondArg.getSignature())) {
            return this._diagnosticFactory.create_BINARY_OP_DOT_WITH_VALUEB_NULL(this.getOperatorName());
        }
        return this.validateObjectSymbolValue((IObjectSymbolBasedValueType)firstArg, secondArg);
    }

    protected abstract Diagnostic validateObjectSymbolValue(IObjectSymbolBasedValueType var1, ValueType var2);

    protected Diagnostic validateNamedPropertyAccessorBase(IObjectSymbolBasedValueType firstArg, LiteralType secondArg) {
        IObjectSymbol curBaseSymbol = firstArg.getSymbol();
        ISymbol nextSymbol = this.getMemberSymbol(firstArg.getSymbol(), secondArg.getLiteralValueRaw());
        if (curBaseSymbol.supportsCoercion("Ljava.util.Map;") && nextSymbol instanceof IPropertySymbol && "Ljava.lang.Object;".equals(((IPropertySymbol)nextSymbol).getTypeDescriptor().getTypeSignature())) {
            return Diagnostic.OK_INSTANCE;
        }
        if (nextSymbol == null) {
            return this._diagnosticFactory.create_MEMBER_NOT_FOUND(secondArg.getLiteralValue(), firstArg.getSymbol().getName());
        }
        return Diagnostic.OK_INSTANCE;
    }

    public SignatureBasedType performOperation(ValueType firstArg, ValueType secondArg) {
        if (!(firstArg instanceof IObjectSymbolBasedValueType)) {
            return null;
        }
        if (TypeCoercer.typeIsNull((String)secondArg.getSignature())) {
            return null;
        }
        return this.handlePerformObjectSymbolValue((IObjectSymbolBasedValueType)firstArg, secondArg);
    }

    protected abstract SignatureBasedType handlePerformObjectSymbolValue(IObjectSymbolBasedValueType var1, ValueType var2);

    protected SignatureBasedType handlePerformNamedPropertyAccessorBase(IObjectSymbolBasedValueType firstArg, LiteralType secondArg) {
        ISymbol symbol = this.getMemberSymbol(firstArg.getSymbol(), secondArg.getLiteralValueRaw());
        if (symbol instanceof IPropertySymbol) {
            return new IObjectSymbolBasedValueType((IPropertySymbol)symbol);
        }
        if (symbol instanceof IMethodSymbol) {
            return new IMethodSymbolBasedType((IMethodSymbol)symbol);
        }
        if (firstArg.isInstanceOf("Ljava.util.Map;")) {
            return NullLiteralType.SINGLETON;
        }
        return null;
    }

    protected final ISymbol getMemberSymbol(IObjectSymbol symbol, Object name) {
        ISymbol memberSymbol = this.getPropertySymbol((ISymbol)symbol, name);
        if (memberSymbol != null) {
            return memberSymbol;
        }
        memberSymbol = this.getMethodSymbol(symbol, name);
        if (memberSymbol != null) {
            return memberSymbol;
        }
        return null;
    }

    protected final ISymbol getPropertySymbol(ISymbol symbol, Object name) {
        AbstractDTPropertyResolver resolver = this.getPropertyResolver();
        if (resolver != null) {
            return resolver.getProperty(symbol, name);
        }
        JSFCorePlugin.log("Error acquiring property resolver", new Throwable());
        return null;
    }

    protected final IMethodSymbol getMethodSymbol(IObjectSymbol symbol, Object name) {
        AbstractDTMethodResolver resolver = this.getMethodResolver();
        if (resolver != null) {
            return resolver.getMethod(symbol, name);
        }
        JSFCorePlugin.log("Error acquiring property resolver", new Throwable());
        return null;
    }

    protected final AbstractDTPropertyResolver getPropertyResolver() {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance(this._file.getProject());
        if (manager != null) {
            return manager.getPropertyResolver();
        }
        return null;
    }

    protected final AbstractDTMethodResolver getMethodResolver() {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance(this._file.getProject());
        if (manager != null) {
            return manager.getMethodResolver();
        }
        return null;
    }

    protected abstract String getOperatorName();
}

