/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.project.facet;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.common.project.facet.core.ClasspathHelper;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.Messages;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFFacetException;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFUtils;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFUtils11;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFUtils12;
import org.eclipse.jst.jsf.core.jsflibraryconfiguration.JSFLibraryConfigurationHelper;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public final class JSFFacetUninstallDelegate
implements IDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            IModelProvider provider = JSFUtils.getModelProvider(project);
            if (provider == null) {
                throw new JSFFacetException(NLS.bind((String)Messages.JSFFacetUninstallDelegate_ConfigErr, (Object)project.getName()));
            }
            if (!provider.validateEdit(null, null).isOK()) {
                throw new JSFFacetException(NLS.bind((String)Messages.JSFFacetUninstallDelegate_NonUpdateableWebXML, (Object)project.getName()));
            }
            this.removeJSFLibraries(project, fv, monitor);
            this.removeRuntimeContributedJSFClasspathEntries(project, fv, monitor);
            this.uninstallJSFReferencesFromWebApp(project, monitor);
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void removeJSFLibraries(IProject project, IProjectFacetVersion fv, IProgressMonitor monitor) {
        IJavaProject jproj = JavaCore.create((IProject)project);
        ArrayList<IClasspathEntry> keptEntries = new ArrayList<IClasspathEntry>();
        try {
            IClasspathEntry[] entries = jproj.getRawClasspath();
            keptEntries = new ArrayList();
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry entry = entries[i];
                if (!JSFLibraryConfigurationHelper.isJSFLibraryContainer(entry)) {
                    keptEntries.add(entry);
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            JSFCorePlugin.log((Exception)((Object)e), "Cannot get classpath entries to remove JSF Libraries for: " + project.getName());
        }
        if (keptEntries.size() > 0) {
            try {
                jproj.setRawClasspath(keptEntries.toArray(new IClasspathEntry[0]), monitor);
            }
            catch (JavaModelException e) {
                JSFCorePlugin.log((Exception)((Object)e), "Exception occured while removing JSF Libraries during JSF Facet uninstall");
            }
        }
    }

    private void removeRuntimeContributedJSFClasspathEntries(IProject project, IProjectFacetVersion fv, IProgressMonitor monitor) {
        try {
            ClasspathHelper.removeClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
        }
        catch (CoreException e) {
            JSFCorePlugin.log(4, "Unable to remove server supplied implementation from the classpath.", e);
        }
    }

    private void uninstallJSFReferencesFromWebApp(IProject project, IProgressMonitor monitor) {
        IModelProvider provider = JSFUtils.getModelProvider(project);
        Object webAppObj = provider.getModelObject();
        if (webAppObj != null) {
            IPath ddPath = new Path("WEB-INF").append("web.xml");
            if (this.isJavaEEWebApp(webAppObj)) {
                WebApp webApp = (WebApp)webAppObj;
                org.eclipse.jst.javaee.web.Servlet servlet = JSFUtils12.findJSFServlet(webApp);
                if (servlet == null) {
                    return;
                }
                provider.modify((Runnable)new RemoveJSFFromJavaEEWebAppOperation(project), ddPath);
            } else {
                org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)webAppObj;
                Servlet servlet = JSFUtils11.findJSFServlet(webApp);
                if (servlet == null) {
                    return;
                }
                provider.modify((Runnable)new RemoveJSFFromJ2EEWebAppOperation(project), ddPath);
            }
        }
    }

    private boolean isJavaEEWebApp(Object webAppObj) {
        return webAppObj instanceof WebApp;
    }

    static class RemoveJSFFromJ2EEWebAppOperation
    implements Runnable {
        private IProject _project;

        RemoveJSFFromJ2EEWebAppOperation(IProject project) {
            this._project = project;
        }

        public void run() {
            org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)ModelProviderManager.getModelProvider((IProject)this._project).getModelObject();
            Servlet servlet = JSFUtils11.findJSFServlet(webApp);
            JSFUtils11.removeURLMappings(webApp, servlet);
            this.removeJSFContextParams(webApp, servlet);
            this.removeJSFServlet(webApp, servlet);
        }

        private void removeJSFContextParams(org.eclipse.jst.j2ee.webapplication.WebApp webApp, Servlet servlet) {
            for (ParamValue cp : webApp.getContextParams()) {
                if (!cp.getName().equals("javax.faces.CONFIG_FILES")) continue;
                webApp.getContextParams().remove((Object)cp);
                break;
            }
        }

        private void removeJSFServlet(org.eclipse.jst.j2ee.webapplication.WebApp webApp, Servlet servlet) {
            webApp.getServlets().remove((Object)servlet);
        }
    }

    static class RemoveJSFFromJavaEEWebAppOperation
    implements Runnable {
        private IProject _project;

        RemoveJSFFromJavaEEWebAppOperation(IProject project) {
            this._project = project;
        }

        public void run() {
            WebApp webApp = (WebApp)ModelProviderManager.getModelProvider((IProject)this._project).getModelObject();
            org.eclipse.jst.javaee.web.Servlet servlet = JSFUtils12.findJSFServlet(webApp);
            JSFUtils12.removeURLMappings(webApp, servlet);
            this.removeJSFContextParams(webApp, servlet);
            this.removeJSFServlet(webApp, servlet);
        }

        private void removeJSFContextParams(WebApp webApp, org.eclipse.jst.javaee.web.Servlet servlet) {
            for (org.eclipse.jst.javaee.core.ParamValue cp : webApp.getContextParams()) {
                if (!cp.getParamName().equals("javax.faces.CONFIG_FILES")) continue;
                webApp.getContextParams().remove(cp);
                break;
            }
        }

        private void removeJSFServlet(WebApp webApp, org.eclipse.jst.javaee.web.Servlet servlet) {
            webApp.getServlets().remove(servlet);
        }
    }
}

