/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedCorrectionProposal;

public class ImplementInterfaceProposal
extends LinkedCorrectionProposal {
    private IBinding fBinding;
    private JavaScriptUnit fAstRoot;
    private ITypeBinding fNewInterface;

    public ImplementInterfaceProposal(IJavaScriptUnit targetCU, ITypeBinding binding, JavaScriptUnit astRoot, ITypeBinding newInterface, int relevance) {
        super("", targetCU, (ASTRewrite)null, relevance, JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif"));
        Assert.isTrue((binding != null && Bindings.isDeclarationBinding((IBinding)binding) ? 1 : 0) != 0);
        this.fBinding = binding;
        this.fAstRoot = astRoot;
        this.fNewInterface = newInterface;
        Object[] args = new String[]{binding.getName(), Bindings.getRawName(newInterface)};
        this.setDisplayName(Messages.format(CorrectionMessages.ImplementInterfaceProposal_name, args));
    }

    protected ASTRewrite getRewrite() throws CoreException {
        ASTNode boundNode = this.fAstRoot.findDeclaringNode(this.fBinding);
        ASTNode declNode = null;
        JavaScriptUnit newRoot = this.fAstRoot;
        if (boundNode != null) {
            declNode = boundNode;
        } else {
            newRoot = ASTResolving.createQuickFixAST(this.getCompilationUnit(), null);
            declNode = newRoot.findDeclaringNode(this.fBinding.getKey());
        }
        ImportRewrite imports = this.createImportRewrite(newRoot);
        if (declNode instanceof TypeDeclaration) {
            AST ast = declNode.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            Type newInterface = imports.addImport(this.fNewInterface, ast);
            ListRewrite listRewrite = rewrite.getListRewrite(declNode, TypeDeclaration.SUPER_INTERFACE_TYPES_PROPERTY);
            listRewrite.insertLast((ASTNode)newInterface, null);
            this.addLinkedPosition(rewrite.track((ASTNode)newInterface), true, "type");
            return rewrite;
        }
        return null;
    }
}

