/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.TypeVariableMaplet;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;

public final class TypeVariableUtil {
    public static TypeVariableMaplet[] composeMappings(TypeVariableMaplet[] first, TypeVariableMaplet[] second) {
        Assert.isNotNull((Object)first);
        Assert.isNotNull((Object)second);
        if (first.length == 0) {
            return first;
        }
        if (second.length == 0) {
            return second;
        }
        TypeVariableMaplet source = null;
        TypeVariableMaplet target = null;
        HashSet<TypeVariableMaplet> set = new HashSet<TypeVariableMaplet>(first.length * second.length);
        int index = 0;
        while (index < first.length) {
            int offset = 0;
            while (offset < second.length) {
                source = first[index];
                target = second[offset];
                if (source.getTargetIndex() == target.getSourceIndex() && source.getTargetName().equals(target.getSourceName())) {
                    set.add(new TypeVariableMaplet(source.getSourceName(), index, target.getTargetName(), offset));
                }
                ++offset;
            }
            ++index;
        }
        TypeVariableMaplet[] mapping = new TypeVariableMaplet[set.size()];
        set.toArray(mapping);
        return mapping;
    }

    private static void extractTypeVariables(String signature, Set variables) {
        Assert.isNotNull((Object)signature);
        Assert.isNotNull((Object)variables);
        String[] arguments = Signature.getTypeArguments((String)signature);
        if (arguments.length == 0) {
            variables.add(Signature.toString((String)signature));
        } else {
            int index = 0;
            while (index < arguments.length) {
                variables.add(Signature.toString((String)arguments[index]));
                ++index;
            }
        }
    }

    private static String[] getReferencedVariables(IType declaring, IMember member) throws JavaScriptModelException {
        Assert.isNotNull((Object)declaring);
        Assert.isNotNull((Object)member);
        String[] variables = TypeVariableUtil.parametersToVariables(declaring.getTypeParameters());
        String[] result = new String[]{};
        if (member instanceof IField) {
            String signature = ((IField)member).getTypeSignature();
            String[] signatures = TypeVariableUtil.getVariableSignatures(signature);
            if (signatures.length == 0) {
                String variable = Signature.toString((String)signature);
                int index = 0;
                while (index < variables.length) {
                    if (variable.equals(variables[index])) {
                        result = new String[]{variable};
                        break;
                    }
                    ++index;
                }
            } else {
                result = new String[signatures.length];
                int index = 0;
                while (index < result.length) {
                    result[index] = Signature.toString((String)signatures[index]);
                    ++index;
                }
            }
        } else if (member instanceof IFunction) {
            IFunction method = (IFunction)member;
            HashSet<String> set = new HashSet<String>();
            String[] types = method.getParameterTypes();
            int index = 0;
            while (index < types.length) {
                TypeVariableUtil.extractTypeVariables(types[index], set);
                ++index;
            }
            TypeVariableUtil.extractTypeVariables(method.getReturnType(), set);
            String[] arguments = TypeVariableUtil.parametersToVariables(((IFunction)member).getTypeParameters());
            int index2 = 0;
            while (index2 < arguments.length) {
                set.add(arguments[index2]);
                ++index2;
            }
            result = new String[set.size()];
            set.toArray(result);
        } else if (member instanceof IType) {
            result = TypeVariableUtil.parametersToVariables(((IType)member).getTypeParameters());
        } else {
            JavaScriptPlugin.logErrorMessage("Unexpected sub-type of IMember: " + member.getClass().getName());
            Assert.isTrue((boolean)false);
        }
        ArrayList<String> list = new ArrayList<String>(variables.length);
        String variable = null;
        int index = 0;
        while (index < variables.length) {
            variable = variables[index];
            int offset = 0;
            while (offset < result.length) {
                if (variable.equals(result[offset])) {
                    list.add(result[offset]);
                }
                ++offset;
            }
            ++index;
        }
        result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    public static String[] getUnmappedVariables(TypeVariableMaplet[] mapping, IType declaring, IMember member) throws JavaScriptModelException {
        Assert.isNotNull((Object)mapping);
        Assert.isNotNull((Object)declaring);
        Assert.isNotNull((Object)member);
        ArrayList<String> list = null;
        String[] types = TypeVariableUtil.getReferencedVariables(declaring, member);
        if (mapping.length == 0) {
            list = new ArrayList<String>(types.length);
            list.addAll(Arrays.asList(types));
        } else {
            HashSet<String> mapped = new HashSet<String>(types.length);
            String type = null;
            int index = 0;
            while (index < types.length) {
                int offset = 0;
                while (offset < mapping.length) {
                    type = types[index];
                    if (mapping[offset].getSourceName().equals(type)) {
                        mapped.add(type);
                    }
                    ++offset;
                }
                ++index;
            }
            list = new ArrayList(types.length - mapped.size());
            index = 0;
            while (index < types.length) {
                type = types[index];
                if (!mapped.contains(type)) {
                    list.add(type);
                }
                ++index;
            }
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    private static String[] getVariableSignatures(String signature) {
        Assert.isNotNull((Object)signature);
        String[] result = null;
        try {
            result = Signature.getTypeArguments((String)signature);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            result = new String[]{};
        }
        return result;
    }

    public static TypeVariableMaplet[] inverseMapping(TypeVariableMaplet[] mapping) {
        Assert.isNotNull((Object)mapping);
        TypeVariableMaplet[] result = new TypeVariableMaplet[mapping.length];
        TypeVariableMaplet maplet = null;
        int index = 0;
        while (index < mapping.length) {
            maplet = mapping[index];
            result[index] = new TypeVariableMaplet(maplet.getTargetName(), maplet.getTargetIndex(), maplet.getSourceName(), maplet.getSourceIndex());
            ++index;
        }
        return result;
    }

    private static TypeVariableMaplet[] parametersToSignatures(ITypeParameter[] domain, String[] range, boolean indexes) {
        Assert.isNotNull((Object)domain);
        Assert.isNotNull((Object)range);
        HashSet<TypeVariableMaplet> set = new HashSet<TypeVariableMaplet>();
        ITypeParameter source = null;
        String target = null;
        String element = null;
        String signature = null;
        int index = 0;
        while (index < domain.length) {
            source = domain[index];
            int offset = 0;
            while (offset < range.length) {
                target = range[offset];
                element = source.getElementName();
                signature = Signature.toString((String)target);
                if (indexes) {
                    if (offset == index) {
                        set.add(new TypeVariableMaplet(element, index, signature, offset));
                    }
                } else if (element.equals(signature)) {
                    set.add(new TypeVariableMaplet(element, index, signature, offset));
                }
                ++offset;
            }
            ++index;
        }
        TypeVariableMaplet[] result = new TypeVariableMaplet[set.size()];
        set.toArray(result);
        return result;
    }

    private static String[] parametersToVariables(ITypeParameter[] parameters) {
        Assert.isNotNull((Object)parameters);
        String[] result = new String[parameters.length];
        int index = 0;
        while (index < parameters.length) {
            result[index] = parameters[index].getElementName();
            ++index;
        }
        return result;
    }

    private static TypeVariableMaplet[] signaturesToParameters(String[] domain, ITypeParameter[] range) {
        Assert.isNotNull((Object)domain);
        Assert.isNotNull((Object)range);
        Assert.isTrue((domain.length == 0 || domain.length == range.length ? 1 : 0) != 0);
        ArrayList<TypeVariableMaplet> list = new ArrayList<TypeVariableMaplet>();
        String source = null;
        String target = null;
        int index = 0;
        while (index < domain.length) {
            source = Signature.toString((String)domain[index]);
            target = range[index].getElementName();
            list.add(new TypeVariableMaplet(source, index, target, index));
            ++index;
        }
        TypeVariableMaplet[] result = new TypeVariableMaplet[list.size()];
        list.toArray(result);
        return result;
    }

    public static TypeVariableMaplet[] subTypeToInheritedType(IType type) throws JavaScriptModelException {
        String[] range;
        String signature;
        Assert.isNotNull((Object)type);
        ITypeParameter[] domain = type.getTypeParameters();
        if (domain.length > 0 && (signature = type.getSuperclassTypeSignature()) != null && (range = TypeVariableUtil.getVariableSignatures(signature)).length > 0) {
            return TypeVariableUtil.parametersToSignatures(domain, range, false);
        }
        return new TypeVariableMaplet[0];
    }

    public static TypeVariableMaplet[] subTypeToSuperType(IType subtype, IType supertype) throws JavaScriptModelException {
        String[] domain;
        String signature;
        ITypeParameter[] range;
        Assert.isNotNull((Object)subtype);
        Assert.isNotNull((Object)supertype);
        TypeVariableMaplet[] mapping = TypeVariableUtil.subTypeToInheritedType(subtype);
        if (mapping.length > 0 && (range = supertype.getTypeParameters()).length > 0 && (signature = subtype.getSuperclassTypeSignature()) != null && (domain = TypeVariableUtil.getVariableSignatures(signature)).length > 0) {
            return TypeVariableUtil.composeMappings(mapping, TypeVariableUtil.signaturesToParameters(domain, range));
        }
        return mapping;
    }

    public static TypeVariableMaplet[] superTypeToInheritedType(IType supertype, IType subtype) throws JavaScriptModelException {
        String[] range;
        String signature;
        Assert.isNotNull((Object)subtype);
        Assert.isNotNull((Object)supertype);
        ITypeParameter[] domain = supertype.getTypeParameters();
        if (domain.length > 0 && (signature = subtype.getSuperclassTypeSignature()) != null && (range = TypeVariableUtil.getVariableSignatures(signature)).length > 0) {
            return TypeVariableUtil.parametersToSignatures(domain, range, true);
        }
        return new TypeVariableMaplet[0];
    }

    public static TypeVariableMaplet[] superTypeToSubType(IType supertype, IType subtype) throws JavaScriptModelException {
        Assert.isNotNull((Object)supertype);
        Assert.isNotNull((Object)subtype);
        return TypeVariableUtil.inverseMapping(TypeVariableUtil.subTypeToSuperType(subtype, supertype));
    }

    private TypeVariableUtil() {
    }
}

