/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jem.internal.adapters.jdom.JavaJDOMAdapterFactory;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaVisibilityKind;
import org.eclipse.jem.java.util.NotificationUtil;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.emf.workbench.nature.EMFNature;
import org.eclipse.jst.j2ee.ejb.CMPAttribute;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.internal.impl.EjbFactoryImpl;

public class CMPJavaChangeSynchronizationAdapter
extends AdapterImpl {
    private static final String J2EE_PROJ_MIGRATION_ADAPTER = "J2EEProjectMigration";
    protected static EjbPackage EJB_PACK = EjbFactoryImpl.getPackage();
    private static HashMap enablementMap = new HashMap();
    protected Resource cmpResource;
    private List foundKeys = new ArrayList();
    private Set updatingSet = new HashSet();

    public static void disable(ContainerManagedEntity cmp) {
        enablementMap.put(cmp, Boolean.FALSE);
    }

    public static void enable(ContainerManagedEntity cmp) {
        enablementMap.put(cmp, Boolean.TRUE);
    }

    public static boolean isEnabled(ContainerManagedEntity cmp) {
        if (!enablementMap.containsKey(cmp)) {
            return true;
        }
        return (Boolean)enablementMap.get(cmp);
    }

    public void notifyChanged(Notification msg) {
        if (!CMPJavaChangeSynchronizationAdapter.isEnabled(this.getCMP())) {
            CMPJavaChangeSynchronizationAdapter.enable(this.getCMP());
            return;
        }
        Object notifier = msg.getNotifier();
        if (!this.updatingSet.contains(notifier)) {
            try {
                this.updatingSet.add(notifier);
                switch (msg.getEventType()) {
                    case 1: {
                        this.setNotification(msg);
                        break;
                    }
                    case 2: {
                        this.unsetNotification(msg);
                        break;
                    }
                    case 8: {
                        this.removeAdapterNotification(msg);
                        break;
                    }
                    case -3456: {
                        this.jemFlushNotification(msg);
                    }
                }
            }
            finally {
                this.updatingSet.remove(notifier);
            }
        }
    }

    protected void setNotification(Notification msg) {
        EStructuralFeature sf = (EStructuralFeature)msg.getFeature();
        if (sf == EJB_PACK.getEnterpriseBean_EjbClass() || sf == EJB_PACK.getEntity_PrimaryKey()) {
            if (!this.isMigrating()) {
                this.removeAttributeMaintenanceAdapter((Notifier)msg.getOldValue());
                this.addAttributeMaintenanceAdapter((Notifier)msg.getNewValue());
                this.touchKeyShapeAdapter(msg);
            }
        } else if (sf == EJB_PACK.getEntity_PrimaryKey()) {
            this.removeAttributeMaintenanceAdapter((Notifier)msg.getOldValue());
            if (this.shouldAddToPrimaryKeyClass((ContainerManagedEntity)this.getTarget())) {
                this.addAttributeMaintenanceAdapter((Notifier)msg.getNewValue());
            }
        } else {
            this.jemFlushNotification(msg);
        }
    }

    private boolean isMigrating() {
        EJBJar jar = ((ContainerManagedEntity)this.getTarget()).getEjbJar();
        if (jar != null) {
            return EcoreUtil.getExistingAdapter((Notifier)jar, (Object)J2EE_PROJ_MIGRATION_ADAPTER) != null;
        }
        return false;
    }

    protected void unsetNotification(Notification msg) {
        EStructuralFeature sf = (EStructuralFeature)msg.getFeature();
        if (!(sf != EJB_PACK.getEnterpriseBean_EjbClass() && sf != EJB_PACK.getEntity_PrimaryKey() || this.isMigrating())) {
            this.removeAttributeMaintenanceAdapter((Notifier)msg.getOldValue());
        }
    }

    protected void jemFlushNotification(Notification msg) {
        if ((NotificationUtil.isFlushNewEvent((Notification)msg) || NotificationUtil.isFlushEvent((Notification)msg)) && !this.isMigrating()) {
            if (msg.getNotifier() == ((ContainerManagedEntity)this.getTarget()).getEjbClass()) {
                this.touchBeanAdapter(msg);
            } else if (msg.getNotifier() == ((ContainerManagedEntity)this.getTarget()).getPrimaryKey()) {
                this.touchKeyShapeAdapter(msg);
            }
        }
    }

    protected void removeAdapterNotification(Notification msg) {
        if (msg.getOldValue() == this && msg.getNotifier() instanceof ContainerManagedEntity) {
            ContainerManagedEntity cmp = (ContainerManagedEntity)msg.getNotifier();
            if (cmp.getEjbClass() != null) {
                cmp.getEjbClass().eAdapters().remove((Object)this);
            }
            if (cmp.getPrimaryKey() != null) {
                cmp.getPrimaryKey().eAdapters().remove((Object)this);
            }
        }
    }

    protected void addAttributeMaintenanceAdapter(Notifier notifier) {
        if (notifier != null && !notifier.eAdapters().contains((Object)this)) {
            notifier.eAdapters().add((Object)this);
        }
    }

    protected void removeAttributeMaintenanceAdapter(Notifier notifier) {
        if (notifier != null) {
            notifier.eAdapters().remove((Object)this);
        }
    }

    protected void touchKeyShapeAdapter(Notification msg) {
        if (msg == null) {
            return;
        }
        ContainerManagedEntity cmp = (ContainerManagedEntity)this.getTarget();
        JavaClass primaryKeyClass = cmp.getPrimaryKey();
        this.synchCMPandKeyAttributes(cmp, primaryKeyClass);
    }

    protected void touchBeanAdapter(Notification msg) {
        if (msg == null) {
            return;
        }
        ContainerManagedEntity cmp = (ContainerManagedEntity)this.getTarget();
        EList cmpAttributes = cmp.getPersistentAttributes();
        if (cmpAttributes != null || !cmpAttributes.isEmpty()) {
            boolean modFlag = this.getCurrentModificationFlag();
            try {
                int i = 0;
                while (i < cmpAttributes.size()) {
                    CMPAttribute cmpAttr = (CMPAttribute)cmpAttributes.get(i);
                    if (cmpAttr != null && !cmpAttr.isDerived()) {
                        cmpAttr.setEType(null);
                    }
                    ++i;
                }
            }
            finally {
                this.setModificationFlag(modFlag);
            }
        }
        this.synchCMPandKeyAttributes(cmp, cmp.getPrimaryKey());
    }

    protected void synchCMPandKeyAttributes(ContainerManagedEntity cmp, JavaClass primaryKeyClass) {
        if (cmp == null || primaryKeyClass == null || cmp.getPrimKeyField() != null || primaryKeyClass.getQualifiedName().startsWith("java.lang")) {
            return;
        }
        this.flushPrimaryKeyClass(primaryKeyClass);
        EList cmpAttributes = cmp.getPersistentAttributes();
        if (cmpAttributes != null || !cmpAttributes.isEmpty()) {
            this.foundKeys.clear();
            EList keyAttributesList = cmp.getKeyAttributes();
            this.foundKeys.addAll(keyAttributesList);
            boolean modFlag = this.getCurrentModificationFlag();
            try {
                List keyFields = primaryKeyClass.getFieldsExtended();
                int i = 0;
                while (i < keyFields.size()) {
                    String fieldName;
                    Field field = (Field)keyFields.get(i);
                    if (field.getJavaVisibility() == JavaVisibilityKind.PUBLIC_LITERAL && (fieldName = field.getName()) != null) {
                        CMPAttribute keyAttr = cmp.getKeyAttribute(fieldName);
                        if (keyAttr == null) {
                            cmp.addKeyAttributeName(fieldName);
                        } else {
                            this.foundKeys.remove(keyAttr);
                        }
                    }
                    ++i;
                }
                if (!this.foundKeys.isEmpty()) {
                    keyAttributesList.removeAll(this.foundKeys);
                }
            }
            finally {
                this.setModificationFlag(modFlag);
            }
        }
    }

    public void setTarget(Notifier newTarget) {
        Resource res;
        boolean isChanged;
        boolean bl = isChanged = this.getTarget() != newTarget;
        if (newTarget == null) {
            super.setTarget(newTarget);
            this.cmpResource = null;
        } else if (newTarget instanceof ContainerManagedEntity && (res = ((ContainerManagedEntity)newTarget).eResource()) != null && res.getResourceSet() != null) {
            super.setTarget(newTarget);
            if (isChanged) {
                this.initializeTarget();
            }
        }
    }

    private void initializeTarget() {
        ContainerManagedEntity cmp = (ContainerManagedEntity)this.getTarget();
        this.addAttributeMaintenanceAdapter((Notifier)cmp.getEjbClass());
        if (this.shouldAddToPrimaryKeyClass(cmp)) {
            this.addAttributeMaintenanceAdapter((Notifier)cmp.getPrimaryKey());
        }
    }

    private boolean shouldAddToPrimaryKeyClass(ContainerManagedEntity cmp) {
        return cmp.getPrimKeyField() == null && cmp.getPrimaryKey() != null && !cmp.getPrimaryKey().getQualifiedName().startsWith("java.lang");
    }

    protected Resource getCMPResource() {
        if (this.cmpResource == null && this.getTarget() != null) {
            this.cmpResource = ((EObject)this.getTarget()).eResource();
        }
        return this.cmpResource;
    }

    protected boolean getCurrentModificationFlag() {
        return this.getCMPResource() != null && this.cmpResource.getContents() != null ? this.cmpResource.isModified() : false;
    }

    protected void setModificationFlag(boolean aBoolean) {
        if (this.getCMPResource() != null) {
            this.getCMPResource().setModified(aBoolean);
        }
    }

    public ContainerManagedEntity getCMP() {
        if (this.getTarget() instanceof ContainerManagedEntity) {
            return (ContainerManagedEntity)this.getTarget();
        }
        return null;
    }

    protected boolean flushPrimaryKeyClass(JavaClass primaryKeyClass) {
        IProject p = ProjectUtilities.getProject((EObject)primaryKeyClass);
        try {
            List natures = EMFNature.getRegisteredRuntimes((IProject)p);
            EMFNature nature = null;
            int i = 0;
            while (i < natures.size()) {
                if (natures.get(i) instanceof EMFNature) {
                    nature = (EMFNature)natures.get(i);
                }
                ++i;
            }
            EList adapterFactories = nature.getResourceSet().getAdapterFactories();
            AdapterFactory factory = EcoreUtil.getAdapterFactory((List)adapterFactories, (Object)"JavaReflection");
            if (factory instanceof JavaJDOMAdapterFactory) {
                JavaJDOMAdapterFactory javaFactory = (JavaJDOMAdapterFactory)factory;
                javaFactory.flushReflectionNoNotification(primaryKeyClass.getQualifiedName());
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }
}

