/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.style;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.provisional.style.StructuredPresentationReconciler;
import org.eclipse.wst.sse.ui.internal.reconcile.DocumentRegionProcessor;
import org.eclipse.wst.sse.ui.internal.style.SemanticHighlightingPresenter;
import org.eclipse.wst.sse.ui.internal.style.SemanticHighlightingReconciler;

public class SemanticHighlightingManager {
    private StructuredTextEditor fEditor;
    private StructuredTextViewer fSourceViewer;
    private SourceViewerConfiguration fConfiguration;
    private StructuredPresentationReconciler fPresentationReconciler;
    private SemanticHighlightingPresenter fPresenter;
    private SemanticHighlightingReconciler fReconciler;

    public void install(StructuredTextEditor editor, StructuredTextViewer sourceViewer, IPreferenceStore preferenceStore, SourceViewerConfiguration configuration, String contentTypeId) {
        this.fEditor = editor;
        this.fSourceViewer = sourceViewer;
        this.fConfiguration = configuration;
        this.fPresentationReconciler = (StructuredPresentationReconciler)this.fConfiguration.getPresentationReconciler((ISourceViewer)this.fSourceViewer);
        if (this.isEnabled()) {
            this.enable();
        }
    }

    private void loadSemanticHighlightings() {
    }

    private void enable() {
        this.loadSemanticHighlightings();
        this.fPresenter = new SemanticHighlightingPresenter();
        this.fPresenter.install(this.fSourceViewer, this.fPresentationReconciler);
        if (this.fEditor != null) {
            this.fReconciler = new SemanticHighlightingReconciler();
            this.fReconciler.install(this.fEditor, (ISourceViewer)this.fSourceViewer, this.fPresenter);
            IReconciler reconciler = this.fConfiguration.getReconciler((ISourceViewer)this.fSourceViewer);
            if (reconciler instanceof DocumentRegionProcessor) {
                ((DocumentRegionProcessor)reconciler).setSemanticHighlightingStrategy(this.fReconciler);
            }
        }
    }

    private void disable() {
        if (this.fReconciler != null) {
            this.fReconciler.uninstall();
            this.fReconciler = null;
        }
        if (this.fPresenter != null) {
            this.fPresenter.uninstall();
            this.fPresenter = null;
        }
    }

    private boolean isEnabled() {
        return true;
    }

    public void uninstall() {
        this.disable();
        this.fEditor = null;
        this.fSourceViewer = null;
        this.fConfiguration = null;
        this.fPresentationReconciler = null;
    }

    static class HighlightedPosition
    extends Position {
        private HighlightingStyle fStyle;
        private boolean fReadOnly;
        private Object fLock;

        public HighlightedPosition(int offset, int length, HighlightingStyle highlighting, Object lock, boolean isReadOnly) {
            super(offset, length);
            this.fStyle = highlighting;
            this.fLock = lock;
            this.fReadOnly = isReadOnly;
        }

        public HighlightedPosition(int offset, int length, HighlightingStyle highlighting, Object lock) {
            this(offset, length, highlighting, lock, false);
        }

        public HighlightedPosition(Position position, HighlightingStyle highlighting, Object lock) {
            this(position.offset, position.length, highlighting, lock, false);
        }

        public HighlightedPosition(Position position, HighlightingStyle highlighting, Object lock, boolean isReadOnly) {
            this(position.offset, position.length, highlighting, lock, isReadOnly);
        }

        public StyleRange createStyleRange() {
            int len = 0;
            if (this.fStyle.isEnabled()) {
                len = this.getLength();
            }
            TextAttribute textAttribute = this.fStyle.getTextAttribute();
            int style = textAttribute.getStyle();
            int fontStyle = style & 3;
            StyleRange styleRange = new StyleRange(this.getOffset(), len, textAttribute.getForeground(), textAttribute.getBackground(), fontStyle);
            styleRange.strikeout = (style & 0x20000000) != 0;
            styleRange.underline = (style & 0x40000000) != 0;
            return styleRange;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEqual(int off, int len, HighlightingStyle highlighting) {
            Object object = this.fLock;
            synchronized (object) {
                return !this.isDeleted() && this.getOffset() == off && this.getLength() == len && this.fStyle == highlighting;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEqual(Position pos, HighlightingStyle highlighting) {
            Object object = this.fLock;
            synchronized (object) {
                return !this.isDeleted() && this.getOffset() == pos.getOffset() && this.getLength() == pos.getLength() && this.fStyle == highlighting;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isContained(int off, int len) {
            Object object = this.fLock;
            synchronized (object) {
                return !this.isDeleted() && off <= this.getOffset() && off + len >= this.getOffset() + this.getLength();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(int off, int len) {
            Object object = this.fLock;
            synchronized (object) {
                super.setOffset(off);
                super.setLength(len);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLength(int length) {
            Object object = this.fLock;
            synchronized (object) {
                super.setLength(length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setOffset(int offset) {
            Object object = this.fLock;
            synchronized (object) {
                super.setOffset(offset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete() {
            Object object = this.fLock;
            synchronized (object) {
                super.delete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void undelete() {
            Object object = this.fLock;
            synchronized (object) {
                super.undelete();
            }
        }

        public HighlightingStyle getHighlighting() {
            return this.fStyle;
        }

        public boolean isReadOnly() {
            return this.fReadOnly;
        }
    }

    public static class HighlightedRange
    extends Region {
        private String fKey;

        public HighlightedRange(int offset, int length, String key) {
            super(offset, length);
            this.fKey = key;
        }

        public String getKey() {
            return this.fKey;
        }

        public boolean equals(Object o) {
            return super.equals(o) && o instanceof HighlightedRange && this.fKey.equals(((HighlightedRange)((Object)o)).getKey());
        }

        public int hashCode() {
            return super.hashCode() | this.fKey.hashCode();
        }
    }

    static class HighlightingStyle {
        private TextAttribute fTextAttribute;
        private boolean fIsEnabled;

        public HighlightingStyle(TextAttribute textAttribute, boolean isEnabled) {
            this.setTextAttribute(textAttribute);
            this.setEnabled(isEnabled);
        }

        public TextAttribute getTextAttribute() {
            return this.fTextAttribute;
        }

        public void setTextAttribute(TextAttribute textAttribute) {
            this.fTextAttribute = textAttribute;
        }

        public boolean isEnabled() {
            return this.fIsEnabled;
        }

        public void setEnabled(boolean isEnabled) {
            this.fIsEnabled = isEnabled;
        }
    }
}

